/*
 * Decompiled with CFR 0.152.
 */
package br.com.escolpi.omni.printer.service;

import br.com.escolpi.omni.printer.util.Commands;
import br.com.escolpi.omni.printer.util.LoggerUtil;
import br.com.escolpi.omni.printer.util.StringUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.springframework.stereotype.Service;

@Service
public class PrinterService
implements Printable {
    public String breakText(String text) {
        int freeSpace = 43;
        if (text.length() > freeSpace) {
            String[] expression = new String[]{text.substring(0, freeSpace - 1) + "\n", text.substring(freeSpace - 1, text.length())};
            return expression[0].concat(expression[1]);
        }
        return text;
    }

    public List<String> getPrinters() {
        DocFlavor.BYTE_ARRAY docFlavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        HashPrintRequestAttributeSet printRequestAtrributeSet = new HashPrintRequestAttributeSet();
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(docFlavor, printRequestAtrributeSet);
        ArrayList<String> printerList = new ArrayList<String>();
        for (PrintService printerService : printServices) {
            printerList.add(printerService.getName());
        }
        return printerList;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        Graphics2D graphics2d = (Graphics2D)graphics;
        graphics2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics.setFont(new Font("Roman", 0, 8));
        graphics.drawString("Hello world !", 0, 10);
        return 0;
    }

    public void printString(String printerName, String text, Integer paperJumpsBefore, Integer paperJumpsAfter) throws Exception {
        DocFlavor.BYTE_ARRAY docFlavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        HashPrintRequestAttributeSet printRequestAtrributeSet = new HashPrintRequestAttributeSet();
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(docFlavor, printRequestAtrributeSet);
        PrintService printService = this.findPrintService(printerName, printServices);
        DocPrintJob docPrintJob = printService.createPrintJob();
        try {
            int i;
            LoggerUtil.salvarLog((String)"Iniciando impress\u00e3o...");
            text = StringUtil.removeSpecialCharacters((String)text);
            for (i = 0; i < paperJumpsBefore; ++i) {
                text = "\n" + text;
            }
            for (i = 0; i < paperJumpsAfter; ++i) {
                text = text + "\n";
            }
            byte[] bytes = StringUtil.unaccent((String)text).getBytes(StandardCharsets.UTF_8);
            SimpleDoc doc = new SimpleDoc(bytes, docFlavor, null);
            docPrintJob.print(doc, null);
            this.printBytes(printerName, Commands.CUT_PAPER);
        }
        catch (Exception e) {
            LoggerUtil.salvarLog((String)("Erro ao imprimir: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public Boolean printersWillCutPaper() throws JsonProcessingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode cfgFile = mapper.readTree(new File(System.getProperty("user.dir") + File.separator + "printer-cfg.json"));
        if (cfgFile.hasNonNull("triggerGuillotine")) {
            return cfgFile.get("triggerGuillotine").asBoolean();
        }
        return true;
    }

    public String truncateText(String text, int maxLength) {
        if (text.length() > maxLength) {
            return text.substring(0, maxLength - 1);
        }
        return text;
    }

    private PrintService findPrintService(String printerName, PrintService[] services) throws Exception {
        for (PrintService printService : services) {
            if (!printService.getName().equalsIgnoreCase(printerName)) continue;
            LoggerUtil.salvarLog((String)("Impressora \"" + printerName + "\" encontrada!"));
            return printService;
        }
        String logMsg = "Impressora \"" + printerName + "\" n\u00e3o encontrada.";
        LoggerUtil.log((String)logMsg);
        LoggerUtil.salvarLog((String)logMsg);
        throw new Exception(logMsg);
    }

    private void printBytes(String printerName, byte[] bytes) throws Exception {
        DocFlavor.BYTE_ARRAY docFlavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        HashPrintRequestAttributeSet printRequestAtrributeSet = new HashPrintRequestAttributeSet();
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(docFlavor, printRequestAtrributeSet);
        PrintService printService = this.findPrintService(printerName, printServices);
        DocPrintJob docPrintJob = printService.createPrintJob();
        try {
            SimpleDoc doc = new SimpleDoc(bytes, docFlavor, null);
            docPrintJob.print(doc, null);
        }
        catch (Exception e) {
            LoggerUtil.salvarLog((String)("Erro ao imprimir: " + e.getMessage()));
            e.printStackTrace();
        }
    }
}

