/*
 * Decompiled with CFR 0.152.
 */
package br.com.escolpi.omni.printer.util;

import br.com.escolpi.omni.printer.PrinterApplication;
import br.com.escolpi.omni.printer.util.DateUtil;
import br.com.escolpi.omni.printer.util.Dominios;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrinterApplication.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    public static final void log(String mensagem) {
        LOGGER.info("{} - OMNI Delivery Task :: " + mensagem, (Object)DATE_TIME_FORMATTER.format(LocalDateTime.now()));
    }

    public static void salvarLog(String textoLog) {
        Calendar cal = Calendar.getInstance();
        String dataAtual = DateUtil.calendarToStringDate((Calendar)cal);
        String caminhoArquivoLog = Dominios.CAMINHO_LOGS + dataAtual + ".txt";
        String textoExistente = "";
        try (BufferedReader bufferedReader2 = new BufferedReader(new FileReader(caminhoArquivoLog));){
            String line = bufferedReader2.readLine();
            while (line != null) {
                textoExistente = textoExistente + "\r\n" + line;
                line = bufferedReader2.readLine();
            }
        }
        catch (FileNotFoundException bufferedReader2) {
        }
        catch (IOException bufferedReader2) {
            // empty catch block
        }
        textoLog = DATE_TIME_FORMATTER.format(LocalDateTime.now()) + " - " + textoLog + textoExistente;
        if (!new File(caminhoArquivoLog).exists()) {
            if (!new File(Dominios.CAMINHO_LOGS).exists()) {
                new File(Dominios.CAMINHO_LOGS).mkdirs();
            }
            new File(caminhoArquivoLog);
        }
        try {
            FileWriter arquivo = new FileWriter(caminhoArquivoLog);
            arquivo.write(textoLog);
            arquivo.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

