/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.view;

import com.escolpi.omni.integracao.components.IntegrationConfig;
import com.escolpi.omni.integracao.entity.configs.CardapioDigitalSettings;
import com.escolpi.omni.integracao.entity.configs.IFoodSettings;
import com.escolpi.omni.integracao.entity.configs.PedidoAgoraSettings;
import com.escolpi.omni.integracao.util.UiUtil;
import java.awt.Component;
import java.awt.HeadlessException;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConfigSummaryWindow
extends JFrame {
    public ConfigSummaryWindow() throws HeadlessException {
        this.setTitle("Configura\u00e7\u00f5es");
        this.setLayout(null);
        this.setResizable(false);
        this.setIconImage(UiUtil.getAppIcon());
        this.setDefaultCloseOperation(0);
        this.setFont(UIManager.getFont("small.font"));
    }

    public void createView() {
        int topOffset = 0;
        if (IntegrationConfig.isPedidoAgoraActive()) {
            topOffset = this.renderPedidoAgoraSettings(topOffset);
        }
        if (IntegrationConfig.isCardapioDigitalActive()) {
            topOffset = this.renderCardapioDigitalSettings(topOffset);
        }
        if (IntegrationConfig.isIFoodActive()) {
            topOffset = this.renderIFoodSettings(topOffset);
        }
        this.setBounds(0, 0, 480, topOffset += 15);
        UiUtil.centerFrame((JFrame)this);
    }

    private int renderCardapioDigitalSettings(int topOffset) {
        JLabel titleCardapioDigital = ConfigSummaryWindow.setConfigHeader((String)"Card\u00e1pio Digital", (int)topOffset);
        this.add((Component)titleCardapioDigital);
        JPanel rowCodEmpresa = UiUtil.createRow((int)(topOffset += titleCardapioDigital.getHeight()));
        rowCodEmpresa.add(new JLabel("Cod. Empressa: "));
        rowCodEmpresa.add(new JLabel(this.getCardapioDigitalSettings().getCompanyId().toString()));
        this.add((Component)rowCodEmpresa);
        JPanel rowReceiveTestOrders = UiUtil.createRow((int)(topOffset += rowCodEmpresa.getHeight()));
        rowReceiveTestOrders.add(new JLabel("Aceita pedidos de teste: "));
        rowReceiveTestOrders.add(new JLabel(UiUtil.getYesNo((boolean)this.getCardapioDigitalSettings().getGetTestOrders())));
        this.add((Component)rowReceiveTestOrders);
        return topOffset += rowReceiveTestOrders.getHeight();
    }

    private int renderIFoodSettings(int topOffset) {
        JLabel titleIFood = ConfigSummaryWindow.setConfigHeader((String)"IFood", (int)topOffset);
        this.add((Component)titleIFood);
        JPanel rowMerchantId = UiUtil.createRow((int)(topOffset += titleIFood.getHeight()));
        rowMerchantId.add(new JLabel("Merchant Id: "));
        rowMerchantId.add(new JLabel(this.getIFoodSettings().getMerchantId()));
        this.add((Component)rowMerchantId);
        JPanel rowAutoconfirmOrders = UiUtil.createRow((int)(topOffset += rowMerchantId.getHeight()));
        rowAutoconfirmOrders.add(new JLabel("Confirma Pedidos Autom\u00e1ticamente: "));
        rowAutoconfirmOrders.add(new JLabel(UiUtil.getYesNo((boolean)this.getIFoodSettings().getAutoConfirmOrders())));
        this.add((Component)rowAutoconfirmOrders);
        JPanel rowDefaultExternalCodes = UiUtil.createRow((int)(topOffset += rowAutoconfirmOrders.getHeight()));
        rowDefaultExternalCodes.add(new JLabel("C\u00f3digo de Opcional externos padr\u00e3o: "));
        rowDefaultExternalCodes.add(new JLabel(this.getIFoodSettings().getCustomizationExternalCodes()));
        this.add((Component)rowDefaultExternalCodes);
        return topOffset += rowDefaultExternalCodes.getHeight();
    }

    private int renderPedidoAgoraSettings(int topOffset) {
        JLabel titlePedidoAgora = ConfigSummaryWindow.setConfigHeader((String)"Pedido Agora", (int)topOffset);
        this.add((Component)titlePedidoAgora);
        JPanel rowCodEmpresa = UiUtil.createRow((int)(topOffset += titlePedidoAgora.getHeight()));
        rowCodEmpresa.add(new JLabel("Cod. Empressa: "));
        rowCodEmpresa.add(new JLabel(this.getPedidoAgoraSettings().getCompanyId().toString()));
        this.add((Component)rowCodEmpresa);
        JPanel rowReceiveTestOrders = UiUtil.createRow((int)(topOffset += rowCodEmpresa.getHeight()));
        rowReceiveTestOrders.add(new JLabel("Aceita pedidos de teste: "));
        rowReceiveTestOrders.add(new JLabel(UiUtil.getYesNo((boolean)this.getPedidoAgoraSettings().getGetTestOrders())));
        this.add((Component)rowReceiveTestOrders);
        JPanel rowImportOrdersWhenStoreClosed = UiUtil.createRow((int)(topOffset += rowReceiveTestOrders.getHeight()));
        rowImportOrdersWhenStoreClosed.add(new JLabel("Aceita importar pedidos com a loja fechada: "));
        rowImportOrdersWhenStoreClosed.add(new JLabel(UiUtil.getYesNo((boolean)this.getPedidoAgoraSettings().getImportOrdersWhenClosedStore())));
        this.add((Component)rowImportOrdersWhenStoreClosed);
        return topOffset += rowImportOrdersWhenStoreClosed.getHeight();
    }

    private static JLabel setConfigHeader(String headerTitle, int topOffset) {
        JLabel label = new JLabel(headerTitle);
        label.setFont(UIManager.getFont("h1.font"));
        label.setForeground(UiUtil.COLOR_ORANGE);
        label.setBounds(5, topOffset, 475, 40);
        return label;
    }

    private CardapioDigitalSettings getCardapioDigitalSettings() {
        return IntegrationConfig.config.getCardapioDigitalSettings();
    }

    private IFoodSettings getIFoodSettings() {
        return IntegrationConfig.config.getiFoodSettings();
    }

    private PedidoAgoraSettings getPedidoAgoraSettings() {
        return IntegrationConfig.config.getPedidoAgoraSettings();
    }
}

