/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.service;

import com.escolpi.omni.integracao.components.routes.RouteComponent;
import com.escolpi.omni.integracao.entity.ItemDoPedido;
import com.escolpi.omni.integracao.entity.LogInterno;
import com.escolpi.omni.integracao.entity.Pedido;
import com.escolpi.omni.integracao.entity.Personalizacao;
import com.escolpi.omni.integracao.entity.api.ConfiguracaoDePizzariaApi;
import com.escolpi.omni.integracao.enumeration.FormaDeEntrega;
import com.escolpi.omni.integracao.enumeration.FuncaoPagamento;
import com.escolpi.omni.integracao.enumeration.TipoCupomDesconto;
import com.escolpi.omni.integracao.exceptions.ConfigurationNotFoundException;
import com.escolpi.omni.integracao.exceptions.IntegrationException;
import com.escolpi.omni.integracao.exceptions.ProductNotFoundException;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.CategoriaDoProdutoDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.CestaDePromocaoDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.EnderecoDeEntregaDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.ItemDoPedidoDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.ItemDoPedidoPorPromocaoDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.OpcaoDePagamentoDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.OpcionalDoItemDoPedidoDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.OpcionalDoItemDoPedidoPorPromocaoDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.PedidoDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.ProdutoDto;
import com.escolpi.omni.integracao.repository.ItemDoPedidoRepository;
import com.escolpi.omni.integracao.repository.OpcionalRepository;
import com.escolpi.omni.integracao.repository.PedidoRepository;
import com.escolpi.omni.integracao.repository.ProdutoRepository;
import com.escolpi.omni.integracao.service.LogInternoService;
import com.escolpi.omni.integracao.service.PedidoAgoraIntegrationService;
import com.escolpi.omni.integracao.util.DateUtil;
import com.escolpi.omni.integracao.util.NullUtil;
import com.escolpi.omni.integracao.util.StringUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PedidoAgoraIntegrationService {
    @Autowired
    private OpcionalRepository optionalRepository;
    @Autowired
    private ItemDoPedidoRepository orderItemRepository;
    @Autowired
    private ProdutoRepository productRepository;
    @Autowired
    private PedidoRepository repository;
    @Autowired
    private LogInternoService logService;
    @Autowired
    private RouteComponent routeComponent;
    private final Logger log = LoggerFactory.getLogger(PedidoAgoraIntegrationService.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final RestTemplate rest = new RestTemplate();

    @Transactional
    public Pedido createOrder(PedidoDto dto) throws IntegrationException {
        String currentDate = DateUtil.format((String)"dd/MM/yyyy", (Date)new Date());
        Pedido order = this.repository.findByPedidoIdApi(dto.getId().toString(), currentDate).orElse(new Pedido());
        if (NullUtil.isNotNullOrZero((Serializable)order.getId()) && this.isOrderImported(order.getId())) {
            return null;
        }
        if (NullUtil.isNotNullOrZero((Serializable)order.getId())) {
            this.log.info("Atualizando pedido {}...", (Object)order.getId());
        } else {
            this.log.info("Importando pedido {}...", (Object)dto.getId());
        }
        order.setPedidoIdApi(dto.getId().toString());
        order.setEmpresaId(dto.getEmpresa().getId());
        if (NullUtil.isNotNullOrZero((Serializable)dto.getValorDescontoPagamentoEmDinheiro())) {
            order.setValorDescontoPagamentoEmDinheiro(Double.valueOf(dto.getValorDescontoPagamentoEmDinheiro().doubleValue()));
        }
        if (dto.getClienteSemCadastro().booleanValue()) {
            order.setClienteNome(dto.getNomeClienteSemCadastro());
            order.setClienteTelefone(StringUtil.formatarTelefone((String)StringUtil.isTextNull((String)dto.getTelefoneClienteSemCadastro())));
        } else {
            order.setClienteNome(dto.getCliente().getNome());
            order.setClienteTelefone(StringUtil.formatarTelefone((String)dto.getCliente().getTelefone()));
            order.setClienteEmail(dto.getCliente().getEmail());
        }
        order.setClienteEmail(dto.getCliente().getEmail());
        order.setValorTarifaEntrega(Double.valueOf(0.0));
        if (dto.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            order.setValorTarifaEntrega(Double.valueOf(dto.getTaxaDeEntrega().doubleValue()));
            PedidoAgoraIntegrationService.populateDeliveryAddress((PedidoDto)dto, (Pedido)order);
        }
        order.setFormaEntrega(dto.getFormaEntrega().toString());
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
        if (NullUtil.isNotNull((Object)dto.getDataAtualizacaoPedido())) {
            localDateTime = DateUtil.parseLocalDateTime((Date)dto.getDataAtualizacaoPedido());
            order.setDtHrAtualizacao(localDateTime.minusHours(3L).format(dateTimeFormatter));
        } else {
            order.setDtHrAtualizacao(localDateTime.format(dateTimeFormatter));
        }
        if (!StringUtil.isBlank((String)dto.getCpfCnpjNota())) {
            order.setCpfCnpjNota(dto.getCpfCnpjNota());
        }
        if (NullUtil.isNotNull((Object)dto.getOpcaoPagamento())) {
            if (dto.getOpcaoPagamento().getFuncao().equals((Object)FuncaoPagamento.PIX)) {
                order.setOpcaoPagamento(String.format("%s (CH: %s)", dto.getOpcaoPagamento().getDescricao(), this.getFormattedPixKey(dto.getOpcaoPagamento())));
            } else {
                order.setOpcaoPagamento(dto.getOpcaoPagamento().getDescricao());
            }
        }
        if (NullUtil.isNotNull((Object)dto.getFormaPagamento())) {
            order.setFormaPagamento(dto.getFormaPagamento().getDescricao().toUpperCase());
        }
        order.setValorTroco(Double.valueOf(NullUtil.isNotNullOrZero((Serializable)dto.getValorTroco()) ? dto.getValorTroco().doubleValue() : 0.0));
        order.setRodizio(Boolean.valueOf(false));
        order.setSituacao(dto.getSituacao());
        order.setOrigem("P AGORA");
        order.setDtHrPedido(DateUtil.format((String)"dd/MM/yyyy HH:mm:ss", (Date)dto.getDataHoraPedido()));
        order.setConfirmado("0");
        order.setObservacoes(StringUtil.isTextNull((String)dto.getObservacoes()));
        this.repository.save((Object)order);
        double totalItemsValue = 0.0;
        if (!CollectionUtils.isEmpty((Collection)dto.getItensDoPedido())) {
            totalItemsValue += dto.getItensDoPedido().stream().map(i -> i.getValor().doubleValue()).reduce(Double::sum).orElse(0.0).doubleValue();
            this.saveOrderItems(order, dto.getItensDoPedido());
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getCestasDePromocao())) {
            for (CestaDePromocaoDto basket : dto.getCestasDePromocao()) {
                totalItemsValue += basket.getValor().doubleValue() / (double)basket.getItens().size();
            }
            this.saveOrderItemsByPromotion(order, dto.getCestasDePromocao());
        }
        this.calculateDiscounts(order, dto, totalItemsValue);
        return order;
    }

    public Long countOrderByAPIId(String orderId) {
        String currentDate = DateUtil.format((String)"dd/MM/yyyy", (Date)new Date());
        return this.repository.countByPedidoIdApi(orderId, currentDate);
    }

    @Transactional
    private void calculateDiscounts(Pedido order, PedidoDto dto, double totalItemsValue) {
        double calculatedValue = 0.0;
        if (NullUtil.isNotNull((Object)dto.getCupomDeDesconto())) {
            double d = calculatedValue = dto.getCupomDeDesconto().getTipoDesconto().equals((Object)TipoCupomDesconto.PERCENTUAL) ? totalItemsValue * dto.getCupomDeDesconto().getValorDesconto() : dto.getCupomDeDesconto().getValorDesconto();
        }
        if (NullUtil.isNotNullOrZero((Serializable)dto.getDebitoCashback())) {
            calculatedValue += dto.getDebitoCashback().doubleValue();
        }
        if (calculatedValue > 0.0) {
            order.setCupomDeDesconto(StringUtil.isTextNull((String)Double.toString(calculatedValue)));
            this.repository.save((Object)order);
        }
    }

    @Transactional
    private void saveOrderItems(Pedido order, Set<ItemDoPedidoDto> items) {
        List pizzaFlavors = new ArrayList();
        for (ItemDoPedidoDto item : items) {
            ItemDoPedido orderItem = new ItemDoPedido();
            orderItem.setPedido(order);
            if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                ConfiguracaoDePizzariaApi pizzaConfig = this.getPizzeriaConfig(order.getEmpresaId());
                if (pizzaConfig == null) {
                    throw new ConfigurationNotFoundException("Configura\u00e7\u00e3o de Pizzaria do Pedido Agora");
                }
                pizzaFlavors = this.getPizzaFlavorsFromItem(item, pizzaConfig);
                orderItem.setCategoria(((ProdutoDto)pizzaFlavors.get(0)).getCategoria().getDescricao());
                orderItem.setProdutoCodigoAtos(((ProdutoDto)pizzaFlavors.get(0)).getCodigoAtos());
            } else {
                orderItem.setProdutoNome(item.getProduto().getNome());
                orderItem.setCategoria(item.getProduto().getCategoria().getDescricao());
                orderItem.setProdutoCodigoAtos(item.getProduto().getCodigoAtos());
            }
            orderItem.setObservacoes(StringUtil.isTextNull((String)item.getObservacoes()));
            orderItem.setQuantidade(item.getQuantidade());
            orderItem.setValor(Double.valueOf(item.getValor().doubleValue()));
            orderItem.setIndPromocao("0");
            if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                this.savePizzaProduct(pizzaFlavors, orderItem, item.getOpcionais());
                continue;
            }
            this.orderItemRepository.save((Object)orderItem);
            this.saveOptionals(orderItem, item.getOpcionais());
        }
    }

    @Transactional
    private void savePizzaProduct(List<ProdutoDto> pizzaFlavors, ItemDoPedido orderItem, Set<OpcionalDoItemDoPedidoDto> optionals) {
        int subProductCounter = pizzaFlavors.size();
        Long parentAtosCode = 0L;
        for (ProdutoDto pizza : pizzaFlavors) {
            if (NullUtil.isNull((Object)orderItem.getProdutoCodigoAtos()) || StringUtil.isBlank((String)orderItem.getProdutoCodigoAtos())) continue;
            Personalizacao itemCustomization = new Personalizacao();
            ItemDoPedido subProductItem = new ItemDoPedido();
            try {
                subProductItem.setCategoria(orderItem.getCategoria());
                subProductItem.setPedido(orderItem.getPedido());
                itemCustomization.setPersonalizacaoDescricao(StringUtil.isTextNull((String)pizza.getNome()));
                subProductItem.setProdutoNome(subProductCounter > 1 ? "1/" + subProductCounter + " " + itemCustomization.getPersonalizacaoDescricao() : itemCustomization.getPersonalizacaoDescricao());
                subProductItem.setProdutoCodigoAtos(StringUtil.isTextNull((String)pizza.getCodigoAtos()));
                subProductItem.setQuantidade(orderItem.getQuantidade());
                subProductItem.setObservacoes(orderItem.getObservacoes());
                subProductItem.setValor(orderItem.getValor());
                if (StringUtil.isNotBlank((String)orderItem.getIndPromocao())) {
                    subProductItem.setIndPromocao(orderItem.getIndPromocao());
                }
                this.orderItemRepository.save((Object)subProductItem);
                if (pizzaFlavors.indexOf(pizza) == 0) {
                    parentAtosCode = subProductItem.getId();
                } else if (pizzaFlavors.indexOf(pizza) > 0) {
                    subProductItem.setProdutoCodigoAtosPai(String.valueOf(parentAtosCode));
                }
                if (!pizza.getCodigoAtos().equals(orderItem.getProdutoCodigoAtos())) continue;
                this.saveOptionals(subProductItem, optionals);
            }
            catch (Exception e) {
                this.logService.save(new LogInterno(Boolean.valueOf(true), StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "", "P AGORA"));
            }
        }
    }

    @Transactional
    private void savePromotionPizzaProduct(List<ProdutoDto> pizzaFlavors, ItemDoPedido orderItem, Set<OpcionalDoItemDoPedidoPorPromocaoDto> optionals) {
        int subProductCounter = pizzaFlavors.size();
        Long parentAtosCode = 0L;
        for (ProdutoDto pizza : pizzaFlavors) {
            if (NullUtil.isNull((Object)orderItem.getProdutoCodigoAtos()) || StringUtil.isBlank((String)orderItem.getProdutoCodigoAtos())) continue;
            Personalizacao itemCustomization = new Personalizacao();
            ItemDoPedido subProductItem = new ItemDoPedido();
            try {
                subProductItem.setCategoria(orderItem.getCategoria());
                subProductItem.setPedido(orderItem.getPedido());
                itemCustomization.setPersonalizacaoDescricao(StringUtil.isTextNull((String)pizza.getNome()));
                subProductItem.setProdutoNome(subProductCounter > 1 ? "1/" + subProductCounter + " " + itemCustomization.getPersonalizacaoDescricao() : itemCustomization.getPersonalizacaoDescricao());
                subProductItem.setProdutoCodigoAtos(StringUtil.isTextNull((String)pizza.getCodigoAtos()));
                subProductItem.setQuantidade(orderItem.getQuantidade());
                subProductItem.setObservacoes(orderItem.getObservacoes());
                subProductItem.setValor(orderItem.getValor());
                if (StringUtil.isNotBlank((String)orderItem.getIndPromocao())) {
                    subProductItem.setIndPromocao(orderItem.getIndPromocao());
                }
                this.orderItemRepository.save((Object)subProductItem);
                if (pizzaFlavors.indexOf(pizza) == 0) {
                    parentAtosCode = subProductItem.getId();
                } else if (pizzaFlavors.indexOf(pizza) > 0) {
                    subProductItem.setProdutoCodigoAtosPai(String.valueOf(parentAtosCode));
                }
            }
            catch (Exception e) {
                this.logService.save(new LogInterno(Boolean.valueOf(true), StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "", "P AGORA"));
            }
            if (!pizza.getCodigoAtos().equals(orderItem.getProdutoCodigoAtos())) continue;
            this.savePromotionOptionals(subProductItem, optionals);
        }
    }

    @Transactional
    private void saveOptionals(ItemDoPedido orderItem, Set<OpcionalDoItemDoPedidoDto> optionals) {
        if (!CollectionUtils.isEmpty(optionals)) {
            for (OpcionalDoItemDoPedidoDto optional : optionals) {
                Personalizacao itemCustomization = new Personalizacao();
                if (NullUtil.isNotNull((Object)optional.getValorDaPersonalizacao().getPersonalizacao())) {
                    itemCustomization.setPersonalizacaoDescricao(StringUtil.isTextNull((String)(optional.getValorDaPersonalizacao().getPersonalizacao().getDescricao() + ": " + StringUtil.isTextNull((String)optional.getValorDaPersonalizacao().getDescricao()))));
                } else {
                    itemCustomization.setPersonalizacaoDescricao(StringUtil.isTextNull((String)(optional.getValorDaPersonalizacao().getPersonalizacaoDeProduto().getDescricao() + ": " + StringUtil.isTextNull((String)optional.getValorDaPersonalizacao().getDescricao()))));
                }
                if (NullUtil.isNullOrZero((Serializable)optional.getQuantidade())) {
                    optional.setQuantidade(Long.valueOf(1L));
                }
                itemCustomization.setQuantidade(Integer.valueOf(optional.getQuantidade().intValue()));
                itemCustomization.setItemPedido(orderItem);
                itemCustomization.setPersonalizacaoValor(Double.valueOf(optional.getValorDaPersonalizacao().getValor().doubleValue()));
                this.optionalRepository.save((Object)itemCustomization);
            }
        }
    }

    @Transactional
    private void savePromotionOptionals(ItemDoPedido orderItem, Set<OpcionalDoItemDoPedidoPorPromocaoDto> optionals) {
        if (!CollectionUtils.isEmpty(optionals)) {
            for (OpcionalDoItemDoPedidoPorPromocaoDto optional : optionals) {
                Personalizacao itemCustomization = new Personalizacao();
                if (NullUtil.isNotNull((Object)optional.getValorDaPersonalizacao().getPersonalizacao())) {
                    itemCustomization.setPersonalizacaoDescricao(StringUtil.isTextNull((String)(optional.getValorDaPersonalizacao().getPersonalizacao().getDescricao() + ": " + StringUtil.isTextNull((String)optional.getValorDaPersonalizacao().getDescricao()))));
                } else {
                    itemCustomization.setPersonalizacaoDescricao(StringUtil.isTextNull((String)(optional.getValorDaPersonalizacao().getPersonalizacaoDeProduto().getDescricao() + ": " + StringUtil.isTextNull((String)optional.getValorDaPersonalizacao().getDescricao()))));
                }
                itemCustomization.setQuantidade(Integer.valueOf(optional.getQuantidade().intValue()));
                itemCustomization.setItemPedido(orderItem);
                itemCustomization.setPersonalizacaoValor(Double.valueOf(optional.getValorDaPersonalizacao().getValor().doubleValue()));
                this.optionalRepository.save((Object)itemCustomization);
            }
        }
    }

    private List<ProdutoDto> getPizzaFlavorsFromItem(ItemDoPedidoDto item, ConfiguracaoDePizzariaApi config) {
        try {
            List ids = Arrays.stream(item.getProdutoComposto().getProdutosIds().split(",")).map(id -> Long.valueOf(id.split(":")[0])).collect(Collectors.toList());
            String url = this.routeComponent.getEndpoint(this.routeComponent.getPedidoAgoraBaseUrl(), "/products/", new String[]{config.getEmpresa().getId().toString()});
            HttpEntity entity = new HttpEntity(ids);
            ResponseEntity response = this.rest.postForEntity(url, (Object)entity, String.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                throw new IntegrationException(String.format("Servi\u00e7o do Pedido Agora est\u00e1 indispon\u00edvel: %s", "N\u00e3o foi poss\u00edvel obter sabores de pizza"));
            }
            List<Object> foundedPizzas = Arrays.asList((Object[])this.mapper.readValue((String)response.getBody(), ProdutoDto[].class));
            if (CollectionUtils.isEmpty(foundedPizzas)) {
                throw new ProductNotFoundException("Produtos dos sabores de pizza n\u00e3o foram encontrados! Revise os c\u00f3digos de integra\u00e7\u00e3o!");
            }
            return foundedPizzas.stream().map(p -> PedidoAgoraIntegrationService.parseToPizzaProduct((String)item.getProdutoComposto().getTamanho(), (String)item.getProdutoComposto().getTamanhoAbreviado(), (ConfiguracaoDePizzariaApi)config, (ProdutoDto)p)).collect(Collectors.toList());
        }
        catch (IOException e) {
            this.log.error("Erro de leitura ao obter os pedidos do Pedido Agora: {}", (Object)e.getMessage());
            throw new IntegrationException(e.getMessage());
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            throw new IntegrationException(e.getMessage());
        }
    }

    private List<ProdutoDto> getPizzaFlavorsFromPromotionItem(ItemDoPedidoPorPromocaoDto item, ConfiguracaoDePizzariaApi config) {
        try {
            List ids = Arrays.stream(item.getProdutoComposto().getProdutosIds().split(",")).map(id -> Long.valueOf(id.split(":")[0])).collect(Collectors.toList());
            String url = this.routeComponent.getEndpoint(this.routeComponent.getPedidoAgoraBaseUrl(), "/products/", new String[]{config.getEmpresa().getId().toString()});
            HttpEntity entity = new HttpEntity(ids);
            ResponseEntity response = this.rest.postForEntity(url, (Object)entity, String.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                throw new IntegrationException(String.format("Servi\u00e7o do Pedido Agora est\u00e1 indispon\u00edvel: %s", "N\u00e3o foi poss\u00edvel obter sabores de pizza"));
            }
            List<Object> foundedPizzas = Arrays.asList((Object[])this.mapper.readValue((String)response.getBody(), ProdutoDto[].class));
            if (CollectionUtils.isEmpty(foundedPizzas)) {
                throw new ProductNotFoundException("Produtos dos sabores de pizza n\u00e3o foram encontrados! Revise os c\u00f3digos de integra\u00e7\u00e3o!");
            }
            return foundedPizzas.stream().map(p -> PedidoAgoraIntegrationService.parseToPizzaProduct((String)item.getProdutoComposto().getTamanho(), (String)item.getProdutoComposto().getTamanhoAbreviado(), (ConfiguracaoDePizzariaApi)config, (ProdutoDto)p)).collect(Collectors.toList());
        }
        catch (ProductNotFoundException e) {
            this.log.error(e.getMessage());
            throw new IntegrationException(e.getMessage());
        }
        catch (IOException e) {
            this.log.error("Erro de leitura ao obter os pedidos do Pedido Agora: {}", (Object)e.getMessage());
            throw new IntegrationException(e.getMessage());
        }
    }

    private static ProdutoDto parseToPizzaProduct(String size, String shortSize, ConfiguracaoDePizzariaApi config, ProdutoDto product) {
        ProdutoDto pizza = new ProdutoDto();
        String productName = String.format("%s  %s", product.getNome(), StringUtil.isNotBlank((String)shortSize) ? shortSize.toUpperCase() : StringUtil.removerAcentos((String)size).substring(0, 4).toUpperCase());
        pizza.setNome(productName);
        pizza.setCategoria(new CategoriaDoProdutoDto(product.getCategoria().getId(), product.getCategoria().getDescricao()));
        if (NullUtil.isNotNull((Object)config.getLabelTamanhoBroto()) && config.getLabelTamanhoBroto().equals(size)) {
            pizza.setCodigoAtos(product.getCodigoAtosBroto());
            pizza.setValor(product.getValorTamanhoBroto());
        } else if (NullUtil.isNotNull((Object)config.getLabelTamanhoMedio()) && config.getLabelTamanhoMedio().equals(size)) {
            pizza.setCodigoAtos(product.getCodigoAtosMedio());
            pizza.setValor(product.getValorTamanhoMedio());
        } else if (NullUtil.isNotNull((Object)config.getLabelTamanhoGrande()) && config.getLabelTamanhoGrande().equals(size)) {
            pizza.setCodigoAtos(product.getCodigoAtosGrande());
            pizza.setValor(product.getValorTamanhoGrande());
        } else if (NullUtil.isNotNull((Object)config.getLabelTamanhoGigante()) && config.getLabelTamanhoGigante().equals(size)) {
            pizza.setCodigoAtos(product.getCodigoAtosGigante());
            pizza.setValor(product.getValorTamanhoGigante());
        } else {
            pizza.setCodigoAtos(product.getCodigoAtos());
            pizza.setValor(product.getValor());
        }
        return pizza;
    }

    @Transactional
    private void saveOrderItemsByPromotion(Pedido order, Set<CestaDePromocaoDto> items) {
        for (CestaDePromocaoDto basket : items) {
            for (ItemDoPedidoPorPromocaoDto item : basket.getItens()) {
                ItemDoPedido orderItem = new ItemDoPedido();
                orderItem.setPedido(order);
                List pizzaFlavors = new ArrayList();
                if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                    ConfiguracaoDePizzariaApi pizzaConfig = this.getPizzeriaConfig(order.getEmpresaId());
                    if (pizzaConfig == null) {
                        throw new ConfigurationNotFoundException("Configura\u00e7\u00e3o de Pizzaria do Pedido Agora");
                    }
                    pizzaFlavors = this.getPizzaFlavorsFromPromotionItem(item, pizzaConfig);
                    orderItem.setProdutoCodigoAtos(((ProdutoDto)pizzaFlavors.get(0)).getCodigoAtos());
                } else {
                    orderItem.setProdutoNome(item.getProduto().getNome());
                    orderItem.setProdutoCodigoAtos(item.getProduto().getCodigoAtos());
                }
                orderItem.setCategoria(basket.getPromocao().getTitulo());
                orderItem.setObservacoes(StringUtil.isTextNull((String)item.getObservacoes()));
                orderItem.setQuantidade(Double.valueOf(item.getQuantidade().doubleValue()));
                orderItem.setValor(Double.valueOf(basket.getValor().doubleValue()));
                if (NullUtil.isNotNullOrZero((Serializable)basket.getPromocao().getValorFixo())) {
                    orderItem.setIndPromocao(String.format("%s|S", basket.getId()));
                } else {
                    orderItem.setIndPromocao(String.format("%s|N", basket.getId()));
                }
                if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                    this.savePromotionPizzaProduct(pizzaFlavors, orderItem, item.getOpcionais());
                    continue;
                }
                this.orderItemRepository.save((Object)orderItem);
                this.savePromotionOptionals(orderItem, item.getOpcionais());
            }
        }
    }

    private String getFormattedPixKey(OpcaoDePagamentoDto paymentOption) {
        try {
            switch (1.$SwitchMap$com$escolpi$omni$integracao$enumeration$TipoDeChavePix[paymentOption.getTipoDeChavePix().ordinal()]) {
                case 1: {
                    return StringUtil.formatarCPF((String)paymentOption.getChavePix());
                }
                case 2: {
                    return StringUtil.formatarCNPJ((String)paymentOption.getChavePix());
                }
                case 3: {
                    return StringUtil.formatarTelefone((String)paymentOption.getChavePix());
                }
            }
            return paymentOption.getChavePix();
        }
        catch (ParseException e) {
            return "";
        }
    }

    private ConfiguracaoDePizzariaApi getPizzeriaConfig(Long companyId) {
        try {
            RestTemplate rest = new RestTemplate();
            String url = this.routeComponent.getEndpoint(this.routeComponent.getPedidoAgoraBaseUrl(), "/config/pizzeria", new String[]{companyId.toString()});
            ResponseEntity response = rest.exchange(url, HttpMethod.GET, HttpEntity.EMPTY, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                return (ConfiguracaoDePizzariaApi)this.mapper.readValue((String)response.getBody(), ConfiguracaoDePizzariaApi.class);
            }
            return null;
        }
        catch (IOException | RestClientException e) {
            String msg = String.format("Servi\u00e7o do Pedido Agora est\u00e1 indispon\u00edvel: %s", e.getMessage());
            this.logService.save(new LogInterno(Boolean.valueOf(true), msg, "P AGORA"));
            throw new IntegrationException(msg);
        }
    }

    private boolean isOrderImported(Long orderId) {
        String currentDate = DateUtil.format((String)"dd/MM/yyyy", (Date)new Date());
        return this.repository.findByPedidoIdApi(orderId.toString(), currentDate).isPresent();
    }

    private static void populateDeliveryAddress(PedidoDto dto, Pedido order) {
        StringBuilder fullAddress = new StringBuilder();
        if (dto.getClienteSemCadastro().booleanValue()) {
            String address = dto.getEnderecoDeEntregaClienteSemCadastro();
            String[] addressComponents = address.replaceAll(",\\s", ",").split(",");
            String[] cityAndUf = addressComponents[4].split("/");
            fullAddress.append(addressComponents[0]).append("|").append(addressComponents[1]).append("|").append(addressComponents[2]).append("|").append(cityAndUf[0]).append("|").append(cityAndUf[1]).append("|");
            if (addressComponents.length >= 6) {
                fullAddress.append(addressComponents[5]).append("|");
            }
            if (addressComponents.length == 7) {
                fullAddress.append(addressComponents[6]);
            }
            if (fullAddress.toString().lastIndexOf("|") == fullAddress.length()) {
                fullAddress = new StringBuilder(fullAddress.substring(0, fullAddress.toString().length()));
            }
        } else {
            EnderecoDeEntregaDto address = dto.getEnderecoEntrega();
            fullAddress.append(StringUtil.isTextNull((String)address.getLogradouro())).append("|").append(StringUtil.isTextNull((String)address.getNumero())).append("|").append(StringUtil.isTextNull((String)address.getBairro())).append("|").append(StringUtil.isTextNull((String)address.getMunicipio().getNome())).append("|").append(StringUtil.isTextNull((String)address.getMunicipio().getUf()));
            if (StringUtil.isNotBlank((String)address.getComplemento())) {
                fullAddress.append("|").append(StringUtil.isTextNull((String)address.getComplemento()));
            }
            if (StringUtil.isNotBlank((String)address.getPontoDeReferencia())) {
                fullAddress.append("|").append(address.getPontoDeReferencia());
            }
            if (!StringUtil.isBlank((String)address.getCep())) {
                order.setCep(address.getCep());
            }
        }
        order.setEnderecoEntrega(fullAddress.toString());
    }
}

