/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.controller;

import com.escolpi.omni.integracao.components.IntegrationConfig;
import com.escolpi.omni.integracao.entity.LogInterno;
import com.escolpi.omni.integracao.entity.configs.IFoodSettings;
import com.escolpi.omni.integracao.exceptions.IntegrationException;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodAuthorizationDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodAuthorizationRequestDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodErrorDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodStoreStatusDto;
import com.escolpi.omni.integracao.service.LogInternoService;
import com.escolpi.omni.integracao.util.Routes;
import com.escolpi.omni.integracao.view.MainWindow;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/integrations/ifood"})
public class IfoodIntegrationController {
    @Autowired
    private LogInternoService logService;
    private int retry = 3;

    @GetMapping(value={"/merchant/status"})
    public ResponseEntity<Boolean> getMerchantStatus() {
        try {
            RestTemplate rest = new RestTemplate();
            ObjectMapper mapper = new ObjectMapper();
            HttpHeaders header = this.getAuthorizationHeader();
            String url = Routes.getEndpoint((String)"https://merchant-api.ifood.com.br/merchant/v1.0/merchants/%s/status", (String[])new String[]{this.getSettings().getMerchantId()});
            ResponseEntity response = rest.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)header), String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                IFoodStoreStatusDto[] storeStatus = (IFoodStoreStatusDto[])mapper.readValue((String)response.getBody(), IFoodStoreStatusDto[].class);
                MainWindow.lblIFoodStatus.setText(String.format("Loja %s", storeStatus[0].getState().equals("OK") ? "aberta" : "fechada"));
                this.resetRetry();
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)true);
            }
            IFoodErrorDto error = (IFoodErrorDto)mapper.readValue((String)response.getBody(), IFoodErrorDto.class);
            throw new IntegrationException(error.getName());
        }
        catch (Exception e) {
            this.logService.save(new LogInterno(Boolean.valueOf(true), String.format("ERRO: %s", e.getMessage()), "IFOOD"));
            this.updateToken();
            this.getMerchantStatus();
            if (this.retry == 0) {
                this.resetRetry();
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)false);
            }
            return null;
        }
    }

    @GetMapping(value={"/authorization/request"})
    public ResponseEntity<?> getRequestAuthorizationCode() {
        try {
            RestTemplate rest = new RestTemplate();
            ObjectMapper mapper = new ObjectMapper();
            HttpHeaders headers = new HttpHeaders();
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
            body.add((Object)"clientId", (Object)this.getSettings().getClientId());
            ResponseEntity response = rest.exchange("https://merchant-api.ifood.com.br/authentication/v1.0/oauth/userCode", HttpMethod.POST, request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                IFoodAuthorizationRequestDto authRequest = (IFoodAuthorizationRequestDto)mapper.readValue((String)response.getBody(), IFoodAuthorizationRequestDto.class);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)authRequest);
            }
            IFoodErrorDto error = (IFoodErrorDto)mapper.readValue((String)response.getBody(), IFoodErrorDto.class);
            throw new IntegrationException(error.getName());
        }
        catch (IntegrationException | IOException | RestClientException e) {
            this.logService.save(new LogInterno(Boolean.valueOf(true), e.getMessage(), "IFOOD"));
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/authorization/request/user-code/{authorizationCode}"})
    public ResponseEntity<?> requestAccessToken(@PathVariable String authorizationCode, @RequestBody IFoodAuthorizationRequestDto authorizationRequest) {
        try {
            RestTemplate template = new RestTemplate();
            ObjectMapper mapper = new ObjectMapper();
            HttpHeaders headers = new HttpHeaders();
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            body.add((Object)"grantType", (Object)"authorization_code");
            body.add((Object)"clientId", (Object)this.getSettings().getClientId());
            body.add((Object)"clientSecret", (Object)this.getSettings().getClientSecret());
            body.add((Object)"authorizationCode", (Object)authorizationCode);
            body.add((Object)"authorizationCodeVerifier", (Object)authorizationRequest.getAuthorizationCodeVerifier());
            HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
            ResponseEntity response = template.exchange("https://merchant-api.ifood.com.br/authentication/v1.0/oauth/token", HttpMethod.POST, request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                IFoodAuthorizationDto authorization = (IFoodAuthorizationDto)mapper.readValue((String)response.getBody(), IFoodAuthorizationDto.class);
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)authorization);
            }
            IFoodErrorDto error = (IFoodErrorDto)mapper.readValue((String)response.getBody(), IFoodErrorDto.class);
            throw new IntegrationException(error.getName());
        }
        catch (IntegrationException | IOException e) {
            this.logService.save(new LogInterno(Boolean.valueOf(true), e.getMessage(), "IFOOD"));
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/authorization/update-token"})
    public void updateToken() {
        try {
            RestTemplate template = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            ObjectMapper mapper = new ObjectMapper();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"grantType", (Object)"refresh_token");
            body.add((Object)"clientId", (Object)this.getSettings().getClientId());
            body.add((Object)"clientSecret", (Object)this.getSettings().getClientSecret());
            body.add((Object)"refreshToken", (Object)this.getSettings().getRefreshToken());
            HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
            ResponseEntity response = template.exchange("https://merchant-api.ifood.com.br/authentication/v1.0/oauth/token", HttpMethod.POST, request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && null != response.getBody()) {
                IFoodAuthorizationDto auth = (IFoodAuthorizationDto)mapper.readValue((String)response.getBody(), IFoodAuthorizationDto.class);
                this.getSettings().setAccessToken(auth.getAccessToken());
                this.getSettings().setRefreshToken(auth.getRefreshToken());
                IntegrationConfig.updateConfigFile();
            }
            ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)true);
        }
        catch (IntegrationException | IOException e) {
            this.logService.save(new LogInterno(Boolean.valueOf(true), e.getMessage(), "IFOOD"));
            ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)false);
        }
    }

    private HttpHeaders getAuthorizationHeader() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("authorization", String.format("Bearer %s", this.getSettings().getAccessToken()));
        return headers;
    }

    private IFoodSettings getSettings() {
        return IntegrationConfig.config.getiFoodSettings();
    }

    private void resetRetry() {
        this.retry = 3;
    }
}

