/*
 * Decompiled with CFR 0.152.
 */
package br.com.escolpi.omni.printer.util;

import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Locale;
import javax.swing.text.MaskFormatter;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringUtil {
    public static String formatCurrency(Double valor) {
        NumberFormat nf = NumberFormat.getCurrencyInstance(new Locale("pt", "BR"));
        return nf.format(valor);
    }

    public static String removeSpecialCharacters(String text) {
        text = StringUtil.removeCharacter((String)text, (String)"!");
        text = StringUtil.removeCharacter((String)text, (String)"@");
        text = StringUtil.removeCharacter((String)text, (String)"#");
        text = StringUtil.removeCharacter((String)text, (String)"%");
        text = StringUtil.removeCharacter((String)text, (String)"\u00a8");
        text = StringUtil.removeCharacter((String)text, (String)"&");
        return text;
    }

    private static String removeCharacter(String text, String character) {
        while (text.contains(character)) {
            text = text.replace(character, "");
        }
        return text;
    }

    public static String generateWhitespace(int length) {
        StringBuilder spaces = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            spaces.append(' ');
        }
        return spaces.toString();
    }

    public static String formatarPrimeiraLetraMaiuscula(String str) {
        String valor = "";
        if (!StringUtils.isEmpty((Object)str)) {
            valor = Character.toUpperCase(str.charAt(0)) + str.substring(1);
            valor = valor.substring(0, 1) + valor.substring(1, valor.length()).toLowerCase();
        }
        return valor;
    }

    public static boolean isBlank(String valor) {
        return valor == null || valor.trim() == "";
    }

    public static boolean isNotBlank(String valor) {
        return valor != null && valor.length() > 0;
    }

    public static String formatar(String pattern, Object valor) throws ParseException {
        MaskFormatter mascara = new MaskFormatter(pattern);
        mascara.setValueContainsLiteralCharacters(false);
        try {
            return mascara.valueToString(valor);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatarCPF(String valor) throws ParseException {
        return StringUtil.formatar((String)"###.###.###-##", (Object)valor);
    }

    public static String formatarCNPJ(String valor) throws ParseException {
        return StringUtil.formatar((String)"##.###.###/####-##", (Object)valor);
    }

    public static final String formatarCpfCnpj(String valor) throws ParseException {
        return valor.length() > 11 ? StringUtil.formatarCNPJ((String)valor) : StringUtil.formatarCPF((String)valor);
    }

    public static String formatarCEP(String valor) throws ParseException {
        return StringUtil.formatar((String)"##.###-###", (Object)valor);
    }

    public static String formatarTelefone(String valor) throws ParseException {
        if (valor.length() == 11) {
            return StringUtil.formatar((String)"(##) #####-####", (Object)valor);
        }
        return StringUtil.formatar((String)"(##) ####-####", (Object)valor);
    }

    public static String formatarData(Date data) {
        if (data == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        return sdf.format(data);
    }

    public static String formatarMoeda(Double valor) {
        NumberFormat nf = NumberFormat.getCurrencyInstance(new Locale("pt", "BR"));
        return nf.format(valor);
    }

    public static String formatarDecimal(Double valor) {
        NumberFormat nf = NumberFormat.getInstance(new Locale("pt", "BR"));
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        return nf.format(valor);
    }

    public static String removerAcentos(String valor) {
        valor = Normalizer.normalize(valor, Normalizer.Form.NFD);
        valor = valor.replaceAll("[^\\p{ASCII}]", "");
        return valor;
    }

    public static String getStringHexa(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            int parteAlta = (bytes[i] >> 4 & 0xF) << 4;
            int parteBaixa = bytes[i] & 0xF;
            if (parteAlta == 0) {
                builder.append('0');
            }
            builder.append(Integer.toHexString(parteAlta | parteBaixa));
        }
        return builder.toString();
    }

    public static String codificarBase64(Number codigo) throws Exception {
        try {
            if (codigo != null) {
                return Base64.getEncoder().encodeToString(codigo.toString().getBytes("UTF-8"));
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("Erro ao codificar para base 64: ".concat(e.getMessage()));
        }
    }

    public static String decodificarBase64(String codigo) throws Exception {
        if (StringUtil.isNotBlank((String)codigo)) {
            return new String(Base64.getDecoder().decode(codigo));
        }
        return null;
    }

    public static String gerarSenha() {
        String[] caracteres = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "x", "w", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "X", "W", "Y", "Z"};
        String senha = "";
        for (int i = 0; i < 8; ++i) {
            int j = (int)(Math.random() * (double)caracteres.length);
            senha = senha + caracteres[j];
        }
        System.out.println("Sua senha gerada \u00e9: " + senha);
        return senha;
    }

    public static String obterExtensao(String nomeArquivo) {
        if (StringUtil.isNotBlank((String)nomeArquivo)) {
            return nomeArquivo.substring(nomeArquivo.lastIndexOf(46), nomeArquivo.length());
        }
        return null;
    }

    public static String obterNomeArquivo(String nomeArquivo) {
        if (StringUtil.isNotBlank((String)nomeArquivo)) {
            return nomeArquivo.substring(0, nomeArquivo.lastIndexOf(46));
        }
        return null;
    }

    public static String removerUltimoCaractere(String valor, String caractere) {
        if (StringUtil.isNotBlank((String)valor) && StringUtil.isNotBlank((String)caractere)) {
            return valor.substring(0, valor.lastIndexOf(caractere));
        }
        return null;
    }

    public static String minificarString(String valor) {
        if (StringUtil.isNotBlank((String)valor)) {
            valor = valor.replaceAll(" ", "");
            valor = valor.toLowerCase();
            valor = StringUtil.removerAcentos((String)valor);
            return valor;
        }
        return null;
    }

    public static String formatarFlag(boolean flag, String whenTrue, String whenFalse) {
        if (whenTrue != null && whenFalse != null) {
            if (flag) {
                return whenTrue;
            }
            return whenFalse;
        }
        return "N/A";
    }

    public static String truncarValor(String valor, Integer limite) {
        if (valor.length() >= limite) {
            valor = valor.substring(0, limite) + "...";
        }
        return valor;
    }

    public static String capitalizar(String valor) {
        if (!StringUtil.isBlank((String)valor)) {
            return StringUtils.capitalize((String)valor);
        }
        return "";
    }

    public static String retornaPrimeiroNome(String nomeCompleto) {
        if (nomeCompleto.contains(" ")) {
            return nomeCompleto.split(" ")[0];
        }
        return nomeCompleto;
    }

    public static String unaccent(String str) {
        String accentedLetters = "\u00b9\u00b2\u00b3\u00e1\u00e0\u00e2\u00e3\u00e4\u00e5\u0101\u0103\u0105\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u0100\u0102\u0104\u00c6\u0107\u010d\u00e7\u00a9\u0106\u010c\u00c7\u0110\u00d0\u00e8\u00e9\u00ea\u0451\u00eb\u0113\u0115\u0117\u0119\u011b\u00c8\u00ca\u00cb\u0401\u0112\u0114\u0116\u0118\u011a\u20ac\u011f\u011e\u0131\u00ec\u00ed\u00ee\u00ef\u00ec\u0129\u012b\u012d\u00cc\u00cd\u00ce\u00cf\u0407\u00cc\u0128\u012a\u012c\u0142\u0141 \u0144\u0148\u00f1\u0143\u0147\u00d1\u00f2\u00f3\u00f4\u00f5\u00f6\u014d\u014f\u0151\u00f8\u00d2\u00d3\u00d4\u00d5\u00d6\u014c\u014e\u0150\u00d8\u0152\u0159\u00ae\u0158\u0161\u015f\u0219\u00df\u0160\u015e\u0218\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u00d9\u00da\u00db\u00dc\u0168\u016a\u016c\u016e\u00fd\u00ff\u00dd\u0178\u017e\u017c\u017a\u017d\u017b\u0179\u00aa\u00ba";
        String unaccentedLetters = "123aaaaaaaaaAAAAAAAAAAccccCCCDDeeeeeeeeeeEEEEEEEEEegGiiiiiiiiiIIIIIIIIIlL nnnNNNoooooooooOOOOOOOOOOrrRssssSSSuuuuuuuuUUUUUUUUyyYYzzzZZZao";
        String[] accentedChars = accentedLetters.split("");
        String[] unaccentedChars = unaccentedLetters.split("");
        for (int i = 0; i < accentedChars.length; ++i) {
            if (!str.contains(accentedChars[i])) continue;
            str = str.replaceAll(accentedChars[i], unaccentedChars[i]);
        }
        return str;
    }

    public static String fixedLengthString(String string, int length) {
        return String.format("%1$" + length + "s", string);
    }

    public static String renderTableLine(String pattern, int breakLength, String[] values) {
        StringBuilder text = new StringBuilder("");
        int totalLines = new Double(values[1].length() / breakLength).intValue();
        for (int i = 0; i <= totalLines; ++i) {
            int pos = i * (breakLength - 1);
            if (i < totalLines) {
                text.append(String.format(pattern, i == 0 ? values[0] : "", values[1].substring(pos, pos + (breakLength - 1)), i == 0 ? values[2] : "")).append("\n");
                continue;
            }
            text.append(String.format(pattern, totalLines == 0 ? values[0] : "", values[1].substring(pos, values[1].length()), totalLines == 0 ? values[2] : "")).append("\n");
        }
        return text.toString();
    }
}

