/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.service;

import com.escolpi.omni.integracao.entity.ProdutoAlteracao;
import com.escolpi.omni.integracao.entity.dto.EmpresaDto;
import com.escolpi.omni.integracao.entity.dto.ProdutoDto;
import com.escolpi.omni.integracao.repository.ProdutoAlteracaoRepository;
import com.escolpi.omni.integracao.util.NullUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProdutoAlteracaoService {
    public static List<ProdutoAlteracao> productsToRemove = new ArrayList();
    public static List<ProdutoAlteracao> productsToUpdate = new ArrayList();
    @Autowired
    private ProdutoAlteracaoRepository repository;

    @Transactional
    public List<String> getProductsToRemove() {
        productsToRemove = new ArrayList();
        List products = this.repository.findAll();
        ArrayList<String> code = new ArrayList<String>();
        if (products.isEmpty()) {
            return code;
        }
        for (ProdutoAlteracao product : products) {
            if (this.isValid(product) || !product.getOperacao().equalsIgnoreCase("EXCLUSAO")) continue;
            code.add(product.getCodigoAtos());
            productsToRemove.add(product);
        }
        return code;
    }

    @Transactional
    public List<ProdutoDto> getProductsToUpdate() {
        productsToUpdate = new ArrayList();
        List changes = this.repository.findAll();
        ArrayList<ProdutoDto> products = new ArrayList<ProdutoDto>();
        if (changes.isEmpty()) {
            return products;
        }
        for (ProdutoAlteracao edit : changes) {
            if (this.isValid(edit) || !edit.getOperacao().equalsIgnoreCase("ALTERAR")) continue;
            ProdutoDto product = new ProdutoDto();
            EmpresaDto company = new EmpresaDto();
            company.setId(edit.getEmpresaId());
            if (NullUtil.isNotNull((Object)edit.getNome())) {
                product.setNome(edit.getNome());
            }
            if (NullUtil.isNotNull((Object)edit.getValor())) {
                product.setValor(BigDecimal.valueOf(edit.getValor()));
            }
            product.setEmFalta(edit.getEmFalta());
            product.setEmpresa(company);
            product.setCodigoAtos(edit.getCodigoAtos());
            products.add(product);
            productsToUpdate.add(edit);
        }
        return products;
    }

    private boolean isValid(ProdutoAlteracao product) {
        if (NullUtil.isNull((Object)product)) {
            return true;
        }
        if (NullUtil.isNull((Object)product.getCodigoAtos())) {
            return true;
        }
        return NullUtil.isNull((Object)product.getEmpresaId());
    }
}

