/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.service;

import com.escolpi.omni.integracao.components.IntegrationConfig;
import com.escolpi.omni.integracao.entity.ItemDoPedido;
import com.escolpi.omni.integracao.entity.Pedido;
import com.escolpi.omni.integracao.entity.Personalizacao;
import com.escolpi.omni.integracao.enumeration.FormaDeEntrega;
import com.escolpi.omni.integracao.enumeration.SituacaoDoPedido;
import com.escolpi.omni.integracao.exceptions.IntegrationException;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodAddictionalFee;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodBenefitDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodCustomerPhoneDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodOrderDetailDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodOrderItemDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodOrderItemOptionDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodPaymentMethodDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodSponsorshipValuesDto;
import com.escolpi.omni.integracao.repository.ItemDoPedidoRepository;
import com.escolpi.omni.integracao.repository.OpcionalRepository;
import com.escolpi.omni.integracao.repository.PedidoRepository;
import com.escolpi.omni.integracao.repository.ProdutoRepository;
import com.escolpi.omni.integracao.service.LogInternoService;
import com.escolpi.omni.integracao.service.PedidoAgoraIntegrationService;
import com.escolpi.omni.integracao.util.DateUtil;
import com.escolpi.omni.integracao.util.NullUtil;
import com.escolpi.omni.integracao.util.StringUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class IFoodIntegrationService {
    private final OpcionalRepository optionalRepository;
    private final ItemDoPedidoRepository orderItemRepository;
    private final ProdutoRepository productRepository;
    private final PedidoRepository repository;
    private final LogInternoService logService;
    private final Logger log = LoggerFactory.getLogger(PedidoAgoraIntegrationService.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final RestTemplate rest = new RestTemplate();

    public IFoodIntegrationService(OpcionalRepository optionalRepository, ItemDoPedidoRepository orderItemRepository, ProdutoRepository productRepository, PedidoRepository repository, LogInternoService logService) {
        this.optionalRepository = optionalRepository;
        this.orderItemRepository = orderItemRepository;
        this.productRepository = productRepository;
        this.repository = repository;
        this.logService = logService;
    }

    @Transactional
    public void createOrder(IFoodOrderDetailDto dto) throws IntegrationException {
        Pedido order = this.composeOrderBaseData(dto);
        IFoodIntegrationService.composeOrderPayment((IFoodOrderDetailDto)dto, (Pedido)order);
        IFoodIntegrationService.composeCustomerAddress((IFoodOrderDetailDto)dto, (Pedido)order);
        if (order.getFormaEntrega().equals("TAKEOUT")) {
            order.setFormaEntrega(FormaDeEntrega.RETIRAR_NO_LOCAL.name());
        }
        if (order.getFormaEntrega().equals("INDOOR")) {
            order.setFormaEntrega(FormaDeEntrega.NA_MESA.name());
            order.setMesa(dto.getIndoor().getTable().replace("Mesa ", ""));
            order.setNomeClienteMesa(order.getClienteNome());
        }
        IFoodIntegrationService.composeBenefitsDiscounts((IFoodOrderDetailDto)dto, (Pedido)order);
        this.repository.save((Object)order);
        this.saveOrderItems(dto, order);
        this.saveOrderAddictionalFee(dto, order);
    }

    private static void composeBenefitsDiscounts(IFoodOrderDetailDto dto, Pedido order) {
        if (!CollectionUtils.isEmpty((Collection)dto.getBenefits())) {
            order.setCupomDeDesconto("");
            HashMap benefits = new HashMap();
            benefits.put("LOJA", new ArrayList());
            benefits.put("IFOOD", new ArrayList());
            benefits.put("EXTERNAL", new ArrayList());
            benefits.put("CHAIN", new ArrayList());
            for (IFoodBenefitDto benefit : dto.getBenefits()) {
                for (IFoodSponsorshipValuesDto sponsorship : benefit.getSponsorshipValues()) {
                    ((List)benefits.get(sponsorship.getName().replace("MERCHANT", "LOJA"))).add(sponsorship.getValue());
                }
            }
            double totalByIFood = ((List)benefits.get("IFOOD")).stream().mapToDouble(value -> value).sum();
            double totalByIStore = ((List)benefits.get("LOJA")).stream().mapToDouble(value -> value).sum();
            if (CollectionUtils.isEmpty((Collection)((Collection)benefits.get("EXTERNAL")))) {
                totalByIStore += ((List)benefits.get("EXTERNAL")).stream().mapToDouble(value -> value).sum();
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)benefits.get("CHAIN")))) {
                totalByIStore += ((List)benefits.get("CHAIN")).stream().mapToDouble(value -> value).sum();
            }
            order.setCupomDeDesconto("LOJA " + StringUtil.formatValue((String)Double.toString(totalByIStore)) + "|IFOOD " + StringUtil.formatValue((String)Double.toString(totalByIFood)));
        }
    }

    private Pedido composeOrderBaseData(IFoodOrderDetailDto dto) {
        Pedido order = new Pedido();
        order.setRodizio(Boolean.FALSE);
        order.setOrigem("IFOOD");
        order.setSituacao(IntegrationConfig.config.getiFoodSettings().getAutoConfirmOrders() != false ? SituacaoDoPedido.CONFIRMADO : SituacaoDoPedido.AGUARDANDO_CONFIRMACAO);
        order.setPedidoIdApi(dto.getId().toString());
        order.setValorTarifaEntrega(dto.getTotal().getDeliveryFee());
        order.setFormaEntrega(dto.getOrderType());
        order.setClienteNome(StringUtil.removeSpecificCharacters((String)dto.getCustomer().getName().replace("PEDIDO DE TESTE - ", ""), (String[])new String[]{"'", "%"}));
        order.setClienteEmail("cliente.ifood");
        order.setClienteTelefone(this.getFormattedPhoneNumber(dto.getCustomer().getPhone()));
        order.setConfirmado("0");
        order.setCodigo(dto.getDisplayId());
        order.setDtHrPedido(DateUtil.format((String)"dd/MM/yyyy HH:mm:ss", (Date)dto.getCreatedAt()));
        if (StringUtil.isNotBlank((String)dto.getCustomer().getDocumentNumber())) {
            order.setCpfCnpjNota(dto.getCustomer().getDocumentNumber());
        }
        if (NullUtil.isNotNull((Object)dto.getSchedule())) {
            order.setDtHrAgendamento(DateUtil.format((String)"dd/MM/yyyy HH:mm:ss", (Date)dto.getSchedule().getDeliveryDateTimeStart()));
        }
        return order;
    }

    private static void composeOrderPayment(IFoodOrderDetailDto dto, Pedido order) {
        IFoodPaymentMethodDto iFoodPayment = (IFoodPaymentMethodDto)dto.getPayments().getMethods().get(0);
        order.setValorTroco(Double.valueOf(0.0));
        switch (iFoodPayment.getType().toUpperCase()) {
            case "CASH": {
                order.setFormaPagamento("DINHEIRO");
                order.setValorTroco(iFoodPayment.getCash().getChangeFor());
                break;
            }
            case "ONLINE": {
                order.setFormaPagamento("PAGO ONLINE");
                break;
            }
            default: {
                order.setFormaPagamento(dto.getOrderType().equals("DELIVERY") ? "NA ENTREGA" : "NA RETIRADA");
            }
        }
        String payment = iFoodPayment.getMethod();
        if (iFoodPayment.getCard() != null) {
            payment = payment + String.format(" - %s", iFoodPayment.getCard().getBrand());
        }
        order.setOpcaoPagamento(payment);
    }

    private String getFormattedPhoneNumber(IFoodCustomerPhoneDto phone) {
        String phoneId = phone.getLocalizer().replace(" ", "");
        String phoneNumber = phone.getNumber().replace(" ", "");
        return phoneNumber + " ID: " + phoneId;
    }

    private static void composeCustomerAddress(IFoodOrderDetailDto dto, Pedido order) {
        if (dto.getOrderType().equals("DELIVERY")) {
            StringBuilder fullAddress = new StringBuilder();
            fullAddress.append(StringUtil.isTextNull((String)dto.getDelivery().getDeliveryAddress().getStreetName()));
            fullAddress.append("|").append(dto.getDelivery().getDeliveryAddress().getStreetNumber());
            fullAddress.append("|").append(StringUtil.isTextNull((String)dto.getDelivery().getDeliveryAddress().getNeighborhood()));
            fullAddress.append("|").append(StringUtil.isTextNull((String)dto.getDelivery().getDeliveryAddress().getCity()));
            fullAddress.append("|").append(StringUtil.isTextNull((String)dto.getDelivery().getDeliveryAddress().getState()));
            String complement = StringUtil.isTextNull((String)dto.getDelivery().getDeliveryAddress().getComplement());
            if (StringUtil.isNotBlank((String)complement)) {
                fullAddress.append("|").append(StringUtil.isTextNull((String)complement));
            }
            if (StringUtil.isNotBlank((String)dto.getDelivery().getDeliveryAddress().getReference())) {
                fullAddress.append("|").append(dto.getDelivery().getDeliveryAddress().getReference());
            }
            order.setEnderecoEntrega(StringUtil.removeSpecificCharacters((String)fullAddress.toString().replace("PEDIDO DE TESTE - N\u00c3O ENTREGAR - ", ""), (String[])new String[]{"'", "%"}));
            order.setCep(dto.getDelivery().getDeliveryAddress().getPostalCode());
        }
    }

    @Transactional
    private void saveOrderItems(IFoodOrderDetailDto dto, Pedido order) {
        for (IFoodOrderItemDto item : dto.getItems()) {
            Optional productEntry;
            ItemDoPedido orderItem = new ItemDoPedido(order);
            orderItem.setProdutoNome(item.getName());
            orderItem.setQuantidade(item.getQuantity());
            orderItem.setValor(item.getTotalPrice());
            orderItem.setObservacoes(item.getObservations());
            orderItem.setIndPromocao("0");
            orderItem.setProdutoCodigoAtos(StringUtil.isNotBlank((String)item.getExternalCode()) ? item.getExternalCode() : IntegrationConfig.config.getDefaultProductCode());
            orderItem.setObservacoes(item.getObservations());
            if (!orderItem.getProdutoCodigoAtos().equals(IntegrationConfig.config.getDefaultProductCode()) && !(productEntry = this.productRepository.findById((Object)orderItem.getProdutoCodigoAtos())).isPresent()) {
                this.logService.saveAndShowLog(Boolean.valueOf(true), String.format("O c\u00f3digo do PDV(%s) do produto %s n\u00e3o foi encontrado!", item.getExternalCode(), item.getName()), "IFOOD", this.log);
                continue;
            }
            this.orderItemRepository.save((Object)orderItem);
            this.saveOrderItemOptionals(orderItem, item);
        }
    }

    @Transactional
    private void saveOrderAddictionalFee(IFoodOrderDetailDto dto, Pedido order) {
        if (!CollectionUtils.isEmpty((Collection)dto.getAdditionalFees())) {
            for (IFoodAddictionalFee fee : dto.getAdditionalFees()) {
                ItemDoPedido feeOrderItem = new ItemDoPedido(order);
                feeOrderItem.setProdutoNome(fee.getDescription());
                feeOrderItem.setProdutoCodigoAtos("99996");
                feeOrderItem.setQuantidade(Double.valueOf(1.0));
                feeOrderItem.setValor(fee.getValue());
                feeOrderItem.setObservacoes(fee.getFullDescription());
                feeOrderItem.setIndPromocao("0");
                this.orderItemRepository.save((Object)feeOrderItem);
            }
        }
    }

    @Transactional
    private void saveOrderItemOptionals(ItemDoPedido orderItem, IFoodOrderItemDto item) {
        if (!CollectionUtils.isEmpty((Collection)item.getOptions())) {
            for (IFoodOrderItemOptionDto option : item.getOptions()) {
                Personalizacao optional = new Personalizacao(orderItem);
                optional.setPersonalizacaoDescricao(option.getName());
                optional.setPersonalizacaoValor(option.getPrice());
                optional.setQuantidade(Integer.valueOf(option.getQuantity().intValue()));
                this.optionalRepository.save((Object)optional);
            }
        }
    }
}

