/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.components;

import com.escolpi.omni.integracao.components.ConnectionComponent;
import com.escolpi.omni.integracao.components.IntegrationConfig;
import com.escolpi.omni.integracao.components.integrations.CardapioDigitalIntegrationComponent;
import com.escolpi.omni.integracao.components.integrations.IFoodIntegrationComponent;
import com.escolpi.omni.integracao.components.integrations.PedidoAgoraIntegrationComponent;
import com.escolpi.omni.integracao.exceptions.IntegrationException;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodOrderEventDto;
import com.escolpi.omni.integracao.view.MainWindow;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;

@Component
@EnableScheduling
@EnableAsync
public class IntegrationTasks {
    private final ReentrantLock cardapioDigitalLock = new ReentrantLock();
    private final ReentrantLock iFoodLock = new ReentrantLock();
    private final ReentrantLock pedidoAgoraLock = new ReentrantLock();
    private static final Logger log = LoggerFactory.getLogger(IntegrationTasks.class);
    private final ConnectionComponent connectionComponent;
    private final CardapioDigitalIntegrationComponent cdIntegration;
    private final PedidoAgoraIntegrationComponent pdagIntegration;
    private final IFoodIntegrationComponent ifoodIntegration;

    public IntegrationTasks(ConnectionComponent connectionComponent, CardapioDigitalIntegrationComponent cdIntegration, PedidoAgoraIntegrationComponent pdagIntegration, IFoodIntegrationComponent ifoodIntegration) {
        this.connectionComponent = connectionComponent;
        this.cdIntegration = cdIntegration;
        this.pdagIntegration = pdagIntegration;
        this.ifoodIntegration = ifoodIntegration;
    }

    @Scheduled(fixedRate=60000L, initialDelay=1000L)
    public void checkConnection() throws IntegrationException {
        try {
            this.connectionComponent.checkDatabaseConnection();
            this.connectionComponent.checkIntegrationConnections();
            MainWindow.setRunningState();
        }
        catch (IntegrationException | ResourceAccessException e) {
            MainWindow.setErrorState((String)e.getMessage());
        }
    }

    @Async
    @Scheduled(fixedRate=60000L, initialDelay=1000L)
    public void processOrders() {
        if (IntegrationConfig.isPedidoAgoraActive()) {
            this.processPedidoAgoraOrders();
        }
        if (IntegrationConfig.isIFoodActive()) {
            this.processIFoodOrders();
        }
    }

    @Async
    @Scheduled(fixedRate=15000L, initialDelay=1000L)
    public void processCardapioDigitalOrders() {
        if (IntegrationConfig.isCardapioDigitalActive()) {
            this.cardapioDigitalLock.lock();
            try {
                boolean isNotRestricted = this.cdIntegration.getRestrictionState();
                if (isNotRestricted) {
                    log.info("Recebendo novo(s) pedido(s) do Card\u00e1pio Digital ...");
                    this.cdIntegration.receiveNewOrders();
                    log.info("Recebendo novo(s) pedido(s) do Card\u00e1pio Digital    OK");
                    log.info("Sincronizando atualiza\u00e7\u00e3o de comandas Card\u00e1pio Digital ...");
                    this.cdIntegration.syncronizeOrderUpdates();
                    log.info("Sincronizando atualiza\u00e7\u00e3o de comandas Card\u00e1pio Digital    OK");
                    log.info("Encerrando solicita\u00e7\u00f5es de fechamento de comandas ...");
                    this.cdIntegration.closeRequestedOrderControls();
                    log.info("Encerrando solicita\u00e7\u00f5es de fechamento de comandas    OK");
                    log.info("Finalizando comandas...");
                    this.cdIntegration.finalizeOrderControls();
                    log.info("Finalizando comandas   OK");
                }
                this.setLastCheck("cardapioDigital");
            }
            finally {
                this.setLastCheck("cardapioDigital");
                this.cardapioDigitalLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIFoodOrders() {
        this.iFoodLock.lock();
        try {
            boolean isOpened = this.ifoodIntegration.getMerchantStatus();
            if (isOpened) {
                log.info("Obtendo eventos de pedido do IFood ...");
                List events = this.ifoodIntegration.receiveOrderEvents();
                boolean eventsHasBeenAckowledged = this.ifoodIntegration.sendEventsAckowledgement(events);
                log.info("Obtendo eventos de pedido do IFood    OK");
                if (eventsHasBeenAckowledged) {
                    log.info("Importando pedidos do IFood...");
                    for (IFoodOrderEventDto event : events) {
                        if (this.ifoodIntegration.wasOrderImported(event.getOrderId().toString())) continue;
                        this.ifoodIntegration.receiveOrder(event.getOrderId());
                    }
                    log.info("Importando pedidos do IFood    OK");
                }
                log.info("Atualizando pedidos do IFood ...");
                this.ifoodIntegration.updateOrders();
                log.info("Atualizando pedidos do IFood    OK");
            }
        }
        finally {
            this.setLastCheck("IFOOD");
            this.iFoodLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPedidoAgoraOrders() {
        this.pedidoAgoraLock.lock();
        try {
            boolean isNotRestricted = this.pdagIntegration.getRestrictionState();
            if (isNotRestricted) {
                boolean isOpened = this.pdagIntegration.getOpeningStoreState();
                boolean importOrderWhenStoreClosed = this.pdagIntegration.getImportOrdersWhenClosedStore();
                if (isOpened || importOrderWhenStoreClosed) {
                    log.info("Recebendo novo(s) pedido(s) do Pedido Agora ...");
                    this.pdagIntegration.receiveNewOrders();
                    log.info("Recebendo novo(s) pedido(s) do Pedido Agora    OK");
                    log.info("Atualizado pedido(s) do Pedido Agora ...");
                    this.pdagIntegration.updateOrders();
                    log.info("Atualizado pedido(s) do Pedido Agora    OK");
                }
            }
        }
        finally {
            this.setLastCheck("pedidoAgora");
            this.pedidoAgoraLock.unlock();
        }
    }

    private void setLastCheck(String company) {
        IntegrationConfig.setLastCheck((String)company);
        MainWindow.defineLastChecking();
    }
}

