/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.service;

import com.escolpi.omni.integracao.entity.LogInterno;
import com.escolpi.omni.integracao.repository.LogInternoRepository;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogInternoService {
    public static final Logger logger = LoggerFactory.getLogger(LogInternoService.class);
    @Autowired
    private LogInternoRepository logInternoRepository;

    @Transactional
    public void deleteOldLogs() {
        List logs = this.logInternoRepository.selectOldLogs();
        logs.forEach(log -> this.logInternoRepository.deleteById((Object)log.getId()));
    }

    @Transactional
    public void save(LogInterno log) {
        try {
            this.logInternoRepository.save((Object)log);
        }
        catch (Exception e) {
            logger.error(log.getMensagem(), (Object)(log.getErro() != false ? "-error" : ""));
        }
    }

    @Deprecated
    public void saveAndShowLog(Boolean isError, String message, String origin) {
        this.save(new LogInterno(isError, message));
        logger.error(message);
    }

    @Deprecated
    public void saveAndShowLog(Boolean isError, String message, String origin, String additionalInfo) {
        this.save(new LogInterno(isError, message, additionalInfo));
        logger.info(message);
    }

    @Transactional
    public void saveAndShowLog(Boolean isError, String message, String origin, Logger log) {
        this.save(new LogInterno(isError, message, origin));
        if (isError.booleanValue()) {
            log.error(message);
        } else {
            log.info(message);
        }
    }
}

