/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.components;

import com.escolpi.omni.integracao.entity.configs.MainConfiguration;
import com.escolpi.omni.integracao.exceptions.IntegrationException;
import com.escolpi.omni.integracao.util.DateUtil;
import com.escolpi.omni.integracao.util.NullUtil;
import com.escolpi.omni.integracao.util.StringUtil;
import com.escolpi.omni.integracao.view.MainWindow;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.aspectj.util.FileUtil;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class IntegrationConfig {
    public static final String CONFIG_FILE_NAME = "integracao-cfg.json";
    public static final String CONFIG_BACKUP_FILE_NAME = "integracao-cfg-bkp.json";
    public static final String DEFAULT_CONFIG_FILE_NAME = "integracao-cfg-default.json";
    public static MainConfiguration config = new MainConfiguration();

    public static boolean isCardapioDigitalActive() {
        return config.getIntegrations().getCardapioDigital();
    }

    public static boolean isIFoodActive() {
        return config.getIntegrations().getiFood();
    }

    public static boolean isPedidoAgoraActive() {
        return config.getIntegrations().getPedidoAgora();
    }

    public static void readConfigFile() throws IOException {
        String pathname = System.getProperty("user.dir") + File.separator + "integracao-cfg.json";
        File configFile = new File(pathname);
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        config = (MainConfiguration)mapper.readValue(configFile, MainConfiguration.class);
        if (configFile.createNewFile()) {
            File defaultConfigFile = Paths.get(System.getProperty("user.dir") + File.separator + "integracao-cfg-default.json", new String[0]).toFile();
            MainConfiguration defaultContig = (MainConfiguration)mapper.readValue(defaultConfigFile, MainConfiguration.class);
            mapper.writeValue(configFile, (Object)defaultContig);
        }
        IntegrationConfig.checkExistingBackupFile();
        IntegrationConfig.validateGeneralSettings();
        if (Boolean.TRUE.equals(config.getIntegrations().getPedidoAgora())) {
            IntegrationConfig.validatePedidoAgoraSettings();
        }
        if (Boolean.TRUE.equals(config.getIntegrations().getCardapioDigital())) {
            IntegrationConfig.validateCardapioDigitalSettings();
        }
        if (Boolean.TRUE.equals(config.getIntegrations().getiFood())) {
            IntegrationConfig.validateIFoodSettings();
        }
        int i = 0;
        if (IntegrationConfig.isPedidoAgoraActive()) {
            MainWindow.setPedidoAgoraStatus((String)("Cod. " + config.getPedidoAgoraSettings().getCompanyId()));
            ++i;
        }
        if (IntegrationConfig.isCardapioDigitalActive()) {
            MainWindow.setCardapioDigitalStatus((String)("Cod. " + config.getCardapioDigitalSettings().getCompanyId()));
            ++i;
        }
        if (IntegrationConfig.isIFoodActive()) {
            ++i;
        }
        if (i == 0) {
            String logMessage = "Nenhuma integra\u00e7\u00e3o ativada.";
            JOptionPane.showMessageDialog(null, logMessage, "Aten\u00e7\u00e3o!", 2);
            System.exit(0);
        }
        if (IntegrationConfig.isPedidoAgoraActive()) {
            IntegrationConfig.setLastCheck((String)"pedidoAgora");
        }
        if (IntegrationConfig.isCardapioDigitalActive()) {
            IntegrationConfig.setLastCheck((String)"cardapioDigital");
        }
        if (IntegrationConfig.isIFoodActive()) {
            IntegrationConfig.setLastCheck((String)"IFOOD");
        }
    }

    public static void setLastCheck(String company) {
        String currentTime = DateUtil.calendarToStringDateAndHour((Calendar)Calendar.getInstance(), (String)"yyyy-MM-dd HH:mm:ss");
        if (IntegrationConfig.isPedidoAgoraActive() && company.equals("pedidoAgora")) {
            config.getLastChecks().getPedidoAgora().setCompanyBlock(currentTime);
            config.getLastChecks().getPedidoAgora().setNewOrders(currentTime);
        }
        if (IntegrationConfig.isCardapioDigitalActive() && company.equals("cardapioDigital")) {
            config.getLastChecks().getCardapioDigital().setCompanyBlock(currentTime);
            config.getLastChecks().getCardapioDigital().setNewOrders(currentTime);
        }
        if (IntegrationConfig.isIFoodActive() && company.equals("IFOOD")) {
            config.getLastChecks().getiFood().setKeepStoreOpened(currentTime);
            config.getLastChecks().getiFood().setMerchantStatus(currentTime);
            config.getLastChecks().getiFood().setUpdatesOnProducts(currentTime);
        }
        IntegrationConfig.updateConfigFile();
    }

    public static void updateConfigFile() {
        try {
            String configFilePath = System.getProperty("user.dir") + File.separator + "integracao-cfg.json";
            ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
            mapper.writeValue(new File(configFilePath), (Object)config);
        }
        catch (IOException e) {
            throw new IntegrationException("Erro ao atualizar as configura\u00e7\u00f5es. A integra\u00e7\u00e3o ser\u00e1 encerrada. Entre em contato com nosso suporte caso o problema persista.");
        }
    }

    private static void checkExistingBackupFile() throws IOException {
        block27: {
            String basePathName = System.getProperty("user.dir") + File.separator;
            File backupFile = new File(basePathName + "integracao-cfg-bkp.json");
            File configFile = new File(basePathName + "integracao-cfg-default.json");
            if (backupFile.createNewFile()) {
                FileUtil.copyFile((File)configFile, (File)backupFile);
            }
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(configFile.getPath()));){
                String existingText = "";
                String line = bufferedReader.readLine();
                if (StringUtil.isNotBlank((String)line)) {
                    while (line != null) {
                        existingText = existingText + line + "\n";
                        line = bufferedReader.readLine();
                    }
                    String path = backupFile.getPath();
                    backupFile.delete();
                    try (FileWriter fileWriter = new FileWriter(path);){
                        fileWriter.write(existingText);
                        break block27;
                    }
                }
                FileUtil.copyFile((File)backupFile, (File)configFile);
            }
        }
    }

    private static void validateCardapioDigitalSettings() {
        ArrayList<String> missingSettings = new ArrayList<String>();
        if (NullUtil.isNull((Object)config.getCardapioDigitalSettings().getGetTestOrders())) {
            missingSettings.add("getTestOrders");
        }
        if (NullUtil.isNull((Object)config.getCardapioDigitalSettings().getCompanyId())) {
            missingSettings.add("companyId");
        }
        if (!missingSettings.isEmpty()) {
            IntegrationConfig.showMissingConfigAlert(missingSettings);
            System.exit(0);
        }
    }

    private static void validateIFoodSettings() {
        ArrayList<String> missingSettings = new ArrayList<String>();
        if (NullUtil.isNull((Object)config.getiFoodSettings().getAutoConfirmOrders())) {
            missingSettings.add("autoConfirmOrders");
        }
        if (NullUtil.isNull((Object)config.getiFoodSettings().getClientId())) {
            missingSettings.add("clientId");
        }
        if (NullUtil.isNull((Object)config.getiFoodSettings().getClientSecret())) {
            missingSettings.add("clientSecret");
        }
        if (NullUtil.isNull((Object)config.getiFoodSettings().getCustomizationExternalCodes())) {
            missingSettings.add("customizationExternalCodes");
        }
        if (NullUtil.isNull((Object)config.getiFoodSettings().getAccessToken())) {
            missingSettings.add("refreshToken");
        }
        if (NullUtil.isNull((Object)config.getiFoodSettings().getMerchantId())) {
            missingSettings.add("merchantId");
        }
        if (!missingSettings.isEmpty()) {
            IntegrationConfig.showMissingConfigAlert(missingSettings);
            System.exit(0);
        }
    }

    private static void validateGeneralSettings() {
        ArrayList<String> missingSettings = new ArrayList<String>();
        if (!(IntegrationConfig.isPedidoAgoraActive() || IntegrationConfig.isIFoodActive() || IntegrationConfig.isCardapioDigitalActive())) {
            String message = String.format("Erro ao iniciar integra\u00e7\u00e3o: %s", "Ao menos um servi\u00e7o de integra\u00e7\u00e3o precisa estar ativado");
            JOptionPane.showMessageDialog(null, message, "Aten\u00e7\u00e3o", 0);
            System.exit(0);
            return;
        }
        if (NullUtil.isNull((Object)config.getCheckDatabaseConnection())) {
            missingSettings.add("checkDatabaseConnection");
        }
        if (NullUtil.isNull((Object)config.getCheckInternetConnection())) {
            missingSettings.add("checkInternetConnection");
        }
        if (NullUtil.isNull((Object)config.getDefaultProductCode())) {
            missingSettings.add("defaultProductCode");
        }
        if (NullUtil.isNull((Object)config.getIntegrations())) {
            missingSettings.add("integrations");
        }
        if (NullUtil.isNull((Object)config.getHideOnClose())) {
            missingSettings.add("hideOnClose");
        }
        if (NullUtil.isNull((Object)config.getImageName())) {
            missingSettings.add("imageName");
        }
        if (NullUtil.isNull((Object)config.getIntegrations().getPedidoAgora())) {
            missingSettings.add("integrations");
        }
        if (NullUtil.isNull((Object)config.getLastChecks())) {
            missingSettings.add("lastChecks");
        }
        if (NullUtil.isNull((Object)config.getPedidoAgoraSettings().getPartnerCode())) {
            missingSettings.add("partnerCode");
        }
        if (NullUtil.isNull((Object)config.getSaveLogs())) {
            missingSettings.add("saveLogs");
        }
        if (NullUtil.isNull((Object)config.getVerifyUpdatesOnProducts())) {
            missingSettings.add("verifyUpdatesOnProducts");
        }
        if (!missingSettings.isEmpty()) {
            IntegrationConfig.showMissingConfigAlert(missingSettings);
            System.exit(0);
        }
    }

    private static void validatePedidoAgoraSettings() {
        ArrayList<String> missingSettings = new ArrayList<String>();
        if (NullUtil.isNull((Object)config.getPedidoAgoraSettings().getGetTestOrders())) {
            missingSettings.add("getTestOrders");
        }
        if (NullUtil.isNull((Object)config.getPedidoAgoraSettings().getCompanyId())) {
            missingSettings.add("companyId");
        }
        if (!missingSettings.isEmpty()) {
            IntegrationConfig.showMissingConfigAlert(missingSettings);
            System.exit(0);
        }
    }

    private static void showMissingConfigAlert(List<String> missingSettings) {
        JOptionPane.showMessageDialog(null, String.format("Uma ou mais configura\u00e7\u00f5es n\u00e3o est\u00e3o definidas:%n%s%nPor favor, verifique.", missingSettings.stream().map(config -> "\"" + config + "\"").collect(Collectors.joining(","))));
    }
}

