/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.components.integrations;

import com.escolpi.omni.integracao.components.IntegrationConfig;
import com.escolpi.omni.integracao.components.integrations.PedidoAgoraIntegrationComponent;
import com.escolpi.omni.integracao.components.routes.RouteComponent;
import com.escolpi.omni.integracao.entity.LogInterno;
import com.escolpi.omni.integracao.entity.Pedido;
import com.escolpi.omni.integracao.entity.configs.PedidoAgoraSettings;
import com.escolpi.omni.integracao.enumeration.SituacaoDoPedido;
import com.escolpi.omni.integracao.enums.IntegrationVendor;
import com.escolpi.omni.integracao.exceptions.IntegrationException;
import com.escolpi.omni.integracao.exceptions.StoreClosedException;
import com.escolpi.omni.integracao.exceptions.StoreRestrictedException;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.AtualizacaoDePedidoDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.PedidoDto;
import com.escolpi.omni.integracao.service.AtualizacaoDeSituacaoService;
import com.escolpi.omni.integracao.service.LogInternoService;
import com.escolpi.omni.integracao.service.PedidoAgoraIntegrationService;
import com.escolpi.omni.integracao.util.RestUtil;
import com.escolpi.omni.integracao.util.StringUtil;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class PedidoAgoraIntegrationComponent {
    private final LogInternoService logService;
    private final PedidoAgoraIntegrationService orderService;
    private final AtualizacaoDeSituacaoService updateService;
    private final Logger log = LoggerFactory.getLogger(PedidoAgoraIntegrationComponent.class);
    private final PriorityQueue<Long> orderQueue = new PriorityQueue();
    private final ObjectMapper mapper = new ObjectMapper();
    private final RestTemplate rest;
    private final RouteComponent routeComponent;
    public static final int ORDERS_PER_RECEIVING = 10;

    public PedidoAgoraIntegrationComponent(LogInternoService logService, PedidoAgoraIntegrationService orderService, AtualizacaoDeSituacaoService updateStatusService, RestTemplate rest, RouteComponent routeComponent) {
        this.logService = logService;
        this.updateService = updateStatusService;
        this.orderService = orderService;
        this.rest = rest;
        this.routeComponent = routeComponent;
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public boolean getRestrictionState() {
        try {
            String url = this.routeComponent.getEndpoint(this.routeComponent.getPedidoAgoraBaseUrl(), "/check-restriction", new String[]{this.getConfig().getCompanyId().toString()});
            ResponseEntity response = this.rest.exchange(url, HttpMethod.GET, RestUtil.getEntityWithUserAgent(), Boolean.class, new Object[0]);
            boolean isRestricted = Boolean.TRUE.equals(response.getBody());
            System.out.println(">>> IS RESTRICTED: " + isRestricted);
            if (!isRestricted) {
                throw new StoreRestrictedException(IntegrationVendor.PEDIDO_AGORA.getDescricao());
            }
            return true;
        }
        catch (HttpClientErrorException e) {
            this.entryErrorLog(e);
            return false;
        }
        catch (StoreRestrictedException e) {
            this.log.info(e.getMessage());
            return false;
        }
    }

    @Transactional
    public boolean getOpeningStoreState() {
        try {
            String url = this.routeComponent.getEndpoint(this.routeComponent.getPedidoAgoraBaseUrl(), "/opening-state", new String[]{this.getConfig().getCompanyId().toString()});
            ResponseEntity response = this.rest.exchange(url, HttpMethod.GET, RestUtil.getEntityWithUserAgent(), Boolean.class, new Object[0]);
            boolean isOpened = Boolean.TRUE.equals(response.getBody());
            if (!isOpened) {
                throw new StoreClosedException(IntegrationVendor.PEDIDO_AGORA.getDescricao());
            }
            return true;
        }
        catch (HttpClientErrorException e) {
            this.entryErrorLog(e);
            return false;
        }
        catch (StoreClosedException e) {
            this.log.info(e.getMessage());
            return false;
        }
    }

    @Transactional
    public void receiveNewOrders() throws IntegrationException {
        try {
            if (this.orderQueue.isEmpty()) {
                this.prepareOrderQueue();
            } else {
                String url;
                ResponseEntity response;
                ArrayList<Long> importedOrders = new ArrayList<Long>();
                while (!this.orderQueue.isEmpty()) {
                    if (this.orderService.countOrderByAPIId(((Long)this.orderQueue.peek()).toString()) != 0L) continue;
                    PedidoDto order = this.getOrderFromPedidoAgoraApi((Long)this.orderQueue.peek());
                    if (!this.getConfig().getGetTestOrders().booleanValue() && order.getTeste().booleanValue()) {
                        this.logService.saveAndShowLog(Boolean.valueOf(false), "Esta loja n\u00e3o permite recebimento de pedido de testes.", "PEDIDO_AGORA", this.log);
                        this.orderQueue.remove();
                        continue;
                    }
                    Pedido created = this.orderService.createOrder(order);
                    importedOrders.add(Long.valueOf(created.getPedidoIdApi()));
                    this.logService.saveAndShowLog(Boolean.valueOf(false), String.format("Pedido n\u00ba %s foi importado com sucesso!", created.getPedidoIdApi()), "PEDIDO_AGORA", this.log);
                    this.orderQueue.remove();
                }
                if (!CollectionUtils.isEmpty(importedOrders) && !(response = this.rest.postForEntity(url = this.routeComponent.getEndpoint(this.routeComponent.getPedidoAgoraBaseUrl(), "/order/confirm/import", new String[]{this.getConfig().getCompanyId().toString()}), (Object)RestUtil.getEntityWithUserAgent(importedOrders), Object.class, new Object[0])).getStatusCode().equals((Object)HttpStatus.ACCEPTED)) {
                    String notImportedOrders = importedOrders.stream().map(String::valueOf).collect(Collectors.joining(","));
                    this.logService.saveAndShowLog(Boolean.valueOf(true), String.format("Os pedido(s) %s n\u00e3o puderam ser importado(s).", notImportedOrders), "P AGORA", this.log);
                }
            }
        }
        catch (Exception e) {
            this.logService.save(new LogInterno(Boolean.valueOf(true), e.getMessage(), "PEDIDO_AGORA"));
        }
    }

    @Transactional
    public void updateOrders() {
        try {
            List updates = this.updateService.listOrderUpdates("P AGORA");
            if (!CollectionUtils.isEmpty((Collection)updates)) {
                ArrayList ordersToUpdate = new ArrayList();
                HashSet ids = new HashSet();
                updates.stream().filter(update -> StringUtil.isNumeric((String)update.getPedidoId()) && ordersToUpdate.stream().noneMatch(u -> u.getId().equals(Long.valueOf(update.getPedidoId())))).forEach(update -> {
                    ordersToUpdate.add(new AtualizacaoDePedidoDto(Long.valueOf(update.getPedidoId()), SituacaoDoPedido.get((int)update.getSituacaoDoPedido())));
                    ids.add(update.getId());
                });
                String url = this.routeComponent.getEndpoint(this.routeComponent.getPedidoAgoraBaseUrl(), "/order/update", new String[]{this.getConfig().getCompanyId().toString()});
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                ResponseEntity response = this.rest.exchange(url, HttpMethod.PUT, RestUtil.getEntityWithUserAgent((HttpHeaders)headers, ordersToUpdate), String.class, new Object[0]);
                if (response.getStatusCode().equals((Object)HttpStatus.ACCEPTED)) {
                    this.updateService.deleteIn(ids);
                    String idList = ids.stream().map(Object::toString).collect(Collectors.joining(","));
                    this.logService.saveAndShowLog(Boolean.valueOf(false), String.format("Os pedidos %s foram atualizados com sucesso!", idList), "PEDIDO_AGORA", this.log);
                }
            }
        }
        catch (IntegrationException e) {
            this.logService.saveAndShowLog(Boolean.valueOf(true), e.getMessage(), "PEDIDO_AGORA", this.log);
        }
        catch (HttpClientErrorException e) {
            this.entryErrorLog(e);
        }
        catch (Exception e) {
            this.logService.saveAndShowLog(Boolean.valueOf(true), String.format("Ocorreu um problema ao atualizar o(s) pedido(s): %s", e.getMessage()), "PEDIDO_AGORA", this.log);
        }
    }

    @Transactional
    private void entryErrorLog(HttpClientErrorException e) {
        switch (1.$SwitchMap$org$springframework$http$HttpStatus[e.getStatusCode().ordinal()]) {
            case 1: {
                this.logService.saveAndShowLog(Boolean.valueOf(true), "Ocorreu um problema ao realizar uma requisi\u00e7\u00e3o: %s", "PEDIDO_AGORA", this.log);
                break;
            }
            case 2: {
                this.logService.saveAndShowLog(Boolean.valueOf(true), String.format("Ocorreu um problema ao realizar uma requisi\u00e7\u00e3o: %s", e.getMessage()), "PEDIDO_AGORA", this.log);
                break;
            }
            case 3: {
                this.logService.saveAndShowLog(Boolean.valueOf(true), String.format("O servi\u00e7o do Pedido Agora est\u00e1 indispon\u00edvel: %s", e.getMessage()), "PEDIDO_AGORA", this.log);
            }
            case 4: {
                this.logService.saveAndShowLog(Boolean.valueOf(true), "Erro interno no servi\u00e7o do Pedido Agora: %s", "PEDIDO_AGORA", this.log);
            }
        }
    }

    private PedidoAgoraSettings getConfig() {
        return IntegrationConfig.config.getPedidoAgoraSettings();
    }

    private PedidoDto getOrderFromPedidoAgoraApi(Long id) {
        try {
            String url = this.routeComponent.getEndpoint(this.routeComponent.getPedidoAgoraBaseUrl(), "/order/%s", new String[]{this.getConfig().getCompanyId().toString(), id.toString()});
            ResponseEntity response = this.rest.exchange(url, HttpMethod.GET, RestUtil.getEntityWithUserAgent(), String.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                return (PedidoDto)this.mapper.readValue((String)response.getBody(), PedidoDto.class);
            }
            if (response.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                throw new IntegrationException("O Pedido %s n\u00e3o foi identificado na plataforma do Pedido Agora.");
            }
            throw new IntegrationException(String.format("O Pedido %s n\u00e3o foi obtido. Verifique a disponibilidade da plataforma %s", id, "PEDIDO_AGORA"));
        }
        catch (Exception e) {
            throw new IntegrationException(e.getMessage());
        }
    }

    private void prepareOrderQueue() {
        try {
            String url = this.routeComponent.getEndpoint(this.routeComponent.getPedidoAgoraBaseUrl(), "/new-orders/", new String[]{this.getConfig().getCompanyId().toString()});
            ResponseEntity response = this.rest.exchange(url, HttpMethod.GET, RestUtil.getEntityWithUserAgent(), String.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                Arrays.stream((Object[])this.mapper.readValue((String)response.getBody(), Long[].class)).filter(id -> !this.orderQueue.contains(id)).collect(Collectors.toList()).forEach(id -> {
                    if (this.orderQueue.size() < 10) {
                        this.orderQueue.add(id);
                    }
                });
                if (!this.orderQueue.isEmpty()) {
                    this.receiveNewOrders();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage());
        }
    }
}

