/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.components.integrations;

import com.escolpi.omni.integracao.components.IntegrationConfig;
import com.escolpi.omni.integracao.components.routes.RouteComponent;
import com.escolpi.omni.integracao.entity.AtualizacaoDeSituacao;
import com.escolpi.omni.integracao.entity.LogInterno;
import com.escolpi.omni.integracao.entity.configs.IFoodSettings;
import com.escolpi.omni.integracao.enumeration.SituacaoDoPedido;
import com.escolpi.omni.integracao.enums.IntegrationVendor;
import com.escolpi.omni.integracao.exceptions.IntegrationException;
import com.escolpi.omni.integracao.exceptions.StoreClosedException;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodAuthorizationDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodAuthorizationRequestDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodErrorDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodEventIdDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodOrderDetailDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodOrderEventDto;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodStoreStatusDto;
import com.escolpi.omni.integracao.service.AtualizacaoDeSituacaoService;
import com.escolpi.omni.integracao.service.IFoodIntegrationService;
import com.escolpi.omni.integracao.service.LogInternoService;
import com.escolpi.omni.integracao.service.PedidoAgoraIntegrationService;
import com.escolpi.omni.integracao.util.StringUtil;
import com.escolpi.omni.integracao.view.MainWindow;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class IFoodIntegrationComponent {
    private final LogInternoService logService;
    private final IFoodIntegrationService service;
    private final PedidoAgoraIntegrationService orderService;
    private final AtualizacaoDeSituacaoService updateStatusService;
    private final Logger log = LoggerFactory.getLogger(IFoodIntegrationComponent.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final RestTemplate rest = new RestTemplate();
    private int retry = 3;
    private final RouteComponent routeComponent;

    public IFoodIntegrationComponent(LogInternoService logService, IFoodIntegrationService service, PedidoAgoraIntegrationService orderService, AtualizacaoDeSituacaoService updateStatusService, RouteComponent routeComponent) {
        this.logService = logService;
        this.service = service;
        this.orderService = orderService;
        this.updateStatusService = updateStatusService;
        this.routeComponent = routeComponent;
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public boolean getMerchantStatus() {
        try {
            this.updateToken();
            HttpHeaders header = this.getAuthorizationHeader();
            String url = this.routeComponent.getEndpoint(this.routeComponent.getIFoodBaseUrl(), "/merchant/v1.0/merchants/%s/status", new String[]{this.getSettings().getMerchantId()});
            ResponseEntity response = this.rest.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)header), String.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                throw new IntegrationException((String)response.getBody());
            }
            IFoodStoreStatusDto[] storeStatus = (IFoodStoreStatusDto[])this.mapper.readValue((String)response.getBody(), IFoodStoreStatusDto[].class);
            boolean isOpened = storeStatus[0].getState().equals("OK");
            MainWindow.lblIFoodStatus.setText(String.format("Loja %s", isOpened ? "aberta" : "fechada"));
            this.resetRetry();
            if (!isOpened) {
                throw new StoreClosedException(IntegrationVendor.IFOOD.getDescricao());
            }
            return true;
        }
        catch (StoreClosedException e) {
            this.log.info(e.getMessage());
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Transactional
    public List<IFoodOrderEventDto> receiveOrderEvents() throws IntegrationException {
        try {
            HttpHeaders headers = this.getAuthorizationHeader();
            String url = this.routeComponent.getEndpoint(this.routeComponent.getIFoodBaseUrl(), "/order/v1.0/events:polling?types=CFM", new String[0]);
            ResponseEntity response = this.rest.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                this.resetRetry();
                return Arrays.asList((Object[])this.mapper.readValue((String)response.getBody(), IFoodOrderEventDto[].class));
            }
        }
        catch (HttpClientErrorException e) {
            if ((e.getStatusCode().equals((Object)HttpStatus.UNAUTHORIZED) || e.getStatusCode().equals((Object)HttpStatus.FORBIDDEN)) && this.retry >= 1) {
                this.updateToken();
                --this.retry;
                this.receiveOrderEvents();
            }
        }
        catch (IOException e) {
            this.logService.saveAndShowLog(Boolean.valueOf(true), e.getMessage(), "IFOOD", this.log);
        }
        return new ArrayList<IFoodOrderEventDto>();
    }

    @Transactional
    public void receiveOrder(UUID orderId) {
        this.logService.saveAndShowLog(Boolean.valueOf(false), String.format("Importando o pedido %s ...", orderId), "IFOOD", this.log);
        HttpHeaders headers = this.getAuthorizationHeader();
        String url = this.routeComponent.getEndpoint(this.routeComponent.getIFoodBaseUrl(), "/order/v1.0/orders/%s", new String[]{orderId.toString()});
        try {
            ResponseEntity response = this.rest.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                IFoodOrderDetailDto orderDto = (IFoodOrderDetailDto)this.mapper.readValue((String)response.getBody(), IFoodOrderDetailDto.class);
                this.service.createOrder(orderDto);
                this.logService.saveAndShowLog(Boolean.valueOf(false), String.format("O pedido %s foi importado com sucesso!", orderId), "IFOOD", this.log);
            }
        }
        catch (HttpClientErrorException response) {
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
            this.logService.saveAndShowLog(Boolean.valueOf(true), e.getMessage(), "IFOOD", this.log);
        }
    }

    @Transactional
    public boolean sendEventsAckowledgement(List<IFoodOrderEventDto> events) {
        boolean eventsAckowledged;
        block4: {
            if (CollectionUtils.isEmpty(events)) {
                return false;
            }
            eventsAckowledged = false;
            List eventsToAcknowledge = events.stream().map(e -> new IFoodEventIdDto(e.getId())).collect(Collectors.toList());
            HttpHeaders headers = this.getAuthorizationHeader();
            headers.add("Content-Type", "application/json");
            HttpEntity requestBody = new HttpEntity(eventsToAcknowledge, (MultiValueMap)headers);
            try {
                String url = this.routeComponent.getEndpoint(this.routeComponent.getIFoodBaseUrl(), "/order/v1.0/events/acknowledgment", new String[0]);
                ResponseEntity response = this.rest.postForEntity(url, (Object)requestBody, String.class, new Object[0]);
                if (response.getStatusCode().equals((Object)HttpStatus.ACCEPTED)) {
                    String eventIds = eventsToAcknowledge.stream().map(e -> e.getId().toString()).collect(Collectors.joining(","));
                    String message = String.format("Os eventos %s foram enviados e reconhecidos com suceso pela API do IFood.", eventIds);
                    this.logService.saveAndShowLog(Boolean.valueOf(false), message, "IFOOD", this.log);
                    eventsAckowledged = true;
                }
            }
            catch (HttpClientErrorException e2) {
                if (!e2.getStatusCode().equals((Object)HttpStatus.UNAUTHORIZED) && !e2.getStatusCode().equals((Object)HttpStatus.FORBIDDEN) || !e2.getStatusCode().equals((Object)HttpStatus.UNAUTHORIZED) && !e2.getStatusCode().equals((Object)HttpStatus.FORBIDDEN) || this.retry < 1) break block4;
                this.updateToken();
                --this.retry;
                this.sendEventsAckowledgement(events);
            }
        }
        return eventsAckowledged;
    }

    @Transactional
    public void updateOrders() {
        block12: {
            try {
                List updates = this.updateStatusService.listOrderUpdates("IFOOD");
                if (!CollectionUtils.isEmpty((Collection)updates)) {
                    HttpHeaders headers = this.getAuthorizationHeader();
                    headers.add("Content-Type", "application/json");
                    for (AtualizacaoDeSituacao update : updates) {
                        String url = "";
                        if (update.getSituacaoDoPedido().equals(SituacaoDoPedido.CONFIRMADO.ordinal())) {
                            url = this.routeComponent.getEndpoint(this.routeComponent.getIFoodBaseUrl(), "/order/v1.0/orders/%s/confirm", new String[]{update.getPedidoId()});
                        }
                        if (update.getSituacaoDoPedido().equals(SituacaoDoPedido.SAIU_PARA_ENTREGA.ordinal())) {
                            url = this.routeComponent.getEndpoint(this.routeComponent.getIFoodBaseUrl(), "/order/v1.0/orders/%s/dispatch", new String[]{update.getPedidoId()});
                        }
                        if (update.getSituacaoDoPedido().equals(SituacaoDoPedido.AGUARDANDO_RETIRADA.ordinal())) {
                            url = this.routeComponent.getEndpoint(this.routeComponent.getIFoodBaseUrl(), "/order/v1.0/orders/%s/readyToPickup", new String[]{update.getPedidoId()});
                        }
                        if (update.getSituacaoDoPedido().equals(SituacaoDoPedido.PEDIDO_EM_PREPARO.ordinal()) || update.getSituacaoDoPedido().equals(SituacaoDoPedido.FINALIZADO.ordinal()) || update.getSituacaoDoPedido().equals(SituacaoDoPedido.CANCELADO.ordinal()) || update.getSituacaoDoPedido().equals(SituacaoDoPedido.CANCELADO_PELO_CLIENTE.ordinal())) {
                            this.updateStatusService.delete(update);
                            continue;
                        }
                        if (!StringUtil.isNotBlank((String)url)) continue;
                        ResponseEntity response = this.rest.exchange(url, HttpMethod.POST, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
                        if (response.getStatusCode().equals((Object)HttpStatus.ACCEPTED)) {
                            this.logService.saveAndShowLog(Boolean.valueOf(false), String.format("O pedido %s foi atualizado com sucesso!", update.getPedidoId()), "IFOOD", this.log);
                        }
                        updates.forEach(arg_0 -> ((AtualizacaoDeSituacaoService)this.updateStatusService).delete(arg_0));
                    }
                }
            }
            catch (HttpClientErrorException e) {
                if (e.getStatusCode().equals((Object)HttpStatus.UNAUTHORIZED) || e.getStatusCode().equals((Object)HttpStatus.FORBIDDEN)) {
                    if ((e.getStatusCode().equals((Object)HttpStatus.UNAUTHORIZED) || e.getStatusCode().equals((Object)HttpStatus.FORBIDDEN)) && this.retry >= 1) {
                        this.updateToken();
                        --this.retry;
                        this.updateOrders();
                    }
                }
                if (e.getStatusCode().equals((Object)HttpStatus.BAD_REQUEST)) {
                    this.logService.saveAndShowLog(Boolean.valueOf(true), String.format("Erro ao atualizar Pedido na API do IFood: %s", e.getMessage()), "IFOOD", this.log);
                }
                if (!e.getStatusCode().equals((Object)HttpStatus.INTERNAL_SERVER_ERROR)) break block12;
                this.logService.saveAndShowLog(Boolean.valueOf(true), "O IFood est\u00e1 passando por instabilidades e n\u00e3o conseguimos nos comunicar ao servi\u00e7o ou reinicie a integra\u00e7\u00e3o ou aguarde alguns instantes.", "IFOOD", this.log);
            }
        }
    }

    private IFoodSettings getSettings() {
        return IntegrationConfig.config.getiFoodSettings();
    }

    private HttpHeaders getAuthorizationHeader() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("authorization", String.format("Bearer %s", this.getSettings().getAccessToken()));
        return headers;
    }

    public IFoodAuthorizationRequestDto getRequestAuthorizationCode() {
        try {
            HttpHeaders headers = new HttpHeaders();
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"clientId", (Object)this.getSettings().getClientId());
            HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
            String url = this.routeComponent.getEndpoint(this.routeComponent.getIFoodBaseUrl(), "/authentication/v1.0/oauth/userCode", new String[0]);
            ResponseEntity response = this.rest.exchange(url, HttpMethod.POST, request, String.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                IFoodErrorDto error = (IFoodErrorDto)this.mapper.readValue((String)response.getBody(), IFoodErrorDto.class);
                throw new IntegrationException(error.getName());
            }
            return (IFoodAuthorizationRequestDto)this.mapper.readValue((String)response.getBody(), IFoodAuthorizationRequestDto.class);
        }
        catch (IntegrationException | IOException e) {
            this.logService.save(new LogInterno(Boolean.valueOf(true), e.getMessage(), "IFOOD"));
            return null;
        }
    }

    private void resetRetry() {
        this.retry = 3;
    }

    public void updateToken() {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity request = this.getUpdateTokenHttpHeader(headers);
            String url = this.routeComponent.getEndpoint(this.routeComponent.getIFoodBaseUrl(), "/authentication/v1.0/oauth/token", new String[0]);
            ResponseEntity response = this.rest.exchange(url, HttpMethod.POST, request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && null != response.getBody()) {
                IFoodAuthorizationDto auth = (IFoodAuthorizationDto)this.mapper.readValue((String)response.getBody(), IFoodAuthorizationDto.class);
                this.getSettings().setAccessToken(auth.getAccessToken());
                this.getSettings().setRefreshToken(auth.getRefreshToken());
                IntegrationConfig.updateConfigFile();
            }
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().equals((Object)HttpStatus.UNAUTHORIZED) || e.getStatusCode().equals((Object)HttpStatus.FORBIDDEN)) {
                this.logService.saveAndShowLog(Boolean.valueOf(true), "O token da integra\u00e7\u00e3o com sua loja IFood expirou e n\u00e3o pode ser renovado de forma autom\u00e1tica. Entre em contato com nosso suporte para renovar a autoriza\u00e7\u00e3o de forma manual.", "IFOOD", this.log);
                JOptionPane.showMessageDialog(null, "Aten\u00e7\u00e3o", "O Token de Acesso da API do IFood expirou e precisa ser renovado. Reinicie a integra\u00e7\u00e3o e atualize suas credenciais. Contate nosso suporte caso precise de ajuda.", 2);
                this.getSettings().setAccessToken("");
                this.getSettings().setRefreshToken("");
                System.exit(0);
            } else if (e.getStatusCode().equals((Object)HttpStatus.INTERNAL_SERVER_ERROR)) {
                JOptionPane.showMessageDialog(null, "Aten\u00e7\u00e3o", "O IFood est\u00e1 passando por instabilidades e n\u00e3o conseguimos nos comunicar ao servi\u00e7o ou reinicie a integra\u00e7\u00e3o ou aguarde alguns instantes.", 2);
            }
        }
        catch (IntegrationException | IOException e) {
            this.logService.save(new LogInterno(Boolean.valueOf(true), e.getMessage(), "IFOOD"));
        }
    }

    public boolean wasOrderImported(String orderIdApi) {
        return this.orderService.countOrderByAPIId(orderIdApi) > 0L;
    }

    private HttpEntity<MultiValueMap<String, String>> getUpdateTokenHttpHeader(HttpHeaders headers) {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"grantType", (Object)"refresh_token");
        requestBody.add((Object)"clientId", (Object)this.getSettings().getClientId());
        requestBody.add((Object)"clientSecret", (Object)this.getSettings().getClientSecret());
        requestBody.add((Object)"refreshToken", (Object)this.getSettings().getRefreshToken());
        return new HttpEntity((Object)requestBody, (MultiValueMap)headers);
    }
}

