/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.components;

import com.escolpi.omni.integracao.Application;
import com.escolpi.omni.integracao.components.IntegrationConfig;
import com.escolpi.omni.integracao.components.routes.RouteComponent;
import com.escolpi.omni.integracao.exceptions.IntegrationException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ConnectionComponent {
    private static final Logger log = LoggerFactory.getLogger(ConnectionComponent.class);
    private final RouteComponent route;

    public ConnectionComponent(RouteComponent route) {
        this.route = route;
    }

    public void checkIntegrationConnections() {
        if (IntegrationConfig.isPedidoAgoraActive()) {
            ConnectionComponent.checkWebConnection((String)this.route.getEndpoint(this.route.getPedidoAgoraBaseUrl(), "/check-connection", new String[0]));
        }
        if (IntegrationConfig.isCardapioDigitalActive()) {
            ConnectionComponent.checkWebConnection((String)this.route.getEndpoint(this.route.getPedidoAgoraBaseUrl(), "/check-connection", new String[0]));
        }
    }

    public void checkDatabaseConnection() throws IntegrationException {
        ConfigurableApplicationContext app = Application.applicationContext;
        if (app == null) {
            log.error("Integra\u00e7\u00e3o n\u00e3o foi dispon\u00edvel. Verifique as configura\u00e7\u00f5es e tente reinici\u00e1-la.");
            throw new IntegrationException("Integra\u00e7\u00e3o n\u00e3o foi dispon\u00edvel. Verifique as configura\u00e7\u00f5es e tente reinici\u00e1-la.");
        }
        if (Boolean.TRUE.equals(IntegrationConfig.config.getCheckDatabaseConnection())) {
            try {
                String dbUrl = app.getEnvironment().getProperty("spring.datasource.url");
                String dbUsername = app.getEnvironment().getProperty("spring.datasource.username");
                String dbPassword = app.getEnvironment().getProperty("spring.datasource.password");
                if (dbUrl == null || dbUsername == null || dbPassword == null) {
                    throw new IntegrationException("Um ou mais par\u00e2metros para acesso ao banco de dados n\u00e3o foi definido. Verifique as configura\u00e7\u00f5es e reinicie a integra\u00e7\u00e3o.");
                }
                try (Connection con = DriverManager.getConnection(dbUrl, dbUsername, dbPassword);){
                    if (con.isClosed()) {
                        throw new IntegrationException("O banco de dados est\u00e1 indispon\u00edvel. Verifique as configura\u00e7\u00f5es de conex\u00e3o com o banco de dados");
                    }
                }
            }
            catch (SQLException e) {
                String sqlError = String.format("Ocorreu um erro durante a tentativa de conex\u00e3o ao banco de dados: %s", e.getMessage());
                log.error(sqlError);
                throw new IntegrationException(sqlError);
            }
        }
    }

    private static void checkWebConnection(String urlToTest) {
        if (Boolean.TRUE.equals(IntegrationConfig.config.getCheckInternetConnection())) {
            try {
                URL url = new URL(urlToTest);
                HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                boolean connected = urlConn.getResponseCode() == 200;
                urlConn.disconnect();
                if (!connected) {
                    throw new IntegrationException("Sua internet est\u00e1 indspon\u00edvel ou com problemas de estabilidade. Reinicie a integra\u00e7\u00e3o.");
                }
            }
            catch (IOException e) {
                throw new IntegrationException("Sua internet est\u00e1 indspon\u00edvel ou com problemas de estabilidade. Reinicie a integra\u00e7\u00e3o.");
            }
        }
    }
}

