/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.domain.Domains;
import com.escolpi.omni.api.domain.Message;
import com.escolpi.omni.api.enumeration.FusoHorario;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.Perfil;
import com.escolpi.omni.api.model.entity.SolicitacaoDeSenha;
import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.model.specification.builder.UsuarioSpecificationBuilder;
import com.escolpi.omni.api.repository.ClienteRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.PerfilRepository;
import com.escolpi.omni.api.repository.SolicitacaoDeSenhaRepository;
import com.escolpi.omni.api.repository.UsuarioRepository;
import com.escolpi.omni.api.service.EmailService;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.FileService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.EnviromentUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.NumberUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UsuarioService {
    @Autowired
    private BCryptPasswordEncoder encoder;
    @Autowired
    private UsuarioRepository repository;
    @Autowired
    private ClienteRepository customerRepository;
    @Autowired
    private EmpresaRepository companyRepository;
    @Autowired
    private EmpresaService companyService;
    @Autowired
    private FileService fileService;
    @Autowired
    private PerfilRepository profileRepository;
    @Autowired
    private SolicitacaoDeSenhaRepository solicitacaoDeSenhaRepository;
    private static final String ASSUNTO_RECUPERACAO_SENHA = "Recuperar Senha";
    private static final Logger LOGGER = LoggerFactory.getLogger(UsuarioService.class);

    public boolean accountExists(Long empresaId, String login) throws ApiException {
        if (StringUtil.isNumericString((String)login)) {
            throw new ApiException("erro.autenticacao.usuario.login.email");
        }
        return this.repository.findByCustomerLoginAndEmpresaId(login, empresaId).isPresent();
    }

    public Boolean checkIfCompanyIsBlocked(Long companyId) throws ApiException {
        Empresa company = (Empresa)this.companyRepository.findById((Object)companyId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", companyId.toString()}));
        return this.checkIsBlocked(company.getUsuario());
    }

    @Transactional
    public void delete(Long id) throws ApiException {
        Usuario edit = (Usuario)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", id.toString()}));
        edit.setExcluido(true);
        this.repository.save((Object)edit);
    }

    @Transactional
    public void closePasswordRecoveryRequest(Usuario user, Long companyId) throws ApiException {
        this.solicitacaoDeSenhaRepository.findByUsuarioId(user.getId());
        List requests = this.solicitacaoDeSenhaRepository.findByUsuarioIdAndEncerradaIsFalse(user.getId());
        requests.forEach(request -> {
            request.setEncerrada(Boolean.valueOf(true));
            this.solicitacaoDeSenhaRepository.save(request);
        });
    }

    public void enviarEmailDeNotificacao(Map<String, String> parametros, String assunto, String mensagem, File logotipo, File badgeGooglePlay, File badgeAppStore) throws ApiException {
        try {
            EmailService.enviarEmail((String)assunto, (String)mensagem, parametros, (File)logotipo, (File)badgeGooglePlay, (File)badgeAppStore);
        }
        catch (Exception e) {
            LOGGER.warn(Message.getInstance().getMessage("erro.api.padrao", new String[]{e.getMessage()}));
        }
    }

    public Page<Usuario> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        UsuarioSpecificationBuilder builder = new UsuarioSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(Arrays.asList("login"), (String)"desc");
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.repository.findAll(spec, (Pageable)pageable);
    }

    public Usuario findById(Long id) {
        return this.repository.findByIdAndExcluidoIsFalse(id).orElse(null);
    }

    public Usuario findVendorByLogin(String login) throws ApiException {
        return (Usuario)this.repository.findByLoginAndPerfil(login, Domains.PROFILE_COLABORATOR_ID).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", "{Login " + login + "}"}));
    }

    public Usuario findVendorByLoginAndCompany(Long companyId, String username) throws ApiException {
        return (Usuario)this.repository.findByLoginAndCompanyAndProfile(username, companyId, Domains.PROFILE_COLABORATOR_ID).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", "{ Login " + username + " | Empresa " + companyId + " }"}));
    }

    public Usuario findVendorByCompanyTelephone(Long companyId, String telephone) throws ApiException {
        return (Usuario)this.repository.findByTelephoneCompanyAndProfile(telephone, companyId, Domains.PROFILE_COLABORATOR_ID).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", "{ Empresa " + companyId + " | Telefone " + telephone + "}"}));
    }

    public Usuario findRootByLogin(String login) throws ApiException {
        return (Usuario)this.repository.findByLoginAndPerfil(login, Domains.PROFILE_ADMINISTRATOR_ID).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", "{ Login " + login + " }"}));
    }

    public List<Usuario> findUserAccounts(Long companyId, String login) {
        ArrayList customers = new ArrayList();
        if (StringUtil.isNumericString((String)login)) {
            customers.addAll(this.customerRepository.findAccountsByTelefoneAndEmpresaId(login, companyId));
        } else {
            customers.addAll(this.customerRepository.findAccountsByLoginAndEmpresaId(login, companyId));
        }
        return customers.stream().map(Cliente::getUsuario).collect(Collectors.toList());
    }

    public SolicitacaoDeSenha obterSolicitacaoDeSenha(Integer numeroAutenticacao, Long usuarioId, Long profileId) throws ApiException {
        return (SolicitacaoDeSenha)this.solicitacaoDeSenhaRepository.findByNumeroAutenticacaoAndUsuarioIdAndUsuarioPerfilIdAndEncerradaIsFalse(numeroAutenticacao, usuarioId, profileId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Solicita\u00e7\u00e3o de Senha", "{ Usu\u00e1rio " + usuarioId + " | Perfil " + profileId + " }"}));
    }

    @Transactional
    public SolicitacaoDeSenha getPasswordRequest(Long id) throws ApiException {
        return (SolicitacaoDeSenha)this.solicitacaoDeSenhaRepository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Solicita\u00e7\u00e3o de Senha", id.toString()}));
    }

    public SolicitacaoDeSenha getPasswordRequest(String email, Long profileId) throws ApiException {
        Usuario user = (Usuario)this.repository.findByLoginAndPerfilId(email, profileId).get();
        return (SolicitacaoDeSenha)this.solicitacaoDeSenhaRepository.findTopByUsuarioId(user.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Solicita\u00e7\u00e3o de Senha", "{ Usuario " + user.getId() + " | Perfil " + profileId + " }"}));
    }

    @Transactional
    public void solicitarRecuperacaoSenhaDaEmpresa(String login, Long profileId, HttpServletRequest request, boolean web) throws ApiException {
        this.validarRecuperacaoSenha(login);
        Usuario usuario = (Usuario)this.repository.findByLoginAndPerfilId(login, profileId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", "{ Login " + login + " | Perfil " + profileId + " }"}));
        SolicitacaoDeSenha solicitacao = new SolicitacaoDeSenha();
        if (usuario.getPerfil().getId().equals(Domains.PROFILE_CUSTOMER_ID)) {
            Cliente cliente = (Cliente)this.customerRepository.findByUsuarioId(usuario.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", "{ Usu\u00e1rio  " + usuario.getId() + " }"}));
            solicitacao.setDataHoraSolicitacao(DateUtil.setTimeByTimezone((FusoHorario)cliente.getEmpresa().getFusoHorario()));
            solicitacao.setUsuario(usuario);
            solicitacao.setEncerrada(Boolean.valueOf(false));
            solicitacao.setNumeroAutenticacao(Integer.valueOf(NumberUtil.generateRandomNumber((int)4)));
        }
        if (usuario.getPerfil().getId().equals(Domains.PROFILE_CUSTOMER_ID)) {
            Empresa empresa = (Empresa)this.companyRepository.findByLogin(login).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", "{ Login " + login + " }"}));
            solicitacao.setDataHoraSolicitacao(DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario()));
            solicitacao.setUsuario(usuario);
            solicitacao.setEncerrada(Boolean.valueOf(false));
            solicitacao.setNumeroAutenticacao(Integer.valueOf(NumberUtil.generateRandomNumber((int)4)));
        }
        this.solicitacaoDeSenhaRepository.save((Object)solicitacao);
        this.notificarRecuperacaoDeSenha(solicitacao, request, web);
    }

    @Deprecated
    @Transactional
    public void solicitarRecuperacaoSenha(String email, Long empresaId, boolean solicitacaoWeb) throws ApiException {
        this.validarRecuperacaoSenha(email);
        Cliente cliente = (Cliente)this.customerRepository.findByLoginAndEmpresaId(email, empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", "{ Email " + email + " | Empresa " + empresaId + " }"}));
        SolicitacaoDeSenha solicitacao = new SolicitacaoDeSenha();
        solicitacao.setUsuario(cliente.getUsuario());
        Empresa empresa = (Empresa)this.companyRepository.findById((Object)empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", empresaId.toString()}));
        solicitacao.setDataHoraSolicitacao(DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario()));
        solicitacao.setEncerrada(Boolean.valueOf(false));
        solicitacao.setNumeroAutenticacao(Integer.valueOf(NumberUtil.generateRandomNumber((int)4)));
        this.solicitacaoDeSenhaRepository.save((Object)solicitacao);
        this.notificarRecuperacaoDeSenha(solicitacao, cliente, solicitacaoWeb);
    }

    @Transactional
    public void redefinePassword(SolicitacaoDeSenha request) throws ApiException {
        SolicitacaoDeSenha edit;
        if (NullUtil.isNotNull((Object)request.getUsuario().getLogin())) {
            if (StringUtil.isNumericString((String)request.getUsuario().getLogin())) {
                request.getUsuario().setTelefone(request.getUsuario().getLogin());
                edit = (SolicitacaoDeSenha)this.solicitacaoDeSenhaRepository.findByNumeroAutenticacaoAndTelephone(request.getNumeroAutenticacao(), request.getUsuario().getLogin()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Solicita\u00e7\u00e3o de Recupera\u00e7\u00e3o de Senha", "{ Usu\u00e1rio " + request.getUsuario().getLogin() + " }"}));
            } else {
                edit = (SolicitacaoDeSenha)this.solicitacaoDeSenhaRepository.findByNumeroAutenticacaoAndLogin(request.getNumeroAutenticacao(), request.getUsuario().getLogin()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Solicita\u00e7\u00e3o de Recupera\u00e7\u00e3o de Senha", "{ Usu\u00e1rio " + request.getUsuario().getLogin() + " }"}));
            }
        } else {
            throw new ApiException("msg.erro.001", new String[]{"Login"});
        }
        this.validarRedefinicaoDaSenha(request, edit);
        edit.setEncerrada(Boolean.valueOf(true));
        this.solicitacaoDeSenhaRepository.save((Object)edit);
        Usuario usuario = (Usuario)this.repository.findById((Object)edit.getUsuario().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", edit.getUsuario().getId().toString()}));
        usuario.setSenha(this.encoder.encode((CharSequence)request.getUsuario().getSenha()));
        this.repository.save((Object)usuario);
    }

    @Transactional
    public void redefineCompanyPassword(SolicitacaoDeSenha request) throws ApiException {
        SolicitacaoDeSenha edit = (SolicitacaoDeSenha)this.solicitacaoDeSenhaRepository.findByNumeroAutenticacaoAndLogin(request.getNumeroAutenticacao(), request.getUsuario().getLogin()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Solicita\u00e7\u00e3o de Recupera\u00e7\u00e3o de Senha", "{ Usuario " + request.getUsuario().getLogin() + " }"}));
        this.validarRedefinicaoDaSenha(request, edit);
        edit.setEncerrada(Boolean.valueOf(true));
        this.solicitacaoDeSenhaRepository.save((Object)edit);
        Usuario user = (Usuario)this.repository.findById((Object)edit.getUsuario().getId()).get();
        user.setSenha(this.encoder.encode((CharSequence)request.getUsuario().getSenha()));
        this.repository.save((Object)user);
    }

    @Transactional
    public SolicitacaoDeSenha requestCustomerPassword(String email, Long companyId) throws ApiException {
        this.validarRecuperacaoSenha(email);
        Cliente customer = (Cliente)this.customerRepository.findByLoginAndEmpresaId(email, companyId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", email}));
        customer.getUsuario().setTelefone(customer.getTelefone());
        this.closePasswordRecoveryRequest(customer.getUsuario(), companyId);
        SolicitacaoDeSenha request = new SolicitacaoDeSenha();
        request.setUsuario(customer.getUsuario());
        Empresa company = (Empresa)this.companyRepository.findById((Object)companyId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", companyId.toString()}));
        request.setDataHoraSolicitacao(DateUtil.setTimeByTimezone((FusoHorario)company.getFusoHorario()));
        request.setEncerrada(Boolean.valueOf(false));
        request.setNumeroAutenticacao(Integer.valueOf(NumberUtil.generateRandomNumber((int)6)));
        this.solicitacaoDeSenhaRepository.save((Object)request);
        return request;
    }

    @Transactional
    public SolicitacaoDeSenha requestCompanyPassword(String login) throws ApiException {
        Usuario user = (Usuario)this.repository.findByLoginAndPerfil(login, Domains.PROFILE_COMPANY_ID).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", login}));
        Empresa company = (Empresa)this.companyRepository.findByUsuarioId(user.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", "{ Usu\u00e1rio " + user.getId() + " }"}));
        this.closePasswordRecoveryRequest(user, company.getId());
        SolicitacaoDeSenha request = new SolicitacaoDeSenha();
        request.setUsuario(user);
        request.setDataHoraSolicitacao(DateUtil.setTimeByTimezone((FusoHorario)company.getFusoHorario()));
        request.setEncerrada(Boolean.valueOf(false));
        request.setNumeroAutenticacao(Integer.valueOf(NumberUtil.generateRandomNumber((int)6)));
        this.solicitacaoDeSenhaRepository.save((Object)request);
        return request;
    }

    @Transactional
    public void save(Usuario user) throws ApiException {
        this.validate(user);
        if (NullUtil.isNotNullOrZero((Number)user.getId())) {
            Usuario edit = (Usuario)this.repository.findById((Object)user.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", user.getId().toString()}));
            edit.setLogin(user.getLogin());
            edit.setNome(user.getNome());
            edit.setBloqueado(user.getBloqueado());
            edit.setEmpresa((Empresa)this.companyRepository.findById((Object)user.getEmpresa().getId()).orElse(null));
            edit.setPerfil((Perfil)this.profileRepository.findById((Object)user.getPerfil().getId()).get());
            edit.setExcluido(false);
            edit.setDemonstracao(false);
            edit.setCodigoDoPdv(user.getCodigoDoPdv());
            edit.setTelefone(user.getTelefone());
            if (StringUtil.isNotBlank((String)user.getSenha())) {
                edit.setSenha(this.encoder.encode((CharSequence)user.getSenha()));
            }
            this.repository.save((Object)edit);
        } else {
            user.setDemonstracao(false);
            user.setExcluido(false);
            user.setEmpresa((Empresa)this.companyRepository.findById((Object)user.getEmpresa().getId()).orElse(null));
            user.setPerfil((Perfil)this.profileRepository.findById((Object)user.getPerfil().getId()).get());
            user.setSenha(this.encoder.encode((CharSequence)user.getSenha()));
            this.repository.save((Object)user);
        }
    }

    @Transactional
    public boolean saveSellerFromPDV(Long companyId, List<Usuario> sellers) {
        boolean saved = false;
        for (Usuario seller : sellers) {
            try {
                Usuario edit = this.repository.findByEmpresaIdAndCodigoDoPdv(companyId, seller.getCodigoDoPdv()).orElse(null);
                if (NullUtil.isNotNull((Object)edit)) {
                    edit.setCodigoDoPdv(seller.getCodigoDoPdv());
                    edit.setNome(seller.getNome());
                    edit.setLogin(seller.getLogin());
                    edit.setTelefone(seller.getTelefone());
                    edit.setBloqueado(seller.getBloqueado());
                    if (StringUtil.isNotBlank((String)edit.getSenha())) {
                        edit.setSenha(seller.getSenha());
                    }
                    this.repository.save((Object)edit);
                } else {
                    this.repository.save((Object)seller);
                }
                saved = true;
            }
            catch (Exception e) {
                saved = false;
            }
        }
        return saved;
    }

    @Transactional
    public void toggleUserLock(Long id) throws ApiException {
        Usuario edit;
        edit.setBloqueado(Boolean.valueOf((edit = (Usuario)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", id.toString()}))).getBloqueado() == false));
        this.repository.save((Object)edit);
    }

    public boolean userExists(String login, Long profileId) {
        return this.repository.findByLoginAndPerfil(login, profileId).isPresent();
    }

    public boolean userExists(Long companyId, String login, Long profileId) {
        Usuario user = StringUtil.isNumericString((String)login) ? (Usuario)this.repository.findByTelephoneCompanyAndProfile(login, companyId, profileId).orElse(null) : (Usuario)this.repository.findByLoginAndCompanyAndProfile(login, companyId, profileId).orElse(null);
        return NullUtil.isNotNull((Object)user);
    }

    private Boolean checkIsBlocked(Usuario user) throws ApiException {
        return ((Usuario)this.repository.findById((Object)user.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", user.getId().toString()}))).getBloqueado();
    }

    @Deprecated
    private String comporTemplateEmailRedefinirSenha(Cliente cliente, SolicitacaoDeSenha solicitacao, Map<String, String> parametros) {
        StringBuilder template = new StringBuilder();
        parametros.put("empresaNomeAbreviado", cliente.getEmpresa().getNomeAbreviado());
        parametros.put("usuarioNome", StringUtil.getFirstName((String)cliente.getNome()));
        parametros.put("codigoAtivacao", solicitacao.getNumeroAutenticacao().toString());
        parametros.put("logoEmpresa", cliente.getEmpresa().getLogotipo());
        parametros.put("empresaNomeFantasia", cliente.getEmpresa().getNomeFantasia());
        parametros.put("empresaEndereco", cliente.getEmpresa().getEndereco());
        parametros.put("emailUsuario", solicitacao.getUsuario().getLogin());
        template.append("<h1>{usuarioNome} redefina sua senha!</h1><h4>Voc\u00ea solicitou a recupera\u00e7\u00e3o de sua senha de acesso. Lembre-se, sua nova senha deve ser definida em 24 horas. Este \u00e9 o seu c\u00f3digo para definir sua nova conta:</h4><h1 style=\"padding-top:25px;padding-bottom:25px;\">{codigoAtivacao}</h1><p style=\"color:#FF0000;font-size:14px;\"><strong>Para definir sua nova senha, acesse seu aplicativo, abra o menu principal, clique em \"Redefinir Senha\" inserindo o c\u00f3digo acima.</strong></p>");
        return EmailService.comporMensagem(parametros, (StringBuilder)template, (boolean)false, (boolean)false);
    }

    @Deprecated
    private String comporTemplateEmailRedefinirSenha(Empresa empresa, SolicitacaoDeSenha solicitacao, Map<String, String> parametros, HttpServletRequest request, boolean web) {
        String url = EnviromentUtil.getCurrentUrl((HttpServletRequest)request);
        if (request.getServerName().contains("localhost")) {
            url = url.concat(":4200");
        }
        StringBuilder template = new StringBuilder();
        parametros.put("empresaNomeAbreviado", empresa.getNomeAbreviado());
        parametros.put("usuarioNome", StringUtil.getFirstName((String)empresa.getContato()));
        if (web) {
            parametros.put("linkAtivacao", String.format("%s/auth/%s/%s/reset-password", url, solicitacao.getUsuario().getId(), solicitacao.getNumeroAutenticacao()));
        } else {
            parametros.put("codigoAtivacao", solicitacao.getNumeroAutenticacao().toString());
        }
        parametros.put("empresaNomeFantasia", empresa.getNomeFantasia());
        parametros.put("empresaEndereco", empresa.getEndereco());
        parametros.put("emailUsuario", solicitacao.getUsuario().getLogin());
        if (web) {
            template.append("<h1>{usuarioNome}, redefina sua senha!</h1><h4>Voc\u00ea solicitou a recupera\u00e7\u00e3o de sua senha de acesso. Lembre-se, sua nova senha deve ser definida em 24 horas. Para definir sua nova senha clique no bot\u00e3o abaixo: </h4><p><strong><a style=\"padding: 15px;background-color: #8f465a;font-weight: bold;text-transform: uppercase;font-family: Arial, Heveltica, sans-serif;border-radius: 10px;text-decoration: none;color: #ffffff;box-shadow: 3px 3px 8px rgba(125, 125, 125, 0.65);\" href=\"{linkAtivacao}\" target=\"_blank\">Clique aqui!</a></strong></p>");
        } else {
            template.append("<h1>{usuarioNome} redefina sua senha!</h1><h4>Voc\u00ea solicitou a recupera\u00e7\u00e3o de sua senha de acesso. Lembre-se, sua nova senha deve ser definida em 24 horas. Este \u00e9 o seu c\u00f3digo para definir sua nova conta:</h4><h1 style=\"padding-top:25px;padding-bottom:25px;\">{codigoAtivacao}</h1><p style=\"color:#FF0000;font-size:14px;\"><strong>Para definir sua nova senha, acesse seu aplicativo, toque em <strong>\"Redefinir Senha\"</strong>.</p>");
        }
        return EmailService.comporMensagem(parametros, (StringBuilder)template, (boolean)false, (boolean)false);
    }

    private void notificarRecuperacaoDeSenha(SolicitacaoDeSenha solicitacao, HttpServletRequest request, boolean web) throws ApiException {
        File logotipo;
        String mensagem;
        Usuario usuario = (Usuario)this.repository.findById((Object)solicitacao.getUsuario().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", solicitacao.getUsuario().getId().toString()}));
        HashMap parametros = new HashMap();
        Perfil perfilCliente = (Perfil)this.profileRepository.findById((Object)Domains.ID_PERFIL_CLIENTE).get();
        if (usuario.getPerfil().getId().equals(perfilCliente.getId())) {
            Cliente cliente = (Cliente)this.customerRepository.findByUsuarioId(usuario.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", "{ Usu\u00e1rio " + usuario.getId().toString() + " }"}));
            mensagem = this.comporTemplateEmailRedefinirSenha(cliente, solicitacao, parametros);
            logotipo = this.obterLogotipoDaEmpresa(solicitacao, cliente.getEmpresa());
        } else {
            Empresa empresa = this.companyService.obterPorUsuario(usuario);
            mensagem = this.comporTemplateEmailRedefinirSenha(empresa, solicitacao, parametros, request, web);
            logotipo = this.obterLogotipoDaEmpresa(solicitacao, empresa);
        }
        this.enviarEmailDeNotificacao(parametros, ASSUNTO_RECUPERACAO_SENHA, mensagem, logotipo, null, null);
    }

    private void notificarRecuperacaoDeSenha(SolicitacaoDeSenha solicitacao, Cliente cliente, boolean solicitacaoWeb) throws ApiException {
        HashMap<String, String> parametros = new HashMap<String, String>();
        Empresa empresa = cliente.getEmpresa();
        parametros.put("empresaNomeAbreviado", empresa.getNomeAbreviado());
        parametros.put("usuarioNome", StringUtil.getFirstName((String)cliente.getNome()));
        parametros.put("codigoAtivacao", solicitacao.getNumeroAutenticacao().toString());
        parametros.put("logoEmpresa", empresa.getLogotipo());
        parametros.put("empresaNomeFantasia", empresa.getNomeFantasia());
        parametros.put("empresaEndereco", empresa.getEndereco());
        parametros.put("emailUsuario", solicitacao.getUsuario().getLogin());
        StringBuilder template = new StringBuilder();
        if (solicitacaoWeb) {
            parametros.put("linkAtivacao", String.format("%s/auth/%s/%s/reset-password", cliente.getEmpresa().getUrlStore(), solicitacao.getUsuario().getId(), solicitacao.getNumeroAutenticacao()));
            template.append("<h1>{usuarioNome} redefina sua senha!</h1><h4>Voc\u00ea solicitou a recupera\u00e7\u00e3o de sua senha de acesso. Lembre-se, sua nova senha deve ser definida em 24 horas. Para definir sua nova senha clique no link abaixo: </h4><p><strong>{linkAtivacao}</strong></p>");
        } else {
            template.append("<h1>{usuarioNome} redefina sua senha!</h1><h4>Voc\u00ea solicitou a recupera\u00e7\u00e3o de sua senha de acesso. Lembre-se, sua nova senha deve ser definida em 24 horas. Este \u00e9 o seu c\u00f3digo para definir sua nova conta:</h4><h1 style=\"padding-top:25px;padding-bottom:25px;\">{codigoAtivacao}</h1><p style=\"color:#FF0000;font-size:14px;\"><strong>Para definir sua nova senha, acesse seu aplicativo, abra o menu principal, clique em \"Redefinir Senha\" inserindo o c\u00f3digo acima.</strong></p>");
        }
        String mensagem = EmailService.comporMensagem(parametros, (StringBuilder)template, (boolean)false, (boolean)false);
        File logotipo = this.obterLogotipoDaEmpresa(solicitacao, cliente.getEmpresa());
        this.enviarEmailDeNotificacao(parametros, ASSUNTO_RECUPERACAO_SENHA, mensagem, logotipo, null, null);
    }

    private File obterLogotipoDaEmpresa(SolicitacaoDeSenha request, Empresa company) throws ApiException {
        File logotipo = null;
        logotipo = StringUtil.isNotBlank((String)company.getLogotipo()) ? this.companyService.obterArquivoDoLogotipo(company, false) : this.fileService.getFile(this.fileService.getRootPath().concat(File.separator).concat("logo.jpg"));
        return logotipo;
    }

    private void validate(Usuario user) throws ApiException {
        if (!NullUtil.isNotNull((Object)user)) {
            throw new ApiException("msg.erro.001", new String[]{"Usu\u00e1rio"});
        }
        if (StringUtil.isBlank((String)user.getNome())) {
            throw new ApiException("msg.erro.001", new String[]{"Nome"});
        }
        if (StringUtil.isBlank((String)user.getLogin())) {
            throw new ApiException("msg.erro.001", new String[]{"Login"});
        }
        if (!StringUtil.isBlank((String)user.getSenha()) || !StringUtil.isBlank((String)user.getConfirmacaoSenha())) {
            if (StringUtil.isBlank((String)user.getSenha())) {
                throw new ApiException("msg.erro.001", new String[]{"Senha"});
            }
            if (StringUtil.isBlank((String)user.getConfirmacaoSenha())) {
                throw new ApiException("msg.erro.001", new String[]{"Confirma\u00e7\u00e3o da Senha"});
            }
        }
        if (NullUtil.isNotNullOrZero((Number)user.getId())) {
            if (this.repository.countByLoginAndPerfil(user.getId(), user.getPerfil().getId(), user.getLogin()) >= 1L) {
                throw new ApiException("erro.entidade.existente.m", new String[]{"Vendedor(a)"});
            }
            if (StringUtil.isNotBlank((String)user.getTelefone()) && this.repository.countByTelefone(user.getId(), user.getTelefone(), user.getPerfil().getId()) >= 1L) {
                throw new ApiException("erro.entidade.existente.m", new String[]{"Telefone do Vendedor(a))"});
            }
        } else {
            if (StringUtil.isNotBlank((String)user.getTelefone()) && this.repository.countByTelefone(user.getTelefone(), user.getPerfil().getId()) > 0L) {
                throw new ApiException("erro.entidade.existente.m", new String[]{"Telefone do Vendedor(a))"});
            }
            if (this.repository.countByLoginAndPerfil(user.getPerfil().getId(), user.getLogin()) >= 1L) {
                throw new ApiException("erro.entidade.existente.m", new String[]{"Vendedor(a)"});
            }
        }
    }

    private void validarRecuperacaoSenha(String login) throws ApiException {
        if (StringUtil.isBlank((String)login)) {
            throw new ApiException("msg.erro.001", new String[]{"E-mail"});
        }
        if (!StringUtil.isNumericString((String)login) && !StringUtil.emailValido((String)login)) {
            throw new ApiException("msg.erro.002", new String[]{"E-mail"});
        }
    }

    private void validarRedefinicaoDaSenha(SolicitacaoDeSenha solicitacaoRedefinicao, SolicitacaoDeSenha solicitacaoAtual) throws ApiException {
        if (StringUtil.isBlank((String)solicitacaoRedefinicao.getUsuario().getTelefone())) {
            if (StringUtil.isBlank((String)solicitacaoRedefinicao.getUsuario().getLogin())) {
                throw new ApiException("msg.erro.001", new String[]{"E-mail"});
            }
            if (!StringUtil.emailValido((String)solicitacaoRedefinicao.getUsuario().getLogin())) {
                throw new ApiException("msg.erro.002", new String[]{"E-mail"});
            }
        }
        if (NullUtil.isNullOrZero((Number)solicitacaoRedefinicao.getNumeroAutenticacao())) {
            throw new ApiException("msg.erro.001", new String[]{"N\u00famero de Autentica\u00e7\u00e3o"});
        }
        if (!solicitacaoRedefinicao.getNumeroAutenticacao().equals(solicitacaoAtual.getNumeroAutenticacao())) {
            throw new ApiException("msg.erro.032");
        }
        if (StringUtil.isBlank((String)solicitacaoRedefinicao.getUsuario().getSenha())) {
            throw new ApiException("msg.erro.001", new String[]{"Nova Senha"});
        }
        if (StringUtil.isBlank((String)solicitacaoRedefinicao.getUsuario().getConfirmacaoSenha())) {
            throw new ApiException("msg.erro.001", new String[]{"Confirme a Senha"});
        }
        if (!solicitacaoRedefinicao.getUsuario().getSenha().equals(solicitacaoRedefinicao.getUsuario().getConfirmacaoSenha())) {
            throw new ApiException("msg.erro.004");
        }
        if (StringUtil.isBlank((String)solicitacaoRedefinicao.getUsuario().getSenha()) || solicitacaoRedefinicao.getUsuario().getSenha().length() < 8) {
            throw new ApiException("msg.erro.005");
        }
        if (DateUtil.calcularDiferencaEntreDatasEmHoras((Date)solicitacaoAtual.getDataHoraSolicitacao(), (Date)new Date()) >= 24L) {
            throw new ApiException("msg.erro.033");
        }
    }
}

