/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.TarifaDeEntregaPorRaio;
import com.escolpi.omni.api.model.specification.builder.TarifaDeEntregaPorRaioSpecificationBuilder;
import com.escolpi.omni.api.repository.TarifaDeEntregaPorRaioRepository;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.NullUtil;
import java.util.List;
import javax.validation.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TarifaDeEntregaPorRaioService
implements BaseCrudService<TarifaDeEntregaPorRaio, Long> {
    @Autowired
    private TarifaDeEntregaPorRaioRepository repository;

    @Transactional
    public void delete(Long id) throws ApiException {
        try {
            this.repository.deleteById((Object)id);
        }
        catch (ConstraintViolationException | DataIntegrityViolationException e) {
            throw new ApiException("msg.erro.048", new String[]{"Tarifa de Entrega Por Raio", "Pedido"});
        }
    }

    public Page<TarifaDeEntregaPorRaio> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        TarifaDeEntregaPorRaioSpecificationBuilder builder = new TarifaDeEntregaPorRaioSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.repository.findAll(spec, (Pageable)pageable);
    }

    public List<TarifaDeEntregaPorRaio> findAll(Long empresaId) throws ApiException {
        return this.repository.findByEmpresaId(empresaId);
    }

    public TarifaDeEntregaPorRaio findById(Long id) throws ApiException {
        return (TarifaDeEntregaPorRaio)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Tarifa de Entrega Por Raio", id.toString()}));
    }

    @Transactional
    public void save(TarifaDeEntregaPorRaio entity) throws ApiException {
        this.validate(entity);
        if (NullUtil.isNotNullOrZero((Number)entity.getId())) {
            TarifaDeEntregaPorRaio edit = this.findById(entity.getId());
            edit.setAtivo(entity.getAtivo());
            edit.setMetros(entity.getMetros());
            edit.setValor(entity.getValor());
            this.repository.save((Object)edit);
            return;
        }
        this.repository.save((Object)entity);
    }

    public void validate(TarifaDeEntregaPorRaio entity) throws ApiException {
        if (NullUtil.isNull((Object)entity)) {
            throw new ApiException("msg.erro.001", new String[]{"Tarifa de Entrega Por Raio"});
        }
        if (NullUtil.isNull((Object)entity.getEmpresa())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (NullUtil.isNull((Object)entity.getMetros())) {
            throw new ApiException("msg.erro.001", new String[]{"Metros"});
        }
        if (NullUtil.isNull((Object)entity.getValor())) {
            throw new ApiException("msg.erro.001", new String[]{"Valor"});
        }
        if (NullUtil.isNotNullOrZero((Number)entity.getId()) ? this.repository.findByDistanceAndCompanyIdAndNotId(entity.getMetros(), entity.getId(), entity.getEmpresa().getId()) > 0L : this.repository.countByDistanceAndCompanyId(entity.getMetros(), entity.getEmpresa().getId()) > 0L) {
            throw new ApiException("erro.entidade.existente.f", new String[]{"Tarifa de Entrega por Raio"});
        }
    }
}

