/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.FusoHorario;
import com.escolpi.omni.api.enumeration.SituacaoDoRecado;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.Recado;
import com.escolpi.omni.api.model.specification.builder.RecadoSpecificationBuilder;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.RecadoRepository;
import com.escolpi.omni.api.repository.TokenRepository;
import com.escolpi.omni.api.service.PushNotificationService;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecadoService
implements BaseCrudService<Recado, Long> {
    @Autowired
    private EmpresaRepository empresaRepository;
    @Autowired
    private TokenRepository fcmTokenRepository;
    @Autowired
    private PushNotificationService pushService;
    @Autowired
    private RecadoRepository recadoRepository;

    @Transactional
    public void delete(Long id) throws ApiException {
        this.recadoRepository.deleteById((Object)id);
    }

    public void enviarPushNotification(Recado recado, List<String> tokens) throws ApiException, JsonProcessingException {
        Empresa empresa = (Empresa)this.empresaRepository.findById((Object)recado.getEmpresa().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", recado.getEmpresa().getId().toString()}));
        for (String token : tokens) {
            this.pushService.enviarRecado(token, recado.getAssunto(), recado.getMensagem(), empresa.getFcmTokenServidor());
        }
    }

    public Page<Recado> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        RecadoSpecificationBuilder builder = new RecadoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.recadoRepository.findAll(spec, (Pageable)pageable);
    }

    public List<Recado> findAll(Long empresaId) throws ApiException {
        return null;
    }

    public Recado findById(Long id) throws ApiException {
        return (Recado)this.recadoRepository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Recado"}));
    }

    public Recado findById(Long id, Long empresaId) throws ApiException {
        Recado scrap = (Recado)this.recadoRepository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Recado", id.toString()}));
        if (!scrap.getEmpresa().getId().equals(empresaId)) {
            throw new ApiException("erro.nao.vinculado", new String[]{Entidade.RECADO.getDescricao()});
        }
        return scrap;
    }

    @Transactional
    public void save(Recado recado) throws ApiException {
        this.validate(recado);
        Empresa empresa = (Empresa)this.empresaRepository.findById((Object)recado.getEmpresa().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", recado.getEmpresa().getId().toString()}));
        recado.setDataHoraAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario()));
        recado.setQtdeLidos(Long.valueOf(0L));
        if (NullUtil.isNotNullOrZero((Number)recado.getId())) {
            Recado edicao = (Recado)this.recadoRepository.findById((Object)recado.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Recado", recado.getId().toString()}));
            edicao.setFormaEnvio(recado.getFormaEnvio());
            edicao.setAssunto(recado.getAssunto());
            edicao.setMensagem(recado.getMensagem());
            edicao.setSituacao(recado.getSituacao());
            edicao.setDataHoraAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario()));
            if (recado.getSituacao().equals((Object)SituacaoDoRecado.ENVIADO)) {
                edicao.setDataHoraEnvio(edicao.getDataHoraAtualizacao());
            }
            this.recadoRepository.save((Object)recado);
        } else {
            this.recadoRepository.save((Object)recado);
        }
        if (recado.getSituacao().equals((Object)SituacaoDoRecado.ENVIADO)) {
            List fcmTokens = this.fcmTokenRepository.findByEmpresaId(recado.getEmpresa().getId());
            this.enviarRecadoViaPush(recado, fcmTokens);
        }
    }

    public void validate(Recado recado) throws ApiException {
        if (NullUtil.isNull((Object)recado)) {
            throw new ApiException("msg.erro.001", new String[]{"Recado"});
        }
        if (NullUtil.isNull((Object)recado.getEmpresa())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (NullUtil.isNull((Object)recado.getAssunto())) {
            throw new ApiException("msg.erro.001", new String[]{"Assunto"});
        }
        if (NullUtil.isNull((Object)recado.getMensagem())) {
            throw new ApiException("msg.erro.001", new String[]{"Mensagem"});
        }
        if (NullUtil.isNull((Object)recado.getFormaEnvio())) {
            throw new ApiException("msg.erro.001", new String[]{"Forma de Envio"});
        }
    }

    private void enviarRecadoViaPush(Recado recado, List<String> fcmTokens) throws ApiException {
        try {
            this.enviarPushNotification(recado, fcmTokens);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }
}

