/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.Origem;
import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.enumeration.TipoToken;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.entity.Token;
import com.escolpi.omni.api.model.entity.dto.Data;
import com.escolpi.omni.api.model.entity.dto.FCMNotification;
import com.escolpi.omni.api.model.entity.dto.Notification;
import com.escolpi.omni.api.repository.ClienteRepository;
import com.escolpi.omni.api.repository.TokenRepository;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Deprecated
@Service
public class PushNotificationService {
    private int countSendPush = 0;
    @Autowired
    private EmpresaService companyService;
    @Autowired
    private ClienteRepository customerRepository;
    @Autowired
    private TokenRepository fcmTokenRepository;
    @Autowired
    private ObjectMapper objectMapper;
    private static final String TPL_PN_TITLE_ATUALIZACAO_PEDIDO = "Acompanhamento de pedido n\u00ba %s";
    private static final String TPL_PN_MSG_ATUALIZACAO_PEDIDO = "O pedido n\u00ba %s foi atualizado para \"%s\" em %s.\nToque aqui para acompanhar seu pedido.";
    private static final String TPL_PN_MSG_PEDIDO_CANCELADO = "O pedido n\u00ba %s foi cancelado. Entre em contato para saber o motivo.";

    @Async(value="notifyCustomerScrapExecutor")
    public void enviarRecado(String clienteFcmToken, String titulo, String mensagem, String fcmTokenEmpresa) throws JsonProcessingException {
        FCMNotification notificacao = new FCMNotification();
        Notification notification = new Notification();
        notification.setBody(mensagem);
        notification.setTitle(titulo);
        notification.setSound("default");
        notificacao.setNotification(notification);
        notificacao.setTo(clienteFcmToken);
        notificacao.setPriority("high");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Authorization", "key=" + fcmTokenEmpresa);
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity request = new HttpEntity((Object)this.objectMapper.writeValueAsString((Object)notificacao), (MultiValueMap)headers);
        restTemplate.exchange("https://fcm.googleapis.com/fcm/send", HttpMethod.POST, request, String.class, new Object[0]);
    }

    @Async(value="notifyOrderExecutor")
    public void notificarAtualizacaoDoPedido(Pedido pedido) throws JsonProcessingException, ApiException {
        TipoToken tipoToken = pedido.getOrigem().equals((Object)Origem.APP) ? TipoToken.APP : TipoToken.WEB;
        Cliente customer = (Cliente)this.customerRepository.findById((Object)pedido.getCliente().getId()).get();
        Token fcmToken = this.fcmTokenRepository.findTopByUsuarioIdAndEmpresaIdAndTipoOrderByIdDesc(customer.getId(), pedido.getEmpresa().getId(), tipoToken).orElse(null);
        Empresa company = this.companyService.findById(pedido.getEmpresa().getId());
        if (NullUtil.isNotNull((Object)fcmToken) && NullUtil.isNotNull((Object)company.getFcmTokenServidor()) && StringUtil.isNotBlank((String)company.getFcmTokenServidor())) {
            FCMNotification fcmNotification = new FCMNotification();
            Notification notification = new Notification();
            Data data = new Data();
            String body = "";
            body = !pedido.getSituacao().equals((Object)SituacaoDoPedido.CANCELADO) ? String.format(TPL_PN_MSG_ATUALIZACAO_PEDIDO, pedido.getId(), pedido.getSituacao().getDescricao(), DateUtil.format((String)"dd/MM/yyyy '\u00e0s' HH:mm:ss", (Date)pedido.getDataAtualizacaoPedido())) : String.format(TPL_PN_MSG_PEDIDO_CANCELADO, pedido.getId());
            notification.setBody(body);
            notification.setTitle(String.format(TPL_PN_TITLE_ATUALIZACAO_PEDIDO, pedido.getId()));
            notification.setSound("default");
            if (pedido.getOrigem().equals((Object)Origem.APP)) {
                data.setRedirecionarParaAcompanhamento("exibir-pedido-em-andamento");
            } else {
                data.setRedirecionarParaAcompanhamento(pedido.getEmpresa().getIdStore() + "store/home/last-order-detail");
            }
            data.setPedidoId(pedido.getId());
            fcmNotification.setNotification(notification);
            fcmNotification.setData(data);
            fcmNotification.setTo(fcmToken.getToken());
            fcmNotification.setPriority("high");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            String token = fcmToken.getTipo().equals((Object)TipoToken.APP) ? company.getFcmTokenServidor() : "AAAAafZdmJ8:APA91bGY7WsE3IapaM0mScgZjpmxXJ-47Vl0mXQZ3ch8Zn7Og04FG1ar61PHcWV0KLWOi4buVd_pLGIwVhdERw4UcnBkR4_HyuQ5WXwf7pJHY8RyXLPu6JjLU9w3RxIEAt33IpbApb-g";
            headers.add("Authorization", "key=" + token);
            RestTemplate restTemplate = new RestTemplate();
            HttpEntity request = new HttpEntity((Object)this.objectMapper.writeValueAsString((Object)fcmNotification), (MultiValueMap)headers);
            try {
                restTemplate.exchange("https://fcm.googleapis.com/fcm/send", HttpMethod.POST, request, String.class, new Object[0]);
                this.countSendPush = 0;
            }
            catch (HttpServerErrorException e) {
                if (this.countSendPush < 3) {
                    ++this.countSendPush;
                    this.notificarAtualizacaoDoPedido(pedido);
                }
                this.countSendPush = 0;
            }
        }
    }

    @Async(value="notifyOrderExecutor")
    public void notifyNewOrder(Pedido order) throws ApiException, JsonProcessingException {
        if (StringUtil.isNotBlank((String)order.getEmpresa().getTokenFcm())) {
            Notification notification = new Notification();
            notification.setTitle("Novo Pedido");
            notification.setBody(String.format("Voc\u00ea tem um novo pedido: No. %s", order.getId()));
            notification.setSound("default");
            notification.setClick_action("APP_EMPRESAS_ACTIVITY");
            FCMNotification fcmNotification = new FCMNotification();
            fcmNotification.setNotification(notification);
            fcmNotification.setTo(order.getEmpresa().getTokenFcm());
            fcmNotification.setPriority("high");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("Authorization", "key=AAAABHjTffk:APA91bE3YBgDyf8HKZNPQyaqdSbbH8r3uyDQOp0mXdtY6dRhV3WL5VbAyjtvlcdGA2GIbGFO1GU-6lbn-nBQ1JS5dfeFbCfnffdgWiiXGT7UgNZ8nUkevXKBQCygJOvvI2S1xAs-A64n");
            RestTemplate restTemplate = new RestTemplate();
            HttpEntity request = new HttpEntity((Object)this.objectMapper.writeValueAsString((Object)fcmNotification), (MultiValueMap)headers);
            restTemplate.exchange("https://fcm.googleapis.com/fcm/send", HttpMethod.POST, request, String.class, new Object[0]);
        }
    }
}

