/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.domain.Domains;
import com.escolpi.omni.api.domain.Message;
import com.escolpi.omni.api.enumeration.DiaDaSemana;
import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.FusoHorario;
import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.enumeration.ValorConfiguracaoBooleano;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CategoriaDoProduto;
import com.escolpi.omni.api.model.entity.Emblema;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.EmpresaConfiguracao;
import com.escolpi.omni.api.model.entity.EmpresaProdutoEmDestaque;
import com.escolpi.omni.api.model.entity.Personalizacao;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.entity.ValorDaPersonalizacao;
import com.escolpi.omni.api.model.entity.dto.CatalogoDoRodizio;
import com.escolpi.omni.api.model.entity.dto.DataOption;
import com.escolpi.omni.api.model.entity.dto.DataOptionGroup;
import com.escolpi.omni.api.model.entity.id.EmpresaId;
import com.escolpi.omni.api.model.projection.AutocompleteView;
import com.escolpi.omni.api.model.specification.builder.ProdutoSpecificationBuilder;
import com.escolpi.omni.api.repository.CategoriaDoProdutoRepository;
import com.escolpi.omni.api.repository.EmblemaRepository;
import com.escolpi.omni.api.repository.EmpresaConfiguracaoRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.ProdutoRepository;
import com.escolpi.omni.api.repository.ValorDaPersonalizacaoRepository;
import com.escolpi.omni.api.service.CategoriaDoProdutoService;
import com.escolpi.omni.api.service.EmpresaProdutoEmDestaqueService;
import com.escolpi.omni.api.service.FileService;
import com.escolpi.omni.api.service.PersonalizacaoService;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.FileUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ProdutoService
implements BaseCrudService<Produto, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProdutoService.class);
    @Autowired
    private FileService fileService;
    @Autowired
    private CategoriaDoProdutoRepository categoriaRepository;
    @Autowired
    private CategoriaDoProdutoService categoryService;
    @Autowired
    private EmpresaRepository empresaRepository;
    @Autowired
    private EmpresaConfiguracaoRepository empresaConfiguracaoRepository;
    @Autowired
    private EmblemaRepository emblemaRepository;
    @Autowired
    private ProdutoRepository repository;
    @Autowired
    private EmpresaProdutoEmDestaqueService destaqueService;
    @Autowired
    private PersonalizacaoService personalizacaoService;
    @Autowired
    private ValorDaPersonalizacaoRepository valorPersonalizacaoRepository;

    public List<AutocompleteView> searchByAutocomplete(Long empresaId, String nome) {
        return this.repository.findByAutocomplete(empresaId, nome);
    }

    public List<AutocompleteView> searchByAutocomplete(Long empresaId, Long categoriaId, String nome) {
        return this.repository.findByAutocomplete(empresaId, categoriaId, nome);
    }

    @Transactional
    public void delete(Long id) throws ApiException {
        try {
            List customizationValues;
            Produto edit = (Produto)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto", id.toString()}));
            edit.setExcluido(Boolean.valueOf(true));
            this.repository.save((Object)edit);
            EmpresaProdutoEmDestaque spotlight = this.destaqueService.findByProdutoId(id);
            if (NullUtil.isNotNull((Object)spotlight)) {
                this.destaqueService.delete(spotlight.getId());
            }
            if (!CollectionUtils.isEmpty((Collection)(customizationValues = this.valorPersonalizacaoRepository.findByProdutoIdAndExcluidoIsFalse(edit.getId())))) {
                customizationValues.forEach(value -> {
                    value.setExcluido(Boolean.valueOf(true));
                    this.valorPersonalizacaoRepository.save(value);
                });
            }
        }
        catch (Exception e) {
            throw new ApiException("erro.entitidade.vinculado", new String[]{"Produto"});
        }
    }

    @Transactional
    public void deleteByConcentrePDV(Long empresaId, List<String> codigosAtos) throws ApiException {
        for (String codigoAtos : codigosAtos) {
            for (Produto produto : this.findByCodigoAtos(empresaId, codigoAtos)) {
                this.delete(produto.getId());
            }
        }
    }

    public Page<Produto> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        ProdutoSpecificationBuilder builder = new ProdutoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.repository.findAll(spec, (Pageable)pageable);
    }

    public Page<Produto> filterAvaliableProducts(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        ProdutoSpecificationBuilder builder = new ProdutoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page results = this.repository.findAll(spec, (Pageable)pageable);
        return results.map(arg_0 -> this.populateProduct(arg_0));
    }

    public List<Produto> findAll(Long empresaId) throws ApiException {
        return this.repository.findByEmpresaIdAndExcluidoIsFalse(empresaId);
    }

    public List<DataOptionGroup> listProductsDataOptionGroupByCategory(Long companyId) {
        ArrayList<DataOptionGroup> options = new ArrayList<DataOptionGroup>();
        List categories = this.categoriaRepository.findByEmpresaIdAndExcluidaIsFalseOrderByDescricao(companyId);
        categories.forEach(category -> {
            List products = this.repository.findByEmpresaIdAndCategoriaIdAndExcluidoIsFalseOrderByNome(companyId, category.getId());
            DataOptionGroup group = new DataOptionGroup(new DataOption(category.getDescricao(), category.getId()));
            group.setOptions(new ArrayList());
            products.stream().filter(product -> product.getEmFalta() == false).forEach(product -> group.getOptions().add(new DataOption(product.getNome(), product.getId())));
            if (!CollectionUtils.isEmpty((Collection)group.getOptions())) {
                options.add(group);
            }
        });
        return options;
    }

    public List<Produto> findByEmpresaIdAndEmOferta(Long empresaId) throws ApiException {
        EmpresaConfiguracao configExibeProdutosEmFalta = (EmpresaConfiguracao)this.empresaConfiguracaoRepository.findByEmpresaIdAndConfiguracaoNome(empresaId, "config-exibe-produtos-em-falta").get();
        boolean exibirEmFalta = configExibeProdutosEmFalta.getValor().equals("1");
        List produtos = this.repository.findByEmpresaIdAndEmOferta(empresaId);
        for (Produto produto : produtos) {
            if (!exibirEmFalta && produto.getEmFalta().booleanValue()) continue;
            CategoriaDoProduto categoria = produto.getCategoria();
            produto.setEmpresa(new Empresa(produto.getEmpresa().getId()));
            produto.setCategoria(new CategoriaDoProduto(categoria.getId()));
            produto.getCategoria().setDescricao(categoria.getDescricao());
            produto.setDataHoraUltimaAtualizacao(null);
            produto.setCodigoAtos(null);
            if (StringUtil.isNotBlank((String)produto.getCaminhoFoto())) {
                if (!produto.getFotoExterna().booleanValue()) {
                    produto.setFoto(this.fileService.getPictureUrl(produto, false));
                    produto.setMiniatura(this.fileService.getPictureUrl(produto, true));
                    continue;
                }
                produto.setFoto(produto.getCaminhoFoto());
                produto.setMiniatura(produto.getCaminhoFoto());
                continue;
            }
            produto.setFoto(null);
            produto.setMiniatura(this.fileService.getPictureUrl(categoria.getEmblema()));
        }
        return produtos;
    }

    public List<Produto> findByEmpresaIdAndNome(Long empresaId, String nome) throws ApiException {
        ArrayList<Produto> produtos = new ArrayList<Produto>();
        EmpresaConfiguracao exibeEmFalta = (EmpresaConfiguracao)this.empresaConfiguracaoRepository.findByEmpresaIdAndConfiguracaoNome(empresaId, "config-exibe-produtos-em-falta").orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Configura\u00e7\u00e3o da Empresa", "{ Empresa " + empresaId + " | Configura\u00e7\u00e3o " + nome + " }"}));
        for (Produto produto : this.repository.findByEmpresaIdAndNomeAndExcluidoIsFalse(empresaId, nome)) {
            if (!StringUtil.isBlank((String)exibeEmFalta.getValor()) && exibeEmFalta.getValor().equals(ValorConfiguracaoBooleano.FALSE.getValor()) && produto.getEmFalta().booleanValue()) continue;
            CategoriaDoProduto categoria = produto.getCategoria();
            produto.setCategoria(new CategoriaDoProduto(produto.getCategoria().getId()));
            produto.setDataHoraUltimaAtualizacao(null);
            produto.setCodigoAtos(null);
            if (StringUtil.isNotBlank((String)produto.getCaminhoFoto())) {
                if (!produto.getFotoExterna().booleanValue()) {
                    produto.setFoto(this.fileService.getPictureUrl(produto, false));
                    produto.setMiniatura(this.fileService.getPictureUrl(produto, true));
                } else {
                    produto.setFoto(produto.getCaminhoFoto());
                    produto.setMiniatura(produto.getCaminhoFoto());
                }
            } else {
                produto.setFoto(null);
                produto.setMiniatura(this.fileService.getPictureUrl(categoria.getEmblema()));
            }
            produto.setEmpresa(new Empresa(produto.getEmpresa().getId()));
            produtos.add(produto);
        }
        return produtos;
    }

    @Deprecated
    public Produto find(Long id) throws ApiException {
        Produto product = new Produto();
        Produto edit = (Produto)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto", id.toString()}));
        product.setId(edit.getId());
        product.setNome(edit.getNome());
        product.setDescricao(edit.getDescricao());
        product.setCodigoAtos(edit.getCodigoAtos());
        product.setEmpresa(new Empresa(edit.getEmpresa().getId()));
        product.setCategoria(new CategoriaDoProduto(edit.getCategoria().getId(), edit.getCategoria().getDescricao()));
        product.getCategoria().setEmblema(edit.getCategoria().getEmblema());
        product.getCategoria().getEmblema().setFoto(this.fileService.getPictureUrl(product.getCategoria().getEmblema()));
        product.getCategoria().setComposicao(edit.getCategoria().getComposicao());
        if (StringUtil.isNotBlank((String)edit.getCaminhoFoto())) {
            if (NullUtil.isNull((Object)product.getFotoExterna()) || !product.getFotoExterna().booleanValue()) {
                product.setFoto(this.fileService.getPictureUrl(edit, false));
                product.setMiniatura(this.fileService.getPictureUrl(edit, true));
            } else {
                product.setFoto(edit.getCaminhoFoto());
                product.setMiniatura(edit.getCaminhoFoto());
            }
        }
        product.setDisponibilidades(edit.getDisponibilidades());
        product.setEmFalta(edit.getEmFalta());
        product.setExibeNaTelaInicial(edit.getExibeNaTelaInicial());
        product.setOpcionaisPorProduto(edit.getOpcionaisPorProduto());
        product.setApenasOpcionaisPorProduto(edit.getApenasOpcionaisPorProduto());
        product.setVendaPorFracao(edit.getVendaPorFracao());
        product.setPeso(edit.getPeso());
        product.setPesoMedio(edit.getPesoMedio());
        product.setVendaPorTamanho(edit.getVendaPorTamanho());
        product.setValor(NullUtil.isNotNullOrZero((BigDecimal)edit.getValor()) ? edit.getValor() : BigDecimal.ZERO);
        product.setLabelTamanhoBroto(StringUtil.isNotBlank((String)edit.getLabelTamanhoBroto()) ? edit.getLabelTamanhoBroto() : "Broto");
        product.setValorTamanhoBroto(NullUtil.isNotNullOrZero((BigDecimal)edit.getValorTamanhoBroto()) ? edit.getValorTamanhoBroto() : BigDecimal.ZERO);
        product.setLimiteSelecaoTamanhoBroto(edit.getLimiteSelecaoTamanhoBroto());
        product.setLabelTamanhoMedio(StringUtil.isNotBlank((String)edit.getLabelTamanhoMedio()) ? edit.getLabelTamanhoMedio() : "M\u00e9dio");
        product.setValorTamanhoMedio(NullUtil.isNotNullOrZero((BigDecimal)edit.getValorTamanhoMedio()) ? edit.getValorTamanhoMedio() : BigDecimal.ZERO);
        product.setLimiteSelecaoTamanhoMedio(edit.getLimiteSelecaoTamanhoMedio());
        product.setLabelTamanhoGrande(StringUtil.isNotBlank((String)edit.getLabelTamanhoGrande()) ? edit.getLabelTamanhoGrande() : "Grande");
        product.setValorTamanhoGrande(NullUtil.isNotNullOrZero((BigDecimal)edit.getValorTamanhoGrande()) ? edit.getValorTamanhoGrande() : BigDecimal.ZERO);
        product.setLimiteSelecaoTamanhoBroto(edit.getLimiteSelecaoTamanhoGrande());
        product.setLabelTamanhoGigante(StringUtil.isNotBlank((String)edit.getLabelTamanhoGigante()) ? edit.getLabelTamanhoGigante() : "Gigante");
        product.setValorTamanhoGigante(NullUtil.isNotNullOrZero((BigDecimal)edit.getValorTamanhoGigante()) ? edit.getValorTamanhoGigante() : BigDecimal.ZERO);
        product.setLimiteSelecaoTamanhoBroto(edit.getLimiteSelecaoTamanhoGigante());
        return product;
    }

    public Produto findById(Long id) throws ApiException {
        Produto product = (Produto)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto", id.toString()}));
        if (StringUtil.isNotBlank((String)product.getCaminhoFoto())) {
            product.setFoto(this.fileService.getPictureUrl(product, false));
            product.setMiniatura(this.fileService.getPictureUrl(product, true));
        }
        product.getCategoria().setEmblema((Emblema)this.emblemaRepository.findById((Object)Domains.ID_EMBLEMA_PADRAO).get());
        return product;
    }

    public Produto findById(Long id, Long empresaId) throws ApiException {
        Produto produto = (Produto)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto", id.toString()}));
        if (!produto.getEmpresa().getId().equals(empresaId)) {
            throw new ApiException("erro.nao.vinculada", new String[]{Entidade.PRODUTO.getDescricao()});
        }
        if (StringUtil.isNotBlank((String)produto.getCaminhoFoto())) {
            if (!produto.getFotoExterna().booleanValue()) {
                produto.setFoto(this.fileService.getPictureUrl(produto, false));
                produto.setMiniatura(this.fileService.getPictureUrl(produto, true));
            } else {
                produto.setFoto(produto.getCaminhoFoto());
                produto.setMiniatura(produto.getCaminhoFoto());
            }
        }
        produto.getCategoria().setEmblema((Emblema)this.emblemaRepository.findById((Object)Domains.ID_EMBLEMA_PADRAO).get());
        return produto;
    }

    public List<Produto> findByCodigoAtos(Long empresaId, String codigoAtos) throws ApiException {
        return this.repository.findByEmpresaIdAndCodigoAtosAndExcluidoIsFalse(empresaId, codigoAtos);
    }

    public List<Produto> findByNomeAndCategoriaId(String nome, Long categoriaId, Long empresaId) throws ApiException {
        ArrayList<Produto> produtos = new ArrayList<Produto>();
        EmpresaConfiguracao exibeEmFalta = (EmpresaConfiguracao)this.empresaConfiguracaoRepository.findByEmpresaIdAndConfiguracaoNome(empresaId, "config-exibe-produtos-em-falta").orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Configura\u00e7\u00e3o da Empresa", "{ Empresa " + empresaId + " | Configura\u00e7\u00e3o " + nome + " }"}));
        for (Produto produto : this.repository.findByNomeAndCategoriaIdAndExcluidoIsFalse(nome, categoriaId)) {
            if (exibeEmFalta.getValor().equals(ValorConfiguracaoBooleano.FALSE.getValor()) && produto.getEmFalta().booleanValue()) continue;
            CategoriaDoProduto categoria = produto.getCategoria();
            produto.setCategoria(new CategoriaDoProduto(categoria.getId()));
            produto.setDataHoraUltimaAtualizacao(null);
            produto.setCodigoAtos(null);
            if (StringUtil.isNotBlank((String)produto.getCaminhoFoto())) {
                if (!produto.getFotoExterna().booleanValue()) {
                    produto.setFoto(this.fileService.getPictureUrl(produto, false));
                    produto.setMiniatura(this.fileService.getPictureUrl(produto, true));
                } else {
                    produto.setFoto(produto.getCaminhoFoto());
                    produto.setMiniatura(produto.getCaminhoFoto());
                }
                produto.setDataHoraUltimaAtualizacao(null);
                produto.setEmpresa(new Empresa(produto.getEmpresa().getId()));
            } else {
                produto.setFoto(null);
                produto.setMiniatura(this.fileService.getPictureUrl(categoria.getEmblema()));
            }
            produtos.add(produto);
        }
        return produtos;
    }

    @Transactional
    public void importFromIFood(String url, Long empresaId) throws IOException, ApiException {
        RestTemplate restTemplate = new RestTemplate();
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Content-Type", (Object)"application/json");
        HttpEntity request = new HttpEntity((Object)url, (MultiValueMap)headers);
        String urlIFood = "https://us-central1-pede-facil-prd.cloudfunctions.net/ifood";
        try {
            ResponseEntity response = restTemplate.postForEntity(urlIFood, (Object)request, String.class, new Object[0]);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode responseBody = mapper.readTree((String)response.getBody());
            if (responseBody.get("error").asBoolean()) {
                throw new ApiException("msg.erro.113");
            }
            this.convertFromIFood(responseBody, empresaId);
        }
        catch (Exception e) {
            throw new ApiException("msg.erro.113");
        }
    }

    @Transactional
    public void linkProducts(Long empresaId, List<Produto> products) throws ApiException {
        if (CollectionUtils.isEmpty(products)) {
            throw new ApiException("msg.erro.098");
        }
        Long naoVinculados = products.stream().filter(product -> !product.getEmpresa().getId().equals(empresaId)).count();
        if (naoVinculados > 0L) {
            throw new ApiException("msg.erro.098");
        }
        products.forEach(product -> {
            Produto edit = (Produto)this.repository.findById((Object)product.getId()).get();
            edit.setCodigoAtos(product.getCodigoAtos());
            this.repository.save((Object)edit);
        });
    }

    public List<Produto> listRecommendedProductsByProfile(Long empresaId, Long usuarioId) throws ApiException {
        if (NullUtil.isNullOrZero((Number)empresaId)) {
            throw new ApiException("msg.erro.001", new String[]{"empresaId"});
        }
        if (NullUtil.isNullOrZero((Number)usuarioId)) {
            throw new ApiException("msg.erro.001", new String[]{"usuarioId"});
        }
        List products = this.repository.findProdutosRecomendadosPorPerfilAndExcluidoIsFalse(empresaId, usuarioId, SituacaoDoPedido.FINALIZADO, (Pageable)PageRequest.of((int)0, (int)5));
        products.forEach(product -> {
            try {
                this.loadProductPicture(product);
            }
            catch (ApiException e) {
                LOGGER.error(Message.getInstance().getMessage("msg.erro.091", new String[]{e.getMessage()}));
            }
        });
        return products;
    }

    public void resetProducts(Long companyId) throws ApiException {
        for (CategoriaDoProduto category : this.categoriaRepository.findByEmpresaIdAndExcluidaIsFalseOrderByDescricao(companyId)) {
            this.categoryService.delete(category.getId());
        }
    }

    @Transactional
    public void save(Produto product) throws ApiException {
        Empresa company = (Empresa)this.empresaRepository.findById((Object)product.getEmpresa().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", product.getEmpresa().getId().toString()}));
        product.getCategoria().setEmblema((Emblema)this.emblemaRepository.findById((Object)Domains.ID_EMBLEMA_PADRAO).get());
        this.validate(product);
        String path = this.getProductsPath(product.getEmpresa().getId()) + File.separator;
        if (NullUtil.isNull((Object)product.getDisponibilidades())) {
            product.setDisponibilidades("1,2,3,4,5,6,7");
        }
        if (NullUtil.isNotNullOrZero((Number)product.getId())) {
            Produto edit = (Produto)this.repository.findById((Object)product.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto", product.getId().toString()}));
            String caminhoFotoAtual = edit.getCaminhoFoto();
            edit.setCodigoAtos(product.getCodigoAtos());
            edit.setNome(product.getNome());
            edit.setDescricao(product.getDescricao());
            edit.setEmFalta(product.getEmFalta());
            edit.setCategoria(product.getCategoria());
            edit.setCategoriaDoRodizio(product.getCategoriaDoRodizio());
            edit.setValor(product.getValor());
            edit.setValorDesconto(product.getValorDesconto());
            edit.setValorTamanhoBroto(product.getValorTamanhoBroto());
            edit.setValorTamanhoMedio(product.getValorTamanhoMedio());
            edit.setValorTamanhoGrande(product.getValorTamanhoGrande());
            edit.setValorTamanhoGigante(product.getValorTamanhoGigante());
            edit.setVendaPorFracao(product.getVendaPorFracao());
            edit.setVendaPorTamanho(product.getVendaPorTamanho());
            edit.setLabelTamanhoBroto(product.getLabelTamanhoBroto());
            edit.setLabelTamanhoMedio(product.getLabelTamanhoMedio());
            edit.setLabelTamanhoGrande(product.getLabelTamanhoGrande());
            edit.setLabelTamanhoGigante(product.getLabelTamanhoGigante());
            edit.setExcluido(product.getExcluido());
            edit.setPesoMedio(product.getPesoMedio());
            edit.setEstoque(product.getEstoque());
            edit.setEstoqueIlimitado(product.getEstoqueIlimitado());
            edit.setLimiteSelecaoTamanhoBroto(product.getLimiteSelecaoTamanhoBroto());
            edit.setLimiteSelecaoTamanhoMedio(product.getLimiteSelecaoTamanhoMedio());
            edit.setLimiteSelecaoTamanhoGrande(product.getLimiteSelecaoTamanhoGrande());
            edit.setLimiteSelecaoTamanhoGigante(product.getLimiteSelecaoTamanhoGigante());
            edit.setExibeNaTelaInicial(product.getExibeNaTelaInicial());
            edit.setVendaPorAtacado(product.getVendaPorAtacado());
            edit.setQtdeMinVendaPorAtacado(product.getQtdeMinVendaPorAtacado());
            edit.setValorAtacado(product.getValorAtacado());
            edit.setValorAPrazo(product.getValorAPrazo());
            edit.setAltura(product.getAltura());
            edit.setLargura(product.getLargura());
            edit.setProfundidade(product.getProfundidade());
            edit.setPeso(product.getPeso());
            edit.setRodizio(Boolean.valueOf(NullUtil.isNotNull((Object)product.getRodizio()) ? product.getRodizio() : false));
            edit.setDisponivelParaORodizio(Boolean.valueOf(NullUtil.isNotNull((Object)product.getDisponivelParaORodizio()) ? product.getDisponivelParaORodizio() : false));
            edit.setProdutosDoRodizio(product.getProdutosDoRodizio());
            edit.setValorMeioRodizio(product.getValorMeioRodizio());
            edit.setOpcionaisPorProduto(Boolean.valueOf(NullUtil.isNotNull((Object)product.getOpcionaisPorProduto()) ? product.getOpcionaisPorProduto() : false));
            edit.setApenasOpcionaisPorProduto(Boolean.valueOf(NullUtil.isNotNull((Object)product.getApenasOpcionaisPorProduto()) ? product.getApenasOpcionaisPorProduto() : false));
            edit.setDataHoraUltimaAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)company.getFusoHorario()));
            edit.setDisponibilidades(product.getDisponibilidades());
            if (!product.getFotoExterna().booleanValue()) {
                edit.setFotoExterna(product.getFotoExterna());
                if (product.isEditarFoto()) {
                    String caminhoMiniatura;
                    String caminhoAtual;
                    if (StringUtil.isNotBlank((String)product.getCaminhoFoto())) {
                        if (StringUtil.isNotBlank((String)edit.getCaminhoFoto())) {
                            caminhoAtual = this.getProductsPath(edit.getEmpresa().getId()) + File.separator + edit.getCaminhoFoto();
                            caminhoMiniatura = this.getProductsPath(edit.getEmpresa().getId()) + File.separator + "_" + edit.getCaminhoFoto();
                            if (FileUtil.fileExists((String)caminhoAtual)) {
                                FileUtil.deleteFile((String)caminhoAtual);
                            }
                            if (FileUtil.fileExists((String)caminhoMiniatura)) {
                                FileUtil.deleteFile((String)caminhoMiniatura);
                            }
                        }
                        edit.setCaminhoFoto(this.generatePictureName(product));
                        path = path + edit.getCaminhoFoto();
                        this.fileService.saveBase64File(path, product.getFoto());
                        this.fileService.saveThumbnailFile(path, product.getFoto(), 640);
                    }
                    if (product.isEditarFoto() && StringUtil.isNotBlank((String)edit.getCaminhoFoto()) && StringUtil.isBlank((String)product.getCaminhoFoto()) && StringUtil.isBlank((String)product.getFoto())) {
                        caminhoAtual = this.getProductsPath(edit.getEmpresa().getId()) + File.separator + edit.getCaminhoFoto();
                        caminhoMiniatura = this.getProductsPath(edit.getEmpresa().getId()) + File.separator + "_" + edit.getCaminhoFoto();
                        edit.setCaminhoFoto(null);
                        if (FileUtil.fileExists((String)caminhoAtual)) {
                            FileUtil.deleteFile((String)caminhoAtual);
                        }
                        if (FileUtil.fileExists((String)caminhoMiniatura)) {
                            FileUtil.deleteFile((String)caminhoMiniatura);
                        }
                    }
                }
            } else {
                if (!StringUtil.isBlank((String)caminhoFotoAtual) && !edit.getFotoExterna().booleanValue()) {
                    String caminhoAtual = this.getProductsPath(edit.getEmpresa().getId()) + File.separator + caminhoFotoAtual;
                    String caminhoMiniatura = this.getProductsPath(edit.getEmpresa().getId()) + File.separator + "_" + caminhoFotoAtual;
                    if (FileUtil.fileExists((String)caminhoAtual)) {
                        FileUtil.deleteFile((String)caminhoAtual);
                    }
                    if (FileUtil.fileExists((String)caminhoMiniatura)) {
                        FileUtil.deleteFile((String)caminhoMiniatura);
                    }
                }
                edit.setFotoExterna(product.getFotoExterna());
                edit.setCaminhoFoto(product.getCaminhoFoto());
            }
            this.repository.save((Object)edit);
            if (edit.getVendaPorTamanho().booleanValue()) {
                this.updateSizeParameters(edit);
            }
        } else {
            product.setDataHoraUltimaAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)company.getFusoHorario()));
            product.setExcluido(Boolean.valueOf(false));
            product.setRodizio(Boolean.valueOf(NullUtil.isNotNull((Object)product.getRodizio()) ? product.getRodizio() : false));
            product.setDisponivelParaORodizio(Boolean.valueOf(NullUtil.isNotNull((Object)product.getDisponivelParaORodizio()) ? product.getDisponivelParaORodizio() : false));
            this.repository.save((Object)product);
            if (StringUtil.isNotBlank((String)product.getFoto())) {
                product.setCaminhoFoto(this.generatePictureName(product));
                path = path + product.getCaminhoFoto();
                this.fileService.saveBase64File(path, product.getFoto());
                this.fileService.saveThumbnailFile(path, product.getFoto(), 640);
                this.repository.save((Object)product);
            }
            if (product.getVendaPorTamanho().booleanValue()) {
                this.updateSizeParameters(product);
            }
        }
    }

    @Transactional
    public void updatePrices(List<Produto> products) throws ApiException {
        for (Produto product : products) {
            Produto edit = (Produto)this.repository.findById((Object)product.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto", product.getId().toString()}));
            if (edit.getVendaPorTamanho().booleanValue()) continue;
            edit.setValor(product.getValor());
            edit.setVendaPorAtacado(product.getVendaPorAtacado());
            edit.setQtdeMinVendaPorAtacado(product.getQtdeMinVendaPorAtacado());
            edit.setValorAtacado(product.getValorAtacado());
            edit.setValorTamanhoBroto(null);
            edit.setLimiteSelecaoTamanhoBroto(null);
            edit.setValorTamanhoMedio(null);
            edit.setLimiteSelecaoTamanhoMedio(null);
            edit.setValorTamanhoGrande(null);
            edit.setLimiteSelecaoTamanhoGrande(null);
            edit.setValorTamanhoGigante(null);
            edit.setLimiteSelecaoTamanhoGigante(null);
            edit.setEstoque(product.getEstoque());
            if (NullUtil.isNotNull((Object)product.getEstoqueIlimitado())) {
                edit.setEstoqueIlimitado(product.getEstoqueIlimitado());
            }
            if (NullUtil.isNotNull((Object)product.getDisponivelParaORodizio())) {
                edit.setDisponivelParaORodizio(product.getDisponivelParaORodizio());
            }
            if (NullUtil.isNotNull((Object)product.getEmFalta())) {
                edit.setEmFalta(product.getEmFalta());
            }
            edit.setDataHoraUltimaAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)edit.getEmpresa().getFusoHorario()));
            edit.setExcluido(product.getExcluido());
            this.repository.save((Object)edit);
        }
    }

    @Transactional
    public void updatePizzaPrices(List<Produto> products) throws ApiException {
        for (Produto product : products) {
            Produto edit = (Produto)this.repository.findById((Object)product.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto", product.getId().toString()}));
            if (!edit.getVendaPorTamanho().booleanValue()) continue;
            edit.setValor(null);
            edit.setVendaPorAtacado(null);
            edit.setQtdeMinVendaPorAtacado(null);
            edit.setValorAtacado(null);
            edit.setEstoqueIlimitado(Boolean.valueOf(true));
            edit.setEstoque(null);
            edit.setValorTamanhoBroto(product.getValorTamanhoBroto());
            edit.setLimiteSelecaoTamanhoBroto(product.getLimiteSelecaoTamanhoBroto());
            edit.setValorTamanhoMedio(product.getValorTamanhoMedio());
            edit.setLimiteSelecaoTamanhoMedio(product.getLimiteSelecaoTamanhoMedio());
            edit.setValorTamanhoGrande(product.getValorTamanhoGrande());
            edit.setLimiteSelecaoTamanhoGrande(product.getLimiteSelecaoTamanhoGrande());
            edit.setValorTamanhoGigante(product.getValorTamanhoGigante());
            edit.setLimiteSelecaoTamanhoGigante(product.getLimiteSelecaoTamanhoGigante());
            edit.setDataHoraUltimaAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)edit.getEmpresa().getFusoHorario()));
            this.repository.save((Object)edit);
        }
    }

    @Transactional
    public void updateAll(Long empresaId, List<Produto> products) throws ApiException {
        for (Produto product : products) {
            Produto edit = (Produto)this.repository.findById((Object)product.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto", product.getId().toString()}));
            if (edit.getVendaPorTamanho().booleanValue()) {
                edit.setValor(product.getValor());
                edit.setVendaPorAtacado(product.getVendaPorAtacado());
                edit.setQtdeMinVendaPorAtacado(product.getQtdeMinVendaPorAtacado());
                edit.setValorAtacado(product.getValorAtacado());
            } else {
                edit.setValorTamanhoBroto(product.getValorTamanhoBroto());
                edit.setLimiteSelecaoTamanhoBroto(product.getLimiteSelecaoTamanhoBroto());
                edit.setValorTamanhoMedio(product.getValorTamanhoMedio());
                edit.setLimiteSelecaoTamanhoMedio(product.getLimiteSelecaoTamanhoMedio());
                edit.setValorTamanhoGrande(product.getValorTamanhoGrande());
                edit.setLimiteSelecaoTamanhoGrande(product.getLimiteSelecaoTamanhoGrande());
                edit.setValorTamanhoGigante(product.getValorTamanhoGigante());
                edit.setLimiteSelecaoTamanhoGigante(product.getLimiteSelecaoTamanhoGigante());
            }
            if (NullUtil.isNotNull((Object)product.getEstoque())) {
                edit.setEstoque(product.getEstoque());
            }
            if (NullUtil.isNotNull((Object)product.getEstoqueIlimitado())) {
                edit.setEstoqueIlimitado(product.getEstoqueIlimitado());
            }
            if (NullUtil.isNotNull((Object)product.getDisponivelParaORodizio())) {
                edit.setDisponivelParaORodizio(product.getDisponivelParaORodizio());
            }
            if (NullUtil.isNotNull((Object)product.getEmFalta())) {
                edit.setEmFalta(product.getEmFalta());
            }
            edit.setDataHoraUltimaAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)edit.getEmpresa().getFusoHorario()));
            edit.setExcluido(product.getExcluido());
            this.repository.save((Object)edit);
        }
    }

    @Transactional
    public void updatePrice(Long empresaId, String codigoAtos, Double valor) throws ApiException {
        Produto product = (Produto)this.repository.findTopByEmpresaIdAndExcluidoIsFalseAndCodigoAtos(empresaId, codigoAtos).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto", "{Emresa " + empresaId + " | C\u00f3digo PDV " + codigoAtos + "}"}));
        product.setValor(new BigDecimal(valor));
        product.setDataHoraUltimaAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)product.getEmpresa().getFusoHorario()));
        this.repository.save((Object)product);
    }

    @Transactional
    public void updateProdutosFromPDV(List<Produto> products) throws ApiException {
        for (Produto product : products) {
            List edits = this.findByCodigoAtos(product.getEmpresa().getId(), product.getCodigoAtos());
            if (edits.size() > 0) {
                for (Produto edit : edits) {
                    if (NullUtil.isNotNull((Object)product.getNome())) {
                        edit.setNome(product.getNome());
                    }
                    if (NullUtil.isNotNullOrZero((BigDecimal)product.getValor())) {
                        edit.setValor(product.getValor());
                    }
                    if (edit.getEmpresa().getControleEstoque().ordinal() > 0) {
                        if (NullUtil.isNotNull((Object)edit.getEstoqueIlimitado()) && !edit.getEstoqueIlimitado().booleanValue()) {
                            if (NullUtil.isNotNull((Object)product.getEmFalta())) {
                                edit.setEmFalta(product.getEmFalta());
                            }
                            if (NullUtil.isNotNull((Object)product.getEstoque())) {
                                if (product.getEstoque().doubleValue() <= 0.0) {
                                    edit.setEstoque(BigDecimal.ZERO);
                                } else if (product.getEstoque().intValue() % 2 == 0 && product.getEstoque().intValue() > 1) {
                                    edit.setEstoque(product.getEstoque().divide(new BigDecimal(2)));
                                } else if (product.getEstoque().intValue() > 1) {
                                    edit.setEstoque(product.getEstoque().subtract(new BigDecimal(1)));
                                    edit.setEstoque(product.getEstoque().divide(new BigDecimal(2)));
                                } else {
                                    edit.setEstoque(BigDecimal.ZERO);
                                }
                                edit.setEmFalta(Boolean.valueOf(edit.getEstoque().compareTo(BigDecimal.ZERO) == 0));
                            } else {
                                edit.setEstoque(BigDecimal.ZERO);
                            }
                        }
                    } else if (NullUtil.isNotNull((Object)product.getEmFalta())) {
                        edit.setEmFalta(product.getEmFalta());
                    }
                    edit.setDataHoraUltimaAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)edit.getEmpresa().getFusoHorario()));
                    this.repository.save((Object)edit);
                }
                continue;
            }
            Produto newProduct = new Produto();
            newProduct.setEstoque(NullUtil.isNull((Object)product.getEstoque()) ? BigDecimal.ZERO : product.getEstoque());
            newProduct.setEmFalta(Boolean.valueOf(newProduct.getEstoque().doubleValue() < 1.0));
            newProduct.setNome(NullUtil.isNotNull((Object)product.getNome()) ? product.getNome() : "PRODUTO SEM NOME");
            CategoriaDoProduto category = (CategoriaDoProduto)this.categoriaRepository.findById((Object)Domains.DEFAULT_CATEGORY_ID).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Categoria do Produto", Domains.DEFAULT_CATEGORY_ID.toString()}));
            newProduct.setCategoria(category);
            newProduct.getCategoria().setEmblema(new Emblema(Long.valueOf(51L)));
            if (NullUtil.isNull((Object)product.getEmpresa()) || NullUtil.isNull((Object)product.getEmpresa().getId())) {
                throw new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", product.getEmpresa().getId().toString()});
            }
            Empresa company = (Empresa)this.empresaRepository.findById((Object)product.getEmpresa().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", product.getEmpresa().getId().toString()}));
            newProduct.setEmpresa(company);
            newProduct.setCodigoAtos(NullUtil.isNotNull((Object)product.getCodigoAtos()) ? product.getCodigoAtos() : null);
            newProduct.setValor(NullUtil.isNotNull((Object)product.getValor()) && product.getValor().doubleValue() > 0.0 ? product.getValor() : BigDecimal.ZERO);
            newProduct.setVendaPorFracao(Boolean.FALSE);
            newProduct.setDataHoraUltimaAtualizacao(new Date());
            newProduct.setExcluido(Boolean.FALSE);
            newProduct.setVendaPorTamanho(Boolean.FALSE);
            this.repository.save((Object)newProduct);
        }
    }

    public void validate(Produto produto) throws ApiException {
        if (NullUtil.isNull((Object)produto)) {
            throw new ApiException("msg.erro.001", new String[]{"Produto"});
        }
        if (StringUtil.isBlank((String)produto.getNome())) {
            throw new ApiException("msg.erro.001", new String[]{"Nome"});
        }
        if (NullUtil.isNull((Object)produto.getCategoria())) {
            throw new ApiException("msg.erro.001", new String[]{"Categoria"});
        }
        if (NullUtil.isNull((Object)produto.getEmpresa())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (NullUtil.isNull((Object)produto.getValor())) {
            throw new ApiException("msg.erro.001", new String[]{"Valor"});
        }
        if (StringUtil.isBlank((String)produto.getNome())) {
            throw new ApiException("msg.erro.001", new String[]{"Nome"});
        }
        if (NullUtil.isNull((Object)produto.getEmFalta())) {
            throw new ApiException("msg.erro.001", new String[]{"Em falta"});
        }
    }

    @Transactional
    private void convertFromIFood(JsonNode resp, Long companyId) throws MalformedURLException, IOException, ApiException {
        Empresa company = (Empresa)this.empresaRepository.findById((Object)companyId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa"}));
        company.setId(companyId);
        Emblema emblema = this.emblemaRepository.findById((Object)51L).orElse(null);
        for (JsonNode categoriaJson : resp.get("data")) {
            Boolean adicionouPersonalizacoesDaCategoria = false;
            CategoriaDoProduto categoria = new CategoriaDoProduto();
            categoria.setAtivo(Boolean.TRUE);
            categoria.setDescricao(categoriaJson.get("name").asText());
            categoria.setEmblema(emblema);
            categoria.setEmpresa(new EmpresaId(company.getId()));
            categoria.setExcluida(Boolean.valueOf(!categoriaJson.get("enabled").asBoolean()));
            categoria.setQuantitativa(Boolean.valueOf(false));
            categoria.setComposicao(Boolean.valueOf(false));
            categoria.setOrdem(Integer.valueOf(categoriaJson.get("order").asInt()));
            categoria.setDestaque(Boolean.valueOf(false));
            this.categoriaRepository.save((Object)categoria);
            for (JsonNode produtoJson : categoriaJson.get("itens")) {
                Produto produto = new Produto();
                produto.setCategoria(categoria);
                produto.setDataHoraUltimaAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)company.getFusoHorario()));
                produto.setDescricao(produtoJson.get("details").asText());
                produto.setEmFalta(Boolean.FALSE);
                produto.setEmpresa(company);
                produto.setExcluido(Boolean.valueOf(!produtoJson.get("enabled").asBoolean()));
                produto.setNome(produtoJson.get("description").asText());
                produto.setValor(new BigDecimal(produtoJson.get("unitMinPrice").asDouble() > produtoJson.get("unitPrice").asDouble() ? produtoJson.get("unitMinPrice").asDouble() : produtoJson.get("unitPrice").asDouble()));
                produto.setVendaPorFracao(Boolean.FALSE);
                produto.setVendaPorTamanho(Boolean.FALSE);
                produto.setFotoExterna(Boolean.FALSE);
                produto.setDisponibilidades("1,2,3,4,5,6,7");
                produto.setEstoque(BigDecimal.ZERO);
                produto.setEstoqueIlimitado(Boolean.valueOf(true));
                produto.setRodizio(Boolean.valueOf(false));
                produto.setExibeNaTelaInicial(Boolean.TRUE);
                if (NullUtil.isNotNull((Object)produtoJson.get("posCode"))) {
                    produto.setCodigoAtos(produtoJson.get("posCode").asText());
                }
                if (produtoJson.get("needChoices").asBoolean() && !adicionouPersonalizacoesDaCategoria.booleanValue()) {
                    adicionouPersonalizacoesDaCategoria = true;
                    for (JsonNode personalizacaoJson : produtoJson.get("choices")) {
                        HashSet<ValorDaPersonalizacao> valoresDaPersonalizacao = new HashSet<ValorDaPersonalizacao>();
                        Personalizacao personalizacao = new Personalizacao();
                        for (JsonNode valorDaPersonalizacaoJson : personalizacaoJson.get("garnishItens")) {
                            ValorDaPersonalizacao valorDaPersonalizacao = new ValorDaPersonalizacao();
                            valorDaPersonalizacao.setDescricao(valorDaPersonalizacaoJson.get("description").asText());
                            valorDaPersonalizacao.setExcluido(Boolean.valueOf(!valorDaPersonalizacaoJson.get("enabled").asBoolean()));
                            valorDaPersonalizacao.setValor(new BigDecimal(valorDaPersonalizacaoJson.get("unitPrice").asDouble()));
                            valorDaPersonalizacao.setEmFalta(Boolean.valueOf(false));
                            valoresDaPersonalizacao.add(valorDaPersonalizacao);
                        }
                        personalizacao.setCategoria(categoria);
                        personalizacao.setDescricao(personalizacaoJson.get("name").asText());
                        personalizacao.setExcluido(Boolean.valueOf(!personalizacaoJson.get("enabled").asBoolean()));
                        personalizacao.setMultiOpcional(Boolean.valueOf(personalizacaoJson.get("max").asInt() > 1));
                        personalizacao.setQuantidadePermitida(Integer.valueOf(personalizacaoJson.get("max").asInt()));
                        personalizacao.setSubProduto(Boolean.FALSE);
                        personalizacao.setSubProdutoFracionado(Boolean.FALSE);
                        personalizacao.setValoresDaPersonalizacao(valoresDaPersonalizacao);
                        this.personalizacaoService.save(personalizacao);
                    }
                }
                produto.setDisponibilidades(DiaDaSemana.listarTodosOsDiasDaSemana().stream().map(dia -> dia.ordinal() + "").collect(Collectors.joining(",")));
                this.repository.save((Object)produto);
                try {
                    String path = this.getProductsPath(companyId) + File.separator;
                    if (StringUtil.isNotBlank((String)StringUtil.obterExtensao((String)produtoJson.get("logoUrl").asText()))) {
                        produto.setCaminhoFoto(this.generateNewPictureName(produto) + StringUtil.obterExtensao((String)produtoJson.get("logoUrl").asText()));
                    }
                    try {
                        InputStream in = new URL("https://static-images.ifood.com.br/image/upload//pratos/" + produtoJson.get("logoUrl").asText()).openStream();
                        Files.copy(in, Paths.get(path + produto.getCaminhoFoto(), new String[0]), new CopyOption[0]);
                        this.fileService.saveThumbnailFile(path + produto.getCaminhoFoto(), produto.getFoto(), 640);
                        produto.setMiniatura(produto.getFotoExterna() != false ? produto.getCaminhoFoto() : this.fileService.getPictureUrl(produto, true));
                        this.repository.save((Object)produto);
                    }
                    catch (FileAlreadyExistsException e) {
                        System.err.println("Produto j\u00e1 tem foto");
                    }
                    catch (IOException e) {
                        if (e.getMessage().startsWith("Server returned HTTP response code: 403")) continue;
                        throw new ApiException("msg.erro.113");
                    }
                }
                catch (NullPointerException e) {
                    System.err.println("Produto sem foto");
                }
            }
        }
    }

    private String generateNewPictureName(Produto produto) {
        return DateUtil.format((String)"yyyyMMdd", (Date)new Date()) + "_" + produto.getId();
    }

    private Produto populateProduct(Produto product) {
        CategoriaDoProduto categoria = product.getCategoria();
        product.setEmpresa(new Empresa(product.getEmpresa().getId()));
        product.setCategoria(new CategoriaDoProduto(categoria.getId()));
        product.getCategoria().setDescricao(categoria.getDescricao());
        product.getCategoria().setQuantitativa(categoria.getQuantitativa());
        product.setDataHoraUltimaAtualizacao(null);
        product.setCodigoAtos(null);
        try {
            if (StringUtil.isNotBlank((String)product.getCaminhoFoto())) {
                if (!product.getFotoExterna().booleanValue()) {
                    product.setFoto(this.fileService.getPictureUrl(product, false));
                    product.setMiniatura(this.fileService.getPictureUrl(product, true));
                } else {
                    product.setFoto(product.getCaminhoFoto());
                    product.setMiniatura(product.getCaminhoFoto());
                }
            } else {
                product.setFoto(this.fileService.getPictureUrl(categoria.getEmblema()));
                product.setMiniatura(this.fileService.getPictureUrl(categoria.getEmblema()));
            }
        }
        catch (ApiException e) {
            LOGGER.warn(Message.getInstance().getMessage("msg.erro.091", new String[]{e.getMessage()}));
        }
        return product;
    }

    @Transactional
    private void updateSizeParameters(Produto product) {
        List products = this.repository.findByEmpresaIdAndCategoriaIdAndIdNot(product.getEmpresa().getId(), product.getCategoria().getId(), product.getId());
        products.forEach(item -> {
            item.setLabelTamanhoBroto(product.getLabelTamanhoBroto());
            item.setLimiteSelecaoTamanhoBroto(product.getLimiteSelecaoTamanhoBroto());
            item.setLabelTamanhoMedio(product.getLabelTamanhoMedio());
            item.setLimiteSelecaoTamanhoMedio(product.getLimiteSelecaoTamanhoMedio());
            item.setLabelTamanhoGrande(product.getLabelTamanhoGrande());
            item.setLimiteSelecaoTamanhoGrande(product.getLimiteSelecaoTamanhoGrande());
            item.setLabelTamanhoGigante(product.getLabelTamanhoGigante());
            item.setLimiteSelecaoTamanhoGigante(product.getLimiteSelecaoTamanhoGigante());
            this.repository.save(item);
        });
    }

    public Produto findCasterById(Long productId) throws ApiException {
        Produto caster = (Produto)this.repository.findById((Object)productId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Rod\u00edzio", productId.toString()}));
        if (!caster.getRodizio().booleanValue()) {
            throw new ApiException("msg.erro.157");
        }
        List products = Arrays.asList(caster.getProdutosDoRodizio().split(",")).stream().map(code -> (Produto)this.repository.findById((Object)new Long((String)code)).get()).collect(Collectors.toList());
        HashSet casterCatalog = new HashSet();
        products.stream().map(product -> product.getCategoria().getDescricao()).distinct().collect(Collectors.toSet()).forEach(category -> casterCatalog.add(new CatalogoDoRodizio(category, new ArrayList())));
        casterCatalog.forEach(catalog -> catalog.getProdutos().addAll(products.stream().filter(product -> product.getCategoria().getDescricao().equals(catalog.getCategoria())).collect(Collectors.toSet())));
        caster.setCatalogoDoRodizio(casterCatalog);
        this.loadProductPicture(caster);
        return caster;
    }

    public String generatePictureName(Produto produto) {
        Date currentDate = new Date();
        return DateUtil.format((String)"yyyyMMdd", (Date)currentDate) + "_" + currentDate.getTime() + StringUtil.obterExtensao((String)produto.getCaminhoFoto());
    }

    public String getProductsPath(Long empresaId) throws ApiException {
        return this.fileService.getCompanyPath(empresaId.toString(), "galeria".concat(File.separator).concat("produtos"), Boolean.valueOf(true));
    }

    public List<String> listUnavaliableProducts(List<Long> productIds) throws ApiException {
        ArrayList<String> options = new ArrayList<String>();
        for (Long productId : productIds) {
            Produto product = (Produto)this.repository.findById((Object)productId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto", productId.toString()}));
            if (product.getEstoqueIlimitado().booleanValue() || product.getEstoque().compareTo(BigDecimal.ZERO) > 0) continue;
            options.add(product.getNome());
        }
        return options;
    }

    private void loadProductPicture(Produto product) throws ApiException {
        if (StringUtil.isNotBlank((String)product.getCaminhoFoto())) {
            if (!product.getFotoExterna().booleanValue()) {
                product.setFoto(this.fileService.getPictureUrl(product, false));
                product.setMiniatura(this.fileService.getPictureUrl(product, true));
            } else {
                product.setFoto(product.getCaminhoFoto());
                product.setMiniatura(product.getCaminhoFoto());
            }
        }
    }
}

