/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import br.com.uol.pagseguro.api.common.domain.TransactionStatus;
import br.com.uol.pagseguro.api.transaction.search.TransactionDetail;
import com.escolpi.omni.api.domain.Domains;
import com.escolpi.omni.api.enumeration.ControleEstoque;
import com.escolpi.omni.api.enumeration.FormaDeEntrega;
import com.escolpi.omni.api.enumeration.FormaDePagamento;
import com.escolpi.omni.api.enumeration.FusoHorario;
import com.escolpi.omni.api.enumeration.LojaDeOrigem;
import com.escolpi.omni.api.enumeration.Origem;
import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.enumeration.StatusDaTransacao;
import com.escolpi.omni.api.enumeration.StatusDaTransacaoCielo;
import com.escolpi.omni.api.enumeration.TipoCupomDesconto;
import com.escolpi.omni.api.enumeration.TipoDeExtratoDeCashback;
import com.escolpi.omni.api.enumeration.TipoRegraCupom;
import com.escolpi.omni.api.enumeration.TipoToken;
import com.escolpi.omni.api.enumeration.ValorConfiguracaoBooleano;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Cashback;
import com.escolpi.omni.api.model.entity.CestaDePromocao;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.CupomDeDesconto;
import com.escolpi.omni.api.model.entity.CupomUtilizado;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.EmpresaConfiguracao;
import com.escolpi.omni.api.model.entity.EnderecoDeEntrega;
import com.escolpi.omni.api.model.entity.ExtratoDeCashback;
import com.escolpi.omni.api.model.entity.ItemDoPedido;
import com.escolpi.omni.api.model.entity.ItemDoPedidoPorPromocao;
import com.escolpi.omni.api.model.entity.Municipio;
import com.escolpi.omni.api.model.entity.MunicipioAtendido;
import com.escolpi.omni.api.model.entity.OpcaoDePagamentoComCartao;
import com.escolpi.omni.api.model.entity.OpcionalDoItemDoPedido;
import com.escolpi.omni.api.model.entity.Pagamento;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.entity.PedidoResumido;
import com.escolpi.omni.api.model.entity.Personalizacao;
import com.escolpi.omni.api.model.entity.PersonalizacaoDeProduto;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.entity.ProdutoComposto;
import com.escolpi.omni.api.model.entity.Promocao;
import com.escolpi.omni.api.model.entity.SolicitacaoDePagamento;
import com.escolpi.omni.api.model.entity.TarifaDeEntregaExclusiva;
import com.escolpi.omni.api.model.entity.TarifacaoDeEntrega;
import com.escolpi.omni.api.model.entity.Token;
import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.model.entity.ValorDaPersonalizacao;
import com.escolpi.omni.api.model.entity.dto.DashboardInfo;
import com.escolpi.omni.api.model.entity.dto.GrupoDePersonalizacoes;
import com.escolpi.omni.api.model.entity.dto.Top10Dto;
import com.escolpi.omni.api.model.projection.CategoriaDoProdutoView;
import com.escolpi.omni.api.model.projection.ClienteView;
import com.escolpi.omni.api.model.projection.CupomDeDescontoView;
import com.escolpi.omni.api.model.projection.EnderecoDeEntregaView;
import com.escolpi.omni.api.model.projection.IdView;
import com.escolpi.omni.api.model.projection.MunicipioView;
import com.escolpi.omni.api.model.projection.OpcaoDePagamentoComCartaoView;
import com.escolpi.omni.api.model.projection.PedidoView;
import com.escolpi.omni.api.model.projection.ProdutoCompostoView;
import com.escolpi.omni.api.model.projection.ProdutoView;
import com.escolpi.omni.api.model.projection.PromocaoView;
import com.escolpi.omni.api.model.projection.RegistroView;
import com.escolpi.omni.api.model.projection.UsuarioView;
import com.escolpi.omni.api.model.specification.builder.PedidoResumidoSpecificationBuilder;
import com.escolpi.omni.api.model.specification.builder.PedidoSpecificationBuilder;
import com.escolpi.omni.api.repository.BairroNaoAtendidoRepository;
import com.escolpi.omni.api.repository.CashbackRepository;
import com.escolpi.omni.api.repository.CestaDePromocaoRepository;
import com.escolpi.omni.api.repository.ClienteRepository;
import com.escolpi.omni.api.repository.CupomUtilizadoRepository;
import com.escolpi.omni.api.repository.EmpresaConfiguracaoRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.EnderecoDeEntregaRepository;
import com.escolpi.omni.api.repository.ExtratoDeCashbackRepository;
import com.escolpi.omni.api.repository.ItemDoPedidoPorPromocaoRepository;
import com.escolpi.omni.api.repository.ItemDoPedidoRepository;
import com.escolpi.omni.api.repository.MunicipioAtendidoRepository;
import com.escolpi.omni.api.repository.MunicipioRepository;
import com.escolpi.omni.api.repository.OpcaoDePagamentoComCartaoRepository;
import com.escolpi.omni.api.repository.OpcionalDoItemDoPedidoRepository;
import com.escolpi.omni.api.repository.PagamentoRepository;
import com.escolpi.omni.api.repository.PedidoRepository;
import com.escolpi.omni.api.repository.PedidoResumidoRepository;
import com.escolpi.omni.api.repository.PersonalizacaoDeProdutoRepository;
import com.escolpi.omni.api.repository.PersonalizacaoRepository;
import com.escolpi.omni.api.repository.ProdutoCompostoRepository;
import com.escolpi.omni.api.repository.ProdutoRepository;
import com.escolpi.omni.api.repository.PromocaoRepository;
import com.escolpi.omni.api.repository.SolicitacaoDePagamentoRepository;
import com.escolpi.omni.api.repository.TarifacaoDeEntregaRepository;
import com.escolpi.omni.api.repository.TokenRepository;
import com.escolpi.omni.api.repository.UsuarioRepository;
import com.escolpi.omni.api.repository.ValorDaPersonalizacaoRepository;
import com.escolpi.omni.api.service.CieloService;
import com.escolpi.omni.api.service.ControleDeEstoqueService;
import com.escolpi.omni.api.service.CupomDeDescontoService;
import com.escolpi.omni.api.service.FileService;
import com.escolpi.omni.api.service.MessengerService;
import com.escolpi.omni.api.service.PagSeguroService;
import com.escolpi.omni.api.service.PagamentoService;
import com.escolpi.omni.api.service.PushNotificationService;
import com.escolpi.omni.api.service.TarifaDeEntregaExclusivaService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.hibernate.Hibernate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PedidoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PedidoService.class);
    @Autowired
    private BairroNaoAtendidoRepository bairroNaoAtendidoRepository;
    @Autowired
    private CestaDePromocaoRepository basketRepository;
    @Autowired
    private CashbackRepository cashbackRepository;
    @Autowired
    private ExtratoDeCashbackRepository cashbackExtractRepository;
    @Autowired
    private ClienteRepository clienteRepository;
    @Autowired
    private MunicipioRepository cityRepository;
    @Autowired
    private MessengerService messengerService;
    @Autowired
    private MunicipioAtendidoRepository municipioAtendidoRepository;
    @Autowired
    private CieloService cieloService;
    @Autowired
    private CupomUtilizadoRepository cupomUtilizadoRepository;
    @Autowired
    private EmpresaRepository companyRepository;
    @Autowired
    private EmpresaConfiguracaoRepository companyConfigRepository;
    @Autowired
    private EnderecoDeEntregaRepository addressRepository;
    @Autowired
    private ControleDeEstoqueService stockManagementService;
    @Autowired
    private FileService fileService;
    @Autowired
    private TokenRepository fcmTokenRepository;
    @Autowired
    private ItemDoPedidoRepository orderItemRepository;
    @Autowired
    private OpcionalDoItemDoPedidoRepository optionalRepository;
    @Autowired
    private ItemDoPedidoPorPromocaoRepository orderItemByPromotionRepository;
    @Autowired
    private OpcaoDePagamentoComCartaoRepository paymentCardRepository;
    @Autowired
    private PagamentoRepository paymentRepository;
    @Autowired
    private PagamentoService paymentService;
    @Autowired
    private PedidoResumidoRepository shortOrderRepository;
    @Autowired
    private PedidoRepository repository;
    @Autowired
    private PersonalizacaoRepository customizationRepository;
    @Autowired
    private PersonalizacaoDeProdutoRepository customizationProductRepository;
    @Autowired
    private ProdutoRepository productRepository;
    @Autowired
    private ProdutoCompostoRepository composedProductRepository;
    @Autowired
    private PromocaoRepository promocaoRepository;
    @Autowired
    private PushNotificationService pushService;
    @Autowired
    private SolicitacaoDePagamentoRepository requestPaymentRepository;
    @Autowired
    private TarifacaoDeEntregaRepository tarifacaoRepository;
    @Autowired
    private ValorDaPersonalizacaoRepository customizationValueRepository;
    @Autowired
    private CupomDeDescontoService cupomDeDescontoService;
    @Autowired
    private PagSeguroService pagSeguroService;
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private TarifaDeEntregaExclusivaService exclusiveDeliveryFeeService;

    public BigDecimal calculateTotalOrderValue(Pedido order) {
        BigDecimal totalItems = BigDecimal.ZERO;
        BigDecimal totalOrder = BigDecimal.ZERO;
        if (NullUtil.isNotNull((Object)order.getTotalDoPedido()) && order.getTotalDoPedido().compareTo(BigDecimal.ZERO) == 1) {
            if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
                totalItems = totalItems.add(order.getItensDoPedido().stream().map(item -> item.getValor()).reduce(BigDecimal.ZERO, (total, valor) -> total.add((BigDecimal)valor)));
            }
            if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
                totalItems = totalItems.add(order.getCestasDePromocao().stream().map(cesta -> cesta.getValor()).reduce(BigDecimal.ZERO, (total, valor) -> total.add((BigDecimal)valor)));
            }
            order.setTotalItensPedido(totalItems);
            totalOrder = totalItems;
            BigDecimal discountValue = BigDecimal.ZERO;
            discountValue = this.calculateTotalOrderByDiscountTicket(order, totalOrder, discountValue);
            totalOrder = this.exemptDeliveryFeeWhenAllowed(order, totalOrder);
            if (NullUtil.isNotNullOrZero((BigDecimal)discountValue)) {
                totalOrder = totalOrder.subtract(discountValue);
            }
            if (NullUtil.isNotNull((Object)order.getFormaPagamento())) {
                BigDecimal discount;
                if (Boolean.TRUE.equals(order.getFormaPagamento().equals((Object)FormaDePagamento.DINHEIRO) && order.getEmpresa().getDescontoPagamentoEmDinheiro() != false) && NullUtil.isNotNullOrZero((BigDecimal)order.getValorDescontoPagamentoEmDinheiro())) {
                    totalOrder = totalOrder.subtract(order.getValorDescontoPagamentoEmDinheiro());
                }
                if (order.getFormaPagamento().equals((Object)FormaDePagamento.MAQUINA_MOVEL) && NullUtil.isNotNull((Object)order.getOpcaoPagamentoCartao()) && NullUtil.isNotNullOrZero((Number)order.getOpcaoPagamentoCartao().getDescontoAplicado())) {
                    discount = totalItems.multiply(new BigDecimal(order.getOpcaoPagamentoCartao().getDescontoAplicado())).divide(new BigDecimal(100));
                    totalOrder = totalOrder.subtract(discount);
                }
                if (order.getFormaPagamento().equals((Object)FormaDePagamento.OUTROS) && NullUtil.isNotNull((Object)order.getOpcaoPagamentoCartao()) && NullUtil.isNotNullOrZero((Number)order.getOpcaoPagamentoCartao().getDescontoAplicado())) {
                    discount = totalItems.multiply(new BigDecimal(order.getOpcaoPagamentoCartao().getDescontoAplicado())).divide(new BigDecimal(100));
                    totalOrder = totalOrder.subtract(discount);
                }
                if (order.getFormaPagamento().equals((Object)FormaDePagamento.PAGAMENTO_ONLINE) && NullUtil.isNotNullOrZero((Number)order.getParcelas()) && NullUtil.isNotNullOrZero((BigDecimal)order.getValorDaParcela())) {
                    totalOrder = order.getValorDaParcela().multiply(new BigDecimal(order.getParcelas()));
                }
            }
            if (NullUtil.isNotNullOrZero((BigDecimal)order.getDebitoCashback())) {
                totalOrder = totalOrder.subtract(order.getDebitoCashback());
            }
        }
        return totalOrder;
    }

    public BigDecimal calculateTotalOrderValueWithoutDiscount(Pedido order) {
        BigDecimal totalItems = BigDecimal.ZERO;
        BigDecimal totalOrder = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
            totalItems = totalItems.add(order.getItensDoPedido().stream().map(item -> item.getValor()).reduce(BigDecimal.ZERO, (total, valor) -> total.add((BigDecimal)valor)));
        }
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            totalItems = totalItems.add(order.getCestasDePromocao().stream().map(cesta -> cesta.getValor()).reduce(BigDecimal.ZERO, (total, valor) -> total.add((BigDecimal)valor)));
        }
        order.setTotalItensPedido(totalItems);
        totalOrder = totalItems;
        totalOrder = this.exemptDeliveryFeeWhenAllowed(order, totalOrder);
        if (NullUtil.isNotNull((Object)order.getFormaPagamento()) && order.getFormaPagamento().equals((Object)FormaDePagamento.DINHEIRO) && NullUtil.isNotNull((Object)order.getEmpresa().getDescontoPagamentoEmDinheiro()) && order.getEmpresa().getDescontoPagamentoEmDinheiro().booleanValue() && NullUtil.isNotNullOrZero((BigDecimal)order.getValorDescontoPagamentoEmDinheiro())) {
            totalOrder = totalOrder.subtract(order.getValorDescontoPagamentoEmDinheiro());
        }
        return totalOrder;
    }

    public BigDecimal calculateTotalOrderByDiscountTicket(Pedido order, BigDecimal totalItems, BigDecimal discountValue) {
        if (NullUtil.isNotNull((Object)order.getCupomDeDesconto())) {
            if (order.getCupomDeDesconto().getTipoDesconto().equals((Object)TipoCupomDesconto.PERCENTUAL) && order.getCupomDeDesconto().getValorDesconto().intValue() <= 100) {
                discountValue = totalItems.multiply(BigDecimal.valueOf(order.getCupomDeDesconto().getValorDesconto() / 100.0));
            }
            if (order.getCupomDeDesconto().getTipoDesconto().equals((Object)TipoCupomDesconto.VALOR_FIXO) && (double)order.getCupomDeDesconto().getValorDesconto().longValue() <= totalItems.doubleValue()) {
                discountValue = BigDecimal.valueOf(order.getCupomDeDesconto().getValorDesconto());
            }
        }
        return discountValue;
    }

    @Transactional
    public void cancelCustomerCashback(Pedido order) throws ApiException {
        ExtratoDeCashback currentExtract = this.cashbackExtractRepository.findTopByPedidoIdOrderByIdDesc(order.getId()).orElse(null);
        if (order.getSituacao().equals((Object)SituacaoDoPedido.CANCELADO) || order.getSituacao().equals((Object)SituacaoDoPedido.CANCELADO_PELO_CLIENTE) || NullUtil.isNotNull((Object)currentExtract) && currentExtract.getTipoDeLancamento().equals((Object)TipoDeExtratoDeCashback.APROVISIONAMENTO)) {
            this.cashbackExtractRepository.delete((Object)currentExtract);
            Cashback cashback = this.cashbackRepository.findCurrentCashback(order.getEmpresa().getId(), order.getCliente().getId()).orElse(null);
            cashback.setCreditoReservado(BigDecimal.ZERO);
            this.cashbackRepository.save((Object)cashback);
        }
    }

    @Transactional
    public void cancelOrder(Long orderId, Long userId) throws ApiException, IOException, InterruptedException {
        ExtratoDeCashback extract;
        Pedido order = (Pedido)this.repository.findById((Object)orderId).orElseThrow(() -> new ApiException("msg.aviso.001"));
        Usuario user = this.usuarioRepository.findById((Object)userId).orElse(null);
        if (NullUtil.isNotNull((Object)user) && user.getPerfil().getId().equals(Domains.PROFILE_CUSTOMER_ID) && !order.getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_CONFIRMACAO) && !order.getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_PAGAMENTO)) {
            throw new ApiException("msg.aviso.001");
        }
        if (order.getRodizio().equals(Boolean.TRUE)) {
            order.setRodizioFechado(Boolean.valueOf(true));
        }
        if (NullUtil.isNotNull((Object)user)) {
            order.setUsuarioCancelamento(user);
        }
        order.setDataHoraCancelamento(new Date());
        order.setSituacao(user.getPerfil().getId().equals(Domains.PROFILE_CUSTOMER_ID) ? SituacaoDoPedido.CANCELADO_PELO_CLIENTE : SituacaoDoPedido.CANCELADO);
        this.repository.save((Object)order);
        ControleEstoque stockControl = (ControleEstoque)this.companyRepository.getCompanyStockControl(order.getEmpresa().getId()).get();
        if (!stockControl.equals((Object)ControleEstoque.SEM_CONTROLE)) {
            if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
                EmpresaConfiguracao config = (EmpresaConfiguracao)this.companyConfigRepository.findByEmpresaIdAndConfiguracaoNome(order.getEmpresa().getId(), "config-estoque-personalizacoes").get();
                if (config.getValor().equals(ValorConfiguracaoBooleano.TRUE.getValor())) {
                    for (ItemDoPedido item : order.getItensDoPedido()) {
                        this.stockManagementService.sumCustomizationValueFromStock(item.getValoresDasPersonalizacoes(), item.getQuantidade());
                    }
                } else {
                    for (ItemDoPedido item : order.getItensDoPedido()) {
                        this.stockManagementService.sumProductToStock(item.getProduto(), item.getQuantidade());
                    }
                }
            }
            if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
                for (CestaDePromocao basket : order.getCestasDePromocao()) {
                    for (ItemDoPedidoPorPromocao item : basket.getItens()) {
                        this.stockManagementService.sumProductToStock(item.getProduto(), Double.valueOf(item.getQuantidade().doubleValue()));
                    }
                }
            }
        }
        if (NullUtil.isNotNull((Object)(extract = (ExtratoDeCashback)this.cashbackExtractRepository.findTopByPedidoIdOrderByIdDesc(orderId).orElse(null)))) {
            if (NullUtil.isNotNullOrZero((BigDecimal)extract.getPedido().getDebitoCashback())) {
                this.exonerateCashback(extract);
            } else {
                this.cancelCustomerCashback(order);
            }
        }
        this.messengerService.sendOrderMessage(order);
    }

    @Transactional
    public void cancelGuestOrder(Long orderId, boolean byCustomer) throws ApiException {
        Pedido order = (Pedido)this.repository.findById((Object)orderId).orElseThrow(() -> new ApiException("msg.aviso.001"));
        if (order.getRodizio().equals(Boolean.TRUE)) {
            order.setRodizioFechado(Boolean.valueOf(true));
        }
        order.setDataHoraCancelamento(new Date());
        order.setSituacao(byCustomer ? SituacaoDoPedido.CANCELADO_PELO_CLIENTE : SituacaoDoPedido.CANCELADO);
        this.repository.save((Object)order);
        ControleEstoque stockControl = (ControleEstoque)this.companyRepository.getCompanyStockControl(order.getEmpresa().getId()).get();
        if (!stockControl.equals((Object)ControleEstoque.SEM_CONTROLE)) {
            if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
                EmpresaConfiguracao config = (EmpresaConfiguracao)this.companyConfigRepository.findByEmpresaIdAndConfiguracaoNome(order.getEmpresa().getId(), "config-estoque-personalizacoes").get();
                if (config.getValor().equals(ValorConfiguracaoBooleano.TRUE.getValor())) {
                    for (ItemDoPedido item : order.getItensDoPedido()) {
                        this.stockManagementService.sumCustomizationValueFromStock(item.getValoresDasPersonalizacoes(), item.getQuantidade());
                    }
                } else {
                    for (ItemDoPedido item : order.getItensDoPedido()) {
                        this.stockManagementService.sumProductToStock(item.getProduto(), item.getQuantidade());
                    }
                }
            }
            if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
                for (CestaDePromocao basket : order.getCestasDePromocao()) {
                    for (ItemDoPedidoPorPromocao item : basket.getItens()) {
                        this.stockManagementService.sumProductToStock(item.getProduto(), Double.valueOf(item.getQuantidade().doubleValue()));
                    }
                }
            }
        }
    }

    @Transactional
    private void exonerateCashback(ExtratoDeCashback extract) {
        Cashback cashback = this.cashbackRepository.findById((Object)extract.getCashback().getId()).orElse(null);
        if (NullUtil.isNotNull((Object)cashback)) {
            ExtratoDeCashback exonerateExtract = new ExtratoDeCashback(cashback);
            exonerateExtract.setDescricao("Cashback estornado pelo cancelamento de pedido.");
            exonerateExtract.setTipoDeLancamento(TipoDeExtratoDeCashback.ESTORNO);
            exonerateExtract.setDataHoraDoLancamento(new Date());
            if (NullUtil.isNotNull((Object)extract.getPedido())) {
                exonerateExtract.setPedido(extract.getPedido());
            }
            if (NullUtil.isNotNullOrZero((BigDecimal)cashback.getCreditoReservado())) {
                exonerateExtract.setValor(new BigDecimal(extract.getValor().doubleValue() * -1.0));
                cashback.setCreditoReservado(BigDecimal.ZERO);
            }
            if (NullUtil.isNotNullOrZero((BigDecimal)cashback.getCreditoUtilizado())) {
                exonerateExtract.setValor(new BigDecimal(extract.getValor().doubleValue() * -1.0));
                cashback.setCreditoDisponivel(cashback.getCreditoDisponivel().add(cashback.getCreditoUtilizado()));
                cashback.setCreditoUtilizado(BigDecimal.ZERO);
            }
            this.cashbackRepository.save((Object)cashback);
            this.cashbackExtractRepository.save((Object)exonerateExtract);
        }
    }

    @Transactional
    public void cancelOrderItem(Long orderItemId) throws ApiException {
        ItemDoPedido orderItem = (ItemDoPedido)this.orderItemRepository.findById((Object)orderItemId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Item do Pedido", orderItemId.toString()}));
        Pedido order = (Pedido)this.repository.findById((Object)orderItem.getPedido().getId()).get();
        order.setTotalDoPedido(order.getTotalDoPedido().subtract(orderItem.getValor()));
        this.orderItemRepository.delete((Object)orderItem);
        this.repository.save((Object)order);
    }

    @Transactional
    public void creditCustomerCashback(Pedido order) throws ApiException {
        ExtratoDeCashback currentExtract = this.cashbackExtractRepository.findTopByPedidoIdOrderByIdDesc(order.getId()).orElse(null);
        if (NullUtil.isNotNull((Object)currentExtract) && currentExtract.getTipoDeLancamento().equals((Object)TipoDeExtratoDeCashback.CREDITO)) {
            return;
        }
        Cashback cashback = this.cashbackRepository.findCurrentCashback(order.getEmpresa().getId(), order.getCliente().getId()).orElse(null);
        if (NullUtil.isNotNull((Object)cashback) && cashback.getAtivo().booleanValue() && NullUtil.isNotNullOrZero((BigDecimal)order.getCreditoCashback())) {
            cashback.setCreditoDisponivel(cashback.getCreditoDisponivel().add(order.getCreditoCashback()));
            cashback.setCreditoReservado(cashback.getCreditoReservado().compareTo(order.getCreditoCashback()) > 1 ? cashback.getCreditoReservado().subtract(order.getCreditoCashback()) : BigDecimal.ZERO);
            this.cashbackRepository.save((Object)cashback);
            ExtratoDeCashback extract = new ExtratoDeCashback(cashback);
            extract.setPedido(order);
            extract.setDataHoraDoLancamento(new Date());
            extract.setTipoDeLancamento(TipoDeExtratoDeCashback.CREDITO);
            extract.setDescricao("Cashback recebido");
            extract.setValor(order.getCreditoCashback());
            this.cashbackExtractRepository.save((Object)extract);
        }
    }

    public Page<Pedido> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage, boolean isHistory) {
        searchCriteria = searchCriteria.concat("@@").concat("lojaDeOrigem:0");
        PedidoSpecificationBuilder builder = new PedidoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(Arrays.asList("dataAtualizacaoPedido"), (String)"desc");
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page results = this.repository.findAll(spec, (Pageable)pageable);
        if (isHistory) {
            return results.map(arg_0 -> this.populateOrderHistory(arg_0));
        }
        if (results.hasContent()) {
            results.forEach(pedido -> {
                if (NullUtil.isNotNullOrZero((BigDecimal)pedido.getTotalDoPedido())) {
                    pedido.setTotalDoPedido(this.calculateTotalOrderValue(pedido));
                }
                if (NullUtil.isNull((Object)pedido.getEnderecoEntrega())) {
                    EnderecoDeEntrega endereco = this.addressRepository.findEnderecoPrincipal(pedido.getCliente().getId()).orElse(null);
                    endereco.setCliente(null);
                    pedido.setEnderecoEntrega(endereco);
                }
            });
        }
        return results;
    }

    public Page<Pedido> filterFeedbacks(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        PedidoSpecificationBuilder builder = new PedidoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(Arrays.asList("dataAtualizacaoPedido"), (String)"desc");
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page results = this.repository.findAll(spec, (Pageable)pageable).map(arg_0 -> this.populateFeedback(arg_0));
        return results;
    }

    @Transactional
    public void finalizeOrder(Pedido order) throws ApiException {
        Pedido edit = this.findById(order.getId());
        edit.setSituacao(SituacaoDoPedido.FINALIZADO);
        this.repository.save((Object)edit);
        if (this.hasCashback(edit)) {
            this.creditCustomerCashback(edit);
        }
    }

    public List<Pedido> findByDataPedidoAndEmpresaId(Long empresaId) {
        return this.repository.findByDataPedidoAndEmpresaId(empresaId, DateUtil.obterDiferencaEmDias((LocalDate)LocalDate.now(), (int)8), DateUtil.obterDiferencaEmDias((LocalDate)LocalDate.now(), (int)1));
    }

    public Pedido findById(Long id) throws ApiException {
        return (Pedido)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Pedido", id.toString()}));
    }

    public Pedido findByIdExterno(String externalId) {
        return this.repository.findByIdExterno(externalId);
    }

    public List<String> findDistinctMonths(Long empresaId) {
        return this.repository.findDistinctMonths(empresaId);
    }

    public DashboardInfo findDashboardInfo(Long companyId, Integer month, Integer year) {
        Date initialDate = DateUtil.adicionaDias((Date)DateUtil.primeiroDiaDoMesAno((Integer)month, (Integer)year), (Integer)-1);
        Date finalDate = DateUtil.maxDateTime((Date)DateUtil.ultimoDiaDoMesAno((Integer)month, (Integer)year));
        DashboardInfo info = new DashboardInfo();
        this.repository.findOrdersValueByDate(companyId, initialDate, finalDate, LojaDeOrigem.PEDIDO_AGORA).forEach(total -> {
            info.setValorPedidos(total.getValor());
            info.setQuantidadePedidos(total.getQuantidade());
        });
        this.repository.findOrdersValueByDateAndDeliveryWay(companyId, initialDate, finalDate, FormaDeEntrega.DELIVERY).forEach(total -> {
            info.setValorDelivery(total.getValor());
            info.setQuantidadeDelivery(total.getQuantidade());
        });
        this.repository.findOrdersValueByDateAndDeliveryWay(companyId, initialDate, finalDate, FormaDeEntrega.RETIRAR_NO_LOCAL).forEach(total -> {
            info.setValorRetirada(total.getValor());
            info.setQuantidadeRetirada(total.getQuantidade());
        });
        this.repository.findOrdersValueByDateAndStatus(companyId, initialDate, finalDate, Arrays.asList(SituacaoDoPedido.CANCELADO, SituacaoDoPedido.CANCELADO_PELO_CLIENTE)).forEach(total -> {
            info.setValorCancelados(total.getValor());
            info.setQuantidadeCancelados(total.getQuantidade());
        });
        ArrayList pedidosPorDia = new ArrayList();
        this.repository.findOrdersByDayInMonth(companyId, initialDate, finalDate).forEach(order -> pedidosPorDia.add(order));
        info.setPedidos(pedidosPorDia);
        info.setQuantidadeClientes(this.clienteRepository.countByEmpresaId(companyId));
        info.setQuantidadeClientesMes(this.clienteRepository.countByEmpresaIdAndDate(companyId, initialDate, finalDate).orElse(0L));
        return info;
    }

    public List<Top10Dto> findTop10Categories(Long companyId, Integer month, Integer year) {
        Date initialDate = DateUtil.adicionaDias((Date)DateUtil.primeiroDiaDoMesAno((Integer)month, (Integer)year), (Integer)-1);
        Date finalDate = DateUtil.maxDateTime((Date)DateUtil.ultimoDiaDoMesAno((Integer)month, (Integer)year));
        ArrayList<Top10Dto> top10Categories = new ArrayList<Top10Dto>();
        this.repository.findTop10Categories(companyId, initialDate, finalDate).forEach(customer -> {
            Object[] obj = (Object[])customer;
            top10Categories.add(new Top10Dto((String)obj[0], (BigDecimal)obj[1]));
        });
        this.repository.findTop10CategoriesByComposition(companyId, initialDate, finalDate).forEach(customer -> {
            Object[] obj = (Object[])customer;
            top10Categories.add(new Top10Dto((String)obj[0], (BigDecimal)obj[1]));
        });
        return top10Categories;
    }

    public List<Top10Dto> findTop10Customers(Long companyId, Integer month, Integer year) {
        Date initialDate = DateUtil.adicionaDias((Date)DateUtil.primeiroDiaDoMesAno((Integer)month, (Integer)year), (Integer)-1);
        Date finalDate = DateUtil.maxDateTime((Date)DateUtil.ultimoDiaDoMesAno((Integer)month, (Integer)year));
        ArrayList<Top10Dto> top10Customers = new ArrayList<Top10Dto>();
        this.repository.findTop10Customers(companyId, initialDate, finalDate).forEach(data -> {
            Object[] entry = (Object[])data;
            top10Customers.add(new Top10Dto((String)entry[0], (BigInteger)entry[1], (BigDecimal)entry[2]));
        });
        return top10Customers;
    }

    public List<Top10Dto> findTop10Neighborhoods(Long companyId, Integer month, Integer year) {
        Date initialDate = DateUtil.adicionaDias((Date)DateUtil.primeiroDiaDoMesAno((Integer)month, (Integer)year), (Integer)-1);
        Date finalDate = DateUtil.maxDateTime((Date)DateUtil.ultimoDiaDoMesAno((Integer)month, (Integer)year));
        ArrayList<Top10Dto> top10Neighborhoods = new ArrayList<Top10Dto>();
        this.repository.findTop10Neighborhoods(companyId, initialDate, finalDate).forEach(neighborhood -> {
            Object[] obj = (Object[])neighborhood;
            Top10Dto top = new Top10Dto();
            top.setNome((String)obj[0]);
            top.setQuantidade((BigInteger)obj[1]);
            top.setSoma((BigDecimal)obj[2]);
            top10Neighborhoods.add(top);
        });
        return top10Neighborhoods;
    }

    public List<Top10Dto> findTop10Products(Long companyId, Integer month, Integer year) {
        Date initialDate = DateUtil.adicionaDias((Date)DateUtil.primeiroDiaDoMesAno((Integer)month, (Integer)year), (Integer)-1);
        Date finalDate = DateUtil.maxDateTime((Date)DateUtil.ultimoDiaDoMesAno((Integer)month, (Integer)year));
        ArrayList<Top10Dto> top10Products = new ArrayList<Top10Dto>();
        this.repository.findTop10Products(companyId, initialDate, finalDate).forEach(product -> {
            Object[] obj = (Object[])product;
            Top10Dto top = new Top10Dto();
            top.setNome((String)obj[0]);
            top.setQuantidade((BigInteger)obj[1]);
            top.setSoma((BigDecimal)obj[2]);
            top10Products.add(top);
        });
        return top10Products;
    }

    public Pedido get(Long empresaId, Long pedidoId) throws ApiException {
        Pedido order = (Pedido)this.repository.findById((Object)pedidoId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Pedido", pedidoId.toString()}));
        if (!order.getSituacao().equals((Object)SituacaoDoPedido.CANCELADO) && NullUtil.isNotNull((Object)order.getFormaPagamento()) && order.getFormaPagamento().equals((Object)FormaDePagamento.PAGAMENTO_ONLINE)) {
            Pagamento pagamento = (Pagamento)this.paymentRepository.findByPedidoId(pedidoId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Pagamento", "{Pedido " + pedidoId.toString() + "}"}));
            order.setCartaoDoCliente(pagamento.getCartaoDoCliente());
        }
        if (!order.getEmpresa().getId().equals(empresaId)) {
            throw new ApiException("erro.pedido.nao.vinculado", new String[]{order.getId().toString(), order.getEmpresa().getNomeFantasia()});
        }
        if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
            order.getItensDoPedido().stream().filter(item -> NullUtil.isNotNull((Object)item.getProdutoComposto())).forEach(item -> this.loadProductsFromComposition(item.getProdutoComposto()));
            this.groupOrderItems(order);
        }
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            order.getCestasDePromocao().forEach(basket -> basket.getItens().stream().filter(item -> NullUtil.isNotNull((Object)item.getProdutoComposto())).forEach(item -> this.loadProductsFromComposition(item.getProdutoComposto())));
            this.groupOrderItemsByPromotion(order);
        }
        if (order.getSituacao().equals((Object)SituacaoDoPedido.CANCELADO)) {
            if (NullUtil.isNotNull((Object)order.getUsuarioCancelamento())) {
                if (order.getUsuarioCancelamento().getPerfil().getId().equals(Domains.PROFILE_CUSTOMER_ID)) {
                    Cliente customer = (Cliente)this.clienteRepository.findByUsuarioId(order.getUsuarioCancelamento().getId()).get();
                    order.setNomeUsuarioCancelamento(String.format("Cliente %s", customer.getNome()));
                } else {
                    order.setNomeUsuarioCancelamento(String.format("%s (%s)", order.getEmpresa().getNomeFantasia(), order.getUsuarioCancelamento().getLogin()));
                }
            } else {
                order.setNomeUsuarioCancelamento("N\u00e3o Especificado");
            }
        }
        return order;
    }

    public List<Personalizacao> getCustomizations(Long empresaId, Long categoriaId) throws ApiException {
        List customizations = this.customizationRepository.findByCategoriaIdAndExcluidoIsFalseOrderByProximaPersonalizacaoIdAscIdAsc(categoriaId, empresaId);
        customizations.forEach(customization -> {
            customization.setValoresDaPersonalizacao(customization.getValoresDaPersonalizacao().stream().filter(vp -> vp.getExcluido() == false && vp.getEmFalta() == false).collect(Collectors.toSet()));
            if (customization.getSubProduto().booleanValue()) {
                Set<ValorDaPersonalizacao> valoresDisponiveis = customization.getValoresDaPersonalizacao().stream().filter(vp -> vp.getProduto().getDisponibilidades().indexOf(DateUtil.obterDiaDaSemanaCorrente().ordinal() + "") >= 0).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(valoresDisponiveis)) {
                    valoresDisponiveis.forEach(vp -> {
                        try {
                            if (NullUtil.isNotNull((Object)vp.getProduto().getCaminhoFoto()) && vp.getProduto().getFotoExterna().booleanValue()) {
                                vp.getProduto().setMiniatura(this.fileService.getPictureUrl(vp.getProduto(), true));
                            } else {
                                vp.getProduto().setMiniatura(vp.getProduto().getFotoExterna() != false ? vp.getProduto().getCaminhoFoto() : this.fileService.getPictureUrl(vp.getProduto().getCategoria().getEmblema()));
                            }
                        }
                        catch (ApiException e) {
                            LOGGER.error(e.getMessage());
                        }
                    });
                    customization.setValoresDaPersonalizacao(valoresDisponiveis);
                } else {
                    customization.setValoresDaPersonalizacao(null);
                }
            }
        });
        return customizations;
    }

    public List<ValorDaPersonalizacao> getCustomizationValues(Long customizationId) {
        return this.customizationValueRepository.findByPersonalizacaoIdAndExcluidoIsFalseOrderByDescricaoAsc(customizationId);
    }

    public TarifacaoDeEntrega getDeliveryFee(Long empresaId, Long id) throws ApiException {
        return (TarifacaoDeEntrega)this.tarifacaoRepository.findByIdAndEmpresaId(id, empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Tarifa\u00e7\u00e3o de Entrega", id.toString()}));
    }

    public TarifacaoDeEntrega getDeliveryFeeByCityAndNeighborhood(Long empresaId, Long municipioId, String bairro, String cep) throws ApiException {
        TarifaDeEntregaExclusiva exclusiveDeliveryFee;
        bairro = StringUtil.removeAllSpaces((String)bairro.trim());
        Empresa company = (Empresa)this.companyRepository.findById((Object)empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", empresaId.toString()}));
        if (NullUtil.isNullOrZero((BigDecimal)company.getValorTarifaUnica())) {
            company.setValorTarifaUnica(BigDecimal.ZERO);
        }
        List<Object> deliveryFees = new ArrayList();
        TarifacaoDeEntrega deliveryFee = null;
        if (company.getMunicipio().getId().equals(municipioId)) {
            if (this.bairroNaoAtendidoRepository.countByEmpresaAndBairroAndMunicipio(empresaId, municipioId, bairro) > 0L) {
                throw new ApiException("msg.erro.107");
            }
            deliveryFees = this.tarifacaoRepository.findTarifacaoPorMunicipioEBairro(empresaId, municipioId, bairro).stream().collect(Collectors.toList());
            for (TarifacaoDeEntrega tarifacaoDeEntrega : deliveryFees) {
                if (!StringUtil.removerAcentos((String)bairro.toLowerCase()).equals(StringUtil.removerAcentos((String)tarifacaoDeEntrega.getBairro().toLowerCase()))) continue;
                deliveryFee = tarifacaoDeEntrega;
                break;
            }
            if (NullUtil.isNull(deliveryFee)) {
                deliveryFee = new TarifacaoDeEntrega();
                deliveryFee.setMunicipio(company.getMunicipio());
                deliveryFee.setValor(NullUtil.isNotNullOrZero((BigDecimal)company.getValorTarifaUnica()) ? company.getValorTarifaUnica() : BigDecimal.ZERO);
            }
        } else {
            MunicipioAtendido servedCity = this.municipioAtendidoRepository.findByEmpresaIdAndMunicipioIdAndAtivoIsTrue(company.getId(), municipioId);
            if (NullUtil.isNull((Object)servedCity)) {
                throw new ApiException("msg.erro.085");
            }
            deliveryFees = this.tarifacaoRepository.findTarifacaoPorMunicipioEBairro(empresaId, municipioId, bairro).stream().collect(Collectors.toList());
            for (TarifacaoDeEntrega tarifacaoDeEntrega : deliveryFees) {
                if (!bairro.toLowerCase().equals(tarifacaoDeEntrega.getBairro().toLowerCase())) continue;
                deliveryFee = tarifacaoDeEntrega;
                break;
            }
            if (NullUtil.isNull(deliveryFee)) {
                deliveryFee = new TarifacaoDeEntrega();
                deliveryFee.setMunicipio(servedCity.getMunicipio());
                if (NullUtil.isNotNullOrZero((BigDecimal)servedCity.getTaxaDeEntrega())) {
                    deliveryFee.setValor(servedCity.getTaxaDeEntrega());
                } else {
                    deliveryFee.setValor(company.getValorTarifaUnica());
                }
            }
        }
        if (StringUtils.hasText((String)cep) && NullUtil.isNotNull((Object)(exclusiveDeliveryFee = this.exclusiveDeliveryFeeService.findActiveExclusiveFee(empresaId, cep, municipioId)))) {
            deliveryFee.setValor(exclusiveDeliveryFee.getValor());
        }
        return deliveryFee;
    }

    public List<Pedido> getMonitoredOrders(Long empresaId) throws ApiException {
        List pedidos = this.repository.findByEmpresaIdOrderByIdAsc(empresaId);
        ArrayList<Pedido> pedidosMonitorados = new ArrayList<Pedido>();
        Empresa empresa = (Empresa)this.companyRepository.findById((Object)empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", empresaId.toString()}));
        Calendar cal = Calendar.getInstance();
        cal.add(11, -24);
        cal.add(11, empresa.getFusoHorario().getDiferencaHoras());
        Date data = new Date();
        data.setTime(new Long(cal.getTimeInMillis()));
        pedidos.forEach(pedido -> {
            if (pedido.getDataHoraPedido().before(data) && !pedido.getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_CONFIRMACAO) && !pedido.getSituacao().equals((Object)SituacaoDoPedido.CANCELADO) && !pedido.getSituacao().equals((Object)SituacaoDoPedido.FINALIZADO)) {
                pedidosMonitorados.add((Pedido)pedido);
            }
        });
        return pedidosMonitorados;
    }

    private void groupBasketOrderItemByCustomization(ItemDoPedidoPorPromocao item) {
        Set<Personalizacao> customizations = item.getValoresDasPersonalizacoes().stream().filter(value -> value.getPersonalizacao() != null).map(value -> value.getPersonalizacao()).collect(Collectors.toMap(Personalizacao::getDescricao, c -> c, (c, c2) -> c)).values().stream().collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(customizations)) {
            customizations.forEach(customization -> item.getGrupoPersonalizacoes().add(new GrupoDePersonalizacoes(customization, item.getValoresDasPersonalizacoes().stream().filter(value -> NullUtil.isNotNull((Object)value.getPersonalizacao()) && value.getPersonalizacao().getId().equals(customization.getId())).sorted(Comparator.comparing(ValorDaPersonalizacao::getDescricao)).collect(Collectors.toList()), null)));
        }
    }

    private void groupBasketOrderItemByCustomizationProduct(ItemDoPedidoPorPromocao item) {
        Set<PersonalizacaoDeProduto> productCustomizations = item.getValoresDasPersonalizacoes().stream().filter(value -> value.getPersonalizacaoDeProduto() != null).map(optional -> optional.getPersonalizacaoDeProduto()).collect(Collectors.toMap(PersonalizacaoDeProduto::getDescricao, c -> c, (c, c2) -> c)).values().stream().collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(productCustomizations)) {
            productCustomizations.forEach(customization -> item.getGrupoPersonalizacoesDeProduto().add(new GrupoDePersonalizacoes(customization, item.getValoresDasPersonalizacoes().stream().filter(value -> NullUtil.isNotNull((Object)value.getPersonalizacaoDeProduto()) && value.getPersonalizacaoDeProduto().getId().equals(customization.getId())).sorted(Comparator.comparing(ValorDaPersonalizacao::getDescricao)).collect(Collectors.toList()), null)));
        }
    }

    private void groupOrderItemByCustomization(ItemDoPedido item) {
        Set<Personalizacao> customizations;
        if (!CollectionUtils.isEmpty((Collection)item.getOpcionais()) && !CollectionUtils.isEmpty(customizations = item.getOpcionais().stream().filter(optional -> optional.getValorDaPersonalizacao().getPersonalizacao() != null).map(optional -> this.customizationRepository.findById((Object)optional.getValorDaPersonalizacao().getPersonalizacao().getId())).map(Optional::get).collect(Collectors.toMap(Personalizacao::getDescricao, c -> c, (c, c2) -> c)).values().stream().collect(Collectors.toSet()))) {
            customizations.forEach(customization -> item.getGrupoPersonalizacoes().add(new GrupoDePersonalizacoes(customization, item.getValoresDasPersonalizacoes().stream().filter(value -> NullUtil.isNotNull((Object)value.getPersonalizacao()) && value.getPersonalizacao().getId().equals(customization.getId())).sorted(Comparator.comparing(ValorDaPersonalizacao::getDescricao)).collect(Collectors.toList()), item.getOpcionais().stream().filter(optional -> NullUtil.isNotNull((Object)optional.getValorDaPersonalizacao().getPersonalizacao()) && optional.getValorDaPersonalizacao().getPersonalizacao().getId().equals(customization.getId())).sorted(Comparator.comparing(OpcionalDoItemDoPedido::getDescricao)).collect(Collectors.toList()))));
        }
    }

    private void groupOrderItemByCustomizationProduct(ItemDoPedido item) {
        Set<PersonalizacaoDeProduto> productCustomizations;
        if (!CollectionUtils.isEmpty((Collection)item.getOpcionais()) && !CollectionUtils.isEmpty(productCustomizations = item.getOpcionais().stream().filter(optional -> optional.getValorDaPersonalizacao().getPersonalizacaoDeProduto() != null).map(optional -> this.customizationProductRepository.findById((Object)optional.getValorDaPersonalizacao().getPersonalizacaoDeProduto().getId())).map(Optional::get).collect(Collectors.toMap(PersonalizacaoDeProduto::getDescricao, c -> c, (c, c2) -> c)).values().stream().collect(Collectors.toSet()))) {
            productCustomizations.forEach(customization -> item.getGrupoPersonalizacoesDeProduto().add(new GrupoDePersonalizacoes(customization, item.getValoresDasPersonalizacoes().stream().filter(value -> NullUtil.isNotNull((Object)value.getPersonalizacaoDeProduto()) && value.getPersonalizacaoDeProduto().getId().equals(customization.getId())).sorted(Comparator.comparing(ValorDaPersonalizacao::getDescricao)).collect(Collectors.toList()), item.getOpcionais().stream().filter(optional -> NullUtil.isNotNull((Object)optional.getValorDaPersonalizacao().getPersonalizacaoDeProduto()) && optional.getValorDaPersonalizacao().getPersonalizacaoDeProduto().getId().equals(customization.getId())).sorted(Comparator.comparing(OpcionalDoItemDoPedido::getDescricao)).collect(Collectors.toList()))));
        }
    }

    public void groupOrderItems(Pedido order) {
        if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
            order.getItensDoPedido().forEach(item -> {
                item.setGrupoPersonalizacoes(new ArrayList());
                item.setGrupoPersonalizacoesDeProduto(new ArrayList());
                if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                    this.loadProductsFromComposition(item.getProdutoComposto());
                }
                this.groupOrderItemByCustomizationProduct(item);
                this.groupOrderItemByCustomization(item);
            });
        }
    }

    public void groupOrderItemsByPromotion(Pedido order) {
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            order.getCestasDePromocao().forEach(basket -> {
                if (!CollectionUtils.isEmpty((Collection)basket.getItens())) {
                    basket.getItens().forEach(item -> {
                        item.setGrupoPersonalizacoes(new ArrayList());
                        item.setGrupoPersonalizacoesDeProduto(new ArrayList());
                        if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                            this.loadProductsFromComposition(item.getProdutoComposto());
                        }
                        this.groupBasketOrderItemByCustomizationProduct(item);
                        this.groupBasketOrderItemByCustomization(item);
                    });
                }
            });
        }
    }

    @Deprecated
    public List<Pedido> listOrderByStatus(Long empresaId, SituacaoDoPedido situacao) {
        Date finalDate = DateUtil.criarHora((Integer)23, (Integer)59, (Integer)59);
        Calendar initialDate = Calendar.getInstance();
        initialDate.setTime(DateUtil.retrocederDias((Date)finalDate, (Integer)1));
        initialDate.set(11, 23);
        initialDate.set(12, 0);
        initialDate.set(13, 0);
        return this.repository.findCompanyOrdersByStatusOnPeriod(empresaId, situacao, initialDate.getTime(), finalDate);
    }

    public List<PedidoView> listNotImportedOrderView(Long companyId) {
        Date initialDate = DateUtil.criarHora((Integer)8, (Integer)0, (Integer)0);
        Date finalDate = DateUtil.criarHora((Integer)23, (Integer)59, (Integer)59);
        List orders = this.repository.findCompanyNotImportedOrdersViewOnPeriod(companyId, initialDate, finalDate);
        orders.forEach(order -> this.populateOrderViewData(companyId, order));
        return orders;
    }

    public List<PedidoView> listdOrderViewByStatus(Long empresaId, SituacaoDoPedido situacao) {
        Date finalDate = DateUtil.criarHora((Integer)23, (Integer)59, (Integer)59);
        Calendar initialDate = Calendar.getInstance();
        initialDate.setTime(DateUtil.retrocederDias((Date)finalDate, (Integer)1));
        initialDate.set(11, 23);
        initialDate.set(12, 0);
        initialDate.set(13, 0);
        List orders = this.repository.findCompanyOrdersViewByStatusOnPeriod(empresaId, situacao, initialDate.getTime(), finalDate);
        orders.forEach(order -> this.populateOrderViewData(empresaId, order));
        return orders;
    }

    public List<Pedido> getNewOrders(Long empresaId) {
        ArrayList<Pedido> novosPedidos = new ArrayList<Pedido>();
        for (Pedido pedido : this.repository.findByEmpresaIdOrderByIdAsc(empresaId)) {
            if (!pedido.getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_CONFIRMACAO)) continue;
            novosPedidos.add(pedido);
        }
        return novosPedidos;
    }

    public Page<PedidoResumido> getOrdersFromOfficeHours(String searchCriteria, int numeroPagina, Integer entriesByPage) throws ApiException {
        PedidoResumidoSpecificationBuilder builder = new PedidoResumidoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(Arrays.asList("dataAtualizacaoPedido"), (String)"desc");
        PageRequest pageable = PageRequest.of((int)numeroPagina, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page results = this.shortOrderRepository.findAll(spec, (Pageable)pageable);
        return results;
    }

    public Page<Pedido> getScheduledOrders(String searchCriteria, int numeroPagina, Integer entriesByPage) throws ApiException {
        PedidoSpecificationBuilder builder = new PedidoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(Arrays.asList("dataHoraAgendamento"), (String)"asc");
        PageRequest pageable = PageRequest.of((int)numeroPagina, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page results = this.repository.findAll(spec, (Pageable)pageable).map(arg_0 -> this.populateOrderOfDay(arg_0));
        return results;
    }

    public List<Pedido> getOrderInProgress(Long usuarioId) {
        List userOrders = this.repository.findByClienteIdOrderByIdDesc(usuarioId);
        ArrayList<Pedido> orders = new ArrayList<Pedido>();
        userOrders.forEach(order -> {
            if (!order.getSituacao().equals((Object)SituacaoDoPedido.FINALIZADO) && !order.getSituacao().equals((Object)SituacaoDoPedido.CANCELADO)) {
                order.setTotalDoPedido(this.calculateTotalOrderValue(order));
                orders.add((Pedido)order);
            }
        });
        return orders;
    }

    public List<Pedido> getOrderInProgressByVendor(Long vendorId) {
        List userOrders = this.repository.findTop20ByVendedorIdOrderByDataHoraPedidoDesc(vendorId);
        ArrayList<Pedido> orders = new ArrayList<Pedido>();
        userOrders.forEach(order -> {
            if (!order.getSituacao().equals((Object)SituacaoDoPedido.FINALIZADO) && !order.getSituacao().equals((Object)SituacaoDoPedido.CANCELADO)) {
                order.setTotalDoPedido(this.calculateTotalOrderValue(order));
                this.groupOrderItems(order);
                orders.add((Pedido)order);
            }
        });
        return orders;
    }

    public Pedido getLastOrder(Long customerId, Long companyId) {
        return this.repository.findTopByClienteIdAndEmpresaIdOrderByIdDesc(customerId, companyId);
    }

    public SituacaoDoPedido getLastOrderStatusByCustomer(Long customerId) {
        Integer statusCode = this.repository.getLastOrderStatusByCustomer(customerId).orElse(null);
        if (NullUtil.isNull((Object)statusCode)) {
            return null;
        }
        return SituacaoDoPedido.get((int)statusCode);
    }

    public SituacaoDoPedido getOrderStatusByOrder(Long orderId) {
        Integer statusCode = this.repository.getOrderStatusByOrder(orderId).orElse(null);
        if (NullUtil.isNull((Object)statusCode)) {
            return null;
        }
        return SituacaoDoPedido.get((int)statusCode);
    }

    public List<Pedido> getLastOrders(Long userId, Long companyId, Integer periodDays) {
        Date diffDays = Date.from(LocalDate.now().minus(Period.ofDays(periodDays)).atStartOfDay(ZoneId.systemDefault()).toInstant());
        List lastOrders = this.repository.findUltimosPedidosRealizados(userId, companyId, SituacaoDoPedido.FINALIZADO, diffDays);
        lastOrders.forEach(order -> {
            BigDecimal isencaoEntrega = order.getEmpresa().getValorIsencaoEntrega();
            order.setCliente(null);
            order.setEmpresa(new Empresa());
            order.getEmpresa().setValorIsencaoEntrega(isencaoEntrega);
            if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
                this.getProductsFromComposedProduct(order);
            }
            if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
                this.getProductsFromPromotionComposedProduct(order);
            }
        });
        return lastOrders;
    }

    public Pedido getLastCustomerOrder(Long clienteId, Long empresaId) {
        List orders = this.repository.findLastCustomersOrderFromDay(clienteId);
        if (CollectionUtils.isEmpty((Collection)orders)) {
            return null;
        }
        Pedido order = new Pedido(((Pedido)orders.get(0)).getId());
        order.setCliente(new Cliente(((Pedido)orders.get(0)).getCliente().getId()));
        order.setSituacao(((Pedido)orders.get(0)).getSituacao());
        order.setFormaEntrega(((Pedido)orders.get(0)).getFormaEntrega());
        order.setClassificacao(((Pedido)orders.get(0)).getClassificacao());
        order.setRespostaFeedback(((Pedido)orders.get(0)).getRespostaFeedback());
        order.setFeedbackUtil(((Pedido)orders.get(0)).getFeedbackUtil());
        if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
            this.getProductsFromComposedProduct(order);
        }
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            this.getProductsFromPromotionComposedProduct(order);
        }
        return order;
    }

    public List<Pedido> getLastCustomerOrdersByTableNumber(Long companyId, String tableNumber) {
        List orders = this.repository.findLastCustomerOrderByTableFromDay(companyId, tableNumber);
        if (CollectionUtils.isEmpty((Collection)orders)) {
            return null;
        }
        orders.forEach(order -> {
            if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
                this.getProductsFromComposedProduct(order);
            }
            if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
                this.getProductsFromPromotionComposedProduct(order);
            }
        });
        return orders;
    }

    public Boolean iFoodOrderExists(String orderId) {
        return NullUtil.isNotNull((Object)this.repository.findByIdExterno(orderId));
    }

    public List<Pedido> listOpenedOrders() throws ApiException {
        return this.repository.findOrdersBySituacoesNotIn(Arrays.asList(SituacaoDoPedido.FINALIZADO, SituacaoDoPedido.CANCELADO, SituacaoDoPedido.CANCELADO_PELO_CLIENTE));
    }

    public Page<PedidoResumido> listNewOrders(String searchCriteria, int numberPage, Integer entriesByPage) throws ApiException, IOException {
        PedidoResumidoSpecificationBuilder builder = new PedidoResumidoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(Arrays.asList("dataAtualizacaoPedido"), (String)"desc");
        PageRequest pageable = PageRequest.of((int)numberPage, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page results = this.shortOrderRepository.findAll(spec, (Pageable)pageable);
        return results;
    }

    public List<OpcaoDePagamentoComCartao> listPaymentOptionsByCard(Long empresaId) {
        return this.paymentCardRepository.findByEmpresaIdAndExcluidaIsFalse(empresaId);
    }

    public void loadProductsFromComposition(ProdutoComposto composition) {
        List<String> productsIds = Arrays.asList(composition.getProdutosIds().split(","));
        composition.setProdutos(this.productRepository.findCompositionItems(productsIds.stream().map(id -> new Long((String)id)).collect(Collectors.toList())));
    }

    @Transactional
    public Pedido updateOrderCasterValues(Pedido caster) throws ApiException {
        Pedido edit = (Pedido)this.repository.findById((Object)caster.getId()).get();
        edit.setQtdeRodizioCompleto(caster.getQtdeRodizioCompleto());
        edit.setValorRodizioCompleto(caster.getValorRodizioCompleto());
        edit.setQtdeMeioRodizio(caster.getQtdeMeioRodizio());
        edit.setValorMeioRodizio(caster.getValorMeioRodizio());
        edit.setDataAtualizacaoPedido(DateUtil.setTimeByTimezone((FusoHorario)edit.getEmpresa().getFusoHorario()));
        edit.setSituacao(SituacaoDoPedido.RODIZIO_ATUALIZADO);
        edit.setTotalDoPedido(caster.getTotalDoPedido());
        this.repository.save((Object)edit);
        if (!CollectionUtils.isEmpty((Collection)caster.getItensDoPedido())) {
            Set<ItemDoPedido> newItems = caster.getItensDoPedido().stream().filter(item -> NullUtil.isNullOrZero((Number)item.getId())).collect(Collectors.toSet());
            newItems.forEach(item -> {
                item.setPedido(edit);
                this.orderItemRepository.save(item);
            });
        }
        return (Pedido)this.repository.findById((Object)edit.getId()).get();
    }

    @Transactional
    public Pedido updateOrderStatus(Pedido order) throws ApiException, IOException, InterruptedException {
        Pedido edit = (Pedido)this.repository.findById((Object)order.getId()).get();
        edit.setEmpresa((Empresa)Hibernate.unproxy((Object)edit.getEmpresa()));
        edit.setSituacao(order.getSituacao());
        edit.setDataAtualizacaoPedido(DateUtil.setTimeByTimezone((FusoHorario)edit.getEmpresa().getFusoHorario()));
        edit.setImportado(order.getImportado());
        if (NullUtil.isNotNull((Object)edit.getCupomDeDesconto()) && edit.getSituacao().equals((Object)SituacaoDoPedido.CANCELADO)) {
            List usedDiscountTickets = this.cupomUtilizadoRepository.findByCupomIdAndEmpresaIdAndClienteId(edit.getCupomDeDesconto().getId(), edit.getEmpresa().getId(), edit.getCliente().getId());
            usedDiscountTickets.forEach(discountTicket -> this.cupomUtilizadoRepository.deleteById((Object)discountTicket.getId()));
        }
        this.repository.updateOrderStatus(edit.getSituacao(), edit.getDataAtualizacaoPedido(), edit.getImportado(), edit.getId());
        if (edit.getSituacao().equals((Object)SituacaoDoPedido.FINALIZADO) && this.hasCashback(edit) && !NullUtil.isNotNullOrZero((BigDecimal)edit.getDebitoCashback())) {
            this.creditCustomerCashback(edit);
        }
        if (!edit.getEmpresa().getControleEstoque().equals((Object)ControleEstoque.SEM_CONTROLE) && edit.getSituacao().equals((Object)SituacaoDoPedido.CANCELADO)) {
            if (!CollectionUtils.isEmpty((Collection)edit.getItensDoPedido())) {
                for (ItemDoPedido item : edit.getItensDoPedido()) {
                    this.stockManagementService.sumProductToStock(item.getProduto(), item.getQuantidade());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)edit.getCestasDePromocao())) {
                for (CestaDePromocao basket : edit.getCestasDePromocao()) {
                    for (ItemDoPedidoPorPromocao item : basket.getItens()) {
                        this.stockManagementService.sumProductToStock(item.getProduto(), Double.valueOf(item.getQuantidade().doubleValue()));
                    }
                }
            }
        }
        return edit;
    }

    @Transactional
    public void upadteTotalOrderValue(Long companyId) {
        this.repository.findByEmpresaIdAndTotalDoPedidoIsNull(companyId).forEach(pedido -> {
            pedido.setTotalDoPedido(this.calculateTotalOrderValue(pedido));
            this.repository.save(pedido);
        });
    }

    public void save(Pedido order) {
        this.repository.save((Object)order);
    }

    @Transactional
    public Pedido saveFeedbackReply(Pedido pedido) throws ApiException, JsonProcessingException {
        if (StringUtil.isBlank((String)pedido.getRespostaFeedback())) {
            throw new ApiException("msg.erro.001", new String[]{"Resposta do feedback"});
        }
        Pedido edit = (Pedido)this.repository.findById((Object)pedido.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Pedido", pedido.getId().toString()}));
        edit.setRespostaFeedback(pedido.getRespostaFeedback());
        this.repository.save((Object)edit);
        TipoToken tokenType = pedido.getOrigem().equals((Object)Origem.APP) ? TipoToken.APP : TipoToken.WEB;
        Token fcmToken = this.fcmTokenRepository.findTopByUsuarioIdAndEmpresaIdAndTipoOrderByIdDesc(edit.getCliente().getUsuario().getId(), edit.getEmpresa().getId(), tokenType).orElse(null);
        if (NullUtil.isNotNull((Object)fcmToken)) {
            this.pushService.enviarRecado(fcmToken.getToken(), "Nova mensagem", "Respondemos a sua mensagem. Clique aqui para visualizar nossa resposta!", edit.getEmpresa().getFcmTokenServidor());
        }
        return edit;
    }

    @Transactional
    public void saveOrderFeedback(Pedido order) throws ApiException {
        Pedido edicao = (Pedido)this.repository.findById((Object)order.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Pedido", order.getId().toString()}));
        if (!NullUtil.isNull((Object)edicao.getClassificacao())) {
            throw new ApiException("msg.info.011");
        }
        edicao.setFeedback(order.getFeedback());
        edicao.setClassificacao(order.getClassificacao());
        edicao.setSugestaoMelhoria(order.getSugestaoMelhoria());
        edicao.setDataAtualizacaoPedido(DateUtil.setTimeByTimezone((FusoHorario)edicao.getEmpresa().getFusoHorario()));
        this.repository.save((Object)edicao);
    }

    @Transactional
    public void sendFeedbackResponse(Long pedidoId, Boolean feedbackUtil) throws ApiException {
        Pedido edicao = (Pedido)this.repository.findById((Object)pedidoId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Pedido", pedidoId.toString()}));
        if (!NullUtil.isNull((Object)edicao.getFeedbackUtil())) {
            throw new ApiException("msg.info.011");
        }
        edicao.setFeedbackUtil(feedbackUtil);
        edicao.setDataAtualizacaoPedido(DateUtil.setTimeByTimezone((FusoHorario)edicao.getEmpresa().getFusoHorario()));
        this.repository.save((Object)edicao);
    }

    @Transactional
    public String notifyNewOrders(Long companyId) throws ApiException {
        ArrayList<SituacaoDoPedido> orderStatus = new ArrayList<SituacaoDoPedido>();
        orderStatus.add(SituacaoDoPedido.AGUARDANDO_CONFIRMACAO);
        Boolean allowReceivesAutoOrders = this.companyRepository.getCompanyReceivesAutoOrdersConfig(companyId).orElse(false);
        if (allowReceivesAutoOrders.booleanValue()) {
            orderStatus.add(SituacaoDoPedido.CONFIRMADO);
        }
        List orderIds = this.repository.findNewOrdersIds(companyId, orderStatus);
        String notify = "";
        if (!CollectionUtils.isEmpty((Collection)orderIds)) {
            notify = orderIds.size() == 1 ? String.format("Voc\u00ea tem um novo pedido: No. %s", orderIds.get(0)) : String.format("Voc\u00ea tem novos pedidos: Nos. %s", orderIds.stream().map(orderId -> String.format("N\u00ba %s", orderId)));
        }
        return notify;
    }

    @Transactional
    public Pedido saveOrder(Pedido order, Long companyId, boolean withOnlinePayment) throws ApiException {
        Cliente customer = this.identifyIOrderCustomer(order);
        if (NullUtil.isNotNull((Object)order.getVendedor())) {
            order.setVendedor((Usuario)this.usuarioRepository.findById((Object)order.getVendedor().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Vendedor", order.getVendedor().getId().toString()})));
        }
        if (NullUtil.isNull((Object)order.getLojaDeOrigem())) {
            order.setLojaDeOrigem(LojaDeOrigem.PEDIDO_AGORA);
        }
        if (NullUtil.isNull((Object)order.getClienteSemCadastro())) {
            order.setClienteSemCadastro(Boolean.valueOf(false));
        }
        if (NullUtil.isNull((Object)order.getSituacao())) {
            order.setSituacao(SituacaoDoPedido.AGUARDANDO_CONFIRMACAO);
        }
        order.setEmpresa((Empresa)Hibernate.unproxy(this.companyRepository.findById((Object)companyId).get()));
        order.setTeste(order.getEmpresa().getEmTeste());
        if (StringUtil.isNotBlank((String)order.getCpfCnpjNota())) {
            order.setCpfCnpjNota(StringUtil.removerMascara((String)order.getCpfCnpjNota()));
        }
        order.setCliente(customer);
        order.setRodizio(Boolean.valueOf(false));
        order.setRodizioFechado(Boolean.valueOf(true));
        order.setImportado(Boolean.valueOf(false));
        Date now = DateUtil.setTimeByTimezone((FusoHorario)order.getEmpresa().getFusoHorario());
        order.setDataHoraPedido(now);
        order.setDataAtualizacaoPedido(now);
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            for (CestaDePromocao basket : order.getCestasDePromocao()) {
                this.validatePromotion(basket.getPromocao());
            }
        }
        if (order.getEmpresa().getAceitaPedidosAuto().booleanValue()) {
            order.setSituacao(NullUtil.isNotNull((Object)order.getDataHoraAgendamento()) ? SituacaoDoPedido.AGENDADO : SituacaoDoPedido.CONFIRMADO);
        } else {
            order.setSituacao(SituacaoDoPedido.AGUARDANDO_CONFIRMACAO);
        }
        Integer monthOrders = this.repository.countOrdersInCurrentMonthByCompanyId(order.getEmpresa().getId(), DateUtil.primeiroDiaMes((Date)new Date()));
        if (order.getEmpresa().getUsuario().isDemonstracao() && monthOrders >= Domains.LIMITE_PEDIDOS_FREEMIUM) {
            order.setPedidoExcedente(Boolean.valueOf(true));
            order.setSituacao(SituacaoDoPedido.AGUARDANDO_CONFIRMACAO);
        } else {
            order.setPedidoExcedente(Boolean.valueOf(false));
        }
        order.setTotalDoPedido(this.calculateTotalOrderValue(order));
        if (NullUtil.isNullOrZero((BigDecimal)order.getTaxaDeEntrega())) {
            order.setTaxaDeEntrega(BigDecimal.ZERO);
        }
        CupomDeDesconto discountTicket = null;
        if (NullUtil.isNotNull((Object)order.getCupomDeDesconto()) && NullUtil.isNotNullOrZero((Number)order.getCupomDeDesconto().getId())) {
            discountTicket = this.cupomDeDescontoService.findById(order.getCupomDeDesconto().getId());
        }
        this.validateLastOrder(order);
        this.repository.save((Object)order);
        if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
            this.saveOrderItems(order);
        }
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            this.saveOrderItensByPromotion(order);
        }
        if (NullUtil.isNotNull((Object)discountTicket)) {
            this.consumeDiscountTicket(order, order.getTotalDoPedido(), discountTicket);
        }
        if (NullUtil.isNotNullOrZero((BigDecimal)order.getCreditoCashback()) || NullUtil.isNotNullOrZero((BigDecimal)order.getDebitoCashback())) {
            this.saveOrderCashback(order);
        }
        return order;
    }

    @Transactional
    public void setImportedOrders(List<Long> importedOrders) {
        importedOrders.forEach(id -> this.repository.setImported(id));
    }

    @Transactional
    public void updatePedidosByPDV(List<Pedido> orders) throws ApiException, IOException, InterruptedException {
        for (Pedido order : orders) {
            Pedido edit = (Pedido)this.repository.findById((Object)order.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Pedido", order.getId().toString()}));
            edit.setDataAtualizacaoPedido(DateUtil.setTimeByTimezone((FusoHorario)edit.getEmpresa().getFusoHorario()));
            edit.setSituacao(order.getSituacao());
            this.repository.save((Object)edit);
            if (edit.getSituacao().equals((Object)SituacaoDoPedido.FINALIZADO) && this.hasCashback(edit)) {
                this.creditCustomerCashback(edit);
            }
            this.messengerService.sendOrderMessage(edit);
        }
    }

    public void validateDelivery(Pedido pedido) throws ApiException {
        if (pedido.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            BigDecimal totalOrder;
            if (!NullUtil.isNotNull((Object)pedido.getFormaPagamento())) {
                throw new ApiException("msg.erro.001", new String[]{"Forma de Pagamento"});
            }
            EnderecoDeEntrega address = (EnderecoDeEntrega)this.addressRepository.findById((Object)pedido.getEnderecoEntrega().getId()).get();
            pedido.setEnderecoEntrega(address);
            Empresa company = (Empresa)this.companyRepository.findById((Object)pedido.getEmpresa().getId()).get();
            if (NullUtil.isNotNullOrZero((BigDecimal)company.getValorMinimoParaEntrega()) && (totalOrder = this.calculateTotalOrderValue(pedido)).compareTo(company.getValorMinimoParaEntrega()) == -1) {
                throw new ApiException("msg.erro.143", new String[]{StringUtil.formatarMoeda((Double)company.getValorMinimoParaEntrega().doubleValue())});
            }
            if (NullUtil.isNotNull((Object)pedido.getOpcaoPagamentoCartao())) {
                OpcaoDePagamentoComCartao pagamentoCartao = (OpcaoDePagamentoComCartao)this.paymentCardRepository.findById((Object)pedido.getOpcaoPagamentoCartao().getId()).get();
                pedido.setOpcaoPagamentoCartao(pagamentoCartao);
            }
            if (this.bairroNaoAtendidoRepository.countByEmpresaAndBairroAndMunicipio(pedido.getEmpresa().getId(), address.getMunicipio().getId(), address.getBairro()) > 0L) {
                throw new ApiException("msg.erro.107");
            }
            EmpresaConfiguracao coberturaNacional = (EmpresaConfiguracao)this.companyConfigRepository.findByEmpresaIdAndConfiguracaoNome(pedido.getEmpresa().getId(), "config-cobertura-nacional").get();
            if (!(coberturaNacional.getValor().equals("1") || pedido.getEnderecoEntrega().getMunicipio().getId().equals(pedido.getEmpresa().getMunicipio().getId()) || pedido.getEmpresa().getId().equals(Domains.ID_PEDIDOAGORA) || pedido.getEmpresa().getId().equals(Domains.ID_PEDIDOAGORA_2) || this.municipioAtendidoRepository.countByEmpresaIdAndMunicipioId(pedido.getEmpresa().getId(), pedido.getEnderecoEntrega().getMunicipio().getId()) != 0L)) {
                throw new ApiException("msg.erro.085");
            }
        }
    }

    public void validateGuestDelivery(Pedido pedido) throws ApiException {
        if (pedido.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            String[] address;
            String[] cityAndUf;
            Municipio city;
            EmpresaConfiguracao coberturaNacional;
            BigDecimal totalOrder;
            if (!NullUtil.isNotNull((Object)pedido.getFormaPagamento())) {
                throw new ApiException("msg.erro.001", new String[]{"Forma de Pagamento"});
            }
            Empresa company = (Empresa)this.companyRepository.findById((Object)pedido.getEmpresa().getId()).get();
            if (NullUtil.isNotNullOrZero((BigDecimal)company.getValorMinimoParaEntrega()) && (totalOrder = this.calculateTotalOrderValue(pedido)).compareTo(company.getValorMinimoParaEntrega()) == -1) {
                throw new ApiException("msg.erro.143", new String[]{StringUtil.formatarMoeda((Double)company.getValorMinimoParaEntrega().doubleValue())});
            }
            if (NullUtil.isNotNull((Object)pedido.getOpcaoPagamentoCartao())) {
                OpcaoDePagamentoComCartao pagamentoCartao = (OpcaoDePagamentoComCartao)this.paymentCardRepository.findById((Object)pedido.getOpcaoPagamentoCartao().getId()).get();
                pedido.setOpcaoPagamentoCartao(pagamentoCartao);
            }
            if (!((coberturaNacional = (EmpresaConfiguracao)this.companyConfigRepository.findByEmpresaIdAndConfiguracaoNome(pedido.getEmpresa().getId(), "config-cobertura-nacional").get()).getValor().equals("1") || (city = (Municipio)this.cityRepository.findByNomeIgnoreCaseAndUfIgnoreCase((cityAndUf = (address = pedido.getEnderecoDeEntregaClienteSemCadastro().replaceAll(",\\s", ",").split(","))[4].split("/"))[0].trim(), cityAndUf[1].substring(0, 2).trim()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Munic\u00edpio", cityAndUf[0]}))).getId().equals(company.getMunicipio().getId()) || !NullUtil.isNotNull((Object)pedido.getEnderecoEntrega()) || pedido.getEmpresa().getId().equals(Domains.ID_PEDIDOAGORA) || pedido.getEmpresa().getId().equals(Domains.ID_PEDIDOAGORA_2) || this.municipioAtendidoRepository.countByEmpresaIdAndMunicipioId(pedido.getEmpresa().getId(), city.getId()) != 0L)) {
                throw new ApiException("msg.erro.085");
            }
        }
    }

    public void validatePromotion(Promocao promotion) throws ApiException {
        Long promotionId = promotion.getId();
        if (!DateUtil.pertenceAoPeriodo((Date)new Date(), (Date)(promotion = (Promocao)this.promocaoRepository.findById((Object)promotionId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Promo\u00e7\u00e3o", promotionId.toString().toString()}))).getDtInicioValidade(), (Date)promotion.getDtFimValidade()).booleanValue()) {
            throw new ApiException("msg.erro.076", new String[]{promotion.getTitulo()});
        }
        if (StringUtil.isBlank((String)promotion.getDisponibilidades())) {
            throw new ApiException("msg.erro.077", new String[]{promotion.getTitulo()});
        }
        ArrayList disponibilidades = new ArrayList();
        Arrays.asList(promotion.getDisponibilidades().split(",")).forEach(disponibilidade -> disponibilidades.add(new Integer((String)disponibilidade)));
        if (disponibilidades.stream().noneMatch(disponibilidade -> disponibilidade.equals(DateUtil.diaDaSemana().ordinal()))) {
            throw new ApiException("msg.erro.077", new String[]{promotion.getTitulo()});
        }
        if (!promotion.getAceitaCupomDeDesconto().booleanValue() && NullUtil.isNotNull((Object)promotion.getCupomDeDesconto())) {
            throw new ApiException("msg.erro.078", new String[]{promotion.getTitulo()});
        }
        if (!promotion.getAtivo().booleanValue()) {
            throw new ApiException("msg.erro.079", new String[]{promotion.getTitulo()});
        }
    }

    public boolean validateDiscountTicketRole(CupomDeDesconto discountTicket, BigDecimal totalOrder) throws ApiException {
        if (discountTicket.getTipoRegra().equals((Object)TipoRegraCupom.MENOR_QUE) && totalOrder.compareTo(new BigDecimal(discountTicket.getValorRegraCupom())) != -1) {
            throw new ApiException("msg.erro.028");
        }
        if (discountTicket.getTipoRegra().equals((Object)TipoRegraCupom.MENOR_OU_IGUAL_QUE) && totalOrder.compareTo(new BigDecimal(discountTicket.getValorRegraCupom())) > 0) {
            throw new ApiException("msg.erro.028");
        }
        if (discountTicket.getTipoRegra().equals((Object)TipoRegraCupom.MAIOR_QUE) && totalOrder.compareTo(new BigDecimal(discountTicket.getValorRegraCupom())) != 1) {
            throw new ApiException("msg.erro.028");
        }
        if (discountTicket.getTipoRegra().equals((Object)TipoRegraCupom.MAIOR_OU_IGUAL_QUE) && totalOrder.compareTo(new BigDecimal(discountTicket.getValorRegraCupom())) < 0) {
            throw new ApiException("msg.erro.028");
        }
        if (discountTicket.getTipoRegra().equals((Object)TipoRegraCupom.IGUAL_A) && totalOrder.compareTo(new BigDecimal(discountTicket.getValorRegraCupom())) != 0) {
            throw new ApiException("msg.erro.028");
        }
        return true;
    }

    public void validateGuestOrderRequest(Pedido order) throws ApiException {
        Empresa company = (Empresa)this.companyRepository.findById((Object)order.getEmpresa().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", order.getEmpresa().getId().toString()}));
        order.setEmpresa(company);
        if (!NullUtil.isNotNull((Object)order)) {
            throw new ApiException("msg.erro.001", new String[]{"Pedido"});
        }
        if (!NullUtil.isNotNull((Object)order.getEmpresa())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (!NullUtil.isNotNull((Object)order.getFormaEntrega())) {
            throw new ApiException("msg.erro.001", new String[]{"Forma de Entrega"});
        }
        if (CollectionUtils.isEmpty((Collection)order.getItensDoPedido()) && CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            throw new ApiException("msg.erro.001", new String[]{"Itens do Pedido/Itens do Pedido por Promo\u00e7\u00e3o"});
        }
        if (NullUtil.isNull((Object)order.getSituacao())) {
            throw new ApiException("msg.erro.001", new String[]{"Situa\u00e7\u00e3o do Pedido"});
        }
        if (!NullUtil.isNotNull((Object)order.getNomeClienteSemCadastro())) {
            throw new ApiException("msg.erro.001", new String[]{"Nome"});
        }
        if (!NullUtil.isNotNull((Object)order.getTelefoneClienteSemCadastro())) {
            throw new ApiException("msg.erro.001", new String[]{"Telefone"});
        }
        this.validateOrderItems(order);
        this.validateOrderItemsByPromotion(order);
        this.validateOrderSchedule(order);
        this.validateLastGuestOrder(order);
    }

    public void validateOrderRequest(Pedido order) throws ApiException {
        Empresa company = (Empresa)this.companyRepository.findById((Object)order.getEmpresa().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa"}));
        order.setEmpresa(company);
        if (!NullUtil.isNotNull((Object)order)) {
            throw new ApiException("msg.erro.001", new String[]{"Pedido"});
        }
        if (!NullUtil.isNotNull((Object)company)) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (company.getUsuario().getBloqueado().booleanValue()) {
            throw new ApiException("msg.erro.147", new String[]{"Pedido"});
        }
        if (!NullUtil.isNotNull((Object)order.getFormaEntrega())) {
            throw new ApiException("msg.erro.001", new String[]{"Forma de Entrega"});
        }
        if (CollectionUtils.isEmpty((Collection)order.getItensDoPedido()) && CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            throw new ApiException("msg.erro.001", new String[]{"Itens do Pedido/Itens do Pedido por Promo\u00e7\u00e3o"});
        }
        if (NullUtil.isNull((Object)order.getSituacao())) {
            throw new ApiException("msg.erro.001", new String[]{"Situa\u00e7\u00e3o do Pedido"});
        }
        if (!NullUtil.isNotNull((Object)order.getCliente())) {
            throw new ApiException("msg.erro.001", new String[]{"Usu\u00e1rio"});
        }
        if (NullUtil.isNotNull((Object)order.getFormaPagamento()) && order.getFormaPagamento().equals((Object)FormaDePagamento.PAGAMENTO_ONLINE)) {
            if (this.customerCantUseOnlinePayment(order).booleanValue()) {
                throw new ApiException("msg.erro.140");
            }
            SolicitacaoDePagamento request = this.requestPaymentRepository.findTopByClienteIdAndEncerradaIsFalse(order.getCliente().getId()).orElse(null);
            if (NullUtil.isNotNull((Object)request) && DateUtil.calcularDiferencaEntreDatasEmMinutos((Date)request.getDataHoraSolicitacao(), (Date)new Date()) >= Domains.EXPIRATION_PAYMENT_VALIDATION_CODE) {
                throw new ApiException("msg.erro.167");
            }
            if (!request.getCodigoDeVerificacao().equals(order.getCodigoDeConfirmacaoDePagamento())) {
                throw new ApiException("msg.erro.168");
            }
        }
        this.validateOrderItems(order);
        this.validateOrderItemsByPromotion(order);
        this.validadeOrderCashback(order);
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            this.validateDelivery(order);
        }
        this.validateLastOrder(order);
    }

    private Boolean customerCantUseOnlinePayment(Pedido pedido) throws ApiException {
        Cliente customer = (Cliente)this.clienteRepository.findById((Object)pedido.getCliente().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", pedido.getCliente().getId().toString()}));
        return NullUtil.isNotNull((Object)customer.getPagamentoOnlineBloqueado()) ? customer.getPagamentoOnlineBloqueado() : Boolean.FALSE;
    }

    @Transactional
    private void consumeDiscountTicket(Pedido pedido, BigDecimal valorTotalPedido, CupomDeDesconto cupom) throws ApiException {
        CupomUtilizado cupomUtilizado = new CupomUtilizado();
        cupomUtilizado.setCupom(cupom);
        cupomUtilizado.setEmpresa(pedido.getEmpresa());
        cupomUtilizado.setCliente(pedido.getCliente());
        cupomUtilizado.setDataHoraUsoDoCupom(DateUtil.setTimeByTimezone((FusoHorario)pedido.getEmpresa().getFusoHorario()));
        this.cupomUtilizadoRepository.save((Object)cupomUtilizado);
    }

    private BigDecimal exemptDeliveryFeeWhenAllowed(Pedido order, BigDecimal totalItems) {
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            if (NullUtil.isNotNullOrZero((BigDecimal)order.getEmpresa().getValorIsencaoEntrega())) {
                if (totalItems.doubleValue() < order.getEmpresa().getValorIsencaoEntrega().doubleValue()) {
                    totalItems = totalItems.add(order.getTaxaDeEntrega());
                }
            } else {
                totalItems = NullUtil.isNotNull((Object)order.getTaxaDeEntrega()) ? totalItems.add(order.getTaxaDeEntrega()) : totalItems.add(order.getEmpresa().getValorTarifaUnica());
            }
        }
        return totalItems;
    }

    private void getProductsFromComposedProduct(Pedido order) {
        order.getItensDoPedido().stream().filter(item -> NullUtil.isNotNull((Object)item.getProdutoComposto())).forEach(item -> {
            List productsIds = Arrays.asList(item.getProdutoComposto().getProdutosIds().split(",")).stream().map(id -> new Long((String)id)).collect(Collectors.toList());
            item.getProdutoComposto().setProdutos(this.productRepository.findByIdIn(productsIds));
        });
    }

    private void getProductsFromPromotionComposedProduct(Pedido order) {
        order.getCestasDePromocao().forEach(basket -> basket.getItens().stream().filter(item -> NullUtil.isNotNull((Object)item.getProdutoComposto())).forEach(item -> {
            List productsIds = Arrays.asList(item.getProdutoComposto().getProdutosIds().split(",")).stream().map(id -> new Long((String)id)).collect(Collectors.toList());
            item.getProdutoComposto().setProdutos(this.productRepository.findByIdIn(productsIds));
        }));
    }

    private boolean hasCashback(Pedido order) {
        EmpresaConfiguracao cashbackConfig = this.companyConfigRepository.findByEmpresaIdAndConfiguracaoNome(order.getEmpresa().getId(), "config-ativar-cashback").orElse(null);
        return NullUtil.isNotNull((Object)cashbackConfig) && cashbackConfig.getValor().equals(ValorConfiguracaoBooleano.TRUE.getValor());
    }

    private Cliente identifyIOrderCustomer(Pedido order) throws ApiException {
        if (NullUtil.isNotNull((Object)order.getCliente()) && NullUtil.isNotNullOrZero((Number)order.getCliente().getId())) {
            return (Cliente)this.clienteRepository.findById((Object)order.getCliente().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", order.getCliente().getId().toString()}));
        }
        return (Cliente)this.clienteRepository.findById((Object)Domains.CLIENTE_EXTERNO_ID).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", "{Pedido " + order.getId() + "}"}));
    }

    public boolean hasNewOrders(Long companyId) {
        return NullUtil.isNotNullOrZero((Number)this.repository.countCompanyNewOrders(companyId));
    }

    @Transactional
    private void saveOrderCashback(Pedido order) throws ApiException {
        if (this.hasCashback(order)) {
            boolean isDebit;
            Cashback cashback = (Cashback)this.cashbackRepository.findCurrentCashback(order.getEmpresa().getId(), order.getCliente().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cashback", "Cliente {" + order.getCliente().getId() + "}"}));
            ExtratoDeCashback extract = new ExtratoDeCashback();
            extract.setDataHoraDoLancamento(new Date());
            boolean bl = isDebit = NullUtil.isNotNull((Object)order.getDebitoCashback()) && order.getDebitoCashback().compareTo(BigDecimal.ZERO) > 0;
            if (isDebit) {
                cashback.setCreditoUtilizado(cashback.getCreditoUtilizado().add(order.getDebitoCashback()));
                cashback.setCreditoDisponivel(cashback.getCreditoDisponivel().subtract(order.getDebitoCashback()));
                cashback.setCreditoReservado(BigDecimal.ZERO);
                extract.setDescricao("Cr\u00e9dito de cashback utilizado utilizado.");
                extract.setTipoDeLancamento(TipoDeExtratoDeCashback.DEBITO);
            } else {
                cashback.setCreditoReservado(cashback.getCreditoReservado().compareTo(BigDecimal.ZERO) > 0 ? cashback.getCreditoReservado().add(order.getCreditoCashback()) : order.getCreditoCashback());
                extract.setDescricao("Cr\u00e9dito de cashback aprovisionado para receber ap\u00f3s a finaliza\u00e7\u00e3o do pedido.");
                extract.setTipoDeLancamento(TipoDeExtratoDeCashback.APROVISIONAMENTO);
            }
            this.cashbackRepository.save((Object)cashback);
            extract.setCashback(cashback);
            extract.setPedido(order);
            extract.setValor(isDebit ? order.getDebitoCashback().multiply(new BigDecimal(-1)) : order.getCreditoCashback());
            this.cashbackExtractRepository.save((Object)extract);
        }
    }

    @Transactional
    private void saveOrderItems(Pedido order) throws ApiException {
        ControleEstoque stockControl = (ControleEstoque)this.companyRepository.getCompanyStockControl(order.getEmpresa().getId()).get();
        for (ItemDoPedido item : order.getItensDoPedido()) {
            item.setPedido(order);
            if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                item.setProduto(null);
                this.composedProductRepository.save((Object)item.getProdutoComposto());
            }
            if (!CollectionUtils.isEmpty((Collection)item.getOpcionais())) {
                item.getOpcionais().forEach(optional -> {
                    optional.setItemDoPedido(item);
                    if (NullUtil.isNullOrZero((Number)optional.getQuantidade())) {
                        optional.setQuantidade(Long.valueOf(1L));
                    }
                });
            }
            if (!CollectionUtils.isEmpty((Collection)item.getOpcionais()) && CollectionUtils.isEmpty((Collection)item.getValoresDasPersonalizacoes())) {
                item.setValoresDasPersonalizacoes(new HashSet());
                item.getOpcionais().forEach(optional -> item.getValoresDasPersonalizacoes().add(optional.getValorDaPersonalizacao()));
            } else if (!CollectionUtils.isEmpty((Collection)item.getValoresDasPersonalizacoes())) {
                item.setOpcionais(new HashSet());
                for (ValorDaPersonalizacao value : item.getValoresDasPersonalizacoes()) {
                    OpcionalDoItemDoPedido optional2 = new OpcionalDoItemDoPedido();
                    optional2.setItemDoPedido(item);
                    optional2.setValorDaPersonalizacao(value);
                    optional2.setQuantidade(Long.valueOf(1L));
                    item.getOpcionais().add(optional2);
                }
            }
            this.orderItemRepository.save((Object)item);
            if (stockControl.equals((Object)ControleEstoque.SEM_CONTROLE)) continue;
            EmpresaConfiguracao config = (EmpresaConfiguracao)this.companyConfigRepository.findByEmpresaIdAndConfiguracaoNome(order.getEmpresa().getId(), "config-estoque-personalizacoes").get();
            if (config.getValor().equals(ValorConfiguracaoBooleano.TRUE.getValor())) {
                this.stockManagementService.subtractCustomizationValueFromStock(item.getValoresDasPersonalizacoes(), item.getQuantidade());
                continue;
            }
            this.stockManagementService.subtractProductFromStock(item.getProduto(), item.getQuantidade());
        }
    }

    @Transactional
    private void saveOrderItensByPromotion(Pedido pedido) throws ApiException {
        for (CestaDePromocao cesta : pedido.getCestasDePromocao()) {
            cesta.setPedido(pedido);
            this.basketRepository.save((Object)cesta);
            for (ItemDoPedidoPorPromocao item : cesta.getItens()) {
                if (NullUtil.isNull((Object)item.getOpcaoQuantitativa())) {
                    item.setOpcaoQuantitativa(Boolean.valueOf(false));
                }
                item.setCesta(cesta);
                if (NullUtil.isNull((Object)item.getGratuito())) {
                    item.setGratuito(Boolean.valueOf(false));
                }
                if (NullUtil.isNull((Object)item.getOpcaoQuantitativa())) {
                    item.setOpcaoQuantitativa(Boolean.valueOf(false));
                }
                if (NullUtil.isNull((Object)item.getValor())) {
                    item.setValor(BigDecimal.ZERO);
                }
                if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                    item.setProduto(null);
                    this.composedProductRepository.save((Object)item.getProdutoComposto());
                }
                this.orderItemByPromotionRepository.save((Object)item);
                if (pedido.getEmpresa().getControleEstoque().equals((Object)ControleEstoque.SEM_CONTROLE)) continue;
                this.stockManagementService.subtractProductFromStock(item.getProduto(), Double.valueOf(item.getQuantidade().doubleValue()));
            }
        }
    }

    private Pedido populateFeedback(Pedido order) {
        Pedido feedback = new Pedido(order.getId());
        feedback.setDataHoraPedido(order.getDataHoraPedido());
        feedback.setCliente(new Cliente(order.getId()));
        feedback.getCliente().setNome(order.getCliente().getNome());
        feedback.getCliente().setTelefone(order.getCliente().getTelefone());
        feedback.setFeedback(order.getFeedback());
        feedback.setRespostaFeedback(order.getRespostaFeedback());
        feedback.setClassificacao(order.getClassificacao());
        return feedback;
    }

    private Pedido populateOrderHistory(Pedido order) {
        Pedido history = new Pedido(order.getId());
        history.setDataHoraPedido(order.getDataHoraPedido());
        history.setCliente(new Cliente(order.getId()));
        history.getCliente().setNome(order.getCliente().getNome());
        history.getCliente().setTelefone(order.getCliente().getTelefone());
        history.setTeste(order.getTeste());
        history.setRodizio(order.getRodizio());
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY) && order.getLojaDeOrigem().equals((Object)LojaDeOrigem.PEDIDO_AGORA) && NullUtil.isNotNull((Object)order.getEnderecoEntrega()) && NullUtil.isNotNull((Object)order.getEnderecoEntrega().getId())) {
            EnderecoDeEntrega address = new EnderecoDeEntrega();
            address = this.addressRepository.findById((Object)order.getEnderecoEntrega().getId()).orElse(null);
            if (NullUtil.isNotNull((Object)address)) {
                history.setEnderecoEntrega(new EnderecoDeEntrega());
                history.getEnderecoEntrega().setMunicipio(address.getMunicipio());
                history.getEnderecoEntrega().setBairro(address.getBairro());
            }
        }
        history.setTotalDoPedido(order.getTotalDoPedido());
        if (NullUtil.isNullOrZero((BigDecimal)history.getTotalDoPedido())) {
            history.setTotalDoPedido(this.calculateTotalOrderValue(order));
        }
        history.setFormaEntrega(order.getFormaEntrega());
        return history;
    }

    private Pedido populateOrderOfDay(Pedido order) {
        Pedido orderItem = new Pedido(order.getId());
        orderItem.setEmpresa(new Empresa(order.getEmpresa().getId()));
        orderItem.getEmpresa().setTokenPagSeguro(order.getEmpresa().getTokenPagSeguro());
        orderItem.getEmpresa().setEmailPagSeguro(order.getEmpresa().getEmailPagSeguro());
        orderItem.setDataAtualizacaoPedido(order.getDataAtualizacaoPedido());
        orderItem.setDataHoraPedido(order.getDataHoraPedido());
        orderItem.setFormaEntrega(order.getFormaEntrega());
        orderItem.setFormaPagamento(order.getFormaPagamento());
        orderItem.setSituacao(order.getSituacao());
        orderItem.setCliente(new Cliente());
        orderItem.getCliente().setNome(order.getCliente().getNome());
        orderItem.getCliente().setTelefone(order.getCliente().getTelefone());
        orderItem.getCliente().setUsuario(new Usuario());
        orderItem.getCliente().getUsuario().setLogin(orderItem.getCliente().getUsuario().getLogin());
        orderItem.setOrigem(order.getOrigem());
        orderItem.setTotalDoPedido(order.getTotalDoPedido());
        orderItem.setFeedback(order.getFeedback());
        orderItem.setRespostaFeedback(order.getRespostaFeedback());
        orderItem.setClassificacao(order.getClassificacao());
        orderItem.setMesa(order.getMesa());
        orderItem.setNomeClienteMesa(order.getNomeClienteMesa());
        orderItem.setTeste(order.getTeste());
        orderItem.setPedidoExcedente(order.getPedidoExcedente());
        orderItem.setClienteSemCadastro(order.getClienteSemCadastro());
        orderItem.setNomeClienteSemCadastro(order.getNomeClienteSemCadastro());
        orderItem.setTelefoneClienteSemCadastro(order.getTelefoneClienteSemCadastro());
        orderItem.setEnderecoDeEntregaClienteSemCadastro(order.getEnderecoDeEntregaClienteSemCadastro());
        if (NullUtil.isNotNull((Object)order.getTelefoneClienteExterno())) {
            orderItem.setTelefoneClienteExterno(order.getTelefoneClienteExterno());
        }
        if (NullUtil.isNotNull((Object)order.getLojaDeOrigem())) {
            orderItem.setLojaDeOrigem(order.getLojaDeOrigem());
        }
        if (NullUtil.isNotNull((Object)order.getNomeClienteExterno())) {
            orderItem.setNomeClienteExterno(order.getNomeClienteExterno());
        }
        if (NullUtil.isNotNull((Object)order.getEnderecoEntregaExterno())) {
            orderItem.setEnderecoEntregaExterno(order.getEnderecoEntregaExterno());
        }
        if (NullUtil.isNullOrZero((BigDecimal)orderItem.getTotalDoPedido())) {
            orderItem.setTotalDoPedido(this.calculateTotalOrderValue(order));
        }
        if (NullUtil.isNotNull((Object)order.getDataHoraAgendamento())) {
            orderItem.setDataHoraAgendamento(order.getDataHoraAgendamento());
        }
        if (NullUtil.isNotNull((Object)order.getDescontoExterno())) {
            orderItem.setDescontoExterno(order.getDescontoExterno());
        }
        orderItem.setClassificacao(order.getClassificacao());
        orderItem.setFeedback(order.getFeedback());
        orderItem.setFeedbackUtil(order.getFeedbackUtil());
        if (order.getRodizio().booleanValue()) {
            orderItem.setQtdeRodizioCompleto(order.getQtdeRodizioCompleto());
            orderItem.setQtdeMeioRodizio(order.getQtdeMeioRodizio());
            orderItem.setProdutoDeRodizio(order.getProdutoDeRodizio());
            orderItem.setValorRodizioCompleto(order.getValorRodizioCompleto());
            orderItem.setValorMeioRodizio(order.getValorMeioRodizio());
            orderItem.setRodizioFechado(order.getRodizioFechado());
        }
        if (NullUtil.isNotNull((Object)order.getVendedor())) {
            orderItem.setVendedor(new Usuario(order.getVendedor().getId()));
            orderItem.getVendedor().setNome(order.getVendedor().getNome());
            orderItem.getVendedor().setLogin(order.getVendedor().getLogin());
        }
        return orderItem;
    }

    private void populateOrderViewData(Long empresaId, PedidoView order) {
        order.setEmpresa(new IdView(empresaId));
        order.setCliente((ClienteView)this.repository.findCustomerByOrderId(order.getId()).orElse(null));
        if (NullUtil.isNotNull((Object)order.getCliente())) {
            order.getCliente().setUsuario((UsuarioView)this.clienteRepository.findByUserCustomerId(order.getCliente().getId()).get());
        }
        order.setEnderecoEntrega((EnderecoDeEntregaView)this.repository.findDeliveryAddressByOrderId(order.getId()).orElse(null));
        if (NullUtil.isNotNull((Object)order.getEnderecoEntrega())) {
            order.getEnderecoEntrega().setMunicipio((MunicipioView)this.addressRepository.findCityByDeliveryAddress(order.getEnderecoEntrega().getId()).get());
        }
        order.setOpcaoPagamentoCartao((OpcaoDePagamentoComCartaoView)this.repository.findCardOptionPaymentByOrderId(order.getId()).orElse(null));
        order.setProdutoDeRodizio((ProdutoView)this.repository.findProductByOrder(order.getId()).orElse(null));
        order.setVendedor((UsuarioView)this.repository.findSallerByOrderId(order.getId()).orElse(null));
        order.setCupomDeDesconto((CupomDeDescontoView)this.repository.findDiscountTicketByOrderId(order.getId()).orElse(null));
        order.setItensDoPedido(this.orderItemRepository.findViewByOrderId(order.getId()));
        order.getItensDoPedido().forEach(item -> {
            item.setProduto((ProdutoView)this.orderItemRepository.findProductByItemId(item.getId()).orElse(null));
            if (NullUtil.isNotNull((Object)item.getProduto())) {
                item.getProduto().setCategoria((CategoriaDoProdutoView)this.productRepository.findCategoryByProductId(item.getProduto().getId()).get());
            }
            item.setProdutoComposto((ProdutoCompostoView)this.orderItemRepository.findComposedProductByItemId(item.getId()).orElse(null));
            item.setOpcionais(this.orderItemRepository.findItemOptionals(item.getId()));
            item.getOpcionais().forEach(optional -> {
                optional.setItemDoPedido(new IdView(item.getId()));
                optional.setValorDaPersonalizacao((RegistroView)this.optionalRepository.findCustomizationValueByOptional(optional.getId()).get());
            });
            item.setValoresDasPersonalizacoes(this.orderItemRepository.findItemCustomizationValues(item.getId()));
            item.getValoresDasPersonalizacoes().forEach(value -> {
                value.setPersonalizacao((RegistroView)this.customizationValueRepository.findCustomizationByValueId(value.getId()).orElse(null));
                value.setPersonalizacaoDeProduto((RegistroView)this.customizationValueRepository.findCustomizationProductByValueId(value.getId()).orElse(null));
            });
        });
        order.setCestasDePromocao(this.basketRepository.findViewByOrderId(order.getId()));
        order.getCestasDePromocao().forEach(basket -> {
            basket.setPromocao((PromocaoView)this.basketRepository.findPromotionByBasketId(basket.getId()).get());
            basket.setItens(this.orderItemByPromotionRepository.findViewByBasketId(basket.getId()));
            basket.getItens().forEach(item -> {
                item.setProduto((ProdutoView)this.orderItemByPromotionRepository.findProductByItemId(item.getId()).orElse(null));
                if (NullUtil.isNotNull((Object)item.getProduto())) {
                    item.getProduto().setCategoria((CategoriaDoProdutoView)this.productRepository.findCategoryByProductId(item.getProduto().getId()).get());
                }
                item.setProdutoComposto((ProdutoCompostoView)this.orderItemByPromotionRepository.findComposedProductByItemId(item.getId()).orElse(null));
                item.setValoresDasPersonalizacoes(this.orderItemByPromotionRepository.findItemCustomizationValues(item.getId()));
                item.getValoresDasPersonalizacoes().forEach(value -> {
                    value.setPersonalizacao((RegistroView)this.customizationValueRepository.findCustomizationByValueId(value.getId()).orElse(null));
                    value.setPersonalizacaoDeProduto((RegistroView)this.customizationValueRepository.findCustomizationProductByValueId(value.getId()).orElse(null));
                });
            });
        });
    }

    private void validadeOrderCashback(Pedido order) throws ApiException {
        if (this.hasCashback(order)) {
            Cashback cashback = this.cashbackRepository.findCurrentCashback(order.getEmpresa().getId(), order.getCliente().getId()).orElse(null);
            Boolean isDebit = NullUtil.isNotNull((Object)order.getDebitoCashback()) && order.getDebitoCashback().compareTo(BigDecimal.ZERO) > 0;
            if (NullUtil.isNotNull((Object)cashback) && isDebit.booleanValue() && cashback.getCreditoDisponivel().compareTo(order.getDebitoCashback()) < -1) {
                throw new ApiException("msg.erro.152");
            }
        }
    }

    private void validateOrderItems(Pedido order) throws ApiException {
        if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
            List itemsWithMissingProducts = order.getItensDoPedido().stream().filter(item -> {
                if (NullUtil.isNull((Object)item.getProduto())) {
                    return false;
                }
                return ((Produto)this.productRepository.findById((Object)item.getProduto().getId()).get()).getEmFalta();
            }).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(itemsWithMissingProducts)) {
                throw new ApiException("msg.erro.120", new String[]{itemsWithMissingProducts.stream().map(item -> item.getProduto().getNome()).collect(Collectors.joining(", "))});
            }
            ArrayList missingCustomizationValues = new ArrayList();
            order.getItensDoPedido().stream().forEach(item -> {
                missingCustomizationValues.addAll(item.getValoresDasPersonalizacoes().stream().filter(value -> ((ValorDaPersonalizacao)this.customizationValueRepository.findById((Object)value.getId()).get()).getExcluido()).collect(Collectors.toList()));
                missingCustomizationValues.addAll(item.getValoresDasPersonalizacoes().stream().filter(value -> ((ValorDaPersonalizacao)this.customizationValueRepository.findById((Object)value.getId()).get()).getEmFalta()).collect(Collectors.toList()));
            });
            if (!CollectionUtils.isEmpty(missingCustomizationValues)) {
                throw new ApiException("msg.erro.121", new String[]{missingCustomizationValues.stream().map(item -> NullUtil.isNotNull((Object)item.getProduto()) ? item.getProduto().getDescricao() : item.getDescricao()).collect(Collectors.joining(", "))});
            }
            long unavaliableProducts = 0L;
            for (ItemDoPedido orderItem : order.getItensDoPedido()) {
                if (NullUtil.isNotNull((Object)orderItem.getProduto())) {
                    if (orderItem.getProduto().getDisponibilidades().indexOf(DateUtil.obterDiaDaSemanaCorrente().ordinal() + "") != -1) continue;
                    ++unavaliableProducts;
                    continue;
                }
                List productsIds = Arrays.asList(orderItem.getProdutoComposto().getProdutosIds().split(",")).stream().map(id -> new Long((String)id)).collect(Collectors.toList());
                unavaliableProducts = this.productRepository.findByIdIn(productsIds).stream().filter(product -> product.getDisponibilidades().indexOf(DateUtil.obterDiaDaSemanaCorrente().ordinal() + "") == -1).count();
            }
            if (unavaliableProducts > 0L) {
                throw new ApiException("msg.erro.127");
            }
            ControleEstoque stockControl = (ControleEstoque)this.companyRepository.getCompanyStockControl(order.getEmpresa().getId()).get();
            if (!stockControl.equals((Object)ControleEstoque.SEM_CONTROLE)) {
                EmpresaConfiguracao config = (EmpresaConfiguracao)this.companyConfigRepository.findByEmpresaIdAndConfiguracaoNome(order.getEmpresa().getId(), "config-estoque-personalizacoes").get();
                if (config.getValor().equals(ValorConfiguracaoBooleano.TRUE.getValor())) {
                    this.stockManagementService.validateCustomizationValueOnStock(order);
                } else {
                    this.stockManagementService.validateOrderItemsOnStock(order);
                }
            }
        }
    }

    private void validateOrderItemsByPromotion(Pedido order) throws ApiException {
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            for (CestaDePromocao cesta : order.getCestasDePromocao()) {
                Promocao promotion = (Promocao)this.promocaoRepository.findById((Object)cesta.getPromocao().getId()).get();
                if (DateUtil.pertenceAoPeriodo((Date)new Date(), (Date)promotion.getDtInicioValidade(), (Date)promotion.getDtFimValidade()).booleanValue()) continue;
                throw new ApiException("msg.erro.076", new String[]{cesta.getPromocao().getTitulo()});
            }
            ArrayList promotionItemsWithMissingProducts = new ArrayList();
            order.getCestasDePromocao().forEach(basket -> promotionItemsWithMissingProducts.addAll(basket.getItens().stream().filter(item -> {
                if (NullUtil.isNull((Object)item.getProduto())) {
                    return false;
                }
                return ((Produto)this.productRepository.findById((Object)item.getProduto().getId()).get()).getEmFalta();
            }).collect(Collectors.toList())));
            if (!CollectionUtils.isEmpty(promotionItemsWithMissingProducts)) {
                throw new ApiException("msg.erro.120", new String[]{promotionItemsWithMissingProducts.stream().map(item -> item.getProduto().getNome()).collect(Collectors.joining(", "))});
            }
            HashSet items = new HashSet();
            order.getCestasDePromocao().stream().forEach(basket -> basket.getItens().forEach(item -> items.add(item)));
            long unavaliableProducts = 0L;
            for (ItemDoPedidoPorPromocao orderItemPromotion : items) {
                if (NullUtil.isNotNull((Object)orderItemPromotion.getProduto())) {
                    if (orderItemPromotion.getProduto().getDisponibilidades().indexOf(DateUtil.obterDiaDaSemanaCorrente().ordinal() + "") != -1) continue;
                    ++unavaliableProducts;
                    continue;
                }
                List productsIds = Arrays.asList(orderItemPromotion.getProdutoComposto().getProdutosIds().split(",")).stream().map(id -> new Long((String)id)).collect(Collectors.toList());
                unavaliableProducts = this.productRepository.findByIdIn(productsIds).stream().filter(product -> product.getDisponibilidades().indexOf(DateUtil.obterDiaDaSemanaCorrente().ordinal() + "") == -1).count();
            }
            if (unavaliableProducts > 0L) {
                throw new ApiException("msg.erro.127");
            }
            ControleEstoque stockControl = (ControleEstoque)this.companyRepository.getCompanyStockControl(order.getEmpresa().getId()).get();
            if (!stockControl.equals((Object)ControleEstoque.SEM_CONTROLE)) {
                this.stockManagementService.validateProductPromotionBasketsOnStock(order);
            }
        }
    }

    private void validateLastOrder(Pedido order) throws ApiException {
        Pedido lastOrder = this.repository.findTopByClienteIdAndEmpresaIdOrderByIdDesc(order.getCliente().getId(), order.getEmpresa().getId());
        if (NullUtil.isNotNull((Object)lastOrder)) {
            boolean orderInPrePreparingStatus;
            boolean bl = orderInPrePreparingStatus = SituacaoDoPedido.listarTodos().stream().filter(status -> lastOrder.getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_CONFIRMACAO) || lastOrder.getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_PAGAMENTO) || lastOrder.getSituacao().equals((Object)SituacaoDoPedido.CONFIRMADO)).count() > 0L;
            if (!order.getCliente().getId().equals(Domains.CLIENTE_EXTERNO_ID) && orderInPrePreparingStatus && DateUtil.calcularDiferencaEntreDatasEmMinutos((Date)lastOrder.getDataAtualizacaoPedido(), (Date)new Date()) <= Domains.TEMPO_SOLICITACAO_PEDIDO) {
                throw new ApiException("msg.erro.114", new String[]{Domains.TEMPO_SOLICITACAO_PEDIDO.toString()});
            }
        }
    }

    private void validateLastGuestOrder(Pedido order) throws ApiException {
        Pedido lastOrder;
        if (NullUtil.isNotNullOrZero((Number)order.getId()) && NullUtil.isNotNull((Object)(lastOrder = (Pedido)this.repository.findById((Object)order.getId()).orElse(null)))) {
            boolean orderInPrePreparingStatus;
            boolean bl = orderInPrePreparingStatus = SituacaoDoPedido.listarTodos().stream().filter(status -> lastOrder.getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_CONFIRMACAO) || lastOrder.getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_PAGAMENTO) || lastOrder.getSituacao().equals((Object)SituacaoDoPedido.CONFIRMADO)).count() > 0L;
            if (!order.getCliente().getId().equals(Domains.CLIENTE_EXTERNO_ID) && orderInPrePreparingStatus && DateUtil.calcularDiferencaEntreDatasEmMinutos((Date)lastOrder.getDataAtualizacaoPedido(), (Date)new Date()) <= Domains.TEMPO_SOLICITACAO_PEDIDO) {
                throw new ApiException("msg.erro.114", new String[]{Domains.TEMPO_SOLICITACAO_PEDIDO.toString()});
            }
        }
    }

    private void validateOrderSchedule(Pedido order) throws ApiException {
        Empresa company = this.companyRepository.findById((Object)order.getEmpresa().getId()).orElse(null);
        EmpresaConfiguracao doesCompanySchedule = (EmpresaConfiguracao)this.companyConfigRepository.findByEmpresaIdAndConfiguracaoNome(order.getEmpresa().getId(), "config-faz-agendamento").get();
        if (NullUtil.isNull((Object)company) || !company.getAberto().booleanValue()) {
            if (doesCompanySchedule.getValor().equals("1")) {
                if (NullUtil.isNull((Object)order.getDataHoraAgendamento()) && NullUtil.isNullOrZero((Serializable)((Object)order.getMesa()))) {
                    throw new ApiException("msg.erro.108");
                }
            } else {
                throw new ApiException("msg.erro.108");
            }
        }
    }

    @Deprecated
    @Transactional
    private void updatePaymentStatus(Pedido order) throws ApiException, IOException {
        if (order.getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_PAGAMENTO)) {
            Pedido currentOrder = this.findById(order.getId());
            Pagamento payment = (Pagamento)this.paymentRepository.findByPedidoId(currentOrder.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Pagamento", "Pedido {" + currentOrder.getId() + "}"}));
            if (this.paymentService.fazPagamentoViaPagSeguro(currentOrder.getEmpresa()).booleanValue()) {
                TransactionDetail transaction = this.pagSeguroService.findTransactionByPayment(currentOrder.getEmpresa(), payment.getCodigoTransacao());
                if (transaction.getStatus().getStatus().equals((Object)TransactionStatus.Status.APPROVED)) {
                    payment.setStatus(StatusDaTransacao.APROVADO);
                    currentOrder.setSituacao(SituacaoDoPedido.CONFIRMADO);
                }
                if (transaction.getStatus().getStatus().equals((Object)TransactionStatus.Status.CANCELLED) || transaction.getStatus().getStatus().equals((Object)TransactionStatus.Status.RETURNED)) {
                    payment.setStatus(StatusDaTransacao.get((int)transaction.getStatus().getStatusId()));
                    currentOrder.setSituacao(SituacaoDoPedido.PAGAMENTO_RECUSADO);
                }
            } else {
                int status = this.cieloService.getTransactionStatus(payment.getCodigoTransacao());
                if (status == StatusDaTransacaoCielo.PAYMENT_CONFIRMED.getStatus()) {
                    payment.setStatus(StatusDaTransacao.APROVADO);
                    currentOrder.setSituacao(SituacaoDoPedido.CONFIRMADO);
                }
                if (status == StatusDaTransacaoCielo.DENIED.getStatus() || status == StatusDaTransacaoCielo.VOIDED.getStatus() || status == StatusDaTransacaoCielo.REFUNDED.getStatus() || status == StatusDaTransacaoCielo.ABORTED.getStatus()) {
                    payment.setStatus(StatusDaTransacao.CANCELADO);
                    currentOrder.setSituacao(SituacaoDoPedido.PAGAMENTO_RECUSADO);
                }
            }
            this.paymentRepository.save((Object)payment);
            this.repository.save((Object)currentOrder);
        }
    }

    @Transactional
    public void toggleImported(Long id) throws ApiException {
        Pedido edit;
        edit.setImportado(Boolean.valueOf((edit = (Pedido)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Pedido", id.toString()}))).getImportado() == false));
        this.repository.save((Object)edit);
    }

    @Transactional
    public void toggleTestMode(Long id) throws ApiException {
        Pedido edit;
        edit.setTeste(Boolean.valueOf((edit = (Pedido)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Pedido", id.toString()}))).getTeste() == false));
        this.repository.save((Object)edit);
    }
}

