/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.Parcelamento;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.ParcelamentoRepository;
import com.escolpi.omni.api.util.NullUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ParcelamentoService {
    @Autowired
    private EmpresaRepository companyRepository;
    @Autowired
    private ParcelamentoRepository repository;

    @Transactional
    public void delete(Long id) throws ApiException {
        Parcelamento entity = (Parcelamento)this.repository.findById((Object)id).get();
        entity.setExcluido(Boolean.valueOf(true));
        this.repository.save((Object)entity);
    }

    public Parcelamento get(Long id) throws ApiException {
        return (Parcelamento)this.repository.findById((Object)id).get();
    }

    public List<Parcelamento> list(Long companyId) throws ApiException {
        return this.repository.findByEmpresaIdAndExcluidoIsFalseOrderByNumero(companyId);
    }

    @Transactional
    public void save(Long empresaId, Parcelamento entity) throws ApiException {
        this.validate(entity);
        if (NullUtil.isNotNullOrZero((Number)entity.getId())) {
            Parcelamento edit = (Parcelamento)this.repository.findById((Object)entity.getId()).get();
            edit.setNumero(entity.getNumero());
            edit.setTaxa(entity.getTaxa());
            this.repository.save((Object)edit);
        } else {
            entity.setExcluido(Boolean.valueOf(false));
            entity.setEmpresa((Empresa)this.companyRepository.findById((Object)entity.getEmpresa().getId()).get());
            this.repository.save((Object)entity);
        }
    }

    private void validate(Parcelamento entity) throws ApiException {
        if (NullUtil.isNotNullOrZero((Number)entity.getId()) && this.repository.countByNumeroAndEmpresaIdAndIdNotAndExcluidoIsFalse(entity.getNumero(), entity.getId(), entity.getEmpresa().getId()) > 0L) {
            throw new ApiException("erro.entidade.existente.f", new String[]{"Parcela"});
        }
        if (this.repository.countByNumeroAndEmpresaIdAndExcluidoIsFalse(entity.getNumero(), entity.getEmpresa().getId()) > 0L) {
            throw new ApiException("erro.entidade.existente.f", new String[]{"Parcela"});
        }
        if (NullUtil.isNull((Object)entity.getEmpresa())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (NullUtil.isNullOrZero((Number)entity.getNumero())) {
            throw new ApiException("msg.erro.001", new String[]{"N\u00famero da Parcela"});
        }
    }
}

