/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import br.com.uol.pagseguro.api.PagSeguro;
import br.com.uol.pagseguro.api.PagSeguroEnv;
import br.com.uol.pagseguro.api.common.domain.Address;
import br.com.uol.pagseguro.api.common.domain.CreditCard;
import br.com.uol.pagseguro.api.common.domain.Document;
import br.com.uol.pagseguro.api.common.domain.Holder;
import br.com.uol.pagseguro.api.common.domain.Installment;
import br.com.uol.pagseguro.api.common.domain.PaymentItem;
import br.com.uol.pagseguro.api.common.domain.Phone;
import br.com.uol.pagseguro.api.common.domain.Sender;
import br.com.uol.pagseguro.api.common.domain.Shipping;
import br.com.uol.pagseguro.api.common.domain.ShippingType;
import br.com.uol.pagseguro.api.common.domain.TransactionStatus;
import br.com.uol.pagseguro.api.common.domain.builder.AddressBuilder;
import br.com.uol.pagseguro.api.common.domain.builder.CreditCardBuilder;
import br.com.uol.pagseguro.api.common.domain.builder.DocumentBuilder;
import br.com.uol.pagseguro.api.common.domain.builder.HolderBuilder;
import br.com.uol.pagseguro.api.common.domain.builder.InstallmentBuilder;
import br.com.uol.pagseguro.api.common.domain.builder.PaymentItemBuilder;
import br.com.uol.pagseguro.api.common.domain.builder.PhoneBuilder;
import br.com.uol.pagseguro.api.common.domain.builder.SenderBuilder;
import br.com.uol.pagseguro.api.common.domain.builder.ShippingBuilder;
import br.com.uol.pagseguro.api.common.domain.enums.Currency;
import br.com.uol.pagseguro.api.common.domain.enums.DocumentType;
import br.com.uol.pagseguro.api.credential.Credential;
import br.com.uol.pagseguro.api.http.HttpClient;
import br.com.uol.pagseguro.api.http.JSEHttpClient;
import br.com.uol.pagseguro.api.session.CreatedSession;
import br.com.uol.pagseguro.api.transaction.register.DirectPaymentRegistration;
import br.com.uol.pagseguro.api.transaction.register.DirectPaymentRegistrationBuilder;
import br.com.uol.pagseguro.api.transaction.search.TransactionDetail;
import br.com.uol.pagseguro.api.utils.logging.CommonsLoggerFactory;
import br.com.uol.pagseguro.api.utils.logging.LoggerFactory;
import com.escolpi.omni.api.enumeration.FormaDeEntrega;
import com.escolpi.omni.api.enumeration.FusoHorario;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.enumeration.ProvedorDePagamento;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.EnderecoDeEntrega;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.service.EnderecoDeEntregaService;
import com.escolpi.omni.api.service.LogDeErroService;
import com.escolpi.omni.api.service.LogDePagamentoService;
import com.escolpi.omni.api.service.PagamentoService;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.HttpClientErrorException;

@Service
public class PagSeguroService {
    @Autowired
    private EmpresaRepository empresaRepository;
    @Autowired
    private LogDeErroService logDeErroService;
    @Autowired
    private LogDePagamentoService logDePagamentoService;
    @Autowired
    private EnderecoDeEntregaService enderecoService;
    @Autowired
    private PagamentoService pagamentoService;

    public CreatedSession createSession(Long empresaId) throws ApiException {
        return this.getInstance(empresaId).sessions().create();
    }

    public PagSeguroEnv getEnviroment() {
        return PagSeguroEnv.PRODUCTION;
    }

    public TransactionStatus.Status getTransactionStatus(Empresa company, String transactionCode) throws ApiException {
        return this.findTransactionByPayment(company, transactionCode).getStatus().getStatus();
    }

    @Transactional
    public String processPayment(Long empresaId, Pedido order) throws ApiException {
        Empresa empresa = (Empresa)this.empresaRepository.findById((Object)empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", empresaId.toString()}));
        TransactionDetail creditCardTransaction = null;
        try {
            creditCardTransaction = this.getInstance(empresaId).transactions().register(this.buildDirectPaymentRegistration(order, empresa)).withCreditCard(this.buildCreditCard(order));
        }
        catch (HttpClientErrorException e) {
            this.logDeErroService.save(order.getEmpresa().getId(), Operacao.PAGAMENTO_ONLINE_PAGSEGURO, new Integer(e.getStatusCode().value()).toString(), e.getMessage());
            throw new ApiException("msg.confirm.036");
        }
        this.logDePagamentoService.savePaymentLog(order, creditCardTransaction.getCode(), creditCardTransaction.getStatus().getStatusId(), ProvedorDePagamento.PAG_SEGURO);
        return creditCardTransaction.getCode();
    }

    @Transactional
    public void savePayment(Pedido order, String transactionCode) throws ApiException {
        TransactionDetail transaction = this.findTransactionByPayment(order.getEmpresa(), transactionCode);
        this.pagamentoService.save(order, transaction);
    }

    private CreditCard buildCreditCard(Pedido order) throws ApiException {
        return new CreditCardBuilder().withBillingAddress(this.buildDeliveryAddress(order)).withInstallment(this.buildInstallment(order)).withHolder(this.buildHolder(order)).withToken(order.getCartaoDoCliente().getTokenDoCartao()).build();
    }

    private Holder buildHolder(Pedido order) {
        return new HolderBuilder().withName(order.getCartaoDoCliente().getTitular()).withBithDate(order.getCliente().getDataNascimento()).withPhone(this.buildCustomerPhone(order)).addDocument(this.buildDocument(order)).build();
    }

    private Phone buildCustomerPhone(Pedido order) {
        return new PhoneBuilder().withAreaCode(order.getCliente().getTelefone().substring(0, 2)).withNumber(order.getCliente().getTelefone().substring(2, order.getCliente().getTelefone().length())).build();
    }

    private Address buildDeliveryAddress(Pedido order) throws ApiException {
        EnderecoDeEntrega mainAddress;
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            mainAddress = order.getEnderecoEntrega();
        } else {
            mainAddress = this.enderecoService.getMainDeliveryAddressOrFirst(order.getCliente().getId());
            if (NullUtil.isNull((Object)mainAddress)) {
                mainAddress = this.enderecoService.obterUltimoEnderecoRegistroPorCliente(order.getCliente().getId());
            }
        }
        AddressBuilder address = new AddressBuilder().withStreet(StringUtil.encodeToIso88591((String)mainAddress.getLogradouro())).withNumber(mainAddress.getNumero()).withDistrict(StringUtil.encodeToIso88591((String)mainAddress.getBairro())).withCity(StringUtil.encodeToIso88591((String)mainAddress.getMunicipio().getNome())).withState(mainAddress.getMunicipio().getUf()).withCountry("BRA").withPostalCode(mainAddress.getCep());
        if (StringUtil.isNotBlank((String)mainAddress.getComplemento())) {
            address.withComplement(StringUtil.encodeToIso88591((String)mainAddress.getComplemento()));
        }
        return address.build();
    }

    private DirectPaymentRegistration buildDirectPaymentRegistration(Pedido order, Empresa empresa) throws ApiException {
        DirectPaymentRegistrationBuilder paymentRegistration = new DirectPaymentRegistrationBuilder().withPaymentMode("default").withReference(this.generateReference(empresa)).withExtraAmount(BigDecimal.ZERO).withCurrency(Currency.BRL).withSender(this.buildSender(order)).withShipping(this.buildShipping(order)).addItem(this.buildPaymentItem(order));
        return paymentRegistration.build();
    }

    private Document buildDocument(Pedido order) {
        return new DocumentBuilder().withType(DocumentType.CPF).withValue(StringUtil.removerMascara((String)order.getCartaoDoCliente().getCpf())).build();
    }

    private Installment buildInstallment(Pedido order) {
        if (NullUtil.isNullOrZero((Number)order.getParcelas())) {
            order.setParcelas(Integer.valueOf(1));
        }
        return new InstallmentBuilder().withNoInterestInstallmentQuantity(Integer.valueOf(order.getParcelas() == 1 ? 2 : order.getParcelas())).withQuantity(order.getParcelas()).withValue(order.getTotalDoPedido().divide(new BigDecimal(order.getParcelas()))).build();
    }

    private PaymentItem buildPaymentItem(Pedido order) {
        return new PaymentItemBuilder().withId(String.format("PDA-%s", Calendar.getInstance().getTimeInMillis())).withDescription(StringUtil.encodeToIso88591((String)String.format("Pedido de Cliente %s - %s", order.getCliente().getNome(), DateUtil.format((String)"dd/MM/yyyy '\u00e0s' HH:mm", (Date)new Date())))).withAmount(order.getTotalDoPedido()).withQuantity(1).build();
    }

    private Shipping buildShipping(Pedido order) throws ApiException {
        Shipping shipping = new ShippingBuilder().withAddress(this.buildDeliveryAddress(order)).withType(ShippingType.Type.USER_CHOISE).build();
        return shipping;
    }

    private Sender buildSender(Pedido order) {
        String customerEmail = order.getCliente().getUsuario().getLogin();
        if (this.getEnviroment().equals((Object)PagSeguroEnv.SANDBOX)) {
            customerEmail = "c53890433466658439924@sandbox.pagseguro.com.br";
        }
        return new SenderBuilder().withHash(order.getCartaoDoCliente().getHashDoComprador()).withName(StringUtil.encodeToIso88591((String)order.getCartaoDoCliente().getTitular())).withEmail(customerEmail).withPhone(this.buildCustomerPhone(order)).withCPF(StringUtil.removerMascara((String)order.getCartaoDoCliente().getCpf())).build();
    }

    private Credential getCredential(Empresa empresa) throws ApiException {
        Credential credential = Credential.sellerCredential((String)empresa.getEmailPagSeguro(), (String)empresa.getTokenPagSeguro());
        return credential;
    }

    private String generateReference(Empresa empresa) {
        return String.format("PDAG%s%s", empresa.getId(), DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario()).getTime());
    }

    private PagSeguro getInstance(Long empresaId) throws ApiException {
        Empresa empresa = (Empresa)this.empresaRepository.findById((Object)empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", empresaId.toString()}));
        return PagSeguro.instance((LoggerFactory)new CommonsLoggerFactory(), (HttpClient)new JSEHttpClient(), (Credential)this.getCredential(empresa), (PagSeguroEnv)this.getEnviroment());
    }

    public TransactionDetail findTransactionByPayment(Empresa company, String transactionCode) throws ApiException {
        return this.getInstance(company.getId()).transactions().search().byCode(transactionCode);
    }
}

