/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.OpcaoDePagamentoComCartao;
import com.escolpi.omni.api.model.specification.builder.OpcaoDePagamentoComCartaoSpecificationBuilder;
import com.escolpi.omni.api.repository.OpcaoDePagamentoComCartaoRepository;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.NullUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OpcaoDePagamentoComCartaoService
implements BaseCrudService<OpcaoDePagamentoComCartao, Long> {
    @Autowired
    private OpcaoDePagamentoComCartaoRepository repository;

    @Transactional
    public void delete(Long id) throws ApiException {
        try {
            OpcaoDePagamentoComCartao paymentOption = this.findById(id);
            paymentOption.setExcluida(Boolean.valueOf(true));
            this.repository.save((Object)paymentOption);
        }
        catch (Exception e) {
            throw new ApiException("msg.erro.048", new String[]{"Op\u00e7\u00e3o de Pagamento com Cart\u00e3o", "Pedido"});
        }
    }

    public Page<OpcaoDePagamentoComCartao> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        OpcaoDePagamentoComCartaoSpecificationBuilder builder = new OpcaoDePagamentoComCartaoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.repository.findAll(spec, (Pageable)pageable);
    }

    public List<OpcaoDePagamentoComCartao> findAll(Long empresaId) {
        return this.repository.findByEmpresaIdAndExcluidaIsFalse(empresaId);
    }

    public OpcaoDePagamentoComCartao findById(Long id) throws ApiException {
        return (OpcaoDePagamentoComCartao)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Op\u00e7\u00e3o de Pagamento com Cart\u00e3o", id.toString()}));
    }

    public OpcaoDePagamentoComCartao findById(Long id, Long empresaId) throws ApiException {
        OpcaoDePagamentoComCartao paymentOption = (OpcaoDePagamentoComCartao)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Op\u00e7\u00e3o de Pagamento com Cart\u00e3o", id.toString()}));
        if (paymentOption.getExcluida().booleanValue()) {
            throw new ApiException("erro.entidade.nao.encontrada", new String[]{"Op\u00e7\u00e3o de Pagamento com Cart\u00e3o", paymentOption.getId().toString()});
        }
        if (!paymentOption.getEmpresa().getId().equals(empresaId)) {
            throw new ApiException("erro.nao.vinculada", new String[]{Entidade.OPCAO_DE_PAGAMENTO_COM_CARTAO.getDescricao()});
        }
        return paymentOption;
    }

    @Transactional
    public void save(OpcaoDePagamentoComCartao paymentOption) throws ApiException {
        this.validate(paymentOption);
        if (NullUtil.isNotNull((Object)paymentOption.getId())) {
            OpcaoDePagamentoComCartao edicao = this.findById(paymentOption.getId());
            edicao.setDescricao(paymentOption.getDescricao());
            edicao.setEmpresa(paymentOption.getEmpresa());
            edicao.setFuncao(paymentOption.getFuncao());
            edicao.setExclusivoDoVendedor(Boolean.valueOf(NullUtil.isNull((Object)paymentOption.getExclusivoDoVendedor()) ? false : paymentOption.getExclusivoDoVendedor()));
            edicao.setTemDetalhes(Boolean.valueOf(NullUtil.isNull((Object)paymentOption.getTemDetalhes()) ? false : paymentOption.getTemDetalhes()));
            edicao.setDescontoAplicado(paymentOption.getDescontoAplicado());
            this.repository.save((Object)edicao);
            return;
        }
        paymentOption.setExcluida(Boolean.valueOf(false));
        this.repository.save((Object)paymentOption);
    }

    public void validate(OpcaoDePagamentoComCartao opcao) throws ApiException {
        if (NullUtil.isNull((Object)opcao)) {
            throw new ApiException("msg.erro.001", new String[]{"Op\u00e7\u00e3o de Pagamento com Cart\u00e3o"});
        }
        if (NullUtil.isNull((Object)opcao.getDescricao())) {
            throw new ApiException("msg.erro.001", new String[]{"Descri\u00e7\u00e3o"});
        }
        if (NullUtil.isNull((Object)opcao.getEmpresa())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (NullUtil.isNull((Object)opcao.getEmpresa().getId())) {
            throw new ApiException("msg.erro.001", new String[]{"ID da Empresa"});
        }
        if (NullUtil.isNull((Object)opcao.getFuncao())) {
            throw new ApiException("msg.erro.001", new String[]{"Fun\u00e7\u00e3o"});
        }
        if (NullUtil.isNotNullOrZero((Number)opcao.getId()) ? this.repository.countByDescricaoAndFuncaoAndIdNotAndEmpresaIdAndExcluidaIsFalse(opcao.getDescricao(), opcao.getFuncao(), opcao.getId(), opcao.getEmpresa().getId()) > 0L : this.repository.countByDescricaoAndFuncaoAndEmpresaIdAndExcluidaIsFalse(opcao.getDescricao(), opcao.getFuncao(), opcao.getEmpresa().getId()) > 0L) {
            throw new ApiException("erro.entidade.existente.f", new String[]{"Op\u00e7\u00e3o de Pagamento com Cart\u00e3o"});
        }
    }
}

