/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.LogDeAcesso;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.LogDeAcessoRepository;
import com.escolpi.omni.api.util.NullUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogDeAcessoService {
    @Autowired
    private EmpresaRepository empresaRepository;
    @Autowired
    private LogDeAcessoRepository repository;

    @Transactional
    public void save(Long empresaId, Entidade entidade, Operacao operacao, String mensagem) throws ApiException {
        LogDeAcesso log = new LogDeAcesso();
        Empresa empresa = (Empresa)this.empresaRepository.findById((Object)empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", empresaId.toString()}));
        log.setEmpresa(empresa);
        log.setUsuario(empresa.getUsuario());
        log.setEntidade(entidade);
        log.setOperacao(operacao);
        log.setMensagem(mensagem);
        this.validate(log);
        this.repository.save((Object)log);
    }

    public void validate(LogDeAcesso log) throws ApiException {
        if (NullUtil.isNull((Object)log)) {
            throw new ApiException("msg.erro.001", new String[]{"Log de Acesso"});
        }
        if (NullUtil.isNull((Object)log.getEmpresa())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (NullUtil.isNull((Object)log.getUsuario())) {
            throw new ApiException("msg.erro.001", new String[]{"Usu\u00e1rio"});
        }
        if (NullUtil.isNull((Object)log.getDataHora())) {
            throw new ApiException("msg.erro.001", new String[]{"Data e Hora"});
        }
        if (NullUtil.isNull((Object)log.getOperacao())) {
            throw new ApiException("msg.erro.001", new String[]{"Opera\u00e7\u00e3o"});
        }
        if (NullUtil.isNull((Object)log.getEntidade())) {
            throw new ApiException("msg.erro.001", new String[]{"Entidade"});
        }
    }
}

