/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.FusoHorario;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CategoriaDoProduto;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.repository.CategoriaDoProdutoRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.ProdutoRepository;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IntegracaoExternaService {
    @Autowired
    private CategoriaDoProdutoRepository categoryRepository;
    @Autowired
    private EmpresaRepository companyRepository;
    @Autowired
    private ProdutoRepository productRepository;

    @Transactional
    public void manageProduct(Produto product, String token) throws ApiException {
        Empresa company = (Empresa)this.companyRepository.findByFcmTokenServidor(token).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", product.getEmpresa().getId().toString()}));
        List products = this.productRepository.findByEmpresaIdAndCodigoAtosAndExcluidoIsFalse(company.getId(), product.getCodigoAtos());
        if (this.isValid(product, Boolean.valueOf(products.size() == 0))) {
            if (products.size() == 0) {
                CategoriaDoProduto category = (CategoriaDoProduto)this.categoryRepository.findByDescricaoAndExcluidaIsFalse(company.getId(), product.getCategoria().getDescricao()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Categoria do Produto", company.getId().toString()}));
                if (!category.getEmpresa().equals(company.getId())) {
                    throw new ApiException("erro.nao.vinculada", new String[]{"Categoria do Produto"});
                }
                product.setEmpresa(company);
                product.setCategoria(category);
                product.setDisponibilidades("1,2,3,4,5,6,7");
                product.setEmFalta(NullUtil.isNull((Object)product.getEmFalta()) ? Boolean.FALSE : product.getEmFalta());
                product.setVendaPorFracao(NullUtil.isNull((Object)product.getVendaPorFracao()) ? Boolean.FALSE : product.getVendaPorFracao());
                product.setVendaPorTamanho(NullUtil.isNull((Object)product.getVendaPorTamanho()) ? Boolean.FALSE : product.getVendaPorTamanho());
                product.setDataHoraUltimaAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)company.getFusoHorario()));
                product.setExcluido(Boolean.FALSE);
                if (StringUtil.isNotBlank((String)product.getCaminhoFoto())) {
                    product.setCaminhoFoto(product.getCaminhoFoto());
                    product.setFotoExterna(Boolean.valueOf(true));
                } else {
                    product.setFotoExterna(Boolean.valueOf(false));
                }
                this.productRepository.save((Object)product);
            } else {
                CategoriaDoProduto category = null;
                if (NullUtil.isNotNull((Object)product.getCategoria()) && NullUtil.isNotNull((Object)product.getCategoria().getDescricao())) {
                    category = this.categoryRepository.findByDescricaoAndExcluidaIsFalse(company.getId(), product.getCategoria().getDescricao()).orElse(null);
                }
                for (Produto edit : products) {
                    if (NullUtil.isNotNull((Object)product.getCategoria()) && StringUtil.isNotBlank((String)product.getCategoria().getDescricao())) {
                        if (NullUtil.isNotNull((Object)category) && !category.getEmpresa().equals(company.getId())) {
                            throw new ApiException("erro.nao.vinculada", new String[]{"Categoria do Produto"});
                        }
                        edit.setCategoria(category);
                    }
                    edit.setDataHoraUltimaAtualizacao(new Date());
                    edit.setDescricao(product.getDescricao());
                    if (StringUtil.isNotBlank((String)product.getNome())) {
                        edit.setNome(product.getNome());
                    }
                    if (NullUtil.isNotNull((Object)product.getValor())) {
                        edit.setValor(product.getValor());
                    }
                    if (NullUtil.isNotNull((Object)product.getEmFalta())) {
                        edit.setEmFalta(product.getEmFalta());
                    }
                    if (StringUtil.isNotBlank((String)product.getCaminhoFoto())) {
                        edit.setCaminhoFoto(product.getCaminhoFoto());
                        edit.setFotoExterna(Boolean.valueOf(true));
                    } else {
                        edit.setFotoExterna(Boolean.valueOf(false));
                        edit.setCaminhoFoto(null);
                    }
                    this.productRepository.save((Object)edit);
                }
            }
        }
    }

    @Transactional
    private boolean isValid(Produto product, Boolean validateCategory) throws ApiException {
        if (NullUtil.isNull((Object)product)) {
            throw new ApiException("msg.erro.001", new String[]{"Produto"});
        }
        if (StringUtil.isBlank((String)product.getNome())) {
            throw new ApiException("msg.erro.001", new String[]{"Nome do Produto"});
        }
        if (StringUtil.isBlank((String)product.getCodigoAtos())) {
            throw new ApiException("msg.erro.001", new String[]{"C\u00f3digo do Produto"});
        }
        if (NullUtil.isNull((Object)product.getValor())) {
            throw new ApiException("msg.erro.001", new String[]{"Valor do Produto"});
        }
        if (NullUtil.isNull((Object)product.getEmFalta())) {
            throw new ApiException("msg.erro.001", new String[]{"Disponibilidade do Produto"});
        }
        if (validateCategory.booleanValue() && (NullUtil.isNull((Object)product.getCategoria()) || NullUtil.isNullOrZero((Serializable)((Object)product.getCategoria().getDescricao())))) {
            throw new ApiException("msg.erro.001", new String[]{"Categoria do Produto"});
        }
        return true;
    }
}

