/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.TipoValorConfiguracao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.EmpresaConfiguracao;
import com.escolpi.omni.api.model.entity.dto.EmpresaConfiguracaoDto;
import com.escolpi.omni.api.repository.ConfiguracaoRepository;
import com.escolpi.omni.api.repository.EmpresaConfiguracaoRepository;
import com.escolpi.omni.api.service.FileService;
import com.escolpi.omni.api.util.FileUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EmpresaConfiguracaoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmpresaConfiguracaoService.class);
    @Autowired
    ConfiguracaoRepository configuracaoRepository;
    @Autowired
    EmpresaConfiguracaoRepository empresaConfiguracaoRepository;
    @Autowired
    FileService fileService;

    public EmpresaConfiguracao findByEmpresaIdAndName(Long empresaId, String nome) throws ApiException {
        EmpresaConfiguracao configuracao = (EmpresaConfiguracao)this.empresaConfiguracaoRepository.findByEmpresaIdAndConfiguracaoNome(empresaId, nome).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Configura\u00e7\u00e3o da Empresa", empresaId.toString()}));
        if (StringUtil.isBlank((String)configuracao.getValor())) {
            configuracao.setValor(configuracao.getConfiguracao().getValorPadrao());
        }
        return configuracao;
    }

    public List<EmpresaConfiguracaoDto> obterConfiguracoes(Long empresaId) throws ApiException {
        List configuracoes = this.empresaConfiguracaoRepository.findByEmpresaId(empresaId);
        configuracoes.forEach(configuracao -> {
            if (NullUtil.isNull((Object)configuracao.getValor())) {
                configuracao.setValor(configuracao.getConfiguracao().getValorPadrao());
            }
        });
        if (CollectionUtils.isEmpty((Collection)configuracoes)) {
            throw new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa"});
        }
        return configuracoes.stream().map(config -> this.converterParaDto(config)).collect(Collectors.toList());
    }

    private EmpresaConfiguracaoDto converterParaDto(EmpresaConfiguracao empresaConfiguracao) {
        EmpresaConfiguracaoDto dto = new EmpresaConfiguracaoDto();
        dto.setId(empresaConfiguracao.getId());
        dto.setNome(empresaConfiguracao.getConfiguracao().getNome());
        dto.setDescricao(empresaConfiguracao.getConfiguracao().getDescricao());
        if (empresaConfiguracao.getConfiguracao().getTipoValor().equals((Object)TipoValorConfiguracao.IMAGEM)) {
            try {
                String valor = StringUtil.isNotBlank((String)empresaConfiguracao.getValor()) ? empresaConfiguracao.getValor() : empresaConfiguracao.getConfiguracao().getValorPadrao();
                File imagem = null;
                if (!StringUtil.isBlank((String)empresaConfiguracao.getValor())) {
                    String pathEmpresa = this.fileService.getCompanyPath(empresaConfiguracao.getEmpresa().getId().toString(), null, Boolean.valueOf(true));
                    if (StringUtil.isNotBlank((String)pathEmpresa)) {
                        imagem = this.fileService.getFile(pathEmpresa + File.separator + valor);
                    }
                } else {
                    imagem = this.fileService.getFile(this.fileService.getRootPath().concat(File.separator).concat(valor));
                }
                dto.setValor(NullUtil.isNotNull((Object)imagem) ? FileUtil.encodeToBase64((File)imagem) : null);
            }
            catch (ApiException e) {
                LOGGER.error(e.getMessage());
            }
        } else {
            dto.setValor(StringUtil.isNotBlank((String)empresaConfiguracao.getValor()) ? empresaConfiguracao.getValor() : empresaConfiguracao.getConfiguracao().getValorPadrao());
        }
        return dto;
    }
}

