/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Configuracao;
import com.escolpi.omni.api.model.entity.EmpresaConfiguracao;
import com.escolpi.omni.api.repository.ConfiguracaoRepository;
import com.escolpi.omni.api.repository.EmpresaConfiguracaoRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConfiguracaoService {
    @Autowired
    private ConfiguracaoRepository repository;
    @Autowired
    private EmpresaRepository companyRepository;
    @Autowired
    private EmpresaConfiguracaoRepository companyConfigRepository;

    public Configuracao findById(Long id) throws ApiException {
        return (Configuracao)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Configura\u00e7\u00e3o", id.toString()}));
    }

    @Transactional
    public void save(Configuracao config) throws ApiException {
        this.validateConfig(config);
        if (NullUtil.isNotNullOrZero((Number)config.getId())) {
            Configuracao edit = (Configuracao)this.repository.findById((Object)config.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Configura\u00e7\u00e3o", config.getId().toString()}));
            edit.setNome(config.getNome());
            edit.setDescricao(config.getDescricao());
            edit.setTipoValor(config.getTipoValor());
            edit.setValorPadrao(config.getValorPadrao());
            this.repository.save((Object)edit);
            return;
        }
        this.repository.save((Object)config);
        this.applyNewConfigToCompanies(config);
    }

    @Transactional
    private void applyNewConfigToCompanies(Configuracao config) {
        List companies = this.companyRepository.findAll();
        companies.forEach(company -> {
            EmpresaConfiguracao cfr_ignored_0 = (EmpresaConfiguracao)this.companyConfigRepository.save((Object)new EmpresaConfiguracao(company, config));
        });
    }

    private void validateConfig(Configuracao config) throws ApiException {
        if (StringUtil.isBlank((String)config.getNome())) {
            throw new ApiException("msg.erro.001", new String[]{"Nome"});
        }
        if (StringUtil.isBlank((String)config.getDescricao())) {
            throw new ApiException("msg.erro.001", new String[]{"Descri\u00e7\u00e3o"});
        }
        if (StringUtil.isBlank((String)config.getValorPadrao())) {
            throw new ApiException("msg.erro.001", new String[]{"Valor Padr\u00e3o"});
        }
        if (NullUtil.isNull((Object)config.getTipoValor())) {
            throw new ApiException("msg.erro.001", new String[]{"Tipo de Valor"});
        }
    }

    public List<EmpresaConfiguracao> findByCompanyIdAndConfigName(Long companyId, String configName) {
        return this.companyConfigRepository.findByCompanyIdAndConfigName(companyId, configName);
    }
}

