/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.domain.Domains;
import com.escolpi.omni.api.enumeration.FusoHorario;
import com.escolpi.omni.api.enumeration.TipoPessoa;
import com.escolpi.omni.api.enumeration.ValorConfiguracaoBooleano;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CancelamentoDaConta;
import com.escolpi.omni.api.model.entity.CartaoDoCliente;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.EmpresaConfiguracao;
import com.escolpi.omni.api.model.entity.EnderecoDeEntrega;
import com.escolpi.omni.api.model.entity.Municipio;
import com.escolpi.omni.api.model.entity.Perfil;
import com.escolpi.omni.api.model.entity.SolicitacaoDeAtivacao;
import com.escolpi.omni.api.model.entity.SolicitacaoDePagamento;
import com.escolpi.omni.api.model.entity.Token;
import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.model.entity.dto.ClienteDto;
import com.escolpi.omni.api.model.projection.UsuarioView;
import com.escolpi.omni.api.model.specification.builder.ClienteSpecificationBuilder;
import com.escolpi.omni.api.repository.CancelamentoDaContaRepository;
import com.escolpi.omni.api.repository.CartaoDoClienteRepository;
import com.escolpi.omni.api.repository.ClienteRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.EnderecoDeEntregaRepository;
import com.escolpi.omni.api.repository.MunicipioRepository;
import com.escolpi.omni.api.repository.PerfilRepository;
import com.escolpi.omni.api.repository.SolicitacaoDeAtivacaoRepository;
import com.escolpi.omni.api.repository.SolicitacaoDePagamentoRepository;
import com.escolpi.omni.api.repository.UsuarioRepository;
import com.escolpi.omni.api.service.EmailService;
import com.escolpi.omni.api.service.EmpresaConfiguracaoService;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.FileService;
import com.escolpi.omni.api.service.TokenService;
import com.escolpi.omni.api.service.UsuarioService;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.CryptUtil;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.NumberUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.hibernate.Hibernate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ClienteService
implements BaseCrudService<Cliente, Long> {
    @Autowired
    private BCryptPasswordEncoder encoder;
    @Autowired
    private ClienteRepository repository;
    @Autowired
    private CancelamentoDaContaRepository accountCancelmentRepository;
    @Autowired
    private SolicitacaoDeAtivacaoRepository activationRequestRepository;
    @Autowired
    private MunicipioRepository cityRepository;
    @Autowired
    private EmpresaRepository companyRepository;
    @Autowired
    private CartaoDoClienteRepository customerCardRepository;
    @Autowired
    private EnderecoDeEntregaRepository deliveryAddressRepository;
    @Autowired
    private PerfilRepository profileRepository;
    @Autowired
    private UsuarioRepository userRepository;
    @Autowired
    private EmpresaService companyService;
    @Autowired
    private EmpresaConfiguracaoService companyConfigService;
    @Autowired
    private TokenService fcmTokenService;
    @Autowired
    private FileService fileService;
    @Autowired
    private SolicitacaoDePagamentoRepository requestPaymentRepository;
    @Autowired
    private UsuarioService userService;
    private static final String ACTIVATION_ACCOUNT_SUBJECT = "Ativa\u00e7\u00e3o de Conta";
    private static final String REACTIVATION_ACCOUNT_SUBJECT = "Reativa\u00e7\u00e3o de Conta";

    @Transactional
    public boolean activateAccount(Long empresaId, String email, Integer numeroAutenticacao) throws ApiException {
        SolicitacaoDeAtivacao solicitacao = this.getNewAccountActivationRequest(empresaId, email);
        if (NullUtil.isNotNull((Object)solicitacao) && numeroAutenticacao.equals(solicitacao.getNumeroAutenticacao())) {
            solicitacao.setEncerrada(Boolean.valueOf(true));
            this.activationRequestRepository.save((Object)solicitacao);
            Cliente cliente = (Cliente)this.repository.findByUsuarioLoginAndEmpresaId(email, empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", email}));
            Empresa empresa = (Empresa)this.companyRepository.findById((Object)empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", empresaId.toString()}));
            cliente.setAtivo(Boolean.valueOf(true));
            cliente.setDataHoraAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario()));
            this.repository.save((Object)cliente);
            return true;
        }
        throw new ApiException("msg.erro.023");
    }

    @Transactional
    public void changeStatusLockIn(Long customerId) throws ApiException {
        UsuarioView user;
        user.setBloqueado(Boolean.valueOf((user = (UsuarioView)this.repository.findByUserCustomerId(customerId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", customerId.toString()}))).getBloqueado() == false));
        this.userRepository.toggleUserLocking(user.getId(), user.getBloqueado());
    }

    @Transactional
    public void changeOnlinePaymentReceivementStatus(Long customerId) throws ApiException {
        Cliente customer;
        customer.setPagamentoOnlineBloqueado(Boolean.valueOf((customer = (Cliente)this.repository.findById((Object)customerId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", customerId.toString()}))).getPagamentoOnlineBloqueado() == false));
        this.repository.save((Object)customer);
    }

    public boolean hasRegistredCustomer(String email, Long empresaId) {
        return this.repository.findByUsuarioLoginAndEmpresaId(email, empresaId).orElse(null) != null;
    }

    public boolean customerHasActiveActivationRequest(String email, Long empresaId) throws ApiException {
        SolicitacaoDeAtivacao solicitacao = this.getNewAccountActivationRequest(empresaId, email);
        return solicitacao != null;
    }

    @Deprecated
    @Transactional
    public Cliente createCustomerAccount(Cliente cliente, Long empresaId, boolean cadastroWeb) throws ApiException {
        this.validateAccountCreate(cliente, empresaId);
        EmpresaConfiguracao configAtivacaoObrigatoria = this.companyConfigService.findByEmpresaIdAndName(empresaId, "config-ativacao-conta-obrigatorio");
        Empresa empresa = (Empresa)this.companyRepository.findById((Object)empresaId).get();
        EnderecoDeEntrega endereco = (EnderecoDeEntrega)cliente.getEnderecosDeEntrega().iterator().next();
        endereco.setCep(StringUtil.removerMascara((String)endereco.getCep()));
        Municipio municipio = (Municipio)this.cityRepository.findByIbgeId(endereco.getMunicipio().getIbgeId()).get();
        cliente.setEmpresa(empresa);
        cliente.setTelefone(StringUtil.removerMascara((String)cliente.getTelefone()));
        cliente.setCpf(StringUtil.removerMascara((String)cliente.getCpf()));
        cliente.getUsuario().setSenha(this.encoder.encode((CharSequence)cliente.getUsuario().getSenha()));
        cliente.getUsuario().setNome(cliente.getNome());
        cliente.getUsuario().setTelefone(StringUtil.removerMascara((String)cliente.getTelefone()));
        cliente.setDataCadastro(DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario()));
        cliente.setDataHoraAtualizacao(cliente.getDataCadastro());
        cliente.setPagamentoOnlineBloqueado(Boolean.valueOf(false));
        if (configAtivacaoObrigatoria.getValor().equals(ValorConfiguracaoBooleano.FALSE.getValor())) {
            cliente.setAtivo(Boolean.TRUE);
        }
        endereco.setCliente(cliente);
        endereco.setExcluido(Boolean.valueOf(false));
        endereco.setMunicipio(municipio);
        cliente.getUsuario().setDemonstracao(false);
        cliente.getUsuario().setPerfil((Perfil)this.profileRepository.findById((Object)Domains.ID_PERFIL_CLIENTE).get());
        this.userRepository.save((Object)cliente.getUsuario());
        this.repository.save((Object)cliente);
        return cliente;
    }

    @Transactional
    public Cliente createCustomerAccount(Cliente cliente, Long empresaId, boolean cadastroWeb, String fcmToken) throws ApiException {
        this.validateAccountCreate(cliente, empresaId);
        EmpresaConfiguracao configAtivacaoObrigatoria = this.companyConfigService.findByEmpresaIdAndName(empresaId, "config-ativacao-conta-obrigatorio");
        Empresa empresa = this.companyRepository.findById((Object)empresaId).orElse(null);
        if (NullUtil.isNotNull((Object)empresa)) {
            cliente.getEnderecosDeEntrega().forEach(endereco -> {
                endereco.setBairro(StringUtil.capitalizar((String)endereco.getBairro()));
                endereco.setComplemento(StringUtil.capitalizar((String)endereco.getComplemento()));
                endereco.setDescricao(StringUtil.capitalizar((String)endereco.getDescricao()));
                endereco.setLogradouro(StringUtil.capitalizar((String)endereco.getLogradouro()));
                endereco.setPontoDeReferencia(StringUtil.capitalizar((String)endereco.getPontoDeReferencia()));
            });
            EnderecoDeEntrega endereco2 = new EnderecoDeEntrega();
            Municipio municipio = new Municipio();
            if (!CollectionUtils.isEmpty((Collection)cliente.getEnderecosDeEntrega())) {
                endereco2 = (EnderecoDeEntrega)cliente.getEnderecosDeEntrega().iterator().next();
                endereco2.setCep(StringUtil.removerMascara((String)endereco2.getCep()));
                municipio = (Municipio)this.cityRepository.findByIbgeId(endereco2.getMunicipio().getIbgeId()).get();
            }
            cliente.setNome(StringUtil.capitalizar((String)cliente.getNome()));
            cliente.setEmpresa(empresa);
            cliente.setTelefone(StringUtil.removerMascara((String)cliente.getTelefone()));
            cliente.getUsuario().setSenha(this.encoder.encode((CharSequence)cliente.getUsuario().getSenha()));
            cliente.getUsuario().setNome(cliente.getNome());
            cliente.getUsuario().setTelefone(StringUtil.removerMascara((String)cliente.getTelefone()));
            cliente.setDataCadastro(DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario()));
            cliente.setDataHoraAtualizacao(cliente.getDataCadastro());
            cliente.setPagamentoOnlineBloqueado(Boolean.valueOf(false));
            cliente.setTipoPessoa(TipoPessoa.FISICA);
            if (configAtivacaoObrigatoria.getValor().equals(ValorConfiguracaoBooleano.FALSE.getValor())) {
                cliente.setAtivo(Boolean.TRUE);
            }
            if (!CollectionUtils.isEmpty((Collection)cliente.getEnderecosDeEntrega())) {
                endereco2.setCliente(cliente);
                endereco2.setExcluido(Boolean.valueOf(false));
                endereco2.setMunicipio(municipio);
            }
            cliente.getUsuario().setDemonstracao(false);
            cliente.getUsuario().setPerfil((Perfil)this.profileRepository.findById((Object)Domains.ID_PERFIL_CLIENTE).get());
            this.userRepository.save((Object)cliente.getUsuario());
            this.repository.save((Object)cliente);
            this.fcmTokenService.save(new Token(empresa, cliente.getUsuario().getId(), fcmToken));
            return cliente;
        }
        return null;
    }

    @Transactional
    public void createNewActivationRequest(Long empresaId, String email, boolean origemWeb) throws ApiException {
        Cliente cliente = (Cliente)this.repository.findByUsuarioLoginAndEmpresaId(StringUtil.removerMascara((String)email), empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", email}));
        this.commitCustomerAccountActivation(cliente);
        SolicitacaoDeAtivacao solicitacao = this.requestActivationAccount(cliente);
        try {
            this.notifyNewActivationAccount(solicitacao, origemWeb);
        }
        catch (Exception e) {
            throw new ApiException("erro.api.padrao", new String[]{e.getMessage()});
        }
    }

    @Transactional
    public boolean edit(Cliente cliente, Long empresaId) throws ApiException {
        this.validarManutencaoDaConta(cliente, empresaId);
        Cliente edicao = (Cliente)this.repository.findById((Object)cliente.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", cliente.getId().toString()}));
        edicao.setNome(cliente.getNome());
        edicao.setDataNascimento(cliente.getDataNascimento());
        Empresa empresa = (Empresa)this.companyRepository.findById((Object)empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", empresaId.toString()}));
        edicao.setDataHoraAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario()));
        edicao.setTelefone(StringUtil.removerMascara((String)cliente.getTelefone()));
        if (StringUtil.isNotBlank((String)cliente.getUsuario().getSenha())) {
            edicao.getUsuario().setSenha(this.encoder.encode((CharSequence)cliente.getUsuario().getSenha()));
            this.userRepository.save((Object)edicao.getUsuario());
        }
        this.repository.save((Object)edicao);
        return true;
    }

    public void sendEmailListToAccountActivation(List<Long> clientesId) throws ApiException {
        for (Long clienteId : clientesId) {
            Cliente cliente = this.repository.findById((Object)clienteId).orElse(null);
            if (NullUtil.isNull((Object)cliente)) continue;
            this.notifyActivationAccount(this.requestActivationAccount(cliente), false);
        }
    }

    @Transactional
    public void delete(Long id) throws ApiException {
        Cliente cliente = (Cliente)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", id.toString()}));
        if (cliente.getAtivo().booleanValue()) {
            throw new ApiException("msg.erro.037", new String[]{cliente.getNome(), cliente.getUsuario().getLogin()});
        }
        this.repository.deleteById((Object)cliente.getId());
        this.userRepository.deleteById((Object)cliente.getUsuario().getId());
    }

    public List<Cliente> findAll(Long empresaId) throws ApiException {
        return this.repository.findByEmpresaIdOrderByNome(empresaId);
    }

    public List<ClienteDto> findAllDto(Long empresaId) throws ApiException {
        ArrayList<ClienteDto> clientes = new ArrayList<ClienteDto>();
        for (Cliente cliente : this.repository.findByEmpresaIdOrderByNome(empresaId)) {
            ClienteDto dto = new ClienteDto();
            dto.setDataCadastro(cliente.getDataCadastro());
            clientes.add(dto);
        }
        return clientes;
    }

    public List<Cliente> findByCompanyAndName(Long companyId, String searchTerm) {
        return this.repository.findByEmpresaIdAndNome(companyId, searchTerm);
    }

    public Cliente findById(Long id) throws ApiException {
        Cliente customer = (Cliente)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", id.toString()}));
        if (!CollectionUtils.isEmpty((Collection)customer.getEnderecosDeEntrega())) {
            customer.setEnderecosDeEntrega(customer.getEnderecosDeEntrega().stream().filter(address -> address.getExcluido() == false).collect(Collectors.toSet()));
        }
        return customer;
    }

    @Transactional
    public void inactivateUserAccount(CancelamentoDaConta cancelamento, Long empresaId) throws ApiException {
        this.validateAccountInactivation(cancelamento);
        Cliente cliente = (Cliente)this.repository.findById((Object)cancelamento.getCliente().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", cancelamento.getCliente().getId().toString()}));
        Empresa empresa = (Empresa)this.companyRepository.findById((Object)empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", empresaId.toString()}));
        cliente.setDataHoraAtualizacao(DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario()));
        cliente.setAtivo(Boolean.valueOf(false));
        this.repository.save((Object)cliente);
        cancelamento.setCliente(cliente);
        cancelamento.setEmpresa((Empresa)this.companyRepository.findById((Object)empresaId).get());
        if (NullUtil.isNull((Object)cancelamento.getCliente())) {
            throw new ApiException("erro.entidade.nao.encontrado", new String[]{cancelamento.getCliente().getId().toString()});
        }
        this.accountCancelmentRepository.save((Object)cancelamento);
    }

    public Cliente get(String email, Long empresaId) throws ApiException {
        Cliente customer = (Cliente)this.repository.findByUsuarioLoginAndEmpresaId(email, empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", email}));
        if (!CollectionUtils.isEmpty((Collection)customer.getEnderecosDeEntrega())) {
            customer.setEnderecosDeEntrega(customer.getEnderecosDeEntrega().stream().filter(address -> address.getExcluido() == false).collect(Collectors.toSet()));
        }
        return customer;
    }

    public List<Cliente> getCustomersDoesntBuySince90Days(Long empresaId) {
        return this.repository.findClientesQueNaoCompramA90Dias(DateUtil.obterDiferencaEmDias((LocalDate)LocalDate.now(), (int)90), empresaId);
    }

    public List<Cliente> getInactiveAccountsLast30days() {
        return this.repository.findContasInativasNosUltimos30Dias(DateUtil.obterDiferencaEmDias((LocalDate)LocalDate.now(), (int)30));
    }

    public List<Cliente> getInactiveCustomers(Long empresaId) throws ApiException {
        return this.repository.findClientesInativos(empresaId);
    }

    File getCompanyLogo(Empresa empresa, Map<String, String> parametros) throws ApiException {
        File logotipo = null;
        logotipo = StringUtil.isNotBlank((String)parametros.get("logoEmpresa")) ? this.companyService.obterArquivoDoLogotipo(empresa, false) : this.fileService.getFile(this.fileService.getCompanyPath(empresa.getId().toString(), null, Boolean.valueOf(true)).concat(File.separator).concat("logo.jpg"));
        return logotipo;
    }

    public ClienteDto findByLogin(String login, Long empresaId) throws ApiException {
        if (login.contains(":")) {
            login = login.split(":")[0];
        }
        Cliente cliente = (Cliente)this.repository.findByLoginAndEmpresaId(login, empresaId).orElseThrow(() -> new ApiException("erro.autenticacao.usuario.nao.encontrado"));
        return this.parseToDto(cliente);
    }

    public SolicitacaoDeAtivacao getNewAccountActivationRequest(Long empresaId, String email) throws ApiException {
        return this.activationRequestRepository.findSolicitacaoDeAtivacaoConta(empresaId, email);
    }

    public List<CartaoDoCliente> listCustomerCards(Long clienteId) {
        List customerCards = this.customerCardRepository.findByClienteIdAndExcluidoIsFalse(clienteId);
        customerCards.forEach(card -> card.setNumeroCartao(CryptUtil.shuffleCreditCardNumber((String)card.getNumeroCartao())));
        return customerCards;
    }

    @Transactional
    public void requestAccountReactivation(Long empresaId, Long clienteId) throws ApiException {
        Cliente cliente = (Cliente)this.repository.findById((Object)clienteId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", clienteId.toString()}));
        Empresa empresa = (Empresa)this.companyRepository.findById((Object)empresaId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", empresaId.toString()}));
        if (!cliente.getEmpresa().getId().equals(empresaId)) {
            throw new ApiException("erro.usuario.nao.vinculado", new String[]{cliente.getNome(), empresa.getNomeFantasia()});
        }
        SolicitacaoDeAtivacao solicitacaoAtual = this.activationRequestRepository.findSolicitacaoDeAtivacaoConta(empresaId, cliente.getUsuario().getLogin());
        if (NullUtil.isNotNull((Object)solicitacaoAtual)) {
            solicitacaoAtual.setEncerrada(Boolean.valueOf(true));
            solicitacaoAtual.setDataHoraSolicitacao(DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario()));
            this.activationRequestRepository.save((Object)solicitacaoAtual);
        }
        SolicitacaoDeAtivacao solicitacao = new SolicitacaoDeAtivacao();
        solicitacao.setDataHoraSolicitacao(DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario()));
        solicitacao.setEmpresa(cliente.getEmpresa());
        solicitacao.setEncerrada(Boolean.valueOf(false));
        solicitacao.setNumeroAutenticacao(Integer.valueOf(NumberUtil.generateRandomNumber((int)4)));
        solicitacao.setCliente(cliente);
        this.activationRequestRepository.save((Object)solicitacao);
        this.notifyReactivationAccount(solicitacao);
    }

    public Boolean checkCustomerLockIn(Long clienteId) throws ApiException {
        return (Boolean)this.repository.checkCustomerLockIn(clienteId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", clienteId.toString()}));
    }

    private ClienteDto parseToDto(Cliente cliente) {
        ClienteDto dto = new ClienteDto();
        dto.setId(cliente.getId());
        dto.setLogin(cliente.getUsuario().getLogin());
        dto.setNome(cliente.getNome());
        dto.setTelefone(cliente.getTelefone());
        dto.setAtivo(cliente.getAtivo());
        dto.setUsuario((Usuario)Hibernate.unproxy((Object)cliente.getUsuario()));
        dto.setDataCadastro(cliente.getDataCadastro());
        dto.setEmpresa(new Empresa(cliente.getEmpresa().getId()));
        return dto;
    }

    @Transactional
    private void commitCustomerAccountActivation(Cliente cliente) throws ApiException {
        SolicitacaoDeAtivacao solicitacao = this.activationRequestRepository.findSolicitacaoDeAtivacaoConta(cliente.getEmpresa().getId(), cliente.getUsuario().getLogin());
        if (NullUtil.isNotNull((Object)solicitacao)) {
            solicitacao.setEncerrada(Boolean.valueOf(true));
            this.activationRequestRepository.save((Object)solicitacao);
        }
    }

    private Cliente groupCustomerAddress(Cliente customer) {
        List addresses;
        EnderecoDeEntrega address = this.deliveryAddressRepository.findEnderecoPrincipal(customer.getId()).orElse(null);
        if (NullUtil.isNull((Object)address) && !CollectionUtils.isEmpty((Collection)(addresses = this.deliveryAddressRepository.findByClienteIdOrderByIdDesc(customer.getId())))) {
            address = (EnderecoDeEntrega)addresses.get(0);
        }
        customer.setEnderecosDeEntrega(new HashSet<EnderecoDeEntrega>(Arrays.asList(address)));
        return customer;
    }

    private void notifyActivationAccount(SolicitacaoDeAtivacao solicitacao, boolean solicitacaoWeb) throws ApiException {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("empresaNomeAbreviado", solicitacao.getEmpresa().getNomeAbreviado());
        parametros.put("usuarioNome", StringUtil.getFirstName((String)solicitacao.getCliente().getNome()));
        parametros.put("codigoAtivacao", String.valueOf(solicitacao.getNumeroAutenticacao()));
        parametros.put("logoEmpresa", solicitacao.getEmpresa().getLogotipo());
        parametros.put("empresaNomeFantasia", solicitacao.getEmpresa().getNomeFantasia());
        parametros.put("empresaEndereco", solicitacao.getEmpresa().getEndereco());
        parametros.put("emailUsuario", solicitacao.getCliente().getUsuario().getLogin());
        StringBuilder template = new StringBuilder();
        boolean possuiAppAndroid = false;
        boolean possuiAppIos = false;
        File badgeGooglePlay = null;
        File badgeAppStore = null;
        if (solicitacaoWeb) {
            possuiAppAndroid = StringUtil.isNotBlank((String)solicitacao.getEmpresa().getUrlAppAndroid());
            possuiAppIos = StringUtil.isNotBlank((String)solicitacao.getEmpresa().getUrlAppIos());
            parametros.put("linkAtivacao", String.format("%s/auth/%s/%s/accounts/activate", solicitacao.getEmpresa().getUrlStore(), solicitacao.getEmpresa().getId(), solicitacao.getCliente().getId()));
            if (possuiAppAndroid) {
                badgeGooglePlay = this.fileService.getFile(this.fileService.getRootPath() + File.separator + "google-play-badge.png");
                parametros.put("urlGooglePlay", solicitacao.getEmpresa().getUrlAppAndroid());
            }
            if (possuiAppIos) {
                badgeAppStore = this.fileService.getFile(this.fileService.getRootPath() + File.separator + "app-store-badge.png");
                parametros.put("urlAppStore", solicitacao.getEmpresa().getUrlAppIos());
            }
            template.append("<h1>Bem-vindo {usuarioNome}!</h1><h4>Complete seu cadastro ativando sua conta clicando no link abaixo:</h4><p><strong>{linkAtivacao}</strong></p>");
        } else {
            template.append("<h1>Bem-vindo {usuarioNome}!</h1><h4>Falta pouco para come\u00e7ar a fazer seus pedidos no aplicativo {empresaNomeFantasia}. Este \u00e9 o seu c\u00f3digo de ativa\u00e7\u00e3o da conta:</h4><h1 style=\"padding-top:25px;padding-bottom:25px;\">{codigoAtivacao}</h1><h5 style=\"color:#555555;font-size:12px;\">Para ativar sua conta com o c\u00f3digo fornecido, fa\u00e7a seu login no aplicativo, abra o menu principal, clique em \"Ativar minha conta\" e siga as instru\u00e7\u00f5es.</h5>");
        }
        String mensagem = EmailService.comporMensagem(parametros, (StringBuilder)template, (boolean)possuiAppAndroid, (boolean)possuiAppIos);
        File logotipo = this.getCompanyLogo(solicitacao.getEmpresa(), parametros);
        this.userService.enviarEmailDeNotificacao(parametros, ACTIVATION_ACCOUNT_SUBJECT, mensagem, logotipo, badgeGooglePlay, badgeAppStore);
    }

    private void notifyNewActivationAccount(SolicitacaoDeAtivacao solicitacao, boolean origemWeb) throws Exception {
        StringBuilder template = new StringBuilder();
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("empresaNomeAbreviado", solicitacao.getEmpresa().getNomeAbreviado());
        parametros.put("usuarioNome", StringUtil.getFirstName((String)solicitacao.getCliente().getNome()));
        parametros.put("codigoAtivacao", solicitacao.getNumeroAutenticacao().toString());
        parametros.put("logoEmpresa", solicitacao.getEmpresa().getLogotipo());
        parametros.put("empresaEndereco", solicitacao.getEmpresa().getEndereco());
        template.append("<h1>{usuarioNome} ative sua conta!</h1><h4>A ativa\u00e7\u00e3o da sua conta expirou e uma nova ativa\u00e7\u00e3o foi solicitada. Lembre-se, sua conta deve ser ativada em 24 horas. Este \u00e9 o seu c\u00f3digo de ativa\u00e7\u00e3o da conta:</h4><h1 style=\"padding-top:25px;padding-bottom:25px;\">{codigoAtivacao}</h1>");
        if (origemWeb) {
            String autenticacaoCodificado = StringUtil.codificarBase64((Number)solicitacao.getNumeroAutenticacao());
            String url = String.format("%s/accounts/account-activate/%s", solicitacao.getEmpresa().getUrlStore(), autenticacaoCodificado);
            parametros.put("linkAtivacao", url);
            template.append("<h5 style=\"color:#555555;font-size:12px;\">Para ativar sua conta com o c\u00f3digo fornecido, fa\u00e7a seu login em nossa loja, abra o menu principal (Ol\u00e1 {usuarioNome}!!), clique em \"Ativar minha conta\" e siga as instru\u00e7\u00f5es. Caso esteja logado, clique no link abaixo:</h5><a href=\"{linkAtivacao}\" target=\"_blank\">" + url + "</a>");
        } else {
            template.append("<h5 style=\"color:#555555;font-size:12px;\">Para ativar sua conta com o c\u00f3digo fornecido, fa\u00e7a seu login no aplicativo, abra o menu principal, clique em \"Ativar minha conta\" e siga as instru\u00e7\u00f5es.</h5>");
        }
        String mensagem = EmailService.comporMensagem(parametros, (StringBuilder)template, (boolean)false, (boolean)false);
        File logotipo = this.getCompanyLogo(solicitacao.getEmpresa(), parametros);
        this.userService.enviarEmailDeNotificacao(parametros, ACTIVATION_ACCOUNT_SUBJECT, mensagem, logotipo, null, null);
    }

    @Transactional
    private SolicitacaoDeAtivacao requestActivationAccount(Cliente cliente) throws ApiException {
        SolicitacaoDeAtivacao solicitacao = new SolicitacaoDeAtivacao();
        solicitacao.setCliente(cliente);
        solicitacao.setEmpresa(cliente.getEmpresa());
        Empresa empresa = (Empresa)this.companyRepository.findById((Object)cliente.getEmpresa().getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", cliente.getEmpresa().getId().toString()}));
        solicitacao.setDataHoraSolicitacao(DateUtil.setTimeByTimezone((FusoHorario)empresa.getFusoHorario()));
        solicitacao.setNumeroAutenticacao(Integer.valueOf(NumberUtil.generateRandomNumber((int)4)));
        solicitacao.setEncerrada(Boolean.valueOf(false));
        this.activationRequestRepository.save((Object)solicitacao);
        return solicitacao;
    }

    private void notifyReactivationAccount(SolicitacaoDeAtivacao solicitacao) throws ApiException {
        StringBuilder template = new StringBuilder();
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("empresaNomeAbreviado", solicitacao.getEmpresa().getNomeAbreviado());
        parametros.put("usuarioNome", StringUtil.getFirstName((String)solicitacao.getCliente().getNome()));
        parametros.put("codigoAtivacao", solicitacao.getNumeroAutenticacao().toString());
        parametros.put("logoEmpresa", solicitacao.getEmpresa().getLogotipo());
        parametros.put("empresaNomeFantasia", solicitacao.getEmpresa().getNomeFantasia());
        parametros.put("empresaEndereco", solicitacao.getEmpresa().getLogradouro());
        parametros.put("emailUsuario", solicitacao.getCliente().getUsuario().getLogin());
        template.append("<h1>{usuarioNome} reative sua conta!</h1><h4>A reativa\u00e7\u00e3o foi solicitada com sucesso. Lembre-se, sua conta deve ser ativada em 24 horas. Este \u00e9 o seu c\u00f3digo de reativa\u00e7\u00e3o da conta:</h4><h1 style=\"padding-top:25px;padding-bottom:25px;\">{codigoAtivacao}</h1><h5 style=\"color:#555555;font-size:12px;\">Para re-ativar sua conta com o c\u00f3digo fornecido, fa\u00e7a seu login no aplicativo, abra o menu principal, clique em \"Ativar minha conta\" e siga as instru\u00e7\u00f5es.</h5>");
        String mensagem = EmailService.comporMensagem(parametros, (StringBuilder)template, (boolean)false, (boolean)false);
        File logotipo = this.getCompanyLogo(solicitacao.getEmpresa(), parametros);
        this.userService.enviarEmailDeNotificacao(parametros, REACTIVATION_ACCOUNT_SUBJECT, mensagem, logotipo, null, null);
    }

    private void validateAccountCreate(Cliente cliente, Long empresaId) throws ApiException {
        if (StringUtil.isBlank((String)cliente.getNome())) {
            throw new ApiException("msg.erro.001", new String[]{"Nome do Cliente"});
        }
        if (!cliente.getNome().contains(" ")) {
            throw new ApiException("msg.erro.003");
        }
        if (StringUtil.isBlank((String)cliente.getUsuario().getLogin())) {
            throw new ApiException("msg.erro.001", new String[]{"E-mail do Cliente"});
        }
        if (!StringUtil.emailValido((String)cliente.getUsuario().getLogin())) {
            throw new ApiException("msg.erro.002", new String[]{"E-mail do Cliente"});
        }
        if (StringUtil.isBlank((String)cliente.getTelefone())) {
            throw new ApiException("msg.erro.001", new String[]{"Telefone do Cliente"});
        }
        if (!cliente.getUsuario().getSenha().equals(cliente.getUsuario().getConfirmacaoSenha())) {
            throw new ApiException("msg.erro.004");
        }
        if (StringUtil.isBlank((String)cliente.getUsuario().getSenha()) || cliente.getUsuario().getSenha().length() < 8) {
            throw new ApiException("msg.erro.005");
        }
        if (this.customerHasActiveActivationRequest(cliente.getUsuario().getLogin(), empresaId)) {
            throw new ApiException("msg.confirm.003");
        }
        if (this.hasRegistredCustomer(cliente.getUsuario().getLogin(), empresaId)) {
            throw new ApiException("msg.confirm.001");
        }
        if (NullUtil.isNotNull(this.repository.findByLoginAndEmpresaId(cliente.getUsuario().getLogin(), empresaId).orElse(null))) {
            throw new ApiException("msg.erro.095");
        }
    }

    private void validateAccountInactivation(CancelamentoDaConta cancelamento) throws ApiException {
        if (NullUtil.isNull((Object)cancelamento.getCliente())) {
            throw new ApiException("msg.erro.001", new String[]{"Cliente"});
        }
        if (NullUtil.isNull((Object)cancelamento.getEmpresa())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (StringUtil.isBlank((String)cancelamento.getMotivo())) {
            throw new ApiException("msg.erro.018");
        }
    }

    private void validarManutencaoDaConta(Cliente cliente, Long empresaId) throws ApiException {
        if (StringUtil.isBlank((String)cliente.getNome())) {
            throw new ApiException("msg.erro.001", new String[]{"Nome do Cliente"});
        }
        if (!cliente.getNome().contains(" ")) {
            throw new ApiException("msg.erro.003");
        }
        if (StringUtil.isBlank((String)cliente.getTelefone())) {
            throw new ApiException("msg.erro.001", new String[]{"Telefone do Cliente"});
        }
        if (StringUtil.isBlank((String)cliente.getUsuario().getLogin())) {
            throw new ApiException("msg.erro.001", new String[]{"E-mail"});
        }
        if (NullUtil.isNull(this.repository.findByLoginAndEmpresaId(cliente.getUsuario().getLogin(), empresaId).orElse(null))) {
            throw new ApiException("msg.erro.095");
        }
        if (StringUtil.isNotBlank((String)cliente.getUsuario().getSenha()) && StringUtil.isNotBlank((String)cliente.getUsuario().getConfirmacaoSenha())) {
            if (!cliente.getUsuario().getSenha().equals(cliente.getUsuario().getConfirmacaoSenha())) {
                throw new ApiException("msg.erro.004");
            }
            if (StringUtil.isBlank((String)cliente.getUsuario().getSenha()) || cliente.getUsuario().getSenha().length() < 8) {
                throw new ApiException("msg.erro.005");
            }
        }
    }

    public Page<Cliente> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        ClienteSpecificationBuilder builder = new ClienteSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page results = this.repository.findAll(spec, (Pageable)pageable).map(arg_0 -> this.groupCustomerAddress(arg_0));
        return results;
    }

    @Transactional
    public void save(Cliente customer) throws ApiException {
        this.validate(customer);
        customer.setCpf(StringUtil.removerMascara((String)customer.getCpf()));
        customer.setTelefone(StringUtil.removerMascara((String)customer.getTelefone()));
        Date now = Calendar.getInstance().getTime();
        customer.setDataHoraAtualizacao(now);
        if (NullUtil.isNotNullOrZero((Number)customer.getId())) {
            Cliente edit = (Cliente)this.repository.findById((Object)customer.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", customer.getId().toString()}));
            edit.setNome(customer.getNome());
            edit.setCpf(customer.getCpf());
            edit.setTelefone(customer.getTelefone());
            edit.setCodigoDoPdv(customer.getCodigoDoPdv());
            edit.setObservacoes(customer.getObservacoes());
            edit.setTipoPessoa(customer.getTipoPessoa());
            if (StringUtil.isNotBlank((String)customer.getUsuario().getSenha())) {
                edit.getUsuario().setSenha(this.encoder.encode((CharSequence)customer.getUsuario().getSenha()));
            }
            edit.getUsuario().setLogin(customer.getUsuario().getLogin());
            edit.getUsuario().setTelefone(customer.getTelefone());
            edit.getUsuario().setBloqueado(edit.getUsuario().getBloqueado());
            this.repository.save((Object)edit);
            this.userRepository.save((Object)edit.getUsuario());
            edit.setEnderecosDeEntrega(customer.getEnderecosDeEntrega());
            this.saveDeliveryAddress(edit);
        } else {
            customer.setDataCadastro(now);
            customer.getUsuario().setSenha(this.encoder.encode((CharSequence)customer.getUsuario().getSenha()));
            customer.getUsuario().setExcluido(false);
            customer.getUsuario().setDemonstracao(false);
            customer.setUsuario((Usuario)this.userRepository.save((Object)customer.getUsuario()));
            customer.getUsuario().setSenha(this.encoder.encode((CharSequence)customer.getUsuario().getSenha()));
            this.userRepository.save((Object)customer.getUsuario());
            this.repository.save((Object)customer);
            this.saveDeliveryAddress(customer);
        }
    }

    @Transactional
    public void saveDeliveryAddress(Cliente customer) throws ApiException {
        if (!CollectionUtils.isEmpty((Collection)customer.getEnderecosDeEntrega())) {
            List currentAddresses = this.deliveryAddressRepository.findByClienteIdAndExcluidoIsFalseOrderByEnderecoPrincipalDesc(customer.getId()).stream().map(address -> address.getId()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(currentAddresses)) {
                customer.getEnderecosDeEntrega().forEach(address -> {
                    address.setCliente(customer);
                    address.setExcluido(Boolean.valueOf(false));
                    address.setMunicipio((Municipio)this.cityRepository.findByIbgeId(address.getMunicipio().getIbgeId()).get());
                    this.deliveryAddressRepository.save(address);
                });
            } else {
                Set<Object> removeEntries = new HashSet();
                Set ids = customer.getEnderecosDeEntrega().stream().filter(address -> NullUtil.isNotNullOrZero((Number)address.getId())).map(value -> value.getId()).collect(Collectors.toSet());
                removeEntries = currentAddresses.stream().filter(id -> !ids.contains(id)).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(removeEntries)) {
                    removeEntries.forEach(addressId -> {
                        EnderecoDeEntrega address = (EnderecoDeEntrega)this.deliveryAddressRepository.findById(addressId).get();
                        address.setExcluido(Boolean.valueOf(true));
                        this.deliveryAddressRepository.save((Object)address);
                    });
                }
                customer.getEnderecosDeEntrega().forEach(address -> {
                    address.setCliente(customer);
                    address.setMunicipio((Municipio)this.cityRepository.findByIbgeId(address.getMunicipio().getIbgeId()).get());
                    address.setExcluido(Boolean.valueOf(false));
                    this.deliveryAddressRepository.save(address);
                });
            }
        } else {
            List addresses = this.deliveryAddressRepository.findByClienteIdAndExcluidoIsFalseOrderByEnderecoPrincipalDesc(customer.getId());
            addresses.forEach(address -> {
                address.setExcluido(Boolean.valueOf(true));
                this.deliveryAddressRepository.save(address);
            });
        }
    }

    @Transactional
    public boolean saveFromPDV(Long companyId, List<Cliente> customers) throws ApiException {
        boolean saved = false;
        for (Cliente customer : customers) {
            try {
                Cliente edit = this.repository.findByEmpresaIdAndCodigoDoPdv(companyId, customer.getCodigoDoPdv()).orElse(null);
                if (NullUtil.isNotNull((Object)edit)) {
                    edit.setNome(customer.getNome());
                    edit.setCpf(customer.getCpf());
                    edit.setTelefone(customer.getTelefone());
                    edit.setCodigoDoPdv(customer.getCodigoDoPdv());
                    edit.setObservacoes(customer.getObservacoes());
                    edit.setTipoPessoa(customer.getTipoPessoa());
                    edit.setDataHoraAtualizacao(new Date());
                    if (StringUtil.isNotBlank((String)customer.getUsuario().getSenha())) {
                        edit.getUsuario().setSenha(this.encoder.encode((CharSequence)customer.getUsuario().getSenha()));
                    }
                    edit.getUsuario().setLogin(customer.getUsuario().getLogin());
                    edit.getUsuario().setBloqueado(edit.getUsuario().getBloqueado());
                    this.repository.save((Object)edit);
                    this.userRepository.save((Object)edit.getUsuario());
                    this.updateMainDelveryAddress(edit);
                } else {
                    customer.setDataCadastro(new Date());
                    this.userRepository.save((Object)customer.getUsuario());
                    this.repository.save((Object)customer);
                    this.saveDeliveryAddress(customer);
                }
                saved = true;
            }
            catch (Exception e) {
                saved = false;
            }
        }
        return saved;
    }

    public void validate(Cliente customer) throws ApiException {
        if (StringUtil.isBlank((String)customer.getNome())) {
            throw new ApiException("msg.erro.001", new String[]{"Nome do Cliente"});
        }
        if (!customer.getNome().contains(" ")) {
            throw new ApiException("msg.erro.003");
        }
        if (NullUtil.isNull((Object)customer.getUsuario())) {
            throw new ApiException("msg.erro.001", new String[]{"Usu\u00e1rio"});
        }
        if (StringUtil.isBlank((String)customer.getTelefone())) {
            throw new ApiException("msg.erro.001", new String[]{"Telefone do Cliente"});
        }
        if (NullUtil.isNull((Object)customer.getUsuario().getPerfil())) {
            throw new ApiException("msg.erro.001", new String[]{"Perfil do Usu\u00e1rio"});
        }
        if (StringUtil.isBlank((String)customer.getUsuario().getLogin())) {
            throw new ApiException("msg.erro.001", new String[]{"Login do Cliente"});
        }
        if (!StringUtil.emailValido((String)customer.getUsuario().getLogin())) {
            throw new ApiException("msg.erro.002", new String[]{"E-mail do Cliente"});
        }
        if (NullUtil.isNullOrZero((Number)customer.getId())) {
            if (StringUtil.isBlank((String)customer.getUsuario().getSenha())) {
                throw new ApiException("msg.erro.001", new String[]{"Senha"});
            }
            if (StringUtil.isBlank((String)customer.getUsuario().getConfirmacaoSenha())) {
                throw new ApiException("msg.erro.001", new String[]{"Confirma\u00e7\u00e3o da Senha"});
            }
        } else if (StringUtil.isNotBlank((String)customer.getUsuario().getSenha()) || StringUtil.isNotBlank((String)customer.getUsuario().getConfirmacaoSenha())) {
            if (StringUtil.isBlank((String)customer.getUsuario().getSenha())) {
                throw new ApiException("msg.erro.001", new String[]{"Senha"});
            }
            if (StringUtil.isNotBlank((String)customer.getUsuario().getSenha()) && StringUtil.isBlank((String)customer.getUsuario().getConfirmacaoSenha())) {
                throw new ApiException("msg.erro.001", new String[]{"Confirma\u00e7\u00e3o da Senha"});
            }
        }
    }

    @Transactional
    private void updateMainDelveryAddress(Cliente customer) {
        EnderecoDeEntrega currentAddress = (EnderecoDeEntrega)customer.getEnderecosDeEntrega().stream().findFirst().get();
        EnderecoDeEntrega editAddress = (EnderecoDeEntrega)this.deliveryAddressRepository.findById((Object)currentAddress.getId()).get();
        editAddress.setLogradouro(currentAddress.getLogradouro());
        editAddress.setNumero(currentAddress.getNumero());
        editAddress.setBairro(currentAddress.getBairro());
        editAddress.setCep(currentAddress.getCep());
        editAddress.setComplemento(currentAddress.getComplemento());
        editAddress.setMunicipio((Municipio)this.cityRepository.findByIbgeId(currentAddress.getMunicipio().getIbgeId()).get());
        editAddress.setPontoDeReferencia(currentAddress.getPontoDeReferencia());
        editAddress.setDescricao(currentAddress.getDescricao());
        editAddress.setEnderecoPrincipal(currentAddress.getEnderecoPrincipal());
        this.deliveryAddressRepository.save((Object)editAddress);
    }

    public void validateOnlinePaymentConfirmationCode(Long customerId, Long validationCode) throws ApiException {
        SolicitacaoDePagamento request = this.requestPaymentRepository.findTopByClienteIdAndEncerradaIsFalse(customerId).orElse(null);
        if (NullUtil.isNull((Object)request)) {
            throw new ApiException("msg.erro.entidade.nao.encontrada", new String[]{"Solicita\u00e7\u00e3o de Pagamento", "{ Cliente : " + customerId + " ^}"});
        }
        if (DateUtil.calcularDiferencaEntreDatasEmMinutos((Date)request.getDataHoraSolicitacao(), (Date)new Date()) >= Domains.EXPIRATION_PAYMENT_VALIDATION_CODE) {
            throw new ApiException("msg.erro.167");
        }
        if (!request.getCodigoDeVerificacao().equals(validationCode)) {
            throw new ApiException("msg.erro.168");
        }
    }
}

