/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.domain.Domains;
import com.escolpi.omni.api.enumeration.FormaDeEntrega;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.enumeration.ProvedorDePagamento;
import com.escolpi.omni.api.enumeration.StatusDaTransacao;
import com.escolpi.omni.api.enumeration.TipoPagamento;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CartaoDoCliente;
import com.escolpi.omni.api.model.entity.Contratacao;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.EnderecoDeEntrega;
import com.escolpi.omni.api.model.entity.Municipio;
import com.escolpi.omni.api.model.entity.Pagamento;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.entity.SolicitacaoDePagamento;
import com.escolpi.omni.api.model.entity.cielo.Address;
import com.escolpi.omni.api.model.entity.cielo.CreditCard;
import com.escolpi.omni.api.model.entity.cielo.Customer;
import com.escolpi.omni.api.model.entity.cielo.DebitCard;
import com.escolpi.omni.api.model.entity.cielo.DeliveryAddress;
import com.escolpi.omni.api.model.entity.cielo.InterestType;
import com.escolpi.omni.api.model.entity.cielo.Payment;
import com.escolpi.omni.api.model.entity.cielo.PedidoCielo;
import com.escolpi.omni.api.model.entity.dto.CartaoDeCredito;
import com.escolpi.omni.api.repository.EnderecoDeEntregaRepository;
import com.escolpi.omni.api.repository.LogDePagamentoDeContratacaoService;
import com.escolpi.omni.api.repository.MunicipioRepository;
import com.escolpi.omni.api.repository.PagamentoRepository;
import com.escolpi.omni.api.repository.SolicitacaoDePagamentoRepository;
import com.escolpi.omni.api.service.LogDeErroService;
import com.escolpi.omni.api.service.LogDePagamentoService;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class CieloService {
    @Autowired
    private MunicipioRepository cityRepository;
    @Autowired
    private EnderecoDeEntregaRepository addressRepository;
    @Autowired
    private LogDeErroService errorLogService;
    @Autowired
    private LogDePagamentoService paymentLogService;
    @Autowired
    private LogDePagamentoDeContratacaoService contractPaymentLogService;
    @Autowired
    private PagamentoRepository paymentRepository;
    @Autowired
    private SolicitacaoDePagamentoRepository requestPaymentRepository;

    @Transactional
    public String convertAndSendContractPayment(Contratacao contract) throws ApiException, IOException {
        PedidoCielo cieloOrder = new PedidoCielo();
        cieloOrder.setMerchantOrderId(String.valueOf(new Date().getTime()));
        cieloOrder.setCustomer(this.buildCustomer(contract.getEmpresa()));
        cieloOrder.setPayment(this.buildPaymentWithCreditCard(contract));
        return this.sendContractPayment(contract, cieloOrder);
    }

    @Transactional
    public String convertAndSendPaymentOrder(Pedido order, TipoPagamento paymentType) throws ApiException, IOException {
        PedidoCielo cieloOrder = new PedidoCielo();
        cieloOrder.setMerchantOrderId(String.valueOf(new Date().getTime()));
        cieloOrder.setCustomer(this.buildCustomer(order));
        cieloOrder.setPayment(paymentType.equals((Object)TipoPagamento.DEBITO) ? this.buildPaymentWithDebitCard(order) : this.buildPaymentWithCreditCard(order));
        return this.sendOrderPayment(order, cieloOrder, paymentType);
    }

    public String findBrandByCardNumber(String cardNumber) throws IOException {
        RestTemplate restTemplate = new RestTemplate();
        String url = String.format("https://apiquery.cieloecommerce.cielo.com.br//1/cardBin/%s", cardNumber);
        MultiValueMap headers = this.getCieloApiHeaders();
        HttpEntity request = new HttpEntity(headers);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, request, String.class, (Map)headers);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode responseBody = mapper.readTree((String)response.getBody());
        return responseBody.get("Provider").asText();
    }

    public int getTransactionStatus(String transactionCode) throws IOException {
        RestTemplate restTemplate = new RestTemplate();
        String url = String.format("https://apiquery.cieloecommerce.cielo.com.br//1/sales/%s", transactionCode);
        MultiValueMap headers = this.getCieloApiHeaders();
        HttpEntity request = new HttpEntity(headers);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, request, String.class, (Map)headers);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode responseBody = mapper.readTree((String)response.getBody());
        return responseBody.get("Payment").get("Status").asInt();
    }

    @Transactional
    private String sendContractPayment(Contratacao contract, PedidoCielo cieloOrder) throws IOException, ApiException {
        RestTemplate restTemplate = new RestTemplate();
        MultiValueMap headers = this.getCieloApiHeaders();
        HttpEntity request = new HttpEntity((Object)cieloOrder, headers);
        ObjectMapper mapper = new ObjectMapper();
        ResponseEntity response = null;
        mapper.writeValueAsString((Object)cieloOrder);
        try {
            response = restTemplate.exchange("https://api.cieloecommerce.cielo.com.br//1/sales/", HttpMethod.POST, request, String.class, (Map)headers);
        }
        catch (HttpClientErrorException e) {
            System.out.println("ERRO AO EFETUAR PAGAMENTO: " + e.getMessage());
            System.out.println("DETALHE DO ERRO: " + e.getResponseBodyAsString());
            JsonNode errors = mapper.readTree(e.getResponseBodyAsString());
            if (NullUtil.isNotNull((Object)errors)) {
                for (JsonNode error : errors) {
                    this.errorLogService.save(Domains.PROFILE_COMPANY_ID, Operacao.PAGAMENTO_ONLINE_CIELO, error.get("Code").asText(), error.get("Message").asText());
                }
            } else {
                this.errorLogService.save(Domains.PROFILE_COMPANY_ID, Operacao.PAGAMENTO_ONLINE_CIELO, "000", String.format("Erro desconnhecido ao efetuar pagamento: %s", e.getMessage()));
            }
            throw new ApiException("msg.confirm.036");
        }
        JsonNode responseBody = mapper.readTree((String)response.getBody());
        String transactionCode = responseBody.get("Payment").get("PaymentId").asText();
        int transactionStatus = responseBody.get("Payment").get("Status").asInt();
        this.contractPaymentLogService.savePaymentLog(contract, transactionCode, transactionStatus, ProvedorDePagamento.CIELO);
        return transactionCode;
    }

    @Transactional
    public String sendOrderPayment(Pedido order, PedidoCielo cieloOrder, TipoPagamento paymentType) throws IOException, ApiException {
        RestTemplate restTemplate = new RestTemplate();
        MultiValueMap headers = this.getCieloApiHeaders();
        HttpEntity request = new HttpEntity((Object)cieloOrder, headers);
        ObjectMapper mapper = new ObjectMapper();
        ResponseEntity response = null;
        mapper.writeValueAsString((Object)cieloOrder);
        try {
            response = restTemplate.exchange("https://api.cieloecommerce.cielo.com.br//1/sales/", HttpMethod.POST, request, String.class, (Map)headers);
            SolicitacaoDePagamento requestConfirmPayment = this.requestPaymentRepository.findTopByClienteIdAndEncerradaIsFalse(order.getCliente().getId()).orElse(null);
            if (NullUtil.isNotNull((Object)requestConfirmPayment)) {
                requestConfirmPayment.setEncerrada(Boolean.valueOf(true));
                this.requestPaymentRepository.save((Object)requestConfirmPayment);
            }
        }
        catch (HttpClientErrorException e) {
            JsonNode errors = mapper.readTree(e.getResponseBodyAsString());
            if (NullUtil.isNotNull((Object)errors)) {
                for (JsonNode error : errors) {
                    this.errorLogService.save(Domains.PROFILE_COMPANY_ID, Operacao.PAGAMENTO_ONLINE_CIELO, error.get("Code").asText(), error.get("Message").asText());
                }
            } else {
                this.errorLogService.save(Domains.PROFILE_COMPANY_ID, Operacao.PAGAMENTO_ONLINE_CIELO, "000", String.format("Erro desconnhecido ao efetuar pagamento: %s", e.getMessage()));
            }
            throw new ApiException("msg.confirm.036");
        }
        JsonNode responseBody = mapper.readTree((String)response.getBody());
        String transactionCode = responseBody.get("Payment").get("PaymentId").asText();
        int transactionStatus = responseBody.get("Payment").get("Status").asInt();
        this.paymentLogService.savePaymentLog(order, transactionCode, transactionStatus, ProvedorDePagamento.CIELO);
        return transactionCode;
    }

    @Transactional
    public void savePayment(Pedido order, String transactionCode, TipoPagamento transactionType) {
        Pagamento pagamento = new Pagamento();
        if (NullUtil.isNotNullOrZero((Number)order.getCartaoDoCliente().getId())) {
            pagamento.setCartaoDoCliente(order.getCartaoDoCliente());
        }
        pagamento.setCodigoTransacao(transactionCode);
        pagamento.setDataHoraTransacao(new Date());
        pagamento.setPedido(order);
        pagamento.setStatus(StatusDaTransacao.APROVADO);
        pagamento.setQuantidadeParcelas(Integer.valueOf(NullUtil.isNotNullOrZero((Number)order.getParcelas()) ? order.getParcelas() : 1));
        pagamento.setTipoPagamento(transactionType);
        this.paymentRepository.save((Object)pagamento);
    }

    private Address buildAddress(Long customerId) throws ApiException {
        Address address = new Address();
        EnderecoDeEntrega endereco = this.addressRepository.findEnderecoPrincipal(customerId).orElse(null);
        if (NullUtil.isNull((Object)endereco)) {
            List enderecos = this.addressRepository.findByClienteIdOrderByIdDesc(customerId);
            endereco = (EnderecoDeEntrega)enderecos.get(0);
        }
        if (NullUtil.isNull((Object)endereco)) {
            throw new ApiException("erro.entidade.nao.encontrada", new String[]{"Endere\u00e7o de Entrega", "{ Pagamento do Cliente " + customerId + " }"});
        }
        address.setCity(endereco.getMunicipio().getNome());
        if (StringUtil.isNotBlank((String)endereco.getComplemento())) {
            address.setComplement(endereco.getComplemento());
        }
        address.setCountry("BRA");
        address.setNumber(endereco.getNumero());
        address.setState(endereco.getMunicipio().getUf());
        address.setStreet(endereco.getLogradouro());
        address.setZipCode(StringUtil.removerMascara((String)endereco.getCep()));
        return address;
    }

    private Address buildAddress(Empresa company) {
        Address address = new Address();
        address.setCity(company.getMunicipio().getNome());
        if (StringUtil.isNotBlank((String)company.getComplemento())) {
            address.setComplement(company.getComplemento());
        }
        address.setCountry("BRA");
        address.setNumber(company.getNumero());
        address.setState(company.getMunicipio().getUf());
        address.setStreet(company.getLogradouro());
        address.setZipCode(StringUtil.removerMascara((String)company.getCep()));
        return address;
    }

    private CreditCard buildCreditCard(CartaoDeCredito card) {
        CreditCard creditCard = new CreditCard();
        if (card.getBandeira().equals("mastercard")) {
            creditCard.setBrand("Master");
        } else {
            creditCard.setBrand(StringUtil.capitalizar((String)card.getBandeira()));
        }
        creditCard.setCardNumber(card.getNumeroCartao());
        creditCard.setExpirationDate(card.getMesValidade() + "/" + card.getAnoValidade());
        creditCard.setHolder(card.getTitular().length() > 25 ? card.getTitular().substring(0, 25) : card.getTitular());
        creditCard.setSecurityCode(card.getCvv());
        return creditCard;
    }

    private CreditCard buildCreditCard(CartaoDoCliente card) throws ApiException {
        CreditCard creditCard = new CreditCard();
        if (card.getBandeira().equals("mastercard")) {
            creditCard.setBrand("Master");
        } else {
            creditCard.setBrand(StringUtil.capitalizar((String)card.getBandeira()));
        }
        creditCard.setCardNumber(card.getNumeroCartao());
        creditCard.setExpirationDate(card.getMesValidade() + "/" + card.getAnoValidade());
        creditCard.setHolder(card.getTitular().length() > 25 ? card.getTitular().substring(0, 25) : card.getTitular());
        creditCard.setSecurityCode(card.getCvv());
        return creditCard;
    }

    private DebitCard buildDebitCard(CartaoDoCliente card) throws ApiException {
        DebitCard debitCard = new DebitCard();
        if (card.getBandeira().equals("mastercard")) {
            debitCard.setBrand("Master");
        } else {
            debitCard.setBrand(StringUtil.capitalizar((String)card.getBandeira()));
        }
        debitCard.setCardNumber(card.getNumeroCartao());
        debitCard.setExpirationDate(card.getMesValidade() + "/" + card.getAnoValidade());
        debitCard.setHolder(card.getTitular().length() > 25 ? card.getTitular().substring(0, 25) : card.getTitular());
        debitCard.setSecurityCode(card.getCvv());
        return debitCard;
    }

    private Customer buildCustomer(Empresa company) throws ApiException {
        Customer customer = new Customer();
        customer.setAddress(this.buildAddress(company));
        customer.setDeliveryAddress(this.getPedidoAgoraAddress());
        customer.setEmail(company.getUsuario().getLogin());
        customer.setName(company.getContato());
        return customer;
    }

    private DeliveryAddress getPedidoAgoraAddress() throws ApiException {
        EnderecoDeEntrega pedidoAgoraAddress = new EnderecoDeEntrega();
        Municipio city = (Municipio)this.cityRepository.findById((Object)Domains.PedidoAgoraAdderss.CITY_ID).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Munic\u00edpio", Domains.PedidoAgoraAdderss.CITY_ID.toString()}));
        pedidoAgoraAddress.setLogradouro("Rua Silva Jardim");
        pedidoAgoraAddress.setNumero("365");
        pedidoAgoraAddress.setBairro("Vila Moraes");
        pedidoAgoraAddress.setMunicipio(city);
        pedidoAgoraAddress.setCep("19900261");
        return this.buildDeliveryAddress(pedidoAgoraAddress);
    }

    private Customer buildCustomer(Pedido order) throws ApiException {
        Customer customer = new Customer();
        customer.setAddress(this.buildAddress(order.getCliente().getId()));
        if (NullUtil.isNotNull((Object)order.getCliente().getDataNascimento())) {
            customer.setBirthDate(DateUtil.format((String)"yyyy-MM-dd", (Date)order.getCliente().getDataNascimento()));
        }
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            customer.setDeliveryAddress(this.buildDeliveryAddress(order.getEnderecoEntrega()));
        } else {
            Set enderecos = order.getCliente().getEnderecosDeEntrega();
            if (enderecos.size() > 0) {
                if (order.getCliente().getEnderecosDeEntrega().stream().filter(address -> address.getEnderecoPrincipal()).count() > 0L) {
                    customer.setDeliveryAddress(this.buildDeliveryAddress(enderecos.stream().filter(address -> address.getEnderecoPrincipal()).findFirst().get()));
                } else {
                    customer.setDeliveryAddress(this.buildDeliveryAddress((EnderecoDeEntrega)enderecos.stream().findFirst().get()));
                }
            } else {
                EnderecoDeEntrega companyAddress = new EnderecoDeEntrega();
                Empresa company = order.getEmpresa();
                companyAddress.setLogradouro(company.getLogradouro());
                companyAddress.setNumero(company.getNumero());
                companyAddress.setBairro(company.getBairro());
                companyAddress.setMunicipio(company.getMunicipio());
                companyAddress.setComplemento(company.getComplemento());
                companyAddress.setCep(company.getCep());
                customer.setDeliveryAddress(this.buildDeliveryAddress(companyAddress));
            }
        }
        customer.setEmail(order.getCliente().getUsuario().getLogin());
        customer.setName(order.getCliente().getNome());
        return customer;
    }

    private DeliveryAddress buildDeliveryAddress(EnderecoDeEntrega endereco) {
        DeliveryAddress deliveryAddress = new DeliveryAddress();
        deliveryAddress.setCity(endereco.getMunicipio().getNome());
        if (StringUtil.isNotBlank((String)endereco.getComplemento())) {
            deliveryAddress.setComplement(endereco.getComplemento());
        }
        deliveryAddress.setCountry("BRA");
        deliveryAddress.setNumber(endereco.getNumero());
        deliveryAddress.setStreet(endereco.getLogradouro());
        deliveryAddress.setState(endereco.getMunicipio().getUf());
        deliveryAddress.setZipCode(StringUtil.removerMascara((String)endereco.getCep()));
        return deliveryAddress;
    }

    private Payment buildPaymentWithCreditCard(Contratacao contract) {
        Payment payment = new Payment();
        payment.setAmount(Integer.valueOf(contract.getValorContratado().multiply(new BigDecimal(100)).intValue()));
        payment.setAuthenticate(Boolean.FALSE);
        payment.setCapture(Boolean.TRUE);
        payment.setCountry("BRA");
        payment.setCreditCard(this.buildCreditCard(contract.getCartaoDaEmpresa()));
        payment.setCurrency("BRL");
        payment.setInstallments(contract.getParcelas());
        payment.setInterest(InterestType.BY_MERCHANT.getDescricao());
        payment.setIsCryptoCurrencyNegotiation(Boolean.FALSE);
        payment.setServiceTaxAmount(Double.valueOf(0.0));
        payment.setSoftDescriptor("PEDIDO AGORA");
        payment.setType("CreditCard");
        return payment;
    }

    private Payment buildPaymentWithCreditCard(Pedido order) throws ApiException {
        Payment payment = new Payment();
        payment.setAmount(Integer.valueOf(order.getTotalDoPedido().multiply(new BigDecimal(100)).intValue()));
        payment.setAuthenticate(Boolean.FALSE);
        payment.setCapture(Boolean.TRUE);
        payment.setCountry("BRA");
        payment.setCreditCard(this.buildCreditCard(order.getCartaoDoCliente()));
        payment.setCurrency("BRL");
        if (NullUtil.isNull((Object)order.getParcelas())) {
            payment.setInstallments(Integer.valueOf(1));
        } else {
            payment.setInstallments(order.getParcelas());
        }
        payment.setInterest(InterestType.BY_MERCHANT.getDescricao());
        payment.setIsCryptoCurrencyNegotiation(Boolean.FALSE);
        payment.setServiceTaxAmount(Double.valueOf(0.0));
        payment.setSoftDescriptor("PEDIDO AGORA");
        payment.setType("CreditCard");
        return payment;
    }

    private Payment buildPaymentWithDebitCard(Pedido order) throws ApiException {
        Payment payment = new Payment();
        payment.setAmount(new Integer(order.getTotalDoPedido().multiply(new BigDecimal(100)).intValue()));
        payment.setAuthenticate(Boolean.FALSE);
        payment.setCapture(Boolean.TRUE);
        payment.setCountry("BRA");
        payment.setDebitCard(this.buildDebitCard(order.getCartaoDoCliente()));
        payment.setCurrency("BRL");
        if (NullUtil.isNull((Object)order.getParcelas())) {
            payment.setInstallments(Integer.valueOf(1));
        } else {
            payment.setInstallments(order.getParcelas());
        }
        payment.setInterest(InterestType.BY_MERCHANT.getDescricao());
        payment.setIsCryptoCurrencyNegotiation(Boolean.FALSE);
        payment.setServiceTaxAmount(Double.valueOf(0.0));
        payment.setSoftDescriptor("PEDIDO AGORA");
        payment.setType("DebitCard");
        return payment;
    }

    private MultiValueMap<String, String> getCieloApiHeaders() {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Content-Type", (Object)"application/json");
        headers.add((Object)"MerchantId", (Object)"6cefc88b-6393-42d3-b0f2-c64dd38fbf71");
        headers.add((Object)"MerchantKey", (Object)"FJNXXCZZCKLQMCJDHMBFRMXUCMDKLVIOEJEDPGMI");
        return headers;
    }
}

