/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.domain.Message;
import com.escolpi.omni.api.enumeration.DiaDaSemana;
import com.escolpi.omni.api.enumeration.ValorConfiguracaoBooleano;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CategoriaDoProduto;
import com.escolpi.omni.api.model.entity.Emblema;
import com.escolpi.omni.api.model.entity.EmpresaConfiguracao;
import com.escolpi.omni.api.model.entity.EmpresaProdutoEmDestaque;
import com.escolpi.omni.api.model.entity.Personalizacao;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.entity.ProdutoDoCatalogo;
import com.escolpi.omni.api.model.entity.ValorDaPersonalizacao;
import com.escolpi.omni.api.model.entity.api.CategoriaDoProdutoApi;
import com.escolpi.omni.api.model.entity.dto.CardapioDaMesa;
import com.escolpi.omni.api.model.entity.dto.CatalogoDePersonalizacoes;
import com.escolpi.omni.api.model.projection.CategoriaDoProdutoView;
import com.escolpi.omni.api.model.projection.EmpresaProdutoEmDestaqueView;
import com.escolpi.omni.api.model.projection.ProdutoView;
import com.escolpi.omni.api.model.projection.PromocaoView;
import com.escolpi.omni.api.model.projection.StatusDoPedidoView;
import com.escolpi.omni.api.model.specification.builder.ProdutoDoCatalogoSpecificationBuilder;
import com.escolpi.omni.api.model.specification.builder.ProdutoSpecificationBuilder;
import com.escolpi.omni.api.repository.CategoriaDoProdutoRepository;
import com.escolpi.omni.api.repository.EmblemaRepository;
import com.escolpi.omni.api.repository.EmpresaProdutoEmDestaqueRepository;
import com.escolpi.omni.api.repository.PedidoRepository;
import com.escolpi.omni.api.repository.PersonalizacaoDeProdutoRepository;
import com.escolpi.omni.api.repository.PersonalizacaoRepository;
import com.escolpi.omni.api.repository.ProdutoDoCatalogoRepository;
import com.escolpi.omni.api.repository.ProdutoRepository;
import com.escolpi.omni.api.repository.PromocaoRepository;
import com.escolpi.omni.api.repository.ValorDaPersonalizacaoRepository;
import com.escolpi.omni.api.service.EmpresaConfiguracaoService;
import com.escolpi.omni.api.service.FileService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CatalogoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatalogoService.class);
    @Autowired
    private ProdutoDoCatalogoRepository catalogProductRepository;
    @Autowired
    private CategoriaDoProdutoRepository categoryRepository;
    @Autowired
    private EmblemaRepository emblemRepository;
    @Autowired
    private PersonalizacaoRepository customizationRepository;
    @Autowired
    private PersonalizacaoDeProdutoRepository customizationProductRepository;
    @Autowired
    private ValorDaPersonalizacaoRepository customizationValueRepository;
    @Autowired
    private PedidoRepository orderRepository;
    @Autowired
    private EmpresaProdutoEmDestaqueRepository spotilightProductRepository;
    @Autowired
    private ProdutoRepository productRepository;
    @Autowired
    private PromocaoRepository promotionRepository;
    @Autowired
    private EmpresaConfiguracaoService companyConfigService;
    @Autowired
    private FileService fileService;

    public List<CategoriaDoProduto> findAllExceptMasterAndEmptyCategories(Long empresaId) {
        return this.categoryRepository.findAllExceptMasterAndEmptyCategories(empresaId);
    }

    public List<CategoriaDoProduto> findAllExceptMasterCategories(Long empresaId) {
        return this.categoryRepository.findSubcategories(empresaId);
    }

    @Deprecated
    public List<Personalizacao> getCustomizationsForPromotion(Long empresaId, Long categoriaId) throws ApiException {
        List customizations = this.customizationRepository.findByCategoriaId(categoriaId, empresaId);
        customizations.forEach(customization -> {
            customization.setValoresDaPersonalizacao(customization.getValoresDaPersonalizacao().stream().filter(vp -> vp.getExcluido() == false).collect(Collectors.toSet()));
            if (customization.getSubProduto().booleanValue() && !CollectionUtils.isEmpty((Collection)customization.getValoresDaPersonalizacao())) {
                Set<ValorDaPersonalizacao> avaliableValues = customization.getValoresDaPersonalizacao().stream().filter(vp -> vp.getProduto().getDisponibilidades().indexOf(DateUtil.obterDiaDaSemanaCorrente().ordinal() + "") >= 0).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(avaliableValues)) {
                    avaliableValues.forEach(value -> {
                        try {
                            value.getProduto().setMiniatura(value.getProduto().getFotoExterna() != false ? value.getProduto().getCaminhoFoto() : this.fileService.getPictureUrl(value.getProduto(), true));
                            if (StringUtil.isBlank((String)value.getProduto().getMiniatura())) {
                                value.getProduto().setMiniatura(this.fileService.getPictureUrl(value.getProduto().getCategoria().getEmblema()));
                            }
                        }
                        catch (ApiException e) {
                            LOGGER.error(e.getMessage());
                        }
                    });
                    customization.setValoresDaPersonalizacao(avaliableValues);
                } else {
                    customization.setValoresDaPersonalizacao(null);
                }
            }
        });
        return customizations;
    }

    public StatusDoPedidoView getOrderState(Long orderId) {
        return this.orderRepository.getOrderState(orderId).orElse(null);
    }

    public StatusDoPedidoView getOrderStateByCustomer(Long customerId) {
        return this.orderRepository.getOrderStateByCustomer(customerId).orElse(null);
    }

    public ProdutoView findProductToCatalog(Long companyId, Long id) throws ApiException {
        DiaDaSemana weekDay = DiaDaSemana.get((int)Calendar.getInstance().get(7));
        ProdutoView product = (ProdutoView)this.productRepository.findByIdToCatlog(id, weekDay.ordinal() + "").orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto", id.toString()}));
        product.setCategoria((CategoriaDoProdutoView)this.productRepository.findCategoryByProductId(product.getId()).get());
        if (StringUtil.isBlank((String)product.getCaminhoFoto())) {
            Emblema emblem = (Emblema)this.emblemRepository.findByCategoryId(product.getCategoria().getId()).get();
            try {
                product.setFoto(null);
                product.setMiniatura(this.fileService.getPictureUrl(emblem));
            }
            catch (ApiException e) {
                LOGGER.warn(Message.getInstance().getMessage("msg.erro.091", new String[]{e.getMessage()}));
            }
        } else if (product.getFotoExterna().booleanValue()) {
            product.setFoto(product.getCaminhoFoto());
            product.setMiniatura(product.getCaminhoFoto());
        } else {
            product.setFoto(this.fileService.getPictureUrl(product, companyId, false));
            product.setMiniatura(this.fileService.getPictureUrl(product, companyId, true));
        }
        return product;
    }

    public Produto findTopProductByCategoryId(Long companyId, Long categoryId) {
        return this.productRepository.findTopByEmpresaIdAndCategoriaId(companyId, categoryId).orElse(null);
    }

    public CatalogoDePersonalizacoes getCustomizationCatalogByProduct(Long productId) throws ApiException {
        Produto product = (Produto)this.productRepository.findById((Object)productId).orElseThrow(() -> new ApiException("msg.entidade.nao.encontrado", new String[]{"Produto"}));
        CatalogoDePersonalizacoes catalog = new CatalogoDePersonalizacoes();
        List customizationProducts = this.customizationProductRepository.findByProdutoIdAndExcluidoIsFalseOrderByOrdem(productId);
        if (!CollectionUtils.isEmpty((Collection)customizationProducts)) {
            catalog.setPersonalizacoesDeProduto(customizationProducts);
            if (product.getApenasOpcionaisPorProduto().booleanValue()) {
                return catalog;
            }
        }
        List customizations = this.customizationRepository.findByCategoriaIdAndExcluidoIsFalseOrderByProximaPersonalizacaoIdAscIdAsc(product.getCategoria().getId(), product.getEmpresa().getId());
        catalog.setPersonalizacoes(customizations.stream().filter(customization -> customization.getSubProduto() == false && customization.getSubProdutoFracionado() == false).collect(Collectors.toList()));
        catalog.getPersonalizacoes().stream().forEach(customization -> customization.setValoresDaPersonalizacao(customization.getValoresDaPersonalizacao().stream().filter(value -> value.getExcluido() == false).collect(Collectors.toSet())));
        return catalog;
    }

    public List<ProdutoDoCatalogo> listCatalogProductsByCategory(Long categoryId) {
        int weekDay = DateUtil.obterDiaDaSemanaCorrente().ordinal();
        List products = this.catalogProductRepository.listCatalogProductsByCategory(categoryId, weekDay + "");
        products.forEach(product -> {
            if (StringUtil.isBlank((String)product.getCaminhoFoto())) {
                Emblema emblem = (Emblema)this.emblemRepository.findByCategoryId(product.getCategoria().getId()).get();
                try {
                    product.setFoto(null);
                    product.setMiniatura(this.fileService.getPictureUrl(emblem));
                }
                catch (ApiException e) {
                    LOGGER.warn(Message.getInstance().getMessage("msg.erro.091", new String[]{e.getMessage()}));
                }
            } else if (product.getFotoExterna().booleanValue()) {
                product.setFoto(product.getCaminhoFoto());
                product.setMiniatura(product.getCaminhoFoto());
            } else {
                product.setFoto(this.fileService.getPictureUrl(product, false));
                product.setMiniatura(this.fileService.getPictureUrl(product, true));
            }
        });
        return products;
    }

    public List<CategoriaDoProduto> listCategoriesByCompany(Long companyId) throws ApiException {
        List categories = this.categoryRepository.listCategories(companyId, DateUtil.obterDiaDaSemanaCorrente().ordinal() + "");
        for (CategoriaDoProduto category : categories) {
            Emblema emblem = new Emblema(category.getEmblema().getId());
            emblem.setFoto(this.fileService.getPictureUrl(category.getEmblema()));
            category.setEmblema(emblem);
        }
        return categories;
    }

    @Deprecated
    public List<CategoriaDoProduto> listCategoriesByCompanyId(Long companyId, Boolean withExclusives) throws ApiException {
        if (NullUtil.isNullOrZero((Number)companyId)) {
            return null;
        }
        List categories = withExclusives != false ? this.categoryRepository.listCategoriesByCompany(companyId) : this.categoryRepository.listCategoriesWithoutExclusivesByCompany(companyId);
        ArrayList<CategoriaDoProduto> avaliableCategories = new ArrayList<CategoriaDoProduto>();
        String dayOWeek = DiaDaSemana.get((int)Calendar.getInstance().get(7)).ordinal() + "";
        for (CategoriaDoProduto category : categories) {
            boolean hasAvaliableProductsOnDay;
            List subcategories = this.categoryRepository.findSubcategoriesByParent(category.getId());
            boolean hasAvaliableSubcategoryProductsOnDay = true;
            if (!CollectionUtils.isEmpty((Collection)subcategories)) {
                for (CategoriaDoProduto subcategory : subcategories) {
                    hasAvaliableSubcategoryProductsOnDay = this.productRepository.findAvaliableProductsByCategory(companyId, subcategory.getId(), dayOWeek).stream().count() > 0L;
                    if (hasAvaliableSubcategoryProductsOnDay) continue;
                    hasAvaliableSubcategoryProductsOnDay = false;
                    break;
                }
            }
            if (!CollectionUtils.isEmpty((Collection)subcategories) && !hasAvaliableSubcategoryProductsOnDay) continue;
            boolean bl = hasAvaliableProductsOnDay = this.productRepository.findAvaliableProductsByCategory(companyId, category.getId(), dayOWeek).stream().count() > 0L;
            if (!hasAvaliableProductsOnDay && CollectionUtils.isEmpty((Collection)subcategories)) continue;
            Emblema emblem = new Emblema(category.getEmblema().getId());
            emblem.setFoto(this.fileService.getPictureUrl(category.getEmblema()));
            category.setEmblema(emblem);
            avaliableCategories.add(category);
        }
        return avaliableCategories;
    }

    public List<CategoriaDoProdutoApi> listarCategoriasDoProdutoApiPorEmpresa(Long empresaId) throws ApiException {
        ArrayList<CategoriaDoProdutoApi> categoriasApi = new ArrayList<CategoriaDoProdutoApi>();
        List categorias = this.listCategoriesByCompanyId(empresaId, Boolean.valueOf(false));
        for (CategoriaDoProduto categoria : categorias) {
            categoriasApi.add(this.popularApi(categoria));
        }
        return categoriasApi;
    }

    public List<Produto> listarProdutosPorEmpresaECategoria(Long empresaId, Long categoriaId) throws ApiException {
        DiaDaSemana dayOWeek = DiaDaSemana.get((int)Calendar.getInstance().get(7));
        List produtos = this.productRepository.findAvaliableProductsByCategory(empresaId, categoriaId, dayOWeek.ordinal() + "");
        ArrayList<Produto> catalogList = new ArrayList<Produto>();
        EmpresaConfiguracao exibeProdutosEmFalta = this.companyConfigService.findByEmpresaIdAndName(empresaId, "config-exibe-produtos-em-falta");
        if (StringUtil.isBlank((String)exibeProdutosEmFalta.getValor())) {
            exibeProdutosEmFalta.setValor(exibeProdutosEmFalta.getConfiguracao().getValorPadrao());
        }
        for (Produto product : produtos) {
            if (product.getEmFalta().booleanValue() && exibeProdutosEmFalta.getValor().equals(ValorConfiguracaoBooleano.FALSE.getValor())) continue;
            Produto item = new Produto();
            CategoriaDoProduto categoria = product.getCategoria();
            item.setId(product.getId());
            item.setNome(product.getNome());
            item.setDescricao(product.getDescricao());
            item.setValor(product.getValor());
            item.setVendaPorTamanho(product.getVendaPorTamanho());
            item.setCategoria(new CategoriaDoProduto(categoria.getId()));
            item.getCategoria().setDescricao(categoria.getDescricao());
            item.getCategoria().setComposicao(categoria.getComposicao());
            item.setValorDesconto(product.getValorDesconto());
            item.setEmFalta(product.getEmFalta());
            item.setVendaPorFracao(product.getVendaPorFracao());
            item.setPesoMedio(product.getPesoMedio());
            item.setDisponibilidades(product.getDisponibilidades());
            item.setEstoque(product.getEstoque());
            item.setEstoqueIlimitado(product.getEstoqueIlimitado());
            item.setVendaPorAtacado(product.getVendaPorAtacado());
            item.setQtdeMinVendaPorAtacado(product.getQtdeMinVendaPorAtacado());
            item.setValorAtacado(product.getValorAtacado());
            if (item.getVendaPorTamanho().booleanValue()) {
                item.setValorTamanhoBroto(product.getValorTamanhoBroto());
                item.setLabelTamanhoBroto(product.getLabelTamanhoBroto());
                item.setLimiteSelecaoTamanhoBroto(product.getLimiteSelecaoTamanhoBroto());
                item.setValorTamanhoMedio(product.getValorTamanhoMedio());
                item.setLabelTamanhoMedio(product.getLabelTamanhoMedio());
                item.setLimiteSelecaoTamanhoMedio(product.getLimiteSelecaoTamanhoMedio());
                item.setValorTamanhoGrande(product.getValorTamanhoGrande());
                item.setLabelTamanhoGrande(product.getLabelTamanhoGrande());
                item.setLimiteSelecaoTamanhoGrande(product.getLimiteSelecaoTamanhoGrande());
                item.setValorTamanhoGigante(product.getValorTamanhoGigante());
                item.setLabelTamanhoGigante(product.getLabelTamanhoGigante());
                item.setLimiteSelecaoTamanhoGigante(product.getLimiteSelecaoTamanhoGigante());
            }
            if (StringUtil.isNotBlank((String)product.getCaminhoFoto()) && !product.getFotoExterna().booleanValue()) {
                item.setMiniatura(this.fileService.getPictureUrl(product, true));
            } else {
                if (product.getFotoExterna().booleanValue()) {
                    item.setMiniatura(product.getCaminhoFoto());
                }
                categoria.getEmblema().setDescricao(null);
                categoria.getEmblema().setFoto(this.fileService.getPictureUrl(categoria.getEmblema()));
                item.getCategoria().setEmblema(categoria.getEmblema());
            }
            catalogList.add(item);
        }
        return catalogList;
    }

    public List<Produto> listarProdutosParaBrinde(Long empresaId, Long categoriaId) throws ApiException {
        List produtos = this.productRepository.findByEmpresaIdAndCategoriaIdAndExcluidoIsFalseOrderByNome(empresaId, categoriaId);
        ArrayList<Produto> catalogList = new ArrayList<Produto>();
        EmpresaConfiguracao exibeProdutosEmFalta = this.companyConfigService.findByEmpresaIdAndName(empresaId, "config-exibe-produtos-em-falta");
        if (StringUtil.isBlank((String)exibeProdutosEmFalta.getValor())) {
            exibeProdutosEmFalta.setValor(exibeProdutosEmFalta.getConfiguracao().getValorPadrao());
        }
        for (Produto produto : produtos) {
            if (produto.getEmFalta().booleanValue() && exibeProdutosEmFalta.getValor().equals(ValorConfiguracaoBooleano.FALSE.getValor())) continue;
            Produto catalogItem = new Produto();
            catalogItem.setId(produto.getId());
            catalogItem.setNome(produto.getNome());
            catalogItem.setValor(produto.getValor());
            catalogItem.setCategoria(produto.getCategoria());
            catalogItem.setEmFalta(produto.getEmFalta());
            catalogList.add(catalogItem);
        }
        return catalogList;
    }

    public List<CategoriaDoProduto> listSpotlightCategoryByCompany(Long companyId) throws ApiException {
        if (NullUtil.isNullOrZero((Number)companyId)) {
            throw new ApiException("erro.api.padrao", new String[]{"empresaId n\u00e3o foi informado"});
        }
        String weekDay = DiaDaSemana.get((int)Calendar.getInstance().get(7)).ordinal() + "";
        List spotlights = this.categoryRepository.listSpotlightCategoryByCompany(companyId, weekDay);
        for (CategoriaDoProduto spotlight : spotlights) {
            if (!StringUtils.hasText((String)spotlight.getCaminhoFoto())) continue;
            spotlight.setFoto(this.fileService.getPictureUrl(spotlight, false));
            spotlight.setMiniatura(this.fileService.getPictureUrl(spotlight, true));
        }
        return spotlights;
    }

    @Deprecated
    public List<EmpresaProdutoEmDestaqueView> listarProdutosEmDestaquePorEmpresa(Long empresaId) throws ApiException {
        if (NullUtil.isNullOrZero((Number)empresaId)) {
            throw new ApiException("erro.api.padrao", new String[]{"empresaId n\u00e3o foi informado"});
        }
        ArrayList<EmpresaProdutoEmDestaqueView> destaques = new ArrayList<EmpresaProdutoEmDestaqueView>();
        DiaDaSemana dayOfWeek = DiaDaSemana.get((int)Calendar.getInstance().get(7));
        List produtosEmDestaque = this.spotilightProductRepository.findByProdutoEmDestaqueNaoPromocional(empresaId, dayOfWeek.ordinal() + "");
        for (EmpresaProdutoEmDestaque destaque : produtosEmDestaque) {
            if (destaque.getProduto().getEmFalta().booleanValue()) continue;
            EmpresaProdutoEmDestaqueView dto = new EmpresaProdutoEmDestaqueView();
            dto.setNome(destaque.getProduto().getNome());
            dto.setTitulo(destaque.getTitulo());
            dto.setProdutoId(destaque.getProduto().getId());
            dto.setValor(destaque.getProduto().getValor());
            if (NullUtil.isNotNull((Object)destaque.getProduto().getValorDesconto()) && destaque.getProduto().getValorDesconto().doubleValue() > 0.0) {
                dto.setValor(destaque.getProduto().getValor().subtract(destaque.getProduto().getValor().multiply(destaque.getProduto().getValorDesconto().divide(new BigDecimal(100)))));
            } else {
                dto.setValor(destaque.getProduto().getValor());
            }
            dto.setVendaPorFracao(destaque.getProduto().getVendaPorFracao());
            dto.setVendaPorTamanho(destaque.getProduto().getVendaPorTamanho());
            dto.setExibirPreco(destaque.getExibirPreco());
            if (destaque.getFotoExterna().booleanValue()) {
                dto.setFoto(destaque.getCaminhoFoto());
                dto.setMiniatura(destaque.getCaminhoFoto());
            } else if (StringUtil.isNotBlank((String)destaque.getCaminhoFoto())) {
                dto.setFoto(this.fileService.getPictureUrl(destaque, false));
                dto.setMiniatura(this.fileService.getPictureUrl(destaque, true));
            }
            destaques.add(dto);
        }
        return destaques;
    }

    public List<EmpresaProdutoEmDestaqueView> listarProdutosEmDestaquePromocionaisPorEmpresa(Long empresaId) throws ApiException {
        if (NullUtil.isNullOrZero((Number)empresaId)) {
            throw new ApiException("erro.api.padrao", new String[]{"empresaId n\u00e3o foi informado"});
        }
        ArrayList<EmpresaProdutoEmDestaqueView> destaques = new ArrayList<EmpresaProdutoEmDestaqueView>();
        DiaDaSemana dayOfWeek = DiaDaSemana.get((int)Calendar.getInstance().get(7));
        List produtosEmDestaque = this.spotilightProductRepository.findByProdutoEmDestaquePromocional(empresaId, dayOfWeek.ordinal() + "");
        for (EmpresaProdutoEmDestaque destaque : produtosEmDestaque) {
            if (destaque.getProduto().getEmFalta().booleanValue()) continue;
            EmpresaProdutoEmDestaqueView dto = new EmpresaProdutoEmDestaqueView();
            dto.setNome(destaque.getProduto().getNome());
            dto.setTitulo(destaque.getTitulo());
            dto.setProdutoId(destaque.getProduto().getId());
            dto.setValor(destaque.getProduto().getValor());
            if (NullUtil.isNotNull((Object)destaque.getProduto().getValorDesconto()) && destaque.getProduto().getValorDesconto().doubleValue() > 0.0) {
                dto.setValor(destaque.getProduto().getValor().subtract(destaque.getProduto().getValor().multiply(destaque.getProduto().getValorDesconto().divide(new BigDecimal(100)))));
            } else {
                dto.setValor(destaque.getProduto().getValor());
            }
            dto.setVendaPorFracao(destaque.getProduto().getVendaPorFracao());
            dto.setVendaPorTamanho(destaque.getProduto().getVendaPorTamanho());
            dto.setExibirPreco(destaque.getExibirPreco());
            if (destaque.getFotoExterna().booleanValue()) {
                dto.setFoto(destaque.getCaminhoFoto());
                dto.setMiniatura(destaque.getCaminhoFoto());
            } else if (StringUtil.isNotBlank((String)destaque.getCaminhoFoto())) {
                dto.setFoto(this.fileService.getPictureUrl(destaque, false));
                dto.setMiniatura(this.fileService.getPictureUrl(destaque, true));
            }
            destaques.add(dto);
        }
        return destaques;
    }

    public List<EmpresaProdutoEmDestaqueView> listSpotlightProductsByCompany(Long companyId) throws ApiException {
        if (NullUtil.isNullOrZero((Number)companyId)) {
            throw new ApiException("erro.api.padrao", new String[]{"empresaId n\u00e3o foi informado"});
        }
        DiaDaSemana dayOfWeek = DiaDaSemana.get((int)Calendar.getInstance().get(7));
        List productsSpotlights = this.spotilightProductRepository.findSpotlightProductByCompany(companyId, dayOfWeek.ordinal() + "");
        ArrayList<EmpresaProdutoEmDestaqueView> spotlights = new ArrayList<EmpresaProdutoEmDestaqueView>();
        productsSpotlights.forEach(spotlight -> {
            EmpresaProdutoEmDestaqueView dto = new EmpresaProdutoEmDestaqueView();
            dto.setNome(spotlight.getProduto().getNome());
            dto.setTitulo(spotlight.getTitulo());
            dto.setProdutoId(spotlight.getProduto().getId());
            dto.setValor(spotlight.getProduto().getValor());
            if (NullUtil.isNotNull((Object)spotlight.getProduto().getValorDesconto()) && spotlight.getProduto().getValorDesconto().doubleValue() > 0.0) {
                dto.setValor(spotlight.getProduto().getValor().subtract(spotlight.getProduto().getValor().multiply(spotlight.getProduto().getValorDesconto().divide(new BigDecimal(100)))));
            } else {
                dto.setValor(spotlight.getProduto().getValor());
            }
            dto.setVendaPorFracao(spotlight.getProduto().getVendaPorFracao());
            dto.setVendaPorTamanho(spotlight.getProduto().getVendaPorTamanho());
            dto.setExibirPreco(spotlight.getExibirPreco());
            if (spotlight.getFotoExterna().booleanValue()) {
                dto.setFoto(spotlight.getCaminhoFoto());
                dto.setMiniatura(spotlight.getCaminhoFoto());
            } else if (StringUtil.isNotBlank((String)spotlight.getCaminhoFoto())) {
                dto.setFoto(this.fileService.getPictureUrl(spotlight, false));
                dto.setMiniatura(this.fileService.getPictureUrl(spotlight, true));
            }
            spotlights.add(dto);
        });
        return spotlights;
    }

    public List<PromocaoView> listSpotlightPromotionsByCompany(Long companyId) throws ApiException {
        if (NullUtil.isNullOrZero((Number)companyId)) {
            throw new ApiException("erro.api.padrao", new String[]{"empresaId n\u00e3o foi informado"});
        }
        List promotions = this.promotionRepository.findAvaliablePromotions(companyId, DateUtil.obterDiaDaSemanaCorrente().ordinal() + "");
        promotions.forEach(promotion -> {
            promotion.setFoto(this.fileService.getPictureUrl(promotion, companyId, false));
            promotion.setMiniatura(this.fileService.getPictureUrl(promotion, companyId, true));
        });
        return promotions;
    }

    public List<ProdutoView> listTempSpotlightProductsByCompany(Long companyId) throws ApiException {
        if (NullUtil.isNullOrZero((Number)companyId)) {
            throw new ApiException("erro.api.padrao", new String[]{"empresaId n\u00e3o foi informado"});
        }
        List products = this.productRepository.listRandomProductsToCatalog(companyId);
        ArrayList<ProdutoView> items = new ArrayList<ProdutoView>();
        products.forEach(product -> {
            ProdutoView item = new ProdutoView();
            item.setId(product.getId());
            item.setNome(product.getNome());
            item.setValor(product.getValor());
            item.setCodigoAtos(product.getCodigoAtos());
            if (product.getVendaPorTamanho().booleanValue()) {
                item.setValorTamanhoBroto(product.getValorTamanhoBroto());
                item.setValorTamanhoMedio(product.getValorTamanhoMedio());
                item.setValorTamanhoGrande(product.getValorTamanhoGrande());
                item.setValorTamanhoGigante(product.getValorTamanhoGigante());
            }
            if (NullUtil.isNotNull((Object)product.getFotoExterna()) && product.getFotoExterna().booleanValue()) {
                item.setFoto(product.getCaminhoFoto());
                item.setMiniatura(product.getCaminhoFoto());
            } else {
                item.setFoto(this.fileService.getPictureUrl(product, false));
                item.setMiniatura(this.fileService.getPictureUrl(product, true));
            }
            items.add(item);
        });
        return items;
    }

    public List<Produto> listSomeOfferProducts(Long empresaId) throws ApiException {
        if (NullUtil.isNullOrZero((Number)empresaId)) {
            throw new ApiException("erro.api.padrao", new String[]{"empresaId n\u00e3o foi informado"});
        }
        List products = this.productRepository.listRandomProductsOnOffer(empresaId);
        products.forEach(product -> {
            if (product.getFotoExterna().booleanValue()) {
                product.setFoto(product.getCaminhoFoto());
                product.setMiniatura(product.getCaminhoFoto());
            } else {
                product.setFoto(this.fileService.getPictureUrl(product, false));
                product.setMiniatura(this.fileService.getPictureUrl(product, true));
            }
        });
        return products;
    }

    public List<CategoriaDoProduto> listarSubCategoriasDaCategoria(Long categoriaId) throws ApiException {
        return this.categoryRepository.findByCategoriaPaiIdAndAtivoIsTrueAndExcluidaIsFalse(categoriaId);
    }

    public List<CardapioDaMesa> listTableMenu(Long companyId) throws ApiException {
        ArrayList<CardapioDaMesa> menu = new ArrayList<CardapioDaMesa>();
        List categories = this.categoryRepository.listAllCategoriesByCompany(companyId);
        categories.forEach(category -> {
            boolean hasChildren;
            boolean bl = hasChildren = categories.stream().filter(c -> NullUtil.isNotNull((Object)c.getCategoriaPai()) && category.getId().equals(c.getCategoriaPai().getId())).count() > 0L;
            if (!hasChildren) {
                CardapioDaMesa menuItem = new CardapioDaMesa(this.populateCategoryList(category));
                menuItem.setTitulo(menuItem.getCategoria().getDescricao());
                DiaDaSemana dayOnWeek = DiaDaSemana.get((int)Calendar.getInstance().get(7));
                List products = this.productRepository.findAvaliableProductsByCategory(companyId, category.getId(), dayOnWeek.ordinal() + "");
                products.forEach(p -> menuItem.getProdutos().add(this.populateProductList(p)));
                menuItem.getProdutos().sort(Comparator.comparing(Produto::getNome));
                if (!CollectionUtils.isEmpty((Collection)menuItem.getProdutos())) {
                    menu.add(menuItem);
                }
            }
        });
        menu.sort(Comparator.comparing(CardapioDaMesa::getTitulo));
        return menu;
    }

    @Deprecated
    public Page<Produto> paginateProductsByCompanyAndCategory(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        searchCriteria = searchCriteria.concat("@@").concat("disponibilidades:").concat(DateUtil.obterDiaDaSemanaCorrente().ordinal() + "");
        ProdutoSpecificationBuilder builder = new ProdutoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page results = this.productRepository.findAll(spec, (Pageable)pageable);
        return results.map(arg_0 -> this.populateProductList(arg_0));
    }

    public Page<ProdutoDoCatalogo> paginateCatalogProduct(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        searchCriteria = searchCriteria.concat("@@").concat("disponibilidades:").concat(DateUtil.obterDiaDaSemanaCorrente().ordinal() + "");
        ProdutoDoCatalogoSpecificationBuilder builder = new ProdutoDoCatalogoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page results = this.catalogProductRepository.findAll(spec, (Pageable)pageable);
        results.forEach(product -> {
            if (StringUtil.isBlank((String)product.getCaminhoFoto())) {
                Emblema emblem = (Emblema)this.emblemRepository.findByCategoryId(product.getCategoria().getId()).get();
                try {
                    product.setFoto(null);
                    product.setMiniatura(this.fileService.getPictureUrl(emblem));
                }
                catch (ApiException e) {
                    LOGGER.warn(Message.getInstance().getMessage("msg.erro.091", new String[]{e.getMessage()}));
                }
            } else if (product.getFotoExterna().booleanValue()) {
                product.setFoto(product.getCaminhoFoto());
                product.setMiniatura(product.getCaminhoFoto());
            } else {
                product.setFoto(this.fileService.getPictureUrl(product, false));
                product.setMiniatura(this.fileService.getPictureUrl(product, true));
            }
        });
        return results;
    }

    private CategoriaDoProdutoApi popularApi(CategoriaDoProduto category) throws ApiException {
        CategoriaDoProdutoApi api = new CategoriaDoProdutoApi();
        api.setId(category.getId());
        api.setDescricao(category.getDescricao());
        api.setEmblemaId(category.getEmblema().getId());
        api.setDescricaoEmblema(category.getEmblema().getDescricao());
        api.setFoto(this.fileService.getPictureUrl(category.getEmblema()));
        return api;
    }

    private CategoriaDoProduto populateCategoryList(CategoriaDoProduto category) {
        CategoriaDoProduto item = new CategoriaDoProduto();
        item.setId(category.getId());
        item.setCategoriaPai(category.getCategoriaPai());
        item.setDescricao(NullUtil.isNull((Object)item.getCategoriaPai()) ? category.getDescricao() : String.format("%s - %s", category.getCategoriaPai().getDescricao(), category.getDescricao()));
        item.setQuantitativa(category.getQuantitativa());
        item.setComposicao(category.getComposicao());
        item.setOrdem(category.getOrdem());
        return item;
    }

    private Produto populateProductList(Produto product) {
        Produto item = new Produto();
        CategoriaDoProduto category = product.getCategoria();
        item.setId(product.getId());
        item.setNome(product.getNome());
        item.setDescricao(product.getDescricao());
        item.setValor(product.getValor());
        item.setVendaPorTamanho(product.getVendaPorTamanho());
        item.setCategoria(new CategoriaDoProduto(category.getId()));
        item.getCategoria().setDescricao(category.getDescricao());
        item.getCategoria().setQuantitativa(category.getQuantitativa());
        item.getCategoria().setComposicao(category.getComposicao());
        item.setValorDesconto(product.getValorDesconto());
        item.setEmFalta(product.getEmFalta());
        item.setVendaPorFracao(product.getVendaPorFracao());
        item.setPesoMedio(product.getPesoMedio());
        item.setDisponibilidades(product.getDisponibilidades());
        item.setEstoque(product.getEstoque());
        item.setEstoqueIlimitado(product.getEstoqueIlimitado());
        item.setVendaPorFracao(product.getVendaPorFracao());
        item.setVendaPorAtacado(product.getVendaPorAtacado());
        item.setQtdeMinVendaPorAtacado(product.getQtdeMinVendaPorAtacado());
        item.setValorAtacado(product.getValorAtacado());
        item.setValorAPrazo(product.getValorAPrazo());
        item.setOpcionaisPorProduto(product.getOpcionaisPorProduto());
        item.setAltura(product.getAltura());
        item.setLargura(product.getLargura());
        item.setProfundidade(product.getProfundidade());
        item.setPeso(product.getPeso());
        if (item.getVendaPorTamanho().booleanValue()) {
            item.setValorTamanhoBroto(product.getValorTamanhoBroto());
            item.setLabelTamanhoBroto(product.getLabelTamanhoBroto());
            item.setValorTamanhoMedio(product.getValorTamanhoMedio());
            item.setLimiteSelecaoTamanhoBroto(product.getLimiteSelecaoTamanhoBroto());
            item.setLabelTamanhoMedio(product.getLabelTamanhoMedio());
            item.setLimiteSelecaoTamanhoMedio(product.getLimiteSelecaoTamanhoMedio());
            item.setValorTamanhoGrande(product.getValorTamanhoGrande());
            item.setLabelTamanhoGrande(product.getLabelTamanhoGrande());
            item.setLimiteSelecaoTamanhoGrande(product.getLimiteSelecaoTamanhoGrande());
            item.setValorTamanhoGigante(product.getValorTamanhoGigante());
            item.setLabelTamanhoGigante(product.getLabelTamanhoGigante());
            item.setLimiteSelecaoTamanhoGigante(product.getLimiteSelecaoTamanhoGigante());
        }
        if (StringUtil.isNotBlank((String)product.getCaminhoFoto()) && !product.getFotoExterna().booleanValue()) {
            item.setFoto(this.fileService.getPictureUrl(product, false));
            item.setMiniatura(this.fileService.getPictureUrl(product, true));
        } else {
            if (product.getFotoExterna().booleanValue()) {
                item.setMiniatura(product.getCaminhoFoto());
            }
            category.getEmblema().setDescricao(null);
            try {
                category.getEmblema().setFoto(this.fileService.getPictureUrl(category.getEmblema()));
            }
            catch (ApiException e) {
                LOGGER.warn(Message.getInstance().getMessage("msg.erro.091", new String[]{e.getMessage()}));
            }
            item.getCategoria().setEmblema(category.getEmblema());
        }
        return item;
    }

    public List<ValorDaPersonalizacao> listUnavaiableCustomizationValues(List<Long> customizationIds) {
        return this.customizationValueRepository.listUnavaiableCustomizationValues(customizationIds);
    }

    public List<CategoriaDoProduto> listSubCategoriesByCategory(Long categoryId) {
        return this.categoryRepository.listSubCategories(categoryId);
    }
}

