/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.TipoDeExtratoDeCashback;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Cashback;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.ExtratoDeCashback;
import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.model.specification.builder.CashbackSpecificationBuilder;
import com.escolpi.omni.api.model.specification.builder.ExtratoDeCashbackSpecificationBuilder;
import com.escolpi.omni.api.repository.CashbackRepository;
import com.escolpi.omni.api.repository.ClienteRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.ExtratoDeCashbackRepository;
import com.escolpi.omni.api.repository.UsuarioRepository;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.NullUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CashbackService
implements BaseCrudService<Cashback, Long> {
    private static final int CASHBACK_INTERVAL_DAYS = 60;
    @Autowired
    private CashbackRepository repository;
    @Autowired
    private ExtratoDeCashbackRepository cashbackExtractRepository;
    @Autowired
    private EmpresaRepository companyRepository;
    @Autowired
    private ClienteRepository customerRepository;
    @Autowired
    private UsuarioRepository userRepository;

    @Transactional
    public void ajustCredits(Cashback cashback, TipoDeExtratoDeCashback extractType, Long userId) throws ApiException {
        Cashback edit = (Cashback)this.repository.findById((Object)cashback.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cashback", cashback.getId().toString()}));
        Usuario user = (Usuario)this.userRepository.findById((Object)userId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Usu\u00e1rio", userId.toString()}));
        ExtratoDeCashback extract = new ExtratoDeCashback(cashback);
        extract.setDataHoraDoLancamento(new Date());
        extract.setTipoDeLancamento(extractType);
        if (extractType.equals((Object)TipoDeExtratoDeCashback.CREDITO)) {
            edit.setCreditoDisponivel(edit.getCreditoDisponivel().add(cashback.getValorAjustado()));
            extract.setDescricao(String.format("Cr\u00e9dito de cashback atribuido pelo usu\u00e1rio %s. Motivo: %s.", user.getLogin(), cashback.getJustificativaDeAlteracao()));
            extract.setValor(cashback.getValorAjustado());
        }
        if (extractType.equals((Object)TipoDeExtratoDeCashback.DEBITO)) {
            edit.setCreditoDisponivel(edit.getCreditoDisponivel().subtract(cashback.getValorAjustado()));
            extract.setDescricao(String.format("Cr\u00e9dito de cashback debitado pelo usu\u00e1rio %s. Motivo: %s.", user.getLogin(), cashback.getJustificativaDeAlteracao()));
            extract.setValor(cashback.getValorAjustado().multiply(new BigDecimal(-1.0)));
        }
        if (extractType.equals((Object)TipoDeExtratoDeCashback.ESTORNO)) {
            edit.setCreditoUtilizado(edit.getCreditoUtilizado().subtract(cashback.getValorAjustado()));
            edit.setCreditoDisponivel(edit.getCreditoDisponivel().add(cashback.getValorAjustado()));
            extract.setDescricao(String.format("Cashback estornado pelo usu\u00e1rio %s. Motivo: %s.", user.getLogin(), cashback.getJustificativaDeAlteracao()));
            extract.setValor(cashback.getValorAjustado());
        }
        this.repository.save((Object)edit);
        this.cashbackExtractRepository.save((Object)extract);
    }

    public List<ExtratoDeCashback> findAllExtractByCashback(Long cashbackId) {
        return this.cashbackExtractRepository.findByCashbackId(cashbackId).orElse(null);
    }

    @Transactional
    public Cashback createCustomerWallet(Long companyId, Long customerId) throws ApiException {
        Cashback cashback = new Cashback();
        cashback.setEmpresa((Empresa)this.companyRepository.findById((Object)companyId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", companyId.toString()})));
        cashback.setCliente((Cliente)this.customerRepository.findById((Object)customerId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", companyId.toString()})));
        cashback.setDataDeInicioDaUtilizacao(new Date());
        cashback.setAtivo(Boolean.valueOf(true));
        cashback.setCreditoDisponivel(BigDecimal.ZERO);
        cashback.setCreditoReservado(BigDecimal.ZERO);
        cashback.setCreditoUtilizado(BigDecimal.ZERO);
        return (Cashback)this.repository.save((Object)cashback);
    }

    public Cashback findByCustomer(Long companyId, Long customerId) {
        return this.repository.findCurrentCashback(companyId, customerId).orElse(null);
    }

    public List<Cashback> listCashbacksToCredit() {
        return this.repository.listCashbackWithProvisionedCredit();
    }

    @Transactional
    public void creditCustomerCashback(Cashback cashback) throws ApiException {
        Cashback edit = (Cashback)this.repository.findById((Object)cashback.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cashback", cashback.getId().toString()}));
        BigDecimal reservedCredit = new BigDecimal(edit.getCreditoDisponivel().doubleValue());
        edit.setCreditoDisponivel(edit.getCreditoDisponivel().add(edit.getCreditoReservado()));
        edit.setCreditoReservado(BigDecimal.ZERO);
        this.repository.save((Object)edit);
        ExtratoDeCashback previousExtract = this.cashbackExtractRepository.findTopByCashbackIdOrderByIdDesc(edit.getId()).orElse(null);
        ExtratoDeCashback extract = new ExtratoDeCashback(cashback);
        extract.setDataHoraDoLancamento(new Date());
        extract.setTipoDeLancamento(TipoDeExtratoDeCashback.CREDITO);
        extract.setDescricao("Cr\u00e9dito de cashback recebido.");
        extract.setValor(reservedCredit);
        if (NullUtil.isNotNull((Object)previousExtract)) {
            extract.setPedido(previousExtract.getPedido());
        }
        this.cashbackExtractRepository.save((Object)extract);
    }

    public Page<ExtratoDeCashback> listCashbackExtractFromLast60Days(Long cashbackId, Integer pageNumber, String sortDirection, Integer entriesByPage) {
        return this.cashbackExtractRepository.listCashbackExtractFromLast60Days(cashbackId, DateUtil.getDateFromLastIntervalOnDays((Date)new Date(), (int)60), (Pageable)PageRequest.of((int)pageNumber, (int)entriesByPage));
    }

    public void delete(Long id) throws ApiException {
    }

    public Page<Cashback> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        CashbackSpecificationBuilder builder = new CashbackSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page results = this.repository.findAll(spec, (Pageable)pageable).map(arg_0 -> this.populateCashback(arg_0));
        return results;
    }

    public Page<ExtratoDeCashback> filterExtract(String searchCriteria, Integer pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        ExtratoDeCashbackSpecificationBuilder builder = new ExtratoDeCashbackSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.cashbackExtractRepository.findAll(spec, (Pageable)pageable);
    }

    public List<Cashback> findAll(Long empresaId) throws ApiException {
        return null;
    }

    public Cashback findById(Long id) throws ApiException {
        return this.repository.findById((Object)id).orElse(null);
    }

    @Transactional
    public void save(Cashback entity) throws ApiException {
        Cashback edit = (Cashback)this.repository.findById((Object)entity.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cashback", entity.getId().toString()}));
        edit.setAtivo(entity.getAtivo());
        edit.setCreditoDisponivel(edit.getCreditoDisponivel());
        edit.setCreditoReservado(edit.getCreditoReservado());
        edit.setCreditoUtilizado(edit.getCreditoUtilizado());
        this.repository.save((Object)edit);
    }

    @Transactional
    public void toggleActivationState(Long id) throws ApiException {
        Cashback edit;
        edit.setAtivo(Boolean.valueOf((edit = (Cashback)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cashback", id.toString()}))).getAtivo() == false));
        this.repository.save((Object)edit);
    }

    public void validate(Cashback entity) throws ApiException {
    }

    private Cashback populateCashback(Cashback cashback) {
        Cashback item = new Cashback();
        item.setId(cashback.getId());
        item.setCliente(new Cliente(cashback.getCliente().getId(), cashback.getCliente().getNome()));
        item.setCreditoDisponivel(cashback.getCreditoDisponivel());
        item.setCreditoReservado(cashback.getCreditoReservado());
        item.setCreditoUtilizado(cashback.getCreditoUtilizado());
        item.setDataDeInicioDaUtilizacao(cashback.getDataDeInicioDaUtilizacao());
        item.setEmpresa(new Empresa(cashback.getEmpresa().getId()));
        item.setAtivo(cashback.getAtivo());
        return item;
    }

    public ExtratoDeCashback findExtractById(Long extractId) throws ApiException {
        return (ExtratoDeCashback)this.cashbackExtractRepository.findById((Object)extractId).orElseThrow(() -> new ApiException("error.entidade,nao.encontrado", new String[]{"Extrato de Cashback"}));
    }
}

