/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CartaoDoCliente;
import com.escolpi.omni.api.repository.CartaoDoClienteRepository;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CryptUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CartaoDoClienteService
implements BaseCrudService<CartaoDoCliente, Long> {
    @Autowired
    CartaoDoClienteRepository repository;

    @Transactional
    public void delete(Long id) throws ApiException {
        CartaoDoCliente card = (CartaoDoCliente)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cart\u00e3o do Cliente", id.toString()}));
        card.setExcluido(Boolean.valueOf(true));
        card.setNumeroCartao("xxxxxxxxxxxxxxxx");
        card.setSequenciaInicial("xxxx");
        card.setSequenciaFinal("xxxx");
        this.repository.save((Object)card);
    }

    public Page<CartaoDoCliente> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        return null;
    }

    public List<CartaoDoCliente> findAll(Long empresaId) throws ApiException {
        return this.repository.findAll();
    }

    public CartaoDoCliente findById(Long id) throws ApiException {
        CartaoDoCliente card = (CartaoDoCliente)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("msg.erro.entidade.nao.encontrado", new String[]{"Cart\u00e3o do Cliente", id.toString()}));
        card.setNumeroCartao(CryptUtil.shuffleCreditCardNumber((String)card.getNumeroCartao()));
        return card;
    }

    public List<CartaoDoCliente> findCardsByCustomer(Long clienteId) {
        return this.repository.findByClienteIdAndExcluidoIsFalse(clienteId);
    }

    public boolean cardBelongsToCustomer(Long customerId, String cardNumber) throws ApiException {
        CartaoDoCliente card = this.repository.findByNumeroCartaoAndExcluidoIsFalse(CryptUtil.shuffleCreditCardNumber((String)cardNumber)).orElse(null);
        return card != null && card.getId().equals(customerId);
    }

    @Transactional
    public void save(CartaoDoCliente card) throws ApiException {
        this.validate(card);
        if (NullUtil.isNotNullOrZero((Number)card.getId())) {
            CartaoDoCliente edit = (CartaoDoCliente)this.repository.findById((Object)card.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cart\u00e3o do Cliente", card.getId().toString()}));
            edit.setAnoValidade(card.getAnoValidade());
            edit.setMesValidade(card.getMesValidade());
            edit.setNumeroCartao(CryptUtil.shuffleCreditCardNumber((String)card.getNumeroCartao()));
            edit.setSequenciaInicial(card.getSequenciaInicial());
            edit.setSequenciaFinal(card.getSequenciaFinal());
            edit.setTitular(card.getTitular().toUpperCase());
            edit.setBandeira(card.getBandeira());
            edit.setExcluido(Boolean.valueOf(NullUtil.isNull((Object)card.getExcluido()) ? false : card.getExcluido()));
            edit.setCpf(StringUtil.removerMascara((String)card.getCpf()));
            this.repository.save((Object)edit);
        } else {
            card.setTitular(card.getTitular().toUpperCase());
            card.setNumeroCartao(CryptUtil.shuffleCreditCardNumber((String)card.getNumeroCartao()));
            card.setExcluido(Boolean.valueOf(false));
            card.setCpf(StringUtil.removerMascara((String)card.getCpf()));
            this.repository.save((Object)card);
        }
    }

    public void validate(CartaoDoCliente card) throws ApiException {
        if (StringUtil.isBlank((String)card.getNumeroCartao())) {
            throw new ApiException("msg.erro.001", new String[]{"N\u00famero do Cart\u00e3o"});
        }
        if (NullUtil.isNullOrZero((Serializable)((Object)card.getSequenciaInicial()))) {
            throw new ApiException("msg.erro.001", new String[]{"Sequ\u00eancia Inicial do Cart\u00e3o"});
        }
        if (NullUtil.isNullOrZero((Serializable)((Object)card.getSequenciaFinal()))) {
            throw new ApiException("msg.erro.001", new String[]{"Sequ\u00eancia Final do Cart\u00e3o"});
        }
        if (NullUtil.isNullOrZero((Serializable)((Object)card.getMesValidade()))) {
            throw new ApiException("msg.erro.001", new String[]{"M\u00eas de vencimento do Cart\u00e3o"});
        }
        if (NullUtil.isNullOrZero((Serializable)((Object)card.getAnoValidade()))) {
            throw new ApiException("msg.erro.001", new String[]{"Ano de vencimento do Cart\u00e3o"});
        }
        if (StringUtil.isBlank((String)card.getTitular())) {
            throw new ApiException("msg.erro.001", new String[]{"T\u00edtular impresso "});
        }
        if (NullUtil.isNullOrZero((Number)card.getId()) && this.customerCardExists(card.getCliente().getId(), CryptUtil.shuffleCreditCardNumber((String)card.getNumeroCartao()))) {
            throw new ApiException("msg.erro.102");
        }
        if (NullUtil.isNotNullOrZero((Number)card.getId()) && this.cardBelongsToCustomer(card.getCliente().getId(), CryptUtil.shuffleCreditCardNumber((String)card.getNumeroCartao()))) {
            throw new ApiException("msg.erro.103");
        }
    }

    private boolean customerCardExists(Long customerId, String numberCard) {
        CartaoDoCliente card = this.repository.findByClienteIdAndNumeroCartaoAndExcluidoIsFalse(customerId, numberCard).orElse(null);
        return card != null;
    }
}

