/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.scheduled;

import com.escolpi.omni.api.model.entity.SolicitacaoDeAtivacao;
import com.escolpi.omni.api.repository.SolicitacaoDeAtivacaoRepository;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.LoggerUtil;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SolicitacaoDeAtivacaoSchedule {
    @Autowired
    private SolicitacaoDeAtivacaoRepository solicitacaoRepository;

    public void excluirSolicitacoesExpiradas() {
        LoggerUtil.log((String)"*** EXCLUIR SOLICITA\u00c7\u00d5ES DE ATIVA\u00c7\u00c3O DE CONTAS EXPIRADAS ***");
        this.solicitacaoRepository.findByEncerradaIsFalse().forEach(solicitacao -> {
            LoggerUtil.info((String)String.format("Verificando %s", this.getInfo(solicitacao)));
            if (DateUtil.calcularDiferencaEntreDatasEmHoras((Date)solicitacao.getDataHoraSolicitacao(), (Date)new Date()) >= 24L) {
                this.solicitacaoRepository.deleteById((Object)solicitacao.getId());
                LoggerUtil.success((String)String.format("A %s expirada foi exclu\u00edda com sucesso!", this.getInfo(solicitacao)));
            }
        });
    }

    private String getInfo(SolicitacaoDeAtivacao solicitacao) {
        return String.format("solicita\u00e7\u00e3o n\u00ba %s da conta %s <%s>", solicitacao.getId(), solicitacao.getCliente().getNome(), solicitacao.getCliente().getUsuario().getLogin());
    }
}

