/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.scheduled;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.service.ClienteService;
import com.escolpi.omni.api.util.LoggerUtil;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ContaDeUsuarioSchedule {
    @Autowired
    private ClienteService clienteService;

    public void excluirContasInativasApos30Dias() {
        LoggerUtil.log((String)"*** EXCLUIR CONTAS INATIVAS A 30 DIAS ***");
        List clientesInativosA30Dias = this.clienteService.getInactiveAccountsLast30days();
        if (!CollectionUtils.isEmpty((Collection)clientesInativosA30Dias)) {
            clientesInativosA30Dias.forEach(cliente -> {
                try {
                    LoggerUtil.log((String)String.format("Excluindo conta %s <%s>...", cliente.getNome(), cliente.getUsuario().getLogin()));
                    this.clienteService.delete(cliente.getId());
                    LoggerUtil.log((String)String.format("Conta %s <%s> exclu\u00edda com sucesso!", cliente.getNome(), cliente.getUsuario().getLogin()));
                }
                catch (ApiException e) {
                    LoggerUtil.error((String)String.format("O usu\u00e1rio %s n\u00e3o foi exclu\u00eddo: %s", cliente.getNome(), e.getMessage()));
                }
            });
        } else {
            LoggerUtil.info((String)"Nenhuma conta para excluir neste momento");
        }
    }
}

