/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.ui;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.FileService;
import com.escolpi.omni.api.service.ProdutoService;
import com.escolpi.omni.api.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ui/pictures/{empresaId}"})
public class LazyPictureResource
extends BaseResource {
    @Autowired
    private ProdutoService produtoService;
    @Autowired
    private FileService fileService;

    @GetMapping(path={"/{produtoId}"}, produces={"text/plain"})
    public String getPictureByProduct(@PathVariable(value="produtoId") Long productId) throws ApiException {
        Produto product = this.produtoService.find(productId);
        if (StringUtil.isBlank((String)product.getCaminhoFoto())) {
            return this.fileService.getBlankPictureUrl();
        }
        return product.getFotoExterna() != false ? product.getCaminhoFoto() : this.fileService.getPictureUrl(product, false);
    }
}

