/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.PersonalizacaoDeProduto;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.PersonalizacaoDeProdutoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/personalizacoes-produtos/{empresaId}"})
public class ManterPersonalizacaoDeProdutoResource
implements BaseCrudResource<PersonalizacaoDeProduto, Long> {
    private Entidade entidade = Entidade.PERSONALIZACAO_DE_PRODUTO;
    @Autowired
    private LogDeAcessoService logService;
    @Autowired
    private PersonalizacaoDeProdutoService service;

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PERSONALIZACAO_EXCLUIR') and #oauth2.hasScope('write')")
    public void delete(@PathVariable Long empresaId, @PathVariable Long id) throws ApiException {
        try {
            this.service.delete(empresaId, id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.EXCLUSAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PERSONALIZACAO_LISTAR') and #oauth2.hasScope('read')")
    public Page<PersonalizacaoDeProduto> filter(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="search") String searchCriteria, @RequestParam(value="numeroPagina") Integer numeroPagina, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        return this.service.filter(empresaId, searchCriteria, numeroPagina, sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PERSONALIZACAO_OBTER') and #oauth2.hasScope('read')")
    public PersonalizacaoDeProduto get(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long id) throws ApiException {
        try {
            PersonalizacaoDeProduto customizationProduct = this.service.findById(id);
            return customizationProduct;
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/find-all"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PERSONALIZACAO_LISTAR') and #oauth2.hasScope('read')")
    public List<PersonalizacaoDeProduto> list(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.service.list(empresaId);
    }

    @PostMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PERSONALIZACAO_CRIAR') and #oauth2.hasScope('write')")
    public void save(@PathVariable(value="empresaId") Long empresaId, @RequestBody PersonalizacaoDeProduto entity) throws ApiException {
        try {
            this.service.save(empresaId, entity);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_PERSONALIZACAO_EDITAR') and #oauth2.hasScope('write')")
    public void update(@PathVariable(value="empresaId") Long empresaId, @RequestBody PersonalizacaoDeProduto entity) throws ApiException {
        try {
            this.service.save(empresaId, entity);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }
}

