/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.entity.PedidoResumido;
import com.escolpi.omni.api.model.entity.dto.DashboardInfo;
import com.escolpi.omni.api.model.entity.dto.Top10Dto;
import com.escolpi.omni.api.model.projection.PedidoView;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.MessengerService;
import com.escolpi.omni.api.service.PedidoService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/pedidos/{empresaId}"})
public class ManterPedidoResource
extends BaseResource {
    @Autowired
    private MessengerService messengerService;
    @Autowired
    private PedidoService service;

    @PutMapping(value={"/cancel/{orderId}/{userId}"})
    public void cancelOrder(@PathVariable Long orderId, @PathVariable Long userId) throws ApiException, IOException, InterruptedException {
        this.service.cancelOrder(orderId, userId);
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_OBTER') and #oauth2.hasScope('read')")
    public ResponseEntity<Page<PedidoResumido>> filter(@RequestParam(value="search") String searchCriteria, @RequestParam(value="numeroPagina") int numeroPagina, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        searchCriteria = searchCriteria.concat("@@").concat("notScheduled:true");
        return new ResponseEntity((Object)this.service.getOrdersFromOfficeHours(searchCriteria, numeroPagina, entriesByPage), HttpStatus.OK);
    }

    @GetMapping(value={"/filter-scheduled-orders"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_OBTER') and #oauth2.hasScope('read')")
    public ResponseEntity<Page<Pedido>> filterScheduledOrders(@RequestParam(value="search") String searchCriteria, @RequestParam(value="numeroPagina") int numeroPagina, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        searchCriteria = searchCriteria.concat("@@").concat("situacao:AGENDADO");
        return new ResponseEntity((Object)this.service.getScheduledOrders(searchCriteria, numeroPagina, entriesByPage), HttpStatus.OK);
    }

    @GetMapping(value={"/filter/novos-pedidos"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_OBTER') and #oauth2.hasScope('read')")
    public ResponseEntity<Page<PedidoResumido>> filterNewOrders(@RequestParam(value="search") String searchCriteria, @RequestParam(value="numeroPagina") int numeroPagina, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException, IOException {
        searchCriteria = searchCriteria.concat("@@").concat("notScheduled:true");
        return new ResponseEntity((Object)this.service.listNewOrders(searchCriteria, numeroPagina, entriesByPage), HttpStatus.OK);
    }

    @GetMapping(value={"/notificar-novos-pedidos"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_OBTER') and #oauth2.hasScope('read')")
    public ResponseEntity<String> notifyNewOrders(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return new ResponseEntity((Object)this.service.notifyNewOrders(empresaId), HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_EXIBIR') and #oauth2.hasScope('read')")
    public ResponseEntity<Pedido> getOrderDetail(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long pedidoId) throws ApiException {
        return new ResponseEntity((Object)this.service.get(empresaId, pedidoId), HttpStatus.OK);
    }

    @DeleteMapping(value={"/{orderItemId}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_ALTERAR') and #oauth2.hasScope('read')")
    public void removeOrderItem(@PathVariable(value="orderItemId") Long orderItemId) throws ApiException {
        this.service.cancelOrderItem(orderItemId);
    }

    @PostMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_OBTER') and #oauth2.hasScope('read')")
    public ResponseEntity<List<PedidoView>> getOrdersByStatus(@PathVariable(value="empresaId") Long empresaId, @RequestBody String situacao) throws ApiException {
        return new ResponseEntity((Object)this.service.listdOrderViewByStatus(empresaId, SituacaoDoPedido.valueOf((String)situacao)), HttpStatus.OK);
    }

    @GetMapping(value={"/atualizar-grafico"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_OBTER') and #oauth2.hasScope('read')")
    public ResponseEntity<List<Pedido>> findByDataPedidoAndEmpresaId(@PathVariable(value="empresaId") Long empresaId) {
        return new ResponseEntity((Object)this.service.findByDataPedidoAndEmpresaId(empresaId), HttpStatus.OK);
    }

    @GetMapping(value={"/distinct-months"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_OBTER') and #oauth2.hasScope('read')")
    public ResponseEntity<List<String>> findDistinctMonths(@PathVariable(value="empresaId") Long empresaId) {
        return new ResponseEntity((Object)this.service.findDistinctMonths(empresaId), HttpStatus.OK);
    }

    @GetMapping(value={"/orders-by-month"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_OBTER') and #oauth2.hasScope('read')")
    public ResponseEntity<DashboardInfo> findDashboardInfo(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="month") Integer month, @RequestParam(value="year") Integer year) {
        return new ResponseEntity((Object)this.service.findDashboardInfo(empresaId, month, year), HttpStatus.OK);
    }

    @GetMapping(value={"/top10-categories"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_OBTER') and #oauth2.hasScope('read')")
    public ResponseEntity<List<Top10Dto>> findTop10Categories(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="month") Integer month, @RequestParam(value="year") Integer year) {
        return new ResponseEntity((Object)this.service.findTop10Categories(empresaId, month, year), HttpStatus.OK);
    }

    @GetMapping(value={"/top10-customers"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_OBTER') and #oauth2.hasScope('read')")
    public ResponseEntity<List<Top10Dto>> findTop10Customers(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="month") Integer month, @RequestParam(value="year") Integer year) {
        return new ResponseEntity((Object)this.service.findTop10Customers(empresaId, month, year), HttpStatus.OK);
    }

    @GetMapping(value={"/top10-neighborhoods"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_OBTER') and #oauth2.hasScope('read')")
    public ResponseEntity<List<Top10Dto>> findTop10Neighborhoods(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="month") Integer month, @RequestParam(value="year") Integer year) {
        return new ResponseEntity((Object)this.service.findTop10Neighborhoods(empresaId, month, year), HttpStatus.OK);
    }

    @GetMapping(value={"/top10-products"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_OBTER') and #oauth2.hasScope('read')")
    public ResponseEntity<List<Top10Dto>> findTop10Products(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="month") Integer month, @RequestParam(value="year") Integer year) {
        return new ResponseEntity((Object)this.service.findTop10Products(empresaId, month, year), HttpStatus.OK);
    }

    @PutMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_ALTERAR') and #oauth2.hasScope('read')")
    public void updateOrderStatus(@RequestBody Pedido order) throws ApiException, IOException, InterruptedException {
        if (!(order = this.service.updateOrderStatus(order)).getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_CONFIRMACAO) || !order.getSituacao().equals((Object)SituacaoDoPedido.FINALIZADO)) {
            this.messengerService.sendOrderMessage(order);
        }
    }

    @PutMapping(value={"/{id}/import"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_ALTERAR') and #oauth2.hasScope('read')")
    public void toggleImported(@PathVariable Long id) throws ApiException {
        this.service.toggleImported(id);
    }

    @PutMapping(value={"/{id}/test"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_ATENDIMENTO_PEDIDO_ALTERAR') and #oauth2.hasScope('read')")
    public void toggleTestMode(@PathVariable Long id) throws ApiException {
        this.service.toggleTestMode(id);
    }
}

