/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.OpcaoDePagamentoComCartao;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.OpcaoDePagamentoComCartaoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/opcoes_pagto_cartao/{empresaId}"})
public class ManterOpcoesDePagamentoComCartaoResource
extends BaseResource
implements BaseCrudResource<OpcaoDePagamentoComCartao, Long> {
    private Entidade entidade = Entidade.OPCAO_DE_PAGAMENTO_COM_CARTAO;
    @Autowired
    private LogDeAcessoService logService;
    @Autowired
    private OpcaoDePagamentoComCartaoService opcaoService;

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_OPCAO_PAGTO_CARTAO_OBTER') and #oauth2.hasScope('read')")
    public OpcaoDePagamentoComCartao get(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long id) throws ApiException {
        try {
            return this.opcaoService.findById(id, empresaId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_OPCAO_PAGTO_CARTAO_EDITAR') and #oauth2.hasScope('write')")
    public void update(@PathVariable(value="empresaId") Long empresaId, @RequestBody OpcaoDePagamentoComCartao opcao) throws ApiException {
        try {
            this.opcaoService.save(opcao);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_OPCAO_PAGTO_CARTAO_EXCLUIR') and #oauth2.hasScope('write')")
    public void delete(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long id) throws ApiException {
        try {
            this.opcaoService.delete(id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.EXCLUSAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_OPCAO_PAGTO_CARTAO_LISTAR') and #oauth2.hasScope('read')")
    public Page<OpcaoDePagamentoComCartao> filter(@PathVariable(value="empresaId") Long empresaId, @RequestParam String search, @RequestParam Integer numeroPagina, @RequestParam List<String> sortBy, @RequestParam String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        search = search + "@@excluida:false";
        Page pages = this.opcaoService.filter(search, numeroPagina.intValue(), sortBy, sortDirection, entriesByPage);
        return pages;
    }

    @PostMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_OPCAO_PAGTO_CARTAO_CRIAR') and #oauth2.hasScope('write')")
    public void save(@PathVariable(value="empresaId") Long empresaId, @RequestBody OpcaoDePagamentoComCartao opcao) throws ApiException {
        try {
            this.opcaoService.save(opcao);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }

    public List<OpcaoDePagamentoComCartao> list(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return null;
    }
}

