/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.PedidoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/pedido/feedback/{empresaId}"})
public class ManterFeedbackResource
extends BaseResource {
    @Autowired
    private PedidoService service;

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_FEEDBACK_LISTAR') and #oauth2.hasScope('read')")
    public Page<Pedido> filter(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="search") String search, @RequestParam(value="numeroPagina") Integer numeroPagina, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        search = search + "@@situacao:" + SituacaoDoPedido.FINALIZADO;
        search = search + "@@feedback:true";
        return this.service.filterFeedbacks(search, numeroPagina.intValue(), sortBy, sortDirection, entriesByPage);
    }

    @PutMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_FEEDBACK_EDITAR') and #oauth2.hasScope('write')")
    public Pedido update(@PathVariable(value="empresaId") Long empresaId, @RequestBody Pedido pedido) throws ApiException, JsonProcessingException {
        return this.service.saveFeedbackReply(pedido);
    }
}

