/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.dto.ClienteDto;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.service.ClienteService;
import com.escolpi.omni.api.service.LogDeAcessoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/clientes/{empresaId}"})
public class ManterClienteResource
extends BaseResource
implements BaseCrudResource<Cliente, Long> {
    private Entidade entidade = Entidade.CLIENTE;
    @Autowired
    private ClienteService service;
    @Autowired
    private LogDeAcessoService logService;

    @PutMapping(value={"/bloqueio/usuario"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CLIENTES_EDITAR') and #oauth2.hasScope('write')")
    public void blockOrUnblockCustomer(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="customerId") Long customerId) throws ApiException {
        try {
            this.service.changeStatusLockIn(customerId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/bloqueio/pagamento-online"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CLIENTES_EDITAR') and #oauth2.hasScope('write')")
    public void lockOnlinePayment(@PathVariable Long empresaId, @RequestParam Long customerId) throws ApiException {
        this.service.changeOnlinePaymentReceivementStatus(customerId);
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CLIENTES_LISTAR') and #oauth2.hasScope('read')")
    public Page<Cliente> filter(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="search") String search, @RequestParam(value="numeroPagina") Integer numeroPagina, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        return this.service.filter(search, numeroPagina.intValue(), sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/inactive-customers"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CLIENTES_OBTER') and #oauth2.hasScope('read')")
    public List<Cliente> findInactive(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        try {
            return this.service.getInactiveCustomers(empresaId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CLIENTES_OBTER') and #oauth2.hasScope('read')")
    public Cliente get(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long id) throws ApiException {
        try {
            return this.service.findById(id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/consultas/sem-pedidos-90"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CLIENTES_LISTAR') and #oauth2.hasScope('read')")
    public List<Cliente> obterClientesQueNaoCompramA90Dias(@PathVariable Long empresaId) {
        return this.service.getCustomersDoesntBuySince90Days(empresaId);
    }

    @PostMapping(value={"/send-email"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CLIENTES_OBTER') and #oauth2.hasScope('read')")
    public void enviar(@PathVariable(value="empresaId") Long empresaId, @RequestBody List<Long> clientesId) throws ApiException {
        this.service.sendEmailListToAccountActivation(clientesId);
    }

    public void delete(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long id) throws ApiException {
    }

    public List<Cliente> list(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return null;
    }

    @GetMapping(value={"/"})
    public List<ClienteDto> listDto(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.service.findAllDto(empresaId);
    }

    @PostMapping(value={"/"})
    public void save(@PathVariable(value="empresaId") Long empresaId, @RequestBody Cliente cliente) throws ApiException {
        try {
            this.service.save(cliente);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/"})
    public void update(@PathVariable(value="empresaId") Long empresaId, @RequestBody Cliente cliente) throws ApiException {
        try {
            this.service.save(cliente);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }
}

