/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.enumeration.TipoDeExtratoDeCashback;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Cashback;
import com.escolpi.omni.api.model.entity.ExtratoDeCashback;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.service.CashbackService;
import com.escolpi.omni.api.service.LogDeAcessoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/cashbacks/{empresaId}"})
public class ManterCashbackResource
implements BaseCrudResource<Cashback, Long> {
    @Autowired
    private CashbackService service;
    @Autowired
    private LogDeAcessoService logService;
    private Entidade entidade = Entidade.CASHBACK;

    @PutMapping(value={"/ajust-credits/{extractType}/{id}/{userId}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CASHBACK_EDITAR') and #oauth2.hasScope('read')")
    public void ajustCashbackCredits(@PathVariable Long empresaId, @PathVariable Long userId, @PathVariable TipoDeExtratoDeCashback extractType, @RequestBody Cashback cashback) throws ApiException {
        try {
            this.service.ajustCredits(cashback, extractType, userId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    public void delete(@PathVariable Long empresaId, @PathVariable Long id) throws ApiException {
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CASHBACK_LISTAR') and #oauth2.hasScope('read')")
    public Page<Cashback> filter(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="search") String searchCriteria, @RequestParam(value="numeroPagina") Integer pageNumber, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        return this.service.filter(searchCriteria, pageNumber.intValue(), sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/filter/extract"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CASHBACK_LISTAR') and #oauth2.hasScope('read')")
    public Page<ExtratoDeCashback> filterExtract(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="search") String searchCriteria, @RequestParam(value="numeroPagina") Integer pageNumber, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        return this.service.filterExtract(searchCriteria, pageNumber, sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CASHBACK_OBTER') and #oauth2.hasScope('read')")
    public Cashback get(@PathVariable Long empresaId, @PathVariable Long id) throws ApiException {
        try {
            return this.service.findById(id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/extract/detail/{extractId}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CASHBACK_OBTER') and #oauth2.hasScope('read')")
    public ExtratoDeCashback getExtractDetail(@PathVariable Long empresaId, @PathVariable Long extractId) throws ApiException {
        try {
            return this.service.findExtractById(extractId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    public List<Cashback> list(Long empresaId) throws ApiException {
        return null;
    }

    @GetMapping(value={"/extract/{cashbackId}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CASHBACK_LISTAR') and #oauth2.hasScope('read')")
    public List<ExtratoDeCashback> listExtract(@PathVariable Long empresaId, @PathVariable Long cashbackId) throws ApiException {
        return this.service.findAllExtractByCashback(cashbackId);
    }

    public void save(Long empresaId, Cashback entity) throws ApiException {
    }

    @PutMapping(value={"/activate/{cashbackId}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CASHBACK_EDITAR') and #oauth2.hasScope('read')")
    public void toggleActivationState(@PathVariable Long empresaId, @PathVariable Long cashbackId) throws ApiException {
        try {
            this.service.toggleActivationState(cashbackId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CASHBACK_EDITAR') and #oauth2.hasScope('read')")
    public void update(@PathVariable Long empresaId, @RequestBody Cashback entity) throws ApiException {
        try {
            this.service.save(entity);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }
}

