/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.SolicitacaoDeSenha;
import com.escolpi.omni.api.model.entity.dto.EmpresaDto;
import com.escolpi.omni.api.model.projection.UsuarioView;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.MessengerService;
import com.escolpi.omni.api.service.UsuarioService;
import com.escolpi.omni.api.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/empresas/conta"})
public class ContaEmpresaResource
extends BaseResource {
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private EmpresaService empresaService;
    @Autowired
    private MessengerService messengerService;

    @GetMapping(value={"/from-root"})
    public EmpresaDto obter(@RequestParam Long id) throws ApiException {
        EmpresaDto company = this.empresaService.obterCadastroCompletoDaEmpresa(id);
        company.setLogadoComoAdm(true);
        return company;
    }

    @GetMapping(value={"/"})
    public EmpresaDto obter(@RequestParam String email) throws ApiException {
        return this.empresaService.obterPorEmail(email);
    }

    @PostMapping(value={"/recuperar-senha"})
    public ResponseEntity<UsuarioView> requestNewPassword(@RequestParam(value="login") String login) throws ApiException {
        SolicitacaoDeSenha request = this.usuarioService.requestCompanyPassword(login);
        this.messengerService.sendRequestCompanyPasswordValidationCode(request);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)new UsuarioView(null, request.getUsuario().getNome(), request.getUsuario().getLogin(), request.getUsuario().getBloqueado(), StringUtil.formatarTelefoneComMascara((String)request.getUsuario().getTelefone())));
    }

    @Deprecated
    @PostMapping(value={"/mobile/recuperar-senha"})
    public void solicitarRecuperacaoSenhaMobile(@RequestParam(value="email") String login, @RequestParam(value="profile") Long profile, HttpServletRequest request) throws ApiException {
        this.usuarioService.solicitarRecuperacaoSenhaDaEmpresa(login, profile, request, false);
    }

    @PutMapping(value={"/redefinir-senha"})
    public void redefinirSenha(@RequestBody SolicitacaoDeSenha solicitacao) throws ApiException {
        this.usuarioService.redefineCompanyPassword(solicitacao);
    }
}

