/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.domain.Domains;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CartaoDoCliente;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.SolicitacaoDeSenha;
import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.model.projection.UsuarioView;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.CartaoDoClienteService;
import com.escolpi.omni.api.service.ClienteService;
import com.escolpi.omni.api.service.MessengerService;
import com.escolpi.omni.api.service.UsuarioService;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contas/{companyId}"})
public class ContaClienteResource
extends BaseResource {
    @Autowired
    private ClienteService customerService;
    @Autowired
    private CartaoDoClienteService customerCardService;
    @Autowired
    private MessengerService messengerService;
    @Autowired
    private UsuarioService userService;

    @GetMapping(value={"/conta-existente"})
    public boolean customerAccountExists(@PathVariable Long companyId, @RequestParam(value="login") String login) throws ApiException {
        return this.userService.accountExists(companyId, login);
    }

    @GetMapping(value={"/contas-existentes"})
    public List<Usuario> findCompanyAccountsByLogin(@PathVariable(value="companyId") Long companyId, @RequestParam(value="login") String login) throws ApiException {
        return this.userService.findUserAccounts(companyId, login);
    }

    @GetMapping(value={"/"})
    public List<Cliente> list(@PathVariable(value="companyId") Long companyId) throws ApiException {
        return this.customerService.findAll(companyId);
    }

    @GetMapping(value={"/search"})
    public List<Cliente> findByName(@PathVariable(value="companyId") Long companyId, @RequestParam(value="nome") String nome) throws ApiException {
        return this.customerService.findByCompanyAndName(companyId, nome);
    }

    @GetMapping(value={"/{email}"})
    public Cliente getUserByEmail(@PathVariable(value="email") String email, @PathVariable Long companyId) throws ApiException {
        return this.customerService.get(email, companyId);
    }

    @GetMapping(value={"/{cartaoId}/obter-cartao"})
    public CartaoDoCliente getCustomerCard(@PathVariable(value="companyId") Long companyId, @PathVariable(value="cartaoId") Long cartaoId) throws ApiException {
        return this.customerCardService.findById(cartaoId);
    }

    @GetMapping(value={"/obter-solicitacao"})
    public SolicitacaoDeSenha getPasswordRequestByAuthCodeAndUserId(@RequestParam(value="numeroAutenticacao") Integer numeroAutenticacao, @RequestParam(value="usuarioId") Long usuarioId) throws ApiException {
        return this.userService.obterSolicitacaoDeSenha(numeroAutenticacao, usuarioId, Domains.PROFILE_CUSTOMER_ID);
    }

    @GetMapping(value={"/{usuarioId}/solicitar-reativacao"})
    public void requestAccountReactivation(@PathVariable Long companyId, @PathVariable Long usuarioId) throws ApiException {
        this.customerService.requestAccountReactivation(companyId, usuarioId);
    }

    @Deprecated
    @PostMapping(value={"/"})
    public boolean criarConta(@RequestBody Cliente customer, @PathVariable Long companyId) throws ApiException {
        return NullUtil.isNotNull((Object)this.customerService.createCustomerAccount(customer, companyId, false));
    }

    @PostMapping(value={"/novo"})
    public boolean createAccount(@RequestBody Cliente usuario, @PathVariable Long companyId, @RequestParam(value="fcmToken") String fcmToken) throws ApiException {
        return NullUtil.isNotNull((Object)this.customerService.createCustomerAccount(usuario, companyId, false, fcmToken));
    }

    @PostMapping(value={"/web"})
    public boolean createAccountByStore(@RequestBody Cliente customer, @PathVariable Long companyId, @RequestParam(value="fcmToken") String fcmToken) throws ApiException {
        return NullUtil.isNotNull((Object)this.customerService.createCustomerAccount(customer, companyId, true, fcmToken));
    }

    @PostMapping(value={"/salvar-cartao"})
    public CartaoDoCliente saveCustomerCard(@PathVariable Long companyId, @RequestBody CartaoDoCliente cartao) throws ApiException {
        this.customerCardService.save(cartao);
        return cartao;
    }

    @PostMapping(value={"/solicitar-ativacao"})
    public void requestNewAccountActivation(@PathVariable Long companyId, @RequestParam(value="cpf") String cpf) throws ApiException {
        this.customerService.createNewActivationRequest(companyId, cpf, false);
    }

    @PostMapping(value={"/recuperar-senha"})
    public ResponseEntity<UsuarioView> requestNewPassword(@RequestParam(value="email") String login, @PathVariable Long companyId) throws ApiException {
        SolicitacaoDeSenha request = this.userService.requestCustomerPassword(login, companyId);
        this.messengerService.sendRequestCustomerPasswordValidationCode(request, companyId);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)new UsuarioView(companyId, request.getUsuario().getNome(), request.getUsuario().getLogin(), request.getUsuario().getBloqueado(), StringUtil.formatarTelefoneComMascara((String)request.getUsuario().getTelefone())));
    }

    @Deprecated
    @PostMapping(value={"/web/recuperar-senha"})
    public void solicitarRecuperacaoSenhaPelaWeb(@RequestParam(value="email") String login, @PathVariable Long companyId) throws ApiException {
        this.userService.solicitarRecuperacaoSenha(login, companyId, true);
    }

    @PutMapping(value={"/redefinir-senha"})
    public void resetPassword(@RequestBody SolicitacaoDeSenha request, @PathVariable Long companyId) throws ApiException {
        this.userService.redefinePassword(request);
    }

    @GetMapping(value={"/{customerId}/verificar-bloqueio"})
    public Boolean checkCustomerLock(@PathVariable Long companyId, @PathVariable Long customerId) throws ApiException {
        return this.customerService.checkCustomerLockIn(customerId);
    }
}

