/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Cashback;
import com.escolpi.omni.api.model.entity.ExtratoDeCashback;
import com.escolpi.omni.api.service.CashbackService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cashbacks/{companyId}"})
public class CashbackResource {
    @Autowired
    private CashbackService service;

    @PostMapping(value={"/create-wallet/{customerId}"})
    @PreAuthorize(value="hasAuthority('ROLE_CASHBACK_EDITAR') and #oauth2.hasScope('read')")
    public Cashback createCashbackWallet(@PathVariable Long companyId, @PathVariable Long customerId) throws ApiException {
        return this.service.createCustomerWallet(companyId, customerId);
    }

    @GetMapping(value={"/{customerId}"})
    @PreAuthorize(value="hasAuthority('ROLE_CASHBACK_LISTAR') and #oauth2.hasScope('read')")
    public Cashback get(@PathVariable Long companyId, @PathVariable Long customerId) {
        return this.service.findByCustomer(companyId, customerId);
    }

    @GetMapping(value={"/{cashbackId}/list"})
    @PreAuthorize(value="hasAuthority('ROLE_CASHBACK_LISTAR') and #oauth2.hasScope('read')")
    public List<ExtratoDeCashback> listCashbackExtract(@PathVariable Long cashbackId) {
        return this.service.findAllExtractByCashback(cashbackId);
    }

    @GetMapping(value={"/{cashbackId}/list/from-60-days"})
    @PreAuthorize(value="hasAuthority('ROLE_CASHBACK_LISTAR') and #oauth2.hasScope('read')")
    public Page<ExtratoDeCashback> listCashbackExtractFromLast60Days(@PathVariable Long cashbackId, @RequestParam Integer pageNumber, @RequestParam String sortDirection, @RequestParam List<String> sortBy, @RequestParam Integer entriesByPage) {
        return this.service.listCashbackExtractFromLast60Days(cashbackId, pageNumber, sortDirection, entriesByPage);
    }
}

