/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.enumeration.ValorConfiguracaoBooleano;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.EmpresaConfiguracao;
import com.escolpi.omni.api.model.entity.EnderecoMac;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.EnderecoMacService;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.PedidoService;
import com.escolpi.omni.api.util.LoggerUtil;
import com.escolpi.omni.api.util.NullUtil;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/backoffice"})
public class BackOfficeResource {
    @Autowired
    private EmpresaService companyService;
    @Autowired
    private LogDeAcessoService logService;
    @Autowired
    private EnderecoMacService enderecoMacService;
    @Autowired
    private PedidoService orderService;

    @GetMapping(value={"/orders/finalize"})
    public void finalizeOrders() throws ApiException {
        try {
            LoggerUtil.log((String)"*** LISTAR PEDIDOS EM ABERTO PARA FINALIZACAO ***");
            List orders = this.orderService.listOpenedOrders();
            int updatedOrders = 0;
            if (!CollectionUtils.isEmpty((Collection)orders)) {
                for (Pedido order : orders) {
                    EmpresaConfiguracao config = this.companyService.getCompanyConfig(order.getEmpresa().getId(), "config-finalizar-pedido-automaticamente");
                    if (!config.getValor().equals(ValorConfiguracaoBooleano.TRUE.getValor())) continue;
                    LoggerUtil.info((String)String.format("ATUALIZANDO PEDIDO No. %s...", order.getId()));
                    order.setSituacao(SituacaoDoPedido.FINALIZADO);
                    this.orderService.finalizeOrder(order);
                    LoggerUtil.info((String)String.format("PEDIDO No. %s FINALIZADO!", order.getId()));
                    ++updatedOrders;
                }
                LoggerUtil.log((String)String.format("%s PEDIDO(S) FORAM ATUALIZADOS", updatedOrders));
                LoggerUtil.log((String)"*** PEDIDOS FINALIZADOS COM SUCESSO! ***");
            } else {
                LoggerUtil.log((String)"*** NENHUM PEDIDO PENDENTE DE FINALIZA\u00c7\u00c3O! ***");
            }
        }
        catch (ApiException e) {
            LoggerUtil.error((String)("!!! ERRO AO FINALIZAR PEDIDOS: " + e.getMessage() + " !!!"));
            this.logService.save(Long.valueOf(0L), Entidade.PEDIDO, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @PostMapping(value={"/send-mac-address"})
    public void sendMacAddress(@RequestBody String macAddress) throws ApiException {
        this.enderecoMacService.save(new EnderecoMac(macAddress));
    }

    @PostMapping(value={"/send-key"})
    public void sendKey(@RequestBody EnderecoMac macAddress) throws ApiException {
        this.enderecoMacService.save(macAddress);
    }

    @GetMapping(value={"/verify-mac-address/{macAddress}"})
    public Boolean verifyMacAddress(@PathVariable(value="macAddress") String macAddress) throws ApiException {
        EnderecoMac address = this.enderecoMacService.findByMacAddress(macAddress);
        if (NullUtil.isNotNull((Object)address)) {
            return address.getAtivo();
        }
        return false;
    }
}

