/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.model.entity.Personalizacao;
import com.escolpi.omni.api.model.projection.AutocompleteView;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PersonalizacaoRepository
extends JpaRepository<Personalizacao, Long>,
JpaSpecificationExecutor<Personalizacao> {
    public static final String ENTITY_NAME = "Personaliza\u00e7\u00e3o";

    public int countByCategoriaIdAndSubProdutoIsTrue(@Param(value="categoriaId") Long var1);

    public int countByCategoriaIdAndDescricaoIgnoreCaseAndExcluidoIsFalse(@Param(value="categoriaDoProduto") Long var1, @Param(value="descricao") String var2);

    @Query(value="SELECT DISTINCT p FROM Personalizacao p INNER JOIN FETCH p.valoresDaPersonalizacao vp WHERE p.excluido IS FALSE AND p.categoria.id = :categoriaDoProduto AND p.categoria.empresa.id = :empresaId AND vp.excluido IS FALSE ORDER BY p.proximaPersonalizacaoId, p.id")
    public List<Personalizacao> findByCategoriaIdAndExcluidoIsFalseOrderByProximaPersonalizacaoIdAscIdAsc(@Param(value="categoriaDoProduto") Long var1, @Param(value="empresaId") Long var2);

    @Query(value="SELECT p FROM Personalizacao p WHERE p.excluido IS FALSE AND p.categoria.id = :categoriaDoProduto AND p.categoria.empresa.id = :empresaId ORDER BY p.proximaPersonalizacaoId, p.id")
    public List<Personalizacao> findByCategoriaId(@Param(value="categoriaDoProduto") Long var1, @Param(value="empresaId") Long var2);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.AutocompleteView(p.descricao, p.id) FROM Personalizacao p WHERE p.categoria.empresa.id = :companyId AND p.excluido IS FALSE AND p.categoria.id = :categoryId AND LOWER(p.descricao) LIKE LOWER(CONCAT('%', :term, '%')) ORDER BY p.descricao")
    public List<AutocompleteView> findByAutocomplete(@Param(value="companyId") Long var1, @Param(value="categoryId") Long var2, @Param(value="term") String var3);

    public List<Personalizacao> findByCategoriaEmpresaId(@Param(value="empresaId") Long var1);

    public Optional<Personalizacao> findTopByOrderByIdDesc();

    public List<Personalizacao> findByProximaPersonalizacaoIdAndExcluidoIsFalse(Long var1);
}

