/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.enumeration.ProvedorDePagamento;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Contratacao;
import com.escolpi.omni.api.model.entity.LogDePagamentoDeContratacao;
import com.escolpi.omni.api.repository.LogDePagamentoDeContratacaoRepository;
import com.escolpi.omni.api.util.StringUtil;
import java.util.Date;
import java.util.Objects;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogDePagamentoDeContratacaoService {
    @Autowired
    private LogDePagamentoDeContratacaoRepository repository;

    @Transactional
    public void savePaymentLog(Contratacao contract, String transactionCode, int transactionStatus, ProvedorDePagamento paymentProvider) throws ApiException {
        LogDePagamentoDeContratacao paymentLog = new LogDePagamentoDeContratacao();
        String cartao = StringUtil.removerMascara((String)contract.getCartaoDaEmpresa().getNumeroCartao());
        paymentLog.setUltimosDigitosDoCartao(Long.valueOf(Objects.requireNonNull(cartao).substring(cartao.length() - 4, cartao.length())));
        paymentLog.setCpfCnpjInformadoDoCartao(StringUtil.removerMascara((String)contract.getCartaoDaEmpresa().getCpfCnpj()));
        paymentLog.setDataHoraDaTransacao(new Date());
        paymentLog.setTotalDaTransacao(contract.getValorContratado());
        paymentLog.setCodigoTransacao(transactionCode);
        paymentLog.setStatusDaTransacao(Integer.valueOf(transactionStatus));
        paymentLog.setProvedorDePagamento(paymentProvider);
        paymentLog.setTitularDoCartao(contract.getCartaoDaEmpresa().getTitular());
        this.repository.save((Object)paymentLog);
    }
}

