/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.model.entity.EmpresaProdutoEmDestaque;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface EmpresaProdutoEmDestaqueRepository
extends JpaRepository<EmpresaProdutoEmDestaque, Long>,
JpaSpecificationExecutor<EmpresaProdutoEmDestaque> {
    public static final String ENTITY_NAME = "Produto em Destaque";

    public Long countByProdutoId(Long var1);

    public Long countByProdutoIdAndIdNot(Long var1, Long var2);

    @Query(value="SELECT pd.* FROM empresas_produtos_destaque pd INNER JOIN produtos p ON p.id = pd.produto_id WHERE p.empresa_id = :empresaId AND p.ind_falta IS FALSE AND pd.ind_exibir IS TRUE ORDER BY p.id DESC", nativeQuery=true)
    public List<EmpresaProdutoEmDestaque> findByEmpresaIdAndProdutoEmFaltaIsFalseAndExibirIsTrueOrderByProdutoIdDesc(@Param(value="empresaId") Long var1);

    @Query(value="SELECT pd.* FROM empresas_produtos_destaque pd INNER JOIN produtos p ON p.id = pd.produto_id INNER JOIN categorias_produtos c ON c.id = p.categoria_id WHERE p.empresa_id = :empresaId AND p.ind_falta IS FALSE AND p.disponibilidades LIKE CONCAT('%', :diasDaSemana, '%') AND pd.ind_exibir IS TRUE AND pd.ind_promocional IS TRUE AND p.ind_exibe_tela_inicial IS TRUE AND c.ind_ativo IS TRUE AND c.ind_excluida IS FALSE ORDER BY p.id DESC", nativeQuery=true)
    public List<EmpresaProdutoEmDestaque> findByProdutoEmDestaquePromocional(@Param(value="empresaId") Long var1, @Param(value="diasDaSemana") String var2);

    @Query(value="SELECT pd.* FROM empresas_produtos_destaque pd INNER JOIN produtos p ON p.id = pd.produto_id INNER JOIN categorias_produtos c ON c.id = p.categoria_id WHERE p.empresa_id = :companyId AND p.ind_falta IS FALSE AND p.disponibilidades LIKE CONCAT('%', :weekDays, '%') AND pd.ind_exibir IS TRUE AND pd.ind_promocional IS FALSE AND c.ind_ativo IS TRUE AND c.ind_excluida IS FALSE ORDER BY p.id DESC", nativeQuery=true)
    @Deprecated
    public List<EmpresaProdutoEmDestaque> findByProdutoEmDestaqueNaoPromocional(@Param(value="companyId") Long var1, @Param(value="weekDays") String var2);

    @Query(value="SELECT pd.* FROM empresas_produtos_destaque pd INNER JOIN produtos p ON p.id = pd.produto_id INNER JOIN categorias_produtos c ON c.id = p.categoria_id WHERE p.empresa_id = :companyId AND p.ind_falta IS FALSE AND p.disponibilidades LIKE CONCAT('%', :weekDays, '%') AND pd.ind_exibir IS TRUE AND pd.ind_promocional IS FALSE AND c.ind_ativo IS TRUE AND c.ind_excluida IS FALSE ORDER BY p.id DESC", nativeQuery=true)
    public List<EmpresaProdutoEmDestaque> findSpotlightProductByCompany(@Param(value="companyId") Long var1, @Param(value="weekDays") String var2);

    public Optional<EmpresaProdutoEmDestaque> findByProdutoId(Long var1);

    public EmpresaProdutoEmDestaque findTopByProdutoId(Long var1);
}

