/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.model.entity.EmpresaConfiguracao;
import com.escolpi.omni.api.model.projection.ConfiguracaoView;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface EmpresaConfiguracaoRepository
extends JpaRepository<EmpresaConfiguracao, Long> {
    public static final String ENTITY_NAME = "Configura\u00e7\u00e3o da Empresa";

    public List<EmpresaConfiguracao> findByEmpresaId(@Param(value="empresaId") Long var1);

    public List<EmpresaConfiguracao> findByEmpresaIdOrderByConfiguracaoId(Long var1);

    public Optional<EmpresaConfiguracao> findByEmpresaIdAndConfiguracaoNome(@Param(value="empresaId") Long var1, @Param(value="configuracaoNome") String var2);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.ConfiguracaoView(ec.configuracao.nome, ec.configuracao.valorPadrao, ec.valor) FROM EmpresaConfiguracao ec WHERE ec.empresa.idStore = :storeId AND ec.configuracao.nome = :configName")
    public Optional<ConfiguracaoView> findByStoreIdAndConfigName(@Param(value="storeId") String var1, @Param(value="configName") String var2);

    @Query(value="FROM EmpresaConfiguracao ep WHERE ep.empresa.id = :companyId AND UNACCENT(ep.configuracao.nome) LIKE CONCAT('%', UNACCENT(:configName), '%')")
    public List<EmpresaConfiguracao> findByCompanyIdAndConfigName(@Param(value="companyId") Long var1, @Param(value="configName") String var2);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.ConfiguracaoView(ec.configuracao.nome, ec.configuracao.valorPadrao, ec.valor) FROM EmpresaConfiguracao ec WHERE ec.empresa.id = ?1 ORDER BY ec.configuracao.nome")
    public List<ConfiguracaoView> getCompanyConfigs(Long var1);
}

