/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CupomDeDesconto;
import com.escolpi.omni.api.model.projection.AutocompleteView;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface CupomDeDescontoRepository
extends JpaRepository<CupomDeDesconto, Long>,
JpaSpecificationExecutor<CupomDeDesconto> {
    public static final String ENTITY_NAME = "Cupom de Desconto";

    public Optional<CupomDeDesconto> findByCodigoAndEmpresaId(@Param(value="codigo") String var1, @Param(value="empresaId") Long var2);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.AutocompleteView(cp.codigo, cp.id) FROM CupomDeDesconto cp WHERE cp.empresa.id = :companyId AND UPPER(cp.codigo) = UPPER(:code) ORDER BY cp.codigo")
    public List<AutocompleteView> searchByAutoComplete(@Param(value="companyId") Long var1, @Param(value="code") String var2);

    public List<CupomDeDesconto> findByEmpresaId(@Param(value="empresaId") Long var1);

    @Query(value="FROM CupomDeDesconto cp WHERE cp.empresa.id = :empresaId AND CURRENT_DATE BETWEEN DATE(cp.dataInicioValidade) AND DATE(cp.dataFimValidade) AND cp.excluido IS FALSE ORDER BY cp.codigo DESC")
    public List<CupomDeDesconto> findCurrentByEmpresaId(@Param(value="empresaId") Long var1);

    public Optional<CupomDeDesconto> findByIdAndExcluidoIsFalse(Long var1);

    public Optional<CupomDeDesconto> findTopByEmpresaIdOrderByIdDesc(@Param(value="empresaId") Long var1) throws ApiException;
}

